--METADATA NAME:CLOB_TABLE_CREATION TYPE:EXEC
DECLARE
v_tbl_exists integer := 0;
BEGIN
  select count(*) into v_tbl_exists from user_tables where table_name='SRC_BKP';
  if v_tbl_exists > 0 then
    execute immediate 'TRUNCATE TABLE SRC_BKP';
    execute immediate 'insert into SRC_BKP SELECT * FROM USER_SOURCE';
    commit;
  end if;
  if v_tbl_exists = 0 then
    execute immediate 'CREATE TABLE SRC_BKP AS SELECT * FROM USER_SOURCE';
  end if;
EXCEPTION WHEN OTHERS THEN
  dbms_output.put_line('Exception: SQLCODE=' || SQLCODE || '  SQLERRM=' || SQLERRM);
  raise;
END;
/
