
--Run Script as     
SET DEFINE OFF

prompt Dropping constraint fk_prefer_users2 on table PREFER


--METADATA NAME:fk_prefer_users2 TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_prefer_users2');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PREFER DROP CONSTRAINT fk_prefer_users2';
  END IF;
END;
  /

prompt Dropping index ndx_projrisk_obs on table PROJRISK

--METADATA NAME:ndx_projrisk_obs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_projrisk_obs');

  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_projrisk_obs';
  END IF;
END;
      /

prompt Dropping index ndx_projrisk_projwbs on table PROJRISK

--METADATA NAME:ndx_projrisk_projwbs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_projrisk_projwbs');

  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_projrisk_projwbs';
  END IF;
END;
      /

prompt Dropping constraint fk_projrisk_obs on table PROJRISK


--METADATA NAME:fk_projrisk_obs TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_obs');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_obs';
  END IF;
END;
  /

prompt Dropping constraint fk_projrisk_project on table PROJRISK


--METADATA NAME:fk_projrisk_project TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_project';
  END IF;
END;
  /

prompt Dropping constraint fk_projrisk_risktype on table PROJRISK


--METADATA NAME:fk_projrisk_risktype TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_risktype');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_risktype';
  END IF;
END;
  /

prompt Dropping constraint fk_projrisk_rsrc on table PROJRISK


--METADATA NAME:fk_projrisk_rsrc TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_rsrc');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_rsrc';
  END IF;
END;
  /

prompt Dropping constraint fk_projrisk_projwbs on table PROJRISK


--METADATA NAME:fk_projrisk_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_projrisk_projwbs');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_projwbs';
  END IF;
END;
  /

prompt Dropping constraint fk_riskctrl_project on table RISKCTRL


--METADATA NAME:fk_riskctrl_project TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_riskctrl_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE RISKCTRL DROP CONSTRAINT fk_riskctrl_project';
  END IF;
END;
  /

prompt Dropping constraint fk_riskctrl_projrisk on table RISKCTRL


--METADATA NAME:fk_riskctrl_projrisk TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_riskctrl_projrisk');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE RISKCTRL DROP CONSTRAINT fk_riskctrl_projrisk';
  END IF;
END;
  /

prompt Dropping index ndx_rsrchour_1 on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_1 TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_rsrchour_1');

  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_rsrchour_1';
  END IF;
END;
      /

prompt Dropping index ndx_taskpred_2 on table TASKPRED

--METADATA NAME:ndx_taskpred_2 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:DROP
DECLARE
  index_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO index_exists FROM user_indexes WHERE index_name = UPPER('ndx_taskpred_2');

  IF index_exists > 0
  THEN
    EXECUTE IMMEDIATE 'DROP INDEX ndx_taskpred_2';
  END IF;
END;
      /

prompt Dropping constraint fk_tasksum_project on table TASKSUM


--METADATA NAME:fk_tasksum_project TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_tasksum_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TASKSUM DROP CONSTRAINT fk_tasksum_project';
  END IF;
END;
  /

prompt Dropping constraint fk_tasksum_projwbs on table TASKSUM


--METADATA NAME:fk_tasksum_projwbs TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_tasksum_projwbs');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TASKSUM DROP CONSTRAINT fk_tasksum_projwbs';
  END IF;
END;
  /

prompt Dropping constraint fk_timesht_rsrc on table TIMESHT


--METADATA NAME:fk_timesht_rsrc TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_timesht_rsrc');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TIMESHT DROP CONSTRAINT fk_timesht_rsrc';
  END IF;
END;
  /

prompt Dropping constraint fk_timesht_tsdates on table TIMESHT


--METADATA NAME:fk_timesht_tsdates TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_timesht_tsdates');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TIMESHT DROP CONSTRAINT fk_timesht_tsdates';
  END IF;
END;
  /

prompt Dropping constraint fk_trsrcsum_project on table TRSRCSUM


--METADATA NAME:fk_trsrcsum_project TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_trsrcsum_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_project';
  END IF;
END;
  /

prompt Dropping constraint fk_trsrcsum_roles on table TRSRCSUM


--METADATA NAME:fk_trsrcsum_roles TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_trsrcsum_roles');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_roles';
  END IF;
END;
  /

prompt Dropping constraint fk_trsrcsum_rsrc on table TRSRCSUM


--METADATA NAME:fk_trsrcsum_rsrc TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_trsrcsum_rsrc');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_rsrc';
  END IF;
END;
  /

prompt Dropping constraint fk_uaccess_project on table UACCESS


--METADATA NAME:fk_uaccess_project TYPE:CONSTRAINT TABLE_NAME:UACCESS CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_uaccess_project');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE UACCESS DROP CONSTRAINT fk_uaccess_project';
  END IF;
END;
  /

prompt Dropping constraint ck_usereng_named_user_flag on table USERENG


--METADATA NAME:ck_usereng_named_user_flag TYPE:CONSTRAINT TABLE_NAME:USERENG CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('ck_usereng_named_user_flag');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE USERENG DROP CONSTRAINT ck_usereng_named_user_flag';
  END IF;
END;
  /

prompt Dropping constraint fk_navidash_dashboard on table NAVIDASH


--METADATA NAME:fk_navidash_dashboard TYPE:CONSTRAINT TABLE_NAME:NAVIDASH CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_navidash_dashboard');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE NAVIDASH DROP CONSTRAINT fk_navidash_dashboard';
  END IF;
END;
  /

prompt Dropping constraint fk_navidash_naviview on table NAVIDASH


--METADATA NAME:fk_navidash_naviview TYPE:CONSTRAINT TABLE_NAME:NAVIDASH CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_navidash_naviview');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE NAVIDASH DROP CONSTRAINT fk_navidash_naviview';
  END IF;
END;
  /

prompt Dropping constraint fk_naviview_users on table NAVIVIEW


--METADATA NAME:fk_naviview_users TYPE:CONSTRAINT TABLE_NAME:NAVIVIEW CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('fk_naviview_users');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE NAVIVIEW DROP CONSTRAINT fk_naviview_users';
  END IF;
END;
  /

prompt Creating table ASGNMNTACAT

--METADATA NAME:ASGNMNTACAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTACAT(
  taskrsrc_id  number(10) NOT NULL,
  asgnmnt_catg_type_id  number(10) NOT NULL,
  asgnmnt_catg_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_asgnmntacat PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ASGNMNTCATTYPE

--METADATA NAME:ASGNMNTCATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATTYPE(
  asgnmnt_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  asgnmnt_catg_short_len  number(10) NOT NULL,
  asgnmnt_catg_type  varchar2(60 CHAR) NOT NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_asgnmntcattype PRIMARY KEY (asgnmnt_catg_type_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ASGNMNTCATVAL

--METADATA NAME:ASGNMNTCATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATVAL(
  asgnmnt_catg_id  number(10) NOT NULL,
  asgnmnt_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  asgnmnt_catg_short_name  varchar2(60 CHAR) NOT NULL,
  asgnmnt_catg_name  varchar2(100 CHAR) NULL,
  parent_asgnmnt_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_asgnmntcatval PRIMARY KEY (asgnmnt_catg_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table DISCUSSION

--METADATA NAME:DISCUSSION TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION(
  discussion_id  number(10) NOT NULL,
  task_id  number(10) NOT NULL,
  discussion_value  varchar2(4000 CHAR) NULL,
  discussion_date  DATE NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_discussion PRIMARY KEY (discussion_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table DISCUSSION_READ

--METADATA NAME:DISCUSSION_READ TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION_READ(
  discussion_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_discussion_read PRIMARY KEY (discussion_id,user_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table DOCREVIEW

--METADATA NAME:DOCREVIEW TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEW(
  doc_review_id  number(10) NOT NULL,
  doc_id  number(10) NOT NULL,
  user_id  number(10) NULL,
  review_name  varchar2(255 CHAR) NULL,
  review_descr  varchar2(255 CHAR) NULL,
  review_type  varchar2(15 CHAR) NULL,
  due_date  DATE NULL,
  status  varchar2(15 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_docreview PRIMARY KEY (doc_review_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,162,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=162)
/
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,163,case p.allow_flag when 'Y' then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=163) 
/

prompt Creating table DOCREVIEWTASK

--METADATA NAME:DOCREVIEWTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEWTASK(
  review_task_id  number(10) NOT NULL,
  doc_review_id  number(10) NOT NULL,
  user_id  number(10) NULL,
  review_date  DATE NULL,
  comments  varchar2(4000 CHAR) NULL,
  priority  number(10) NULL,
  status  varchar2(15 CHAR) NULL,
  attachment_uuid  varchar2(4000 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_docreviewtask PRIMARY KEY (review_task_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table FINTMPL

--METADATA NAME:FINTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE FINTMPL(
  fintmpl_id  number(10) NOT NULL,
  fintmpl_name  varchar2(255 CHAR) NOT NULL,
  default_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) DEFAULT 'NotPrmUser' NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) DEFAULT 'NotPrmUser' NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_fintmpl PRIMARY KEY (fintmpl_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) Select 1, 'Calendar', 'Y', SYSDATE, SYSDATE FROM DUAL WHERE NOT EXISTS (SELECT 1 FROM FINTMPL WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
/

prompt Creating table IMAGEDATA

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE IMAGEDATA(
  image_id  number(10) NOT NULL,
  image_name  varchar2(120 CHAR) NULL,
  image_data  BLOB NOT NULL,
  image_thumbnail  BLOB NOT NULL,
  image_extension  varchar2(20 CHAR) DEFAULT 'png' NOT NULL,
  default_flag  varchar2(1 CHAR) NOT NULL,
  image_purpose  varchar2(50 CHAR) NOT NULL,
  image_description  varchar2(250 CHAR) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_imagedata PRIMARY KEY (image_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table LOCATION

--METADATA NAME:LOCATION TYPE:TABLE CHANGE:CREATE
CREATE TABLE LOCATION(
  location_id  number(10) NOT NULL,
  location_name  varchar2(255 CHAR) NOT NULL,
  location_type  varchar2(24 CHAR) NULL,
  address_line1  varchar2(200 CHAR) NULL,
  address_line2  varchar2(200 CHAR) NULL,
  address_line3  varchar2(200 CHAR) NULL,
  city_name  varchar2(200 CHAR) NULL,
  municipality_name  varchar2(200 CHAR) NULL,
  state_name  varchar2(200 CHAR) NULL,
  state_code  varchar2(2 CHAR) NULL,
  country_name  varchar2(200 CHAR) NULL,
  country_code  varchar2(3 CHAR) NULL,
  postal_code  varchar2(20 CHAR) NULL,
  longitude  NUMBER NULL,
  latitude  NUMBER NULL,
  geo_location  SDO_GEOMETRY NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_location PRIMARY KEY (location_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
DECLARE
TABLE_MISSING exception;
pragma exception_init(TABLE_MISSING,-942);
BEGIN
execute immediate q'[INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID) 
VALUES ('LOCATION', 'GEO_LOCATION', 
   SDO_DIM_ARRAY 
     (SDO_DIM_ELEMENT('LONG', -180.0, 180.0, 0.5), 
     SDO_DIM_ELEMENT('LAT', -90.0, 90.0, 0.5)), 
   8307)]';
EXCEPTION WHEN TABLE_MISSING  THEN NULL;
END;   
/

--METADATA NAME:ndx_location_geo_location TYPE:INDEX TABLE_NAME:LOCATION CHANGE:CREATE      
BEGIN
execute immediate 'CREATE INDEX ndx_location_geo_location
ON location (geo_location)
INDEXTYPE IS mdsys.spatial_index';
EXCEPTION WHEN OTHERS THEN NULL;
END;   
/
  
  
prompt Creating table PFOLIOUSER

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  pfolio_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ROLECATTYPE

--METADATA NAME:ROLECATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATTYPE(
  role_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  role_catg_short_len  number(10) NOT NULL,
  role_catg_type  varchar2(60 CHAR) NOT NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_rolecattype PRIMARY KEY (role_catg_type_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ROLECATVAL

--METADATA NAME:ROLECATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATVAL(
  role_catg_id  number(10) NOT NULL,
  role_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  role_catg_short_name  varchar2(60 CHAR) NOT NULL,
  role_catg_name  varchar2(100 CHAR) NULL,
  parent_role_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_rolecatval PRIMARY KEY (role_catg_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ROLERCAT

--METADATA NAME:ROLERCAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLERCAT(
  role_id  number(10) NOT NULL,
  role_catg_type_id  number(10) NOT NULL,
  role_catg_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_rolercat PRIMARY KEY (role_id,role_catg_type_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table SUMPROJCOST

--METADATA NAME:SUMPROJCOST TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMPROJCOST(
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  cost_type_id  number(10) NOT NULL,
  start_date  DATE NULL,
  end_date  DATE NULL,
  spread_type  varchar2(20 CHAR) NULL,
  act_cost  number(23,6) NULL,
  remain_cost  number(23,6) NULL,
  target_cost  number(23,6) NULL,
  total_cost  number(23,6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table SUMTASK

--METADATA NAME:SUMTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASK(
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  bcwp  number(25,6) NULL,
  bcws  number(25,6) NULL,
  eac  number(25,6) NULL,
  eac_work_qty  number(22,6) NULL,
  etc  number(25,6) NULL,
  etc_work_qty  number(22,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  sched_work_qty  number(22,6) NULL,
  complete_cnt  number(10) NULL,
  active_cnt  number(10) NULL,
  notstarted_cnt  number(10) NULL,
  base_complete_cnt  number(10) NULL,
  base_active_cnt  number(10) NULL,
  base_notstarted_cnt  number(10) NULL,
  act_drtn_hr_cnt  number(17,6) NULL,
  total_drtn_hr_cnt  number(17,6) NULL,
  base_drtn_hr_cnt  number(17,6) NULL,
  remain_drtn_hr_cnt  number(17,6) NULL,
  total_float_hr_cnt  number(17,6) NULL,
  act_end_date  DATE NULL,
  act_start_date  DATE NULL,
  base_end_date  DATE NULL,
  base_start_date  DATE NULL,
  reend_date  DATE NULL,
  restart_date  DATE NULL,
  act_this_per_work_cost  number(25,6) NULL,
  act_this_per_work_qty  number(22,6) NULL,
  act_this_per_equip_cost  number(25,6) NULL,
  act_this_per_equip_qty  number(22,6) NULL,
  act_this_per_mat_cost  number(25,6) NULL,
  act_cost  number(25,6) NULL,
  act_equip_cost  number(25,6) NULL,
  act_expense_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_work_qty  number(22,6) NULL,
  base_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  base_expense_cost  number(25,6) NULL,
  base_mat_cost  number(25,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_equip_qty  number(22,6) NULL,
  base_work_qty  number(22,6) NULL,
  remain_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  remain_work_qty  number(22,6) NULL,
  target_cost  number(25,6) NULL,
  target_equip_cost  number(25,6) NULL,
  target_expense_cost  number(25,6) NULL,
  target_mat_cost  number(25,6) NULL,
  target_work_cost  number(25,6) NULL,
  target_equip_qty  number(22,6) NULL,
  target_work_qty  number(22,6) NULL,
  total_cost  number(25,6) NULL,
  total_equip_cost  number(25,6) NULL,
  total_expense_cost  number(25,6) NULL,
  total_mat_cost  number(25,6) NULL,
  total_work_cost  number(25,6) NULL,
  total_equip_qty  number(22,6) NULL,
  total_work_qty  number(22,6) NULL,
  target_start_date  DATE NULL,
  target_end_date  DATE NULL,
  target_drtn_hr_cnt  number(17,6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
UPDATE prefer SET phase_label='WBS Category',update_date=sysdate,update_user=sys_context('USERENV','CURRENT_SCHEMA')
/
--METADATA  TYPE:ADHOC_SQL
UPDATE projwbs SET sum_data_flag='N' where sum_data_flag != 'N'
/
--METADATA  TYPE:ADHOC_SQL
UPDATE project SET last_tasksum_date=null where last_tasksum_date is not null
/

prompt Creating table SUMTASKSPREAD

--METADATA NAME:SUMTASKSPREAD TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASKSPREAD(
  proj_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  start_date  DATE NOT NULL,
  end_date  DATE NOT NULL,
  spread_type  varchar2(20 CHAR) NOT NULL,
  act_cost  number(25,6) NULL,
  act_equip_cost  number(25,6) NULL,
  act_expense_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_work_qty  number(22,6) NULL,
  base_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  base_expense_cost  number(25,6) NULL,
  base_mat_cost  number(25,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_equip_qty  number(22,6) NULL,
  base_work_qty  number(22,6) NULL,
  late_remain_cost  number(25,6) NULL,
  late_remain_equip_cost  number(25,6) NULL,
  late_remain_expense_cost  number(25,6) NULL,
  late_remain_mat_cost  number(25,6) NULL,
  late_remain_work_cost  number(25,6) NULL,
  late_remain_equip_qty  number(22,6) NULL,
  late_remain_work_qty  number(22,6) NULL,
  remain_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  remain_work_qty  number(22,6) NULL,
  target_cost  number(25,6) NULL,
  target_equip_cost  number(25,6) NULL,
  target_expense_cost  number(25,6) NULL,
  target_mat_cost  number(25,6) NULL,
  target_work_cost  number(25,6) NULL,
  target_equip_qty  number(22,6) NULL,
  target_work_qty  number(22,6) NULL,
  total_cost  number(25,6) NULL,
  total_equip_cost  number(25,6) NULL,
  total_expense_cost  number(25,6) NULL,
  total_mat_cost  number(25,6) NULL,
  total_work_cost  number(25,6) NULL,
  total_equip_qty  number(22,6) NULL,
  total_work_qty  number(22,6) NULL,
  bcwp  number(25,6) NULL,
  bcws  number(25,6) NULL,
  eac  number(25,6) NULL,
  eac_work_qty  number(22,6) NULL,
  etc  number(25,6) NULL,
  etc_work_qty  number(22,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  sched_work_qty  number(22,6) NULL,
  fin_period_act_work_qty  number(22,6) NULL,
  fin_period_act_work_cost  number(25,6) NULL,
  fin_period_act_equip_qty  number(22,6) NULL,
  fin_period_act_equip_cost  number(25,6) NULL,
  fin_period_act_mat_cost  number(25,6) NULL,
  fin_period_act_expense_cost  number(25,6) NULL,
  fin_period_total_work_qty  number(22,6) NULL,
  fin_period_total_work_cost  number(25,6) NULL,
  fin_period_total_equip_qty  number(22,6) NULL,
  fin_period_total_equip_cost  number(25,6) NULL,
  fin_period_total_mat_cost  number(25,6) NULL,
  fin_period_total_expense_cost  number(25,6) NULL,
  fin_period_total_cost  number(25,6) NULL,
  fin_period_act_cost  number(25,6) NULL,
  fin_period_bcwp  number(25,6) NULL,
  fin_period_perfm_work_qty  number(22,6) NULL,
  fin_period_eac  number(25,6) NULL,
  fin_period_eac_work_qty  number(22,6) NULL,
  fin_period_bcws  number(25,6) NULL,
  fin_period_sched_work_qty  number(22,6) NULL
  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table SUMTRSRC

--METADATA NAME:SUMTRSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTRSRC(
  sumtrsrc_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  wbs_id  number(10) NULL,
  start_date  DATE NULL,
  end_date  DATE NULL,
  spread_type  varchar2(20 CHAR) NULL,
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  act_start_date  DATE NULL,
  act_end_date  DATE NULL,
  remain_start_date  DATE NULL,
  remain_end_date  DATE NULL,
  overalloc_date  DATE NULL,
  staffed_act_qty  number(23,6) NULL,
  unstaffed_act_qty  number(23,6) NULL,
  staffed_act_cost  number(23,6) NULL,
  unstaffed_act_cost  number(23,6) NULL,
  staffed_act_ot_qty  number(23,6) NULL,
  unstaffed_act_ot_qty  number(23,6) NULL,
  staffed_act_ot_cost  number(23,6) NULL,
  unstaffed_act_ot_cost  number(23,6) NULL,
  staffed_act_reg_cost  number(23,6) NULL,
  unstaffed_act_reg_cost  number(23,6) NULL,
  staffed_act_reg_qty  number(23,6) NULL,
  unstaffed_act_reg_qty  number(23,6) NULL,
  staffed_late_remain_qty  number(23,6) NULL,
  unstaffed_late_remain_qty  number(23,6) NULL,
  staffed_late_remain_cost  number(23,6) NULL,
  unstaffed_late_remain_cost  number(23,6) NULL,
  staffed_remain_qty  number(23,6) NULL,
  unstaffed_remain_qty  number(23,6) NULL,
  staffed_remain_cost  number(23,6) NULL,
  unstaffed_remain_cost  number(23,6) NULL,
  staffed_target_qty  number(23,6) NULL,
  unstaffed_target_qty  number(23,6) NULL,
  staffed_target_cost  number(23,6) NULL,
  unstaffed_target_cost  number(23,6) NULL,
  staffed_total_qty  number(23,6) NULL,
  unstaffed_total_qty  number(23,6) NULL,
  staffed_total_cost  number(23,6) NULL,
  unstaffed_total_cost  number(23,6) NULL,
  fin_period_act_qty  number(23,6) NULL,
  fin_period_act_cost  number(23,6) NULL,
  fin_period_total_qty  number(23,6) NULL,
  fin_period_total_cost  number(23,6) NULL
,CONSTRAINT pk_sumtrsrc PRIMARY KEY (sumtrsrc_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TASKRISK

--METADATA NAME:TASKRISK TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKRISK(
  task_id  number(10) NOT NULL,
  risk_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_risk_task PRIMARY KEY (risk_id,task_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TASKSUMFIN

--METADATA NAME:TASKSUMFIN TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKSUMFIN(
  task_sum_fin_id  number(10) NOT NULL,
  fin_dates_id  number(10) NOT NULL,
  wbs_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  task_sum_id  number(10) NOT NULL,
  act_work_qty  number(22,6) NULL,
  act_work_cost  number(25,6) NULL,
  act_equip_qty  number(22,6) NULL,
  act_equip_cost  number(25,6) NULL,
  act_mat_cost  number(25,6) NULL,
  act_expense_cost  number(25,6) NULL,
  total_work_qty  number(22,6) NULL,
  total_work_cost  number(25,6) NULL,
  total_equip_qty  number(22,6) NULL,
  total_equip_cost  number(25,6) NULL,
  total_mat_cost  number(25,6) NULL,
  total_expense_cost  number(25,6) NULL,
  total_cost  number(23,6) NULL,
  act_cost  number(23,6) NULL,
  bcwp  number(25,6) NULL,
  perfm_work_qty  number(22,6) NULL,
  etc  number(25,6) NULL,
  etc_work_qty  number(22,6) NULL,
  eac  number(25,6) NULL,
  eac_work  number(22,6) NULL,
  bcws  number(25,6) NULL,
  acwp  number(25,6) NULL,
  sched_work_qty  number(22,6) NULL,
  base_cost  number(23,6) NULL,
  base_work_qty  number(22,6) NULL,
  base_work_cost  number(25,6) NULL,
  base_mat_cost  number(25,6) NULL,
  base_equip_cost  number(25,6) NULL,
  base_equip_qty  number(22,6) NULL,
  base_expense_cost  number(25,6) NULL,
  remain_cost  number(23,6) NULL,
  remain_work_qty  number(22,6) NULL,
  remain_work_cost  number(25,6) NULL,
  remain_mat_cost  number(25,6) NULL,
  remain_equip_cost  number(25,6) NULL,
  remain_equip_qty  number(22,6) NULL,
  remain_expense_cost  number(25,6) NULL,
  target_cost  number(23,6) NULL,
  target_equip_cost  number(25,6) NULL,
  target_equip_qty  number(22,6) NULL,
  target_expense_cost  number(25,6) NULL,
  target_mat_cost  number(25,6) NULL,
  target_work_cost  number(25,6) NULL,
  target_work_qty  number(22,6) NULL,
  late_remain_work_qty  number(22,6) NULL,
  late_remain_work_cost  number(25,6) NULL,
  late_remain_equip_cost  number(25,6) NULL,
  late_remain_equip_qty  number(22,6) NULL,
  late_remain_cost  number(23,6) NULL,
  late_remain_mat_cost  number(25,6) NULL,
  late_remain_expense_cost  number(25,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_tasksumfin PRIMARY KEY (task_sum_fin_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TMPLCATG

--METADATA NAME:TMPLCATG TYPE:TABLE CHANGE:CREATE
CREATE TABLE TMPLCATG(
  tmplcatg_catg_id  number(10) NOT NULL,
  catg_name  varchar2(255 CHAR) NOT NULL,
  project_flag  varchar2(1 CHAR) NOT NULL,
  process_flag  varchar2(1 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_tmplcatg PRIMARY KEY (tmplcatg_catg_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TRSRCSUMFN

--METADATA NAME:TRSRCSUMFN TYPE:TABLE CHANGE:CREATE
CREATE TABLE TRSRCSUMFN(
  trsrc_sum_fin_id  number(10) NOT NULL,
  fin_dates_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  rsrc_id  number(10) NULL,
  role_id  number(10) NULL,
  taskrsrc_sum_id  number(10) NOT NULL,
  act_qty  number(17,6) NULL,
  act_cost  number(23,6) NULL,
  act_ot_qty  number(17,6) NULL,
  act_reg_qty  number(17,6) NULL,
  act_ot_cost  number(23,6) NULL,
  act_reg_cost  number(23,6) NULL,
  total_qty  number(22,6) NULL,
  total_cost  number(23,6) NULL,
  remain_qty  number(17,6) NULL,
  remain_cost  number(23,6) NULL,
  target_qty  number(19,6) NULL,
  target_cost  number(23,6) NULL,
  staffed_remain_qty  number(17,6) NULL,
  unstaffed_remain_qty  number(17,6) NULL,
  staffed_remain_cost  number(25,6) NULL,
  unstaffed_remain_cost  number(25,6) NULL,
  staffed_late_remain_qty  number(17,6) NULL,
  unstaffed_late_remain_qty  number(17,6) NULL,
  staffed_late_remain_cost  number(25,6) NULL,
  unstaffed_late_remain_cost  number(25,6) NULL,
  late_remain_qty  number(17,6) NULL,
  late_remain_cost  number(25,6) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_trsrcsumfn PRIMARY KEY (trsrc_sum_fin_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table TSAUDIT

--METADATA NAME:TSAUDIT TYPE:TABLE CHANGE:CREATE
CREATE TABLE TSAUDIT(
  ts_audit_id  number(10) NOT NULL,
  audit_date  DATE NULL,
  rsrc_id  number(10) NULL,
  rsrc_short_name  varchar2(255 CHAR) NULL,
  rsrc_name  varchar2(255 CHAR) NULL,
  ts_status_code  varchar2(20 CHAR) NULL,
  reg_hrs  number(17,6) NULL,
  reg_ot_hrs  number(17,6) NULL,
  pend_reg_hrs  number(17,6) NULL,
  pend_reg_ot_hrs  number(17,6) NULL,
  oh_hrs  number(17,6) NULL,
  oh_ot_hrs  number(17,6) NULL,
  pend_oh_hrs  number(17,6) NULL,
  pend_oh_ot_hrs  number(17,6) NULL,
  ts_id  number(10) NULL,
  ts_start_date  DATE NULL,
  ts_end_date  DATE NULL,
  proj_id  number(10) NULL,
  proj_short_name  varchar2(40 CHAR) NULL,
  ts_task_status  varchar2(20 CHAR) NULL,
  user_id  number(10) NULL,
  user_name  varchar2(255 CHAR) NULL,
  approving_as  varchar2(50 CHAR) NULL
,CONSTRAINT pk_tsaudit PRIMARY KEY (ts_audit_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
truncate table refrdel
/

prompt Creating table TSDELEGATE

--METADATA NAME:TSDELEGATE TYPE:TABLE CHANGE:CREATE
CREATE TABLE TSDELEGATE(
  ts_delegate_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  ts_delegate_user_id  number(10) NOT NULL,
  proj_id  number(10) NULL,
  active_flag  varchar2(1 CHAR) DEFAULT 'N' NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_tsdelegate PRIMARY KEY (ts_delegate_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table USEROPEN

--METADATA NAME:USEROPEN TYPE:TABLE CHANGE:CREATE
CREATE TABLE USEROPEN(
  user_open_id  number(10) NOT NULL,
  user_open_name  varchar2(255 CHAR) NOT NULL,
  user_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_useropen PRIMARY KEY (user_open_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table USER_ACCEPTANCE_CONSENT

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:TABLE CHANGE:CREATE
CREATE TABLE USER_ACCEPTANCE_CONSENT(
  user_id  number(10) NOT NULL,
  status  number(10) NULL,
  modified_date  DATE DEFAULT sysdate NULL,
  consent_type  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_user_acceptance_consent PRIMARY KEY (user_id,consent_type)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table USROPNVAL

--METADATA NAME:USROPNVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE USROPNVAL(
  user_open_id  number(10) NOT NULL,
  pk_id  number(10) NOT NULL,
  usropn_type  varchar2(20 CHAR) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_usropnval PRIMARY KEY (user_open_id,pk_id,usropn_type)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table VWPREFDASH

--METADATA NAME:VWPREFDASH TYPE:TABLE CHANGE:CREATE
CREATE TABLE VWPREFDASH(
  dashboard_id  number(10) NOT NULL,
  view_pref_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_vwprefdash PRIMARY KEY (dashboard_id,view_pref_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
DELETE from admin_config where config_name = 'myprimavera.bre.INTERNAL_PLUGINS' 
/

prompt Creating table WKFLTMPL

--METADATA NAME:WKFLTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE WKFLTMPL(
  wkfl_tmpl_id  number(10) NOT NULL,
  template_name  varchar2(255 CHAR) NOT NULL,
  project_flag  varchar2(1 CHAR) NOT NULL,
  wk_external_key  varchar2(255 CHAR) NULL,
  tmplcatg_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_wkfltmpl PRIMARY KEY (wkfl_tmpl_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA NAME:color TYPE:FIELD TABLE_NAME:ACTVCODE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('ACTVCODE') and column_name=upper('color');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE ACTVCODE add   color  varchar2(6 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:rsrc_private TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('rsrc_private');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   rsrc_private  varchar2(1 CHAR) DEFAULT ''N'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:day_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('day_hr_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   day_hr_cnt  number(10,2) NULL
';
  end if;
END;         
/

--METADATA NAME:week_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('week_hr_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   week_hr_cnt  number(10,2) NULL
';
  end if;
END;         
/

--METADATA NAME:year_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('year_hr_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   year_hr_cnt  number(10,2) NULL
';
  end if;
END;         
/

--METADATA NAME:month_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('CALENDAR') and column_name=upper('month_hr_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE CALENDAR add   month_hr_cnt  number(10,2) NULL
';
  end if;
END;         
/

--METADATA NAME:parent_actv_code_id TYPE:FIELD TABLE_NAME:DLTACTV CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('DLTACTV') and column_name=upper('parent_actv_code_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE DLTACTV add   parent_actv_code_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_doc_key TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('DOCUMENT') and column_name=upper('cr_external_doc_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE DOCUMENT add   cr_external_doc_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:rpt_id TYPE:FIELD TABLE_NAME:FILTPROP CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('FILTPROP') and column_name=upper('rpt_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE FILTPROP add   rpt_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:FINDATES CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('FINDATES') and column_name=upper('fintmpl_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE FINDATES add   fintmpl_id  number(10) DEFAULT 1 NOT NULL
';
  end if;
END;         
/

--METADATA NAME:parent_job_id TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('JOBSVC') and column_name=upper('parent_job_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE JOBSVC add   parent_job_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:old_str TYPE:FIELD TABLE_NAME:PKXREF CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PKXREF') and column_name=upper('old_str');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PKXREF add   old_str  varchar2(40 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:new_str TYPE:FIELD TABLE_NAME:PKXREF CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PKXREF') and column_name=upper('new_str');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PKXREF add   new_str  varchar2(40 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:min_pro_version TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PREFER') and column_name=upper('min_pro_version');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PREFER add   min_pro_version  varchar2(10 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:ts_rsrc_def_asgn_out_actv_flag TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PREFER') and column_name=upper('ts_rsrc_def_asgn_out_actv_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PREFER add   ts_rsrc_def_asgn_out_actv_flag  varchar2(1 CHAR) DEFAULT ''Y'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:prof_descr TYPE:FIELD TABLE_NAME:PROFILE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROFILE') and column_name=upper('prof_descr');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROFILE add   prof_descr  varchar2(255 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:rsrc_role_match_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('rsrc_role_match_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   rsrc_role_match_flag  varchar2(1 CHAR) DEFAULT ''N'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('cr_external_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   cr_external_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:apply_actuals_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('apply_actuals_date');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   apply_actuals_date  DATE NULL
';
  end if;
END;         
/

--METADATA  TYPE:ADHOC_SQL
update usereng set named_user_flag='Y',update_date=sysdate,update_user=sys_context('USERENV','CURRENT_SCHEMA') where named_user_flag='N'
/

--METADATA NAME:description TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('description');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   description  varchar2(500 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:intg_proj_type TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('intg_proj_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   intg_proj_type  varchar2(7 CHAR) NULL
';
  end if;
END;         
/

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,157,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=157) 
/

--METADATA NAME:matrix_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('matrix_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   matrix_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('location_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   location_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:last_schedule_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('last_schedule_date');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   last_schedule_date  DATE NULL
';
  end if;
END;         
/

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('control_updates_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   control_updates_flag  varchar2(1 CHAR) DEFAULT ''N'' NOT NULL
';
  end if;
END;         
/

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,169,'N', sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=169)
/

--METADATA NAME:hist_interval TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('hist_interval');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   hist_interval  varchar2(25 CHAR) DEFAULT ''Month'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:hist_level TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('hist_level');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   hist_level  varchar2(10 CHAR) DEFAULT ''HL_None'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('fintmpl_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   fintmpl_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:risk_to_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_to_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_to_type  varchar2(12 CHAR) DEFAULT ''RT_Threat'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:identified_by_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('identified_by_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   identified_by_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:response_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('response_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   response_type  varchar2(12 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:response_text TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('response_text');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   response_text  varchar2(255 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:pre_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   pre_rsp_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:pre_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_schd_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   pre_rsp_schd_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:pre_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_cost_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   pre_rsp_cost_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:post_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('post_rsp_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   post_rsp_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:post_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('post_rsp_schd_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   post_rsp_schd_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:post_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('post_rsp_cost_prblty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   post_rsp_cost_prblty  varchar2(2 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:risk_cause TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_cause');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_cause  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:risk_effect TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_effect');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_effect  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:notes TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('notes');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   notes  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:risk_code TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_code');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_code  varchar2(40 CHAR) DEFAULT 0 NOT NULL
';
  end if;
END;         
/

--METADATA NAME:risk_desc TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJRISK') and column_name=upper('risk_desc');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJRISK add   risk_desc  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJWBS') and column_name=upper('intg_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJWBS add   intg_type  varchar2(100 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:status_reviewer TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJWBS') and column_name=upper('status_reviewer');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJWBS add   status_reviewer  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:parent_risk_type_id TYPE:FIELD TABLE_NAME:RISKTYPE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RISKTYPE') and column_name=upper('parent_risk_type_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RISKTYPE add   parent_risk_type_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:start_date TYPE:FIELD TABLE_NAME:ROLERATE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('ROLERATE') and column_name=upper('start_date');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE ROLERATE add   start_date  DATE DEFAULT sysdate NOT NULL
';
  end if;
END;         
/

--METADATA NAME:max_qty_per_hr TYPE:FIELD TABLE_NAME:ROLERATE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('ROLERATE') and column_name=upper('max_qty_per_hr');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE ROLERATE add   max_qty_per_hr  number(16,8) DEFAULT 1 NULL
';
  end if;
END;         
/

--METADATA NAME:rpt_area TYPE:FIELD TABLE_NAME:RPT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RPT') and column_name=upper('rpt_area');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RPT add   rpt_area  varchar2(32 CHAR) DEFAULT ''Unknown'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:user_id TYPE:FIELD TABLE_NAME:RPT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RPT') and column_name=upper('user_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RPT add   user_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RSRC') and column_name=upper('intg_type');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RSRC add   intg_type  varchar2(100 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('RSRC') and column_name=upper('location_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE RSRC add   location_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:refrdel_project_bypass TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('SPIDMAP') and column_name=upper('refrdel_project_bypass');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE SPIDMAP add   refrdel_project_bypass  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASK') and column_name=upper('location_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASK add   location_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASK') and column_name=upper('control_updates_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASK add   control_updates_flag  varchar2(1 CHAR) DEFAULT ''N'' NULL
';
  end if;
END;         
/

--METADATA NAME:comments TYPE:FIELD TABLE_NAME:TASKPRED CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASKPRED') and column_name=upper('comments');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASKPRED add   comments  varchar2(250 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:prior_ts_act_reg_qty TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASKRSRC') and column_name=upper('prior_ts_act_reg_qty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASKRSRC add   prior_ts_act_reg_qty  number(17,6) NULL
';
  end if;
END;         
/

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,156,case p.allow_flag when 'Y' then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p where priv_num=29  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=156)
/

--METADATA NAME:prior_ts_act_ot_qty TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASKRSRC') and column_name=upper('prior_ts_act_ot_qty');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASKRSRC add   prior_ts_act_ot_qty  number(17,6) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:TASKWKSP CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASKWKSP') and column_name=upper('cr_external_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASKWKSP add   cr_external_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:table_name TYPE:FIELD TABLE_NAME:UDFVALUE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('UDFVALUE') and column_name=upper('table_name');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE UDFVALUE add   table_name  varchar2(30 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:pk2_id TYPE:FIELD TABLE_NAME:UPKLIST CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('UPKLIST') and column_name=upper('pk2_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE UPKLIST add   pk2_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:ui_view_pref_id TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERS') and column_name=upper('ui_view_pref_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERS add   ui_view_pref_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERS') and column_name=upper('cr_external_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERS add   cr_external_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERS') and column_name=upper('cr_user_name');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERS add   cr_user_name  varchar2(255 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:failed_login_attempts_cnt TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERS') and column_name=upper('failed_login_attempts_cnt');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERS add   failed_login_attempts_cnt  number(10) DEFAULT 0 NULL
';
  end if;
END;         
/

--METADATA NAME:userset_blob TYPE:FIELD TABLE_NAME:USERSET CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('USERSET') and column_name=upper('userset_blob');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE USERSET add   userset_blob  BLOB NULL
';
  end if;
END;         
/

--METADATA NAME:view_pref_value_blob TYPE:FIELD TABLE_NAME:VWPREFDATA CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('VWPREFDATA') and column_name=upper('view_pref_value_blob');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE VWPREFDATA add   view_pref_value_blob  BLOB NULL
';
  end if;
END;         
/

--METADATA NAME:fin_dates_id1 TYPE:FIELD TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WBSRSRC_QTY') and column_name=upper('fin_dates_id1');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WBSRSRC_QTY add   fin_dates_id1  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:fin_qty1 TYPE:FIELD TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WBSRSRC_QTY') and column_name=upper('fin_qty1');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WBSRSRC_QTY add   fin_qty1  number(17,6) NULL
';
  end if;
END;         
/

--METADATA NAME:fin_dates_id2 TYPE:FIELD TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WBSRSRC_QTY') and column_name=upper('fin_dates_id2');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WBSRSRC_QTY add   fin_dates_id2  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:fin_qty2 TYPE:FIELD TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WBSRSRC_QTY') and column_name=upper('fin_qty2');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WBSRSRC_QTY add   fin_qty2  number(17,6) NULL
';
  end if;
END;         
/

--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:WORKSPACE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('WORKSPACE') and column_name=upper('cr_external_key');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE WORKSPACE add   cr_external_key  varchar2(4000 CHAR) NULL
';
  end if;
END;         
/

prompt Dropping constraint pk_nextkey on table NEXTKEY


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('pk_nextkey');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE NEXTKEY DROP CONSTRAINT pk_nextkey';
  END IF;
END;
  /

prompt Creating constraint fk_asgnmntacat_asgnmntcattype on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgnmntacat_asgnmntcatval on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_asgnmntcatval TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcatval FOREIGN KEY (asgnmnt_catg_id)
REFERENCES ASGNMNTCATVAL (asgnmnt_catg_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgnmntacat_taskrsrc on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_taskrsrc TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgnmntacat_project on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_project TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgncatval_asgnmntcattype on table ASGNMNTCATVAL


--METADATA NAME:fk_asgncatval_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
ALTER TABLE ASGNMNTCATVAL
ADD CONSTRAINT fk_asgncatval_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id) 
/

prompt Creating constraint fk_discussion_task on table DISCUSSION


--METADATA NAME:fk_discussion_task TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT fk_discussion_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_discussion_read_users on table DISCUSSION_READ


--METADATA NAME:fk_discussion_read_users TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_discussion_read_discussion on table DISCUSSION_READ


--METADATA NAME:fk_discussion_read_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_discussion FOREIGN KEY (discussion_id)
REFERENCES DISCUSSION (discussion_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_docreview_document on table DOCREVIEW


--METADATA NAME:fk_docreview_document TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
/

prompt Creating constraint fk_docreview_users on table DOCREVIEW


--METADATA NAME:fk_docreview_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_docreviewtask_docreview on table DOCREVIEWTASK


--METADATA NAME:fk_docreviewtask_docreview TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_docreview FOREIGN KEY (doc_review_id)
REFERENCES DOCREVIEW (doc_review_id) 
/

prompt Creating constraint fk_docreviewtask_users on table DOCREVIEWTASK


--METADATA NAME:fk_docreviewtask_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_filtprop_rpt on table FILTPROP


--METADATA NAME:fk_filtprop_rpt TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
/

prompt Creating constraint fk_findates_fintmpl on table FINDATES


--METADATA NAME:fk_findates_fintmpl TYPE:CONSTRAINT TABLE_NAME:FINDATES CHANGE:CREATE
ALTER TABLE FINDATES
ADD CONSTRAINT fk_findates_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
/

prompt Creating constraint fk_pfoliouser_users on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_project_fintmpl on table PROJECT


--METADATA NAME:fk_project_fintmpl TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id) 
/

prompt Creating constraint fk_rolecatval_rolecattype on table ROLECATVAL


--METADATA NAME:fk_rolecatval_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLECATVAL CHANGE:CREATE
ALTER TABLE ROLECATVAL
ADD CONSTRAINT fk_rolecatval_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
/

prompt Creating constraint fk_rolercat_rolecattype on table ROLERCAT


--METADATA NAME:fk_rolercat_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
/

prompt Creating constraint fk_rolercat_rolecatval on table ROLERCAT


--METADATA NAME:fk_rolercat_rolecatval TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecatval FOREIGN KEY (role_catg_id)
REFERENCES ROLECATVAL (role_catg_id) 
/

prompt Creating constraint fk_rolercat_roles on table ROLERCAT


--METADATA NAME:fk_rolercat_roles TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
/

prompt Creating constraint fk_rpt_users on table RPT


--METADATA NAME:fk_rpt_users TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_sumprojcost_project on table SUMPROJCOST


--METADATA NAME:fk_sumprojcost_project TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumprojcost_projwbs on table SUMPROJCOST


--METADATA NAME:fk_sumprojcost_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumprojcost_costtype on table SUMPROJCOST


--METADATA NAME:fk_sumprojcost_costtype TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtask_project on table SUMTASK


--METADATA NAME:fk_sumtask_project TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtask_projwbs on table SUMTASK


--METADATA NAME:fk_sumtask_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtaskspread_project on table SUMTASKSPREAD


--METADATA NAME:fk_sumtaskspread_project TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtaskspread_projwbs on table SUMTASKSPREAD


--METADATA NAME:fk_sumtaskspread_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtrsrc_project on table SUMTRSRC


--METADATA NAME:fk_sumtrsrc_project TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_sumtrsrc_projwbs on table SUMTRSRC


--METADATA NAME:fk_sumtrsrc_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_risk_riskid on table TASKRISK


--METADATA NAME:fk_risk_riskid TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_riskid FOREIGN KEY (risk_id)
REFERENCES PROJRISK (risk_id) 
/

prompt Creating constraint fk_risk_task on table TASKRISK


--METADATA NAME:fk_risk_task TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
/

prompt Creating constraint fk_taskrisk_project on table TASKRISK


--METADATA NAME:fk_taskrisk_project TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_taskrisk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_tsdelegate_users on table TSDELEGATE


--METADATA NAME:fk_tsdelegate_users TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_tsdelegate_users2 on table TSDELEGATE


--METADATA NAME:fk_tsdelegate_users2 TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_users2 FOREIGN KEY (ts_delegate_user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_tsdelegate_project on table TSDELEGATE


--METADATA NAME:fk_tsdelegate_project TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_useropen_users on table USEROPEN


--METADATA NAME:fk_useropen_users TYPE:CONSTRAINT TABLE_NAME:USEROPEN CHANGE:CREATE
ALTER TABLE USEROPEN
ADD CONSTRAINT fk_useropen_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_user_acpt_consent_users on table USER_ACCEPTANCE_CONSENT


--METADATA NAME:fk_user_acpt_consent_users TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT fk_user_acpt_consent_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_usropnval_useropen on table USROPNVAL


--METADATA NAME:fk_usropnval_useropen TYPE:CONSTRAINT TABLE_NAME:USROPNVAL CHANGE:CREATE
ALTER TABLE USROPNVAL
ADD CONSTRAINT fk_usropnval_useropen FOREIGN KEY (user_open_id)
REFERENCES USEROPEN (user_open_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_vwprefdash_dashboard on table VWPREFDASH


--METADATA NAME:fk_vwprefdash_dashboard TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT fk_vwprefdash_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_vwprefdash_viewpref on table VWPREFDASH


--METADATA NAME:fk_vwprefdash_viewpref TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT fk_vwprefdash_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_wbsrsrc_qty_findates1 on table WBSRSRC_QTY


--METADATA NAME:fk_wbsrsrc_qty_findates1 TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_findates1 FOREIGN KEY (fin_dates_id1)
REFERENCES FINDATES (fin_dates_id) 
/

prompt Creating constraint fk_wbsrsrc_qty_findates2 on table WBSRSRC_QTY


--METADATA NAME:fk_wbsrsrc_qty_findates2 TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_findates2 FOREIGN KEY (fin_dates_id2)
REFERENCES FINDATES (fin_dates_id) 
/

prompt Creating constraint fk_wkfltmpl_tmplcatg on table WKFLTMPL


--METADATA NAME:fk_wkfltmpl_tmplcatg TYPE:CONSTRAINT TABLE_NAME:WKFLTMPL CHANGE:CREATE
ALTER TABLE WKFLTMPL
ADD CONSTRAINT fk_wkfltmpl_tmplcatg FOREIGN KEY (tmplcatg_catg_id)
REFERENCES TMPLCATG (tmplcatg_catg_id) 
/

--METADATA NAME:chng_by_name TYPE:FIELD TABLE_NAME:BUDGCHNG CHANGE:ALTER
ALTER TABLE BUDGCHNG modify chng_by_name varchar2(255 CHAR)
/

--METADATA NAME:clndr_name TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:ALTER
ALTER TABLE CALENDAR modify clndr_name varchar2(255 CHAR)
/

--METADATA NAME:author_name TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify author_name varchar2(255 CHAR)
/

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify private_loc varchar2(4000 CHAR)
/

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify public_loc varchar2(4000 CHAR)
/

--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER
ALTER TABLE JOBSVC modify job_name varchar2(255 CHAR)
/

--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER
ALTER TABLE NEXTKEY modify key_name varchar2(60 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:NOTE CHANGE:ALTER
ALTER TABLE NOTE modify user_name varchar2(255 CHAR)
/

--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE modify proj_catg_type varchar2(60 CHAR)
/

--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL modify proj_catg_short_name varchar2(60 CHAR)
/

--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT modify prm_user_name varchar2(255 CHAR)
/

--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT modify netaddress varchar2(64 CHAR)
/

--METADATA NAME:enqueue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE modify enqueue_user varchar2(255 CHAR)
/

--METADATA NAME:sender_name TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE modify sender_name varchar2(255 CHAR)
/

--METADATA NAME:dequeue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE modify dequeue_user varchar2(255 CHAR)
/

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER
ALTER TABLE PROJECT modify add_by_name varchar2(255 CHAR)
/

--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJISSU CHANGE:ALTER
ALTER TABLE PROJISSU modify add_by_name varchar2(255 CHAR)
/
 
--METADATA NAME:add_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK modify add_date NULL
/

--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK modify risk_name varchar2(200 CHAR)
/
 
--METADATA NAME:est_wt TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS modify est_wt NULL
/

--METADATA NAME:private_db_user_name TYPE:FIELD TABLE_NAME:PUBUSER CHANGE:ALTER
ALTER TABLE PUBUSER modify private_db_user_name varchar2(255 CHAR)
/

--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify rsrc_short_name varchar2(255 CHAR)
/

--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify rsrc_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:ALTER
ALTER TABLE SPIDMAP modify user_name varchar2(255 CHAR)
/
 
--METADATA NAME:est_wt TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER
ALTER TABLE TASK modify est_wt NULL
/

--METADATA NAME:review_type TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER
ALTER TABLE TASK modify review_type DEFAULT 'RV_OK'
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:UEVNTREG CHANGE:ALTER
ALTER TABLE UEVNTREG modify user_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS modify user_name varchar2(255 CHAR)
/

--METADATA NAME:actual_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS modify actual_name varchar2(255 CHAR)
/

--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD modify user_name varchar2(255 CHAR)
/

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD modify os_user_name varchar2(255 CHAR)
/

--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSION CHANGE:ALTER
ALTER TABLE USESSION modify os_user_name varchar2(255 CHAR)
/

prompt Creating index ndx_asgnacat_asgnmntcattype on table ASGNMNTACAT

--METADATA NAME:ndx_asgnacat_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNACAT_ASGNMNTCATTYPE
ON ASGNMNTACAT (asgnmnt_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_asgnmntcatval on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_asgnmntcatval TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_ASGNMNTCATVAL
ON ASGNMNTACAT (asgnmnt_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_update_date1 on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_update_date1 TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_UPDATE_DATE1
ON ASGNMNTACAT (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_dsi on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_dsi TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_DSI
ON ASGNMNTACAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_upd on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_upd TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_UPD
ON ASGNMNTACAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_proj_id on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_proj_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_PROJ_ID
ON ASGNMNTACAT (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_taskrsrc_id on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_taskrsrc_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_TASKRSRC_ID
ON ASGNMNTACAT (taskrsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcattype_dsi on table ASGNMNTCATTYPE

--METADATA NAME:ndx_asgnmntcattype_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATTYPE_DSI
ON ASGNMNTCATTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcattype_upd on table ASGNMNTCATTYPE

--METADATA NAME:ndx_asgnmntcattype_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATTYPE_UPD
ON ASGNMNTCATTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgncatval_asgnmntcattype on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgncatval_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX NDX_ASGNCATVAL_ASGNMNTCATTYPE
ON ASGNMNTCATVAL (asgnmnt_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcatval_parent_catg on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgnmntcatval_parent_catg TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATVAL_PARENT_CATG
ON ASGNMNTCATVAL (parent_asgnmnt_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcatval_dsi on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgnmntcatval_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATVAL_DSI
ON ASGNMNTCATVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcatval_upd on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgnmntcatval_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATVAL_UPD
ON ASGNMNTCATVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_1 on table DISCUSSION

--METADATA NAME:ndx_discussion_1 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX NDX_DISCUSSION_1
ON DISCUSSION (task_id,discussion_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_2 on table DISCUSSION

--METADATA NAME:ndx_discussion_2 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX NDX_DISCUSSION_2
ON DISCUSSION (user_id,discussion_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_dsi on table DISCUSSION

--METADATA NAME:ndx_discussion_dsi TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE INDEX NDX_DISCUSSION_DSI
ON DISCUSSION (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_discussion_read_dsi on table DISCUSSION_READ

--METADATA NAME:ndx_discussion_read_dsi TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
CREATE INDEX NDX_DISCUSSION_READ_DSI
ON DISCUSSION_READ (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreview_document on table DOCREVIEW

--METADATA NAME:ndx_docreview_document TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE INDEX NDX_DOCREVIEW_DOCUMENT
ON DOCREVIEW (doc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreview_users on table DOCREVIEW

--METADATA NAME:ndx_docreview_users TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE INDEX NDX_DOCREVIEW_USERS
ON DOCREVIEW (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreviewtask_docreview on table DOCREVIEWTASK

--METADATA NAME:ndx_docreviewtask_docreview TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE INDEX NDX_DOCREVIEWTASK_DOCREVIEW
ON DOCREVIEWTASK (doc_review_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_docreviewtask_users on table DOCREVIEWTASK

--METADATA NAME:ndx_docreviewtask_users TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE INDEX NDX_DOCREVIEWTASK_USERS
ON DOCREVIEWTASK (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_document_cr_external_key on table DOCUMENT

--METADATA NAME:ndx_document_cr_external_key TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
declare 
v_spl_ind number;
maximum_key_length exception;
pragma EXCEPTION_INIT (maximum_key_length, -1450);
begin
  select count(*)  into v_spl_ind from user_ind_columns 
  where index_name= 'NDX_DOCUMENT_CR_EXTERNAL_KEY' 
  and table_name = 'DOCUMENT' 
  and column_name = 'CR_EXTERNAL_DOC_KEY'; 

  if v_spl_ind = 0 then
    execute immediate 'CREATE INDEX ndx_document_cr_external_key
    ON DOCUMENT (cr_external_doc_key)
    TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';

  end if;
exception when maximum_key_length then 
    execute immediate 'CREATE INDEX ndx_document_cr_external_key
    ON DOCUMENT (standard_hash(cr_external_doc_key))
    TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)';

  when others then
    null;
end;
/

prompt Creating index ndx_findates_1 on table FINDATES

--METADATA NAME:ndx_findates_1 TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE INDEX NDX_FINDATES_1
ON FINDATES (start_date,end_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_findates_fintmpl on table FINDATES

--METADATA NAME:ndx_findates_fintmpl TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE INDEX NDX_FINDATES_FINTMPL
ON FINDATES (fintmpl_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fintmpl_dsi on table FINTMPL

--METADATA NAME:ndx_fintmpl_dsi TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE INDEX NDX_FINTMPL_DSI
ON FINTMPL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fintmpl_upd on table FINTMPL

--METADATA NAME:ndx_fintmpl_upd TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE INDEX NDX_FINTMPL_UPD
ON FINTMPL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_imagedata_image_name on table IMAGEDATA

--METADATA NAME:ndx_imagedata_image_name TYPE:INDEX TABLE_NAME:IMAGEDATA CHANGE:CREATE
CREATE UNIQUE INDEX NDX_IMAGEDATA_IMAGE_NAME
ON IMAGEDATA (image_name)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_calendar on table PROJECT

--METADATA NAME:ndx_project_calendar TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX NDX_PROJECT_CALENDAR
ON PROJECT (clndr_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_last_fin_dates on table PROJECT

--METADATA NAME:ndx_project_last_fin_dates TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX NDX_PROJECT_LAST_FIN_DATES
ON PROJECT (last_fin_dates_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_matrix on table PROJECT

--METADATA NAME:ndx_project_matrix TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX NDX_PROJECT_MATRIX
ON PROJECT (matrix_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_fintmpl on table PROJECT

--METADATA NAME:ndx_project_fintmpl TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX NDX_PROJECT_FINTMPL
ON PROJECT (fintmpl_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecattype_dsi on table ROLECATTYPE

--METADATA NAME:ndx_rolecattype_dsi TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE INDEX NDX_ROLECATTYPE_DSI
ON ROLECATTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecattype_upd on table ROLECATTYPE

--METADATA NAME:ndx_rolecattype_upd TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE INDEX NDX_ROLECATTYPE_UPD
ON ROLECATTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_rolecattype on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_rolecattype TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX NDX_ROLECATVAL_ROLECATTYPE
ON ROLECATVAL (role_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_parent_catg on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_parent_catg TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX NDX_ROLECATVAL_PARENT_CATG
ON ROLECATVAL (parent_role_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_dsi on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_dsi TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX NDX_ROLECATVAL_DSI
ON ROLECATVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_upd on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_upd TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX NDX_ROLECATVAL_UPD
ON ROLECATVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_rolecattype on table ROLERCAT

--METADATA NAME:ndx_rolercat_rolecattype TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_ROLECATTYPE
ON ROLERCAT (role_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_rolecatval on table ROLERCAT

--METADATA NAME:ndx_rolercat_rolecatval TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_ROLECATVAL
ON ROLERCAT (role_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_update_date1 on table ROLERCAT

--METADATA NAME:ndx_rolercat_update_date1 TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_UPDATE_DATE1
ON ROLERCAT (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_dsi on table ROLERCAT

--METADATA NAME:ndx_rolercat_dsi TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_DSI
ON ROLERCAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_upd on table ROLERCAT

--METADATA NAME:ndx_rolercat_upd TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_UPD
ON ROLERCAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_unit on table RSRC

--METADATA NAME:ndx_rsrc_unit TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX NDX_RSRC_UNIT
ON RSRC (unit_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrc_curr on table RSRC

--METADATA NAME:ndx_rsrc_curr TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE INDEX NDX_RSRC_CURR
ON RSRC (curr_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_project on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_project TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX NDX_RSRCHOUR_PROJECT
ON RSRCHOUR (proj_id,ts_id,task_ts_flag,rsrc_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_status_code on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_status_code TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX NDX_RSRCHOUR_STATUS_CODE
ON RSRCHOUR (status_code,proj_id,ts_id,rsrc_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rsrchour_ts_rsrc on table RSRCHOUR

--METADATA NAME:ndx_rsrchour_ts_rsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE INDEX NDX_RSRCHOUR_TS_RSRC
ON RSRCHOUR (ts_id,rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumprojcost_wbs on table SUMPROJCOST

--METADATA NAME:ndx_sumprojcost_wbs TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE INDEX NDX_SUMPROJCOST_WBS
ON SUMPROJCOST (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumprojcost_cost_type on table SUMPROJCOST

--METADATA NAME:ndx_sumprojcost_cost_type TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE INDEX NDX_SUMPROJCOST_COST_TYPE
ON SUMPROJCOST (cost_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumprojcost_proj on table SUMPROJCOST

--METADATA NAME:ndx_sumprojcost_proj TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE INDEX NDX_SUMPROJCOST_PROJ
ON SUMPROJCOST (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtask_proj on table SUMTASK

--METADATA NAME:ndx_sumtask_proj TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE INDEX NDX_SUMTASK_PROJ
ON SUMTASK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtask_wbs on table SUMTASK

--METADATA NAME:ndx_sumtask_wbs TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE INDEX NDX_SUMTASK_WBS
ON SUMTASK (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtaskspread_proj on table SUMTASKSPREAD

--METADATA NAME:ndx_sumtaskspread_proj TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE INDEX NDX_SUMTASKSPREAD_PROJ
ON SUMTASKSPREAD (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtaskspread_wbs on table SUMTASKSPREAD

--METADATA NAME:ndx_sumtaskspread_wbs TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE INDEX NDX_SUMTASKSPREAD_WBS
ON SUMTASKSPREAD (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_project on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_project TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX NDX_SUMTRSRC_PROJECT
ON SUMTRSRC (proj_id,spread_type)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_projwbs on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_projwbs TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX NDX_SUMTRSRC_PROJWBS
ON SUMTRSRC (wbs_id,spread_type)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_rsrcrole on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_rsrcrole TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX NDX_SUMTRSRC_RSRCROLE
ON SUMTRSRC (rsrc_id,role_id,spread_type)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_sumtrsrc_projrsrcrole_id on table SUMTRSRC

--METADATA NAME:ndx_sumtrsrc_projrsrcrole_id TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE INDEX NDX_SUMTRSRC_PROJRSRCROLE_ID
ON SUMTRSRC (proj_id,rsrc_id,role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_task_proj_rsrc on table TASK

--METADATA NAME:ndx_task_proj_rsrc TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX NDX_TASK_PROJ_RSRC
ON TASK (proj_id,rsrc_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500k next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fn_task_code on table TASK

--METADATA NAME:ndx_fn_task_code TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE INDEX NDX_FN_TASK_CODE
ON TASK (task_code)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_proj_actv_code on table TASKACTV

--METADATA NAME:ndx_taskactv_proj_actv_code TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX NDX_TASKACTV_PROJ_ACTV_CODE
ON TASKACTV (proj_id,actv_code_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskactv_proj_task_actv on table TASKACTV

--METADATA NAME:ndx_taskactv_proj_task_actv TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE INDEX NDX_TASKACTV_PROJ_TASK_ACTV
ON TASKACTV (proj_id,task_id,actv_code_type_id,actv_code_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_pred_proj on table TASKPRED

--METADATA NAME:ndx_taskpred_pred_proj TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX NDX_TASKPRED_PRED_PROJ
ON TASKPRED (pred_proj_id,proj_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_perfc1 on table TASKPRED

--METADATA NAME:ndx_taskpred_perfc1 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX NDX_TASKPRED_PERFC1
ON TASKPRED (proj_id, pred_proj_id, task_pred_id, task_id, pred_task_id, pred_type, lag_hr_cnt, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskpred_perfc2 on table TASKPRED

--METADATA NAME:ndx_taskpred_perfc2 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE INDEX NDX_TASKPRED_PERFC2
ON TASKPRED (pred_proj_id,proj_id, task_id, pred_task_id, task_pred_id, pred_type, lag_hr_cnt, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrisk_risk on table TASKRISK

--METADATA NAME:ndx_taskrisk_risk TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE INDEX NDX_TASKRISK_RISK
ON TASKRISK (risk_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrisk_proj on table TASKRISK

--METADATA NAME:ndx_taskrisk_proj TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE INDEX NDX_TASKRISK_PROJ
ON TASKRISK (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrisk_task on table TASKRISK

--METADATA NAME:ndx_taskrisk_task TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE INDEX NDX_TASKRISK_TASK
ON TASKRISK (task_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_proj_rsrc on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_proj_rsrc TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX NDX_TASKRSRC_PROJ_RSRC
ON TASKRSRC (proj_id,rsrc_id, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_proj_role on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_proj_role TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX NDX_TASKRSRC_PROJ_ROLE
ON TASKRSRC (proj_id,role_id, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_taskrsrc_proj_acct on table TASKRSRC

--METADATA NAME:ndx_taskrsrc_proj_acct TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE INDEX NDX_TASKRSRC_PROJ_ACCT
ON TASKRSRC (proj_id,acct_id, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_m1 on table TASKSUM

--METADATA NAME:ndx_tasksum_m1 TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX NDX_TASKSUM_M1
ON TASKSUM (task_sum_id, wbs_id, proj_id, complete_cnt, active_cnt, notstarted_cnt, base_complete_cnt, base_active_cnt, base_notstarted_cnt, act_drtn_hr_cnt, act_equip_qty, act_work_qty, total_drtn_hr_cnt, base_drtn_hr_cnt, base_work_qty, base_equip_qty, remain_drtn_hr_cnt, remain_work_qty, remain_equip_qty, total_float_hr_cnt, act_expense_cost, act_work_cost, act_equip_cost, base_expense_cost, base_work_cost, base_equip_cost, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksum_m2 on table TASKSUM

--METADATA NAME:ndx_tasksum_m2 TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE INDEX NDX_TASKSUM_M2
ON TASKSUM (task_sum_id, wbs_id, proj_id, bcwp, bcws, remain_expense_cost, remain_work_cost, remain_equip_cost, perfm_work_qty, sched_work_qty, act_end_date, act_start_date, base_end_date, base_start_date, reend_date, restart_date, etc_work_qty, etc, act_this_per_work_cost, act_this_per_work_qty, act_this_per_equip_cost, act_this_per_equip_qty, base_mat_cost, act_mat_cost, remain_mat_cost, act_this_per_mat_cost, delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_1 on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_1 TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX NDX_TASKSUMFIN_1
ON TASKSUMFIN (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 500K next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_projwbs on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_projwbs TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX NDX_TASKSUMFIN_PROJWBS
ON TASKSUMFIN (wbs_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_findates on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_findates TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX NDX_TASKSUMFIN_FINDATES
ON TASKSUMFIN (fin_dates_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_tasksum on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_tasksum TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX NDX_TASKSUMFIN_TASKSUM
ON TASKSUMFIN (task_sum_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_dsi on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_dsi TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX NDX_TASKSUMFIN_DSI
ON TASKSUMFIN (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tasksumfin_upd on table TASKSUMFIN

--METADATA NAME:ndx_tasksumfin_upd TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE INDEX NDX_TASKSUMFIN_UPD
ON TASKSUMFIN (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tmplcatg_dsi on table TMPLCATG

--METADATA NAME:ndx_tmplcatg_dsi TYPE:INDEX TABLE_NAME:TMPLCATG CHANGE:CREATE
CREATE INDEX NDX_TMPLCATG_DSI
ON TMPLCATG (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsum_role_dialog on table TRSRCSUM

--METADATA NAME:ndx_trsrcsum_role_dialog TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE INDEX NDX_TRSRCSUM_ROLE_DIALOG
ON TRSRCSUM (proj_id,taskrsrc_sum_id,rsrc_id,role_id,skill_level,overalloc_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_1 on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_1 TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX NDX_TRSRCSUMFN_1
ON TRSRCSUMFN (fin_dates_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_project on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_project TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX NDX_TRSRCSUMFN_PROJECT
ON TRSRCSUMFN (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_roles on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_roles TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX NDX_TRSRCSUMFN_ROLES
ON TRSRCSUMFN (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_rsrc on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_rsrc TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX NDX_TRSRCSUMFN_RSRC
ON TRSRCSUMFN (rsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_trsrcsum on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_trsrcsum TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX NDX_TRSRCSUMFN_TRSRCSUM
ON TRSRCSUMFN (taskrsrc_sum_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_dsi on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_dsi TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX NDX_TRSRCSUMFN_DSI
ON TRSRCSUMFN (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_trsrcsumfn_upd on table TRSRCSUMFN

--METADATA NAME:ndx_trsrcsumfn_upd TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE INDEX NDX_TRSRCSUMFN_UPD
ON TRSRCSUMFN (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsaudit_audit_date on table TSAUDIT

--METADATA NAME:ndx_tsaudit_audit_date TYPE:INDEX TABLE_NAME:TSAUDIT CHANGE:CREATE
CREATE INDEX NDX_TSAUDIT_AUDIT_DATE
ON TSAUDIT (audit_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 80K next 80K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdelegate_1 on table TSDELEGATE

--METADATA NAME:ndx_tsdelegate_1 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE INDEX NDX_TSDELEGATE_1
ON TSDELEGATE (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdelegate_users1 on table TSDELEGATE

--METADATA NAME:ndx_tsdelegate_users1 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE INDEX NDX_TSDELEGATE_USERS1
ON TSDELEGATE (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_tsdelegate_users2 on table TSDELEGATE

--METADATA NAME:ndx_tsdelegate_users2 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE INDEX NDX_TSDELEGATE_USERS2
ON TSDELEGATE (ts_delegate_user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_useropen_users on table USEROPEN

--METADATA NAME:ndx_useropen_users TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE UNIQUE INDEX NDX_USEROPEN_USERS
ON USEROPEN (user_id,user_open_name,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_useropen_dsi on table USEROPEN

--METADATA NAME:ndx_useropen_dsi TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE INDEX NDX_USEROPEN_DSI
ON USEROPEN (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_useropen_upd on table USEROPEN

--METADATA NAME:ndx_useropen_upd TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE INDEX NDX_USEROPEN_UPD
ON USEROPEN (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_users_curr on table USERS

--METADATA NAME:ndx_users_curr TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE INDEX NDX_USERS_CURR
ON USERS (curr_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_userset_user on table USERSET

--METADATA NAME:ndx_userset_user TYPE:INDEX TABLE_NAME:USERSET CHANGE:CREATE
CREATE INDEX NDX_USERSET_USER
ON USERSET (user_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usropnval_user_open_id on table USROPNVAL

--METADATA NAME:ndx_usropnval_user_open_id TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE INDEX NDX_USROPNVAL_USER_OPEN_ID
ON USROPNVAL (user_open_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usropnval_dsi on table USROPNVAL

--METADATA NAME:ndx_usropnval_dsi TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE INDEX NDX_USROPNVAL_DSI
ON USROPNVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_usropnval_upd on table USROPNVAL

--METADATA NAME:ndx_usropnval_upd TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE INDEX NDX_USROPNVAL_UPD
ON USROPNVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdash_viewpref on table VWPREFDASH

--METADATA NAME:ndx_vwprefdash_viewpref TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE INDEX NDX_VWPREFDASH_VIEWPREF
ON VWPREFDASH (view_pref_id,dashboard_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdash_dsi on table VWPREFDASH

--METADATA NAME:ndx_vwprefdash_dsi TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE INDEX NDX_VWPREFDASH_DSI
ON VWPREFDASH (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_vwprefdash_upd on table VWPREFDASH

--METADATA NAME:ndx_vwprefdash_upd TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE INDEX NDX_VWPREFDASH_UPD
ON VWPREFDASH (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_role on table WBSRSRC

--METADATA NAME:ndx_wbsrsrc_role TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE INDEX NDX_WBSRSRC_ROLE
ON WBSRSRC (role_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100K next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_qty_fin_dates_id2 on table WBSRSRC_QTY

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id2 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE INDEX NDX_WBSRSRC_QTY_FIN_DATES_ID2
ON WBSRSRC_QTY (fin_dates_id2)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wbsrsrc_qty_fin_dates_id1 on table WBSRSRC_QTY

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id1 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE INDEX NDX_WBSRSRC_QTY_FIN_DATES_ID1
ON WBSRSRC_QTY (fin_dates_id1)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wkfltmpl_tmplcatg on table WKFLTMPL

--METADATA NAME:ndx_wkfltmpl_tmplcatg TYPE:INDEX TABLE_NAME:WKFLTMPL CHANGE:CREATE
CREATE INDEX NDX_WKFLTMPL_TMPLCATG
ON WKFLTMPL (tmplcatg_catg_id,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_wkfltmpl_dsi on table WKFLTMPL

--METADATA NAME:ndx_wkfltmpl_dsi TYPE:INDEX TABLE_NAME:WKFLTMPL CHANGE:CREATE
CREATE INDEX NDX_WKFLTMPL_DSI
ON WKFLTMPL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATVAL_asgnmnt_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATVAL_asgnmnt_catg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DISCUSSION_discussion_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DISCUSSION_discussion_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCREVIEW_doc_review_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCREVIEW_doc_review_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCREVIEWTASK_review_task_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCREVIEWTASK_review_task_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('FINTMPL_fintmpl_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('FINTMPL_fintmpl_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('IMAGEDATA_image_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('IMAGEDATA_image_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('LOCATION_location_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('LOCATION_location_id')) 
/

prompt Creating constraint pk_nextkey on table NEXTKEY


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:CREATE
ALTER TABLE NEXTKEY
ADD CONSTRAINT pk_nextkey PRIMARY KEY (key_name)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 20K next 20K minextents 1 maxextents unlimited pctincrease 0)
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATTYPE_role_catg_type_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATTYPE_role_catg_type_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATVAL_role_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATVAL_role_catg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('SUMTRSRC_sumtrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('SUMTRSRC_sumtrsrc_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKSUMFIN_task_sum_fin_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKSUMFIN_task_sum_fin_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TMPLCATG_tmplcatg_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TMPLCATG_tmplcatg_catg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TRSRCSUMFN_trsrc_sum_fin_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TRSRCSUMFN_trsrc_sum_fin_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TSAUDIT_ts_audit_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TSAUDIT_ts_audit_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TSDELEGATE_ts_delegate_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TSDELEGATE_ts_delegate_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('USEROPEN_user_open_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('USEROPEN_user_open_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WKFLTMPL_wkfl_tmpl_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WKFLTMPL_wkfl_tmpl_id')) 
/



--METADATA TYPE:UP2 GROUP:60to61 NAME:UPDATERPTAREA 
declare
  pret_val number;
  pret_msg varchar2(255);
  lobd     BLOB;
  pattern1 VARCHAR2(30) := 'GroupByTableName';
  tabname  varchar2(32);
  position INTEGER := 1;
  buf      varchar2(32767);
  cursor rptcur is
    select rpt_id from rpt;
BEGIN
  -- get the LOB locator
  for rptrec in rptcur loop
    SELECT rpt_data INTO lobd FROM rpt WHERE rpt_id = rptrec.rpt_id;
    position := DBMS_LOB.INSTR(lobd, UTL_RAW.cast_to_raw(pattern1), 1, 1);
    IF position = 0 THEN
      update rpt set rpt_area = 'UNKNOWN' where rpt_id = rptrec.rpt_id;
    ELSE
      buf     := UTL_RAW.cast_to_varchar2(DBMS_LOB.SUBSTR(lobd,
                                                          2000,
                                                          position));
      tabname := substr(buf,
                        instr(buf, '''', 1, 1) + 1,
                        instr(buf, '''', 1, 2) - instr(buf, '''', 1, 1) - 1);
      if tabname is not null then
        update rpt set rpt_area = tabname where rpt_id = rptrec.rpt_id;
      else
        update rpt set rpt_area = 'UNKNOWN' where rpt_id = rptrec.rpt_id;
      end if;
    end if;
  end loop;
  commit;
    pret_val := 0;
    pret_msg := 'Update RPT_AREA in RPT table successful' ;
   dbms_output.put_line(pret_msg);  
exception
  when value_error then
    pret_val := -1;
    pret_msg := 'Error in Updating RPT_AREA in RPT table ' || SQLERRM;
    dbms_output.put_line(pret_msg); 
  when others then
    pret_val := -1;
    pret_msg := 'Error in Updating RPT_AREA in RPT table ' || SQLERRM;
    dbms_output.put_line(pret_msg);
END;



/ 
--END TYPE:UP2 GROUP:60to61 NAME:UPDATERPTAREA
--METADATA TYPE:UP2 GROUP:60to61 NAME:MIGRATE_NAVIVIEW 
declare

   TYPE nv_type IS REF CURSOR;
   TYPE nd_type IS REF CURSOR;
   nv nv_type; 
   nd nd_type;

  vkeys pls_integer; 
  vstartkey number(10);
  existing_naviview_name varchar2(255);
  existing_user_id pls_integer;
  existing_naviview_data varchar2(4000);
  existing_default_flag char(1);
  existing_naviview_id varchar2(4000);
  TimesheetApproval varchar2(4000);
  ProjectTimesheetApproval varchar2(4000);
  ApproveTimesheets varchar2(4000);
  start_pos pls_integer;
  end_pos pls_integer;
  tempstr varchar2(255);
  done pls_integer;
  vwprefkey varchar2(255);
  vwprefkey_val varchar2(40);
  vwprefkeyseq_val varchar2(40);
  dashboardid pls_integer;
  seqnum pls_integer;
  tableexist   pls_integer;
  dyn_sql_string varchar2(4000);

BEGIN
  SELECT COUNT(1)
  INTO tableexist
  FROM user_tables
  WHERE table_name = 'NAVIVIEW';

  IF tableexist = 1 THEN

    -- Get nextkeys for INSERTs
    dyn_sql_string := 'SELECT count(*) ' ||
                      'FROM naviview ';
    EXECUTE IMMEDIATE dyn_sql_string
                      INTO vkeys; 

    IF vkeys > 0 THEN
      getnextkeys('viewpref_view_pref_id', vkeys, vstartkey);
      COMMIT;
    END IF;

    --Process rows in naviview table
    OPEN nv FOR
      'SELECT navi_view_id ' || 
      'FROM naviview';

    LOOP
      FETCH nv INTO existing_naviview_id;
      EXIT WHEN nv%NOTFOUND;

      dyn_sql_string := 'SELECT navi_view_name, user_id, navi_view_data, default_flag ' ||
                        'FROM naviview ' ||
                        'WHERE navi_view_id = :1 ';
      EXECUTE IMMEDIATE dyn_sql_string
                        INTO existing_naviview_name, existing_user_id, existing_naviview_data, existing_default_flag  
                        USING existing_naviview_id;
   
      --Add row to ViewPref
      dyn_sql_string := 'INSERT INTO viewpref (view_pref_id, view_pref_name, view_pref_type, user_id ) ' ||
                        'VALUES (:1, :2, :3, :4) ';
      EXECUTE IMMEDIATE dyn_sql_string
                        USING vstartkey, existing_naviview_name, 'VT_UIVIEW', existing_user_id;

      --Add rows to VWPREFDATA for each value in NAVIVIEW.navi_view_data
      start_pos := INSTR(existing_naviview_data, '<NavigationViewContentData>');
      existing_naviview_data := SUBSTR(existing_naviview_data, start_pos + LENGTH('<NavigationViewContentData>') );
        
      LOOP
          start_pos := INSTR(existing_naviview_data, '<');
          end_pos := INSTR(existing_naviview_data, '/>');
          IF (end_pos = 0) or (start_pos = 0) THEN
		  EXIT;
          ELSE
            tempstr := SUBSTR(existing_naviview_data, start_pos+1, end_pos-start_pos-1);
            existing_naviview_data := SUBSTR(existing_naviview_data, end_pos + 2);
            vwprefkey := RTRIM(SUBSTR(tempstr, 1, INSTR(tempstr, ' ')));
            start_pos := INSTR(tempstr, 'value="') + 7;
            vwprefkey_val := SUBSTR(tempstr, start_pos, INSTR(tempstr, '"', start_pos)-start_pos); 
          

          
            dyn_sql_string := 'UPDATE users SET ui_view_pref_id =  :1' ||
                              'WHERE navi_view_id =  :2';
            EXECUTE IMMEDIATE dyn_sql_string
                              USING vstartkey, existing_naviview_id;
          

          IF vwprefkey = 'ProjectTimesheetApproval' THEN
            ProjectTimesheetApproval := vwprefkey_val;
          ELSIF vwprefkey = 'ApproveTimesheets' THEN
            ApproveTimesheets := vwprefkey_val;
          ELSE
            dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                              'VALUES (:1, :2, :3) ';
            EXECUTE IMMEDIATE dyn_sql_string 
                              USING vstartkey, 'UIView.' || vwprefkey, vwprefkey_val;

            start_pos := INSTR(tempstr,'sequenceNum="');
            IF start_pos > 0 THEN
              start_pos := start_pos + 13;
              vwprefkeyseq_val := SUBSTR(tempstr, start_pos, INSTR(tempstr, '"', start_pos)-start_pos); 
	    dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                              'VALUES (:1, :2, :3) ';
            EXECUTE IMMEDIATE dyn_sql_string 
                              USING vstartkey, 'UIView.' || vwprefkey || 'Seq', vwprefkeyseq_val;
            END IF;

          END IF;
        END IF;

        IF (TRIM(existing_naviview_data) = '</NavigationViewContentData>') THEN
	  EXIT;
        END IF;
      END LOOP; 

      --Create new combo key for ProjectTimesheetApproval and ApprovedTimesheets
      TimesheetApproval := 'true';
      IF (LOWER(ProjectTimesheetApproval)='false') AND (LOWER(ApproveTimesheets)='false') THEN
        TimesheetApproval := 'false';
      END IF;
      dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                        'VALUES (:1, :2, :3) ';
      EXECUTE IMMEDIATE dyn_sql_string 
                        USING vstartkey, 'UIView.' || 'TimesheetApproval', TimesheetApproval;

      dyn_sql_string := 'INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value) ' ||
                        'VALUES (:1, :2, :3) ';
      EXECUTE IMMEDIATE dyn_sql_string 
                        USING vstartkey, 'UIView.' || 'TimesheetApprovalSeq', '3';

      --Populate VWPREFDASH
      OPEN nd FOR
        'SELECT dashboard_id, seq_num ' ||
        'FROM navidash ' ||
        'WHERE navi_view_id = ' || existing_naviview_id;
      LOOP
        FETCH nd INTO dashboardid, seqnum;
        EXIT WHEN nd%NOTFOUND;
        dyn_sql_string := 'INSERT INTO vwprefdash (dashboard_id, seq_num, view_pref_id) ' ||
                          'VALUES (:1, :2, :3) ';
        EXECUTE IMMEDIATE dyn_sql_string 
                          USING dashboardid, seqnum, vstartkey;
      END LOOP;
      CLOSE nd;

      --Update Settings table with default view
      IF existing_default_flag = 'Y' THEN
        dyn_sql_string := 'INSERT INTO settings (namespace, setting_name, setting_value) ' ||
                          'VALUES (:1, :2, :3) ';
        EXECUTE IMMEDIATE dyn_sql_string 
                          USING 'VT_UIVIEW', 'UIView.DefaultViewId', vstartkey;
      END IF;

      vstartkey := vstartkey + 1;

    END LOOP;
    CLOSE nv;
  
  EXECUTE IMMEDIATE 'DROP TABLE navidash';
  EXECUTE IMMEDIATE 'DROP TABLE naviview';
  EXECUTE IMMEDIATE 'DROP VIEW privuser.navidash';
  EXECUTE IMMEDIATE 'DROP VIEW privuser.naviview';

  END IF; --NAVIVIEW exists
  COMMIT;
  
 
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;
END;



/ 
--END TYPE:UP2 GROUP:60to61 NAME:MIGRATE_NAVIVIEW
--METADATA TYPE:UP2 GROUP:61to62 NAME:UPDATE_VWPREFDATA 
declare
  cursor vwcur is select view_pref_id,view_pref_type from viewpref  where view_pref_type='VT_UIVIEW' ;
  dyn_sql_string varchar2(4000);
  TYPE varray_type IS VARRAY(10) OF VARCHAR2(32);
  vwkeys varray_type;  
  vwvalues varray_type; 
BEGIN
 vwkeys:=varray_type('UIView.DeleteProject','UIView.DeleteProjectSeq','UIView.ManagePortfoliosPort','UIView.ManagePortfoliosPortSeq','UIView.OpenPortfolios','UIView.OpenPortfoliosSeq','UIView.OpenProject','UIView.OpenProjectSeq');
 vwvalues:=varray_type('true','5','true','4','true','3','true','4');
--delete rows for VWPREFDATA
delete from VWPREFDATA where VIEW_PREF_KEY in ('UIView.ApproveTimesheets','UIView.ApproveTimesheetsSeq','UIView.CreatePortfolio','UIView.CreatePortfolioSeq','UIView.InitiateProjectProcess','UIView.InitiateProjectProcessSeq','UIView.ProjectTimesheetApproval','UIView.ProjectTimesheetApprovalSeq');  
for vwrec in vwcur loop
for i in vwkeys.FIRST..vwkeys.LAST
loop
dyn_sql_string :='insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)'|| 'values(:1,:2,:3)';
EXECUTE IMMEDIATE dyn_sql_string using vwrec.view_pref_id,vwkeys(i),vwvalues(i);
end loop;
end loop;
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;

END;


/ 
--END TYPE:UP2 GROUP:61to62 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:61to62 NAME:DELETE_ADMIN_CONFIG 
begin
UPDATE TASKRSRC set act_this_per_qty=0.0 where act_this_per_qty is null;
DELETE from admin_config where config_name = 'myprimavera.bre.INTERNAL_PLUGINS';
end;


/ 
--END TYPE:UP2 GROUP:61to62 NAME:DELETE_ADMIN_CONFIG
--METADATA TYPE:UP2 GROUP:61to62 NAME:UPDATE_SETTINGS 
begin
insert into settings (namespace, setting_name, setting_value) select distinct 'Table_Settings', 'udfvalue_denorm',
'N' from settings where not exists ( select 1 from settings where namespace='Table_Settings' and setting_name =
'udfvalue_denorm' );

insert into settings (namespace, setting_name, setting_value) select distinct 'Query_Settings',
'tasksum_query_split', 'N' from settings where not exists ( select 1 from settings where namespace='Query_Settings'
and setting_name = 'tasksum_query_split' );
end;


/ 
--END TYPE:UP2 GROUP:61to62 NAME:UPDATE_SETTINGS
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA 
declare
  cursor cur_vpdata is
  select DISTINCT view_pref_id 
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
  or    upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType');
  v_firstbardisptype varchar2(255);
 v_secondbardisptype varchar2(255);
begin
  for r_vpdata in cur_vpdata loop
  
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value)
select r_vpdata.view_pref_id view_pref_id, 'VT_ACTIVITY.BarDisplayTypes' view_pref_key, 'NORMAL_BAR' view_pref_value
from VWPREFDATA 
where view_pref_id = r_vpdata.view_pref_id 
and not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes') and view_pref_id = r_vpdata.view_pref_id)
and rownum < 2;

select upper(view_pref_value) into v_firstbardisptype
			from VWPREFDATA
			where view_pref_id = r_vpdata.view_pref_id
      and   upper(view_pref_key) = upper('VT_ACTIVITY.FirstBarDisplayType');
begin      
select upper(view_pref_value) into v_secondbardisptype
			from VWPREFDATA
			where view_pref_id = r_vpdata.view_pref_id
      and   upper(view_pref_key) = upper('VT_ACTIVITY.SecondBarDisplayType');
 
exception
 when no_data_found then  v_secondbardisptype:=null;
 end;
 
update VWPREFDATA
set view_pref_value = v_firstbardisptype || 
			decode(nvl(v_secondbardisptype, ''), 'NO_BAR', '', '', '', ',' ||case when v_secondbardisptype='BASELINE_BAR' then 'PRIMARY_BASELINE_BAR' else v_secondbardisptype end) 
where view_pref_id = r_vpdata.view_pref_id 
and   upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes');


delete from VWPREFDATA 
where view_pref_id = r_vpdata.view_pref_id 
and (upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
      or    
      upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType')
    );

commit;

end loop;
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(view_pref_id),'UIView.ImportExportProject','Y' from viewpref where view_pref_type='VT_UIVIEW'; 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(view_pref_id),'UIView.ImportExportProjectSeq','5' from viewpref where view_pref_type='VT_UIVIEW' ;
end; 


/ 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS 
declare
db_version varchar2(255);
begin
select database_version into db_version from prefer;
if substr(db_version, length ('PMDB,') + 1, 4) >'0600' then
execute immediate('begin drop_background_procs;end;');
end if;
delete from settings where namespace='database.background.Damon';
delete from settings where namespace='database.background.Symon';
commit;
end;


/ 
--END TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG 
declare 
cursor usercur is select user_id from users where prof_id=12;
vusereng_id  usereng.user_eng_id%TYPE;
TYPE varray_type IS VARRAY(10) OF VARCHAR2(32);
cnt pls_integer;
engtype varray_type;
dyn_sql_string varchar2(4000);
begin 
engtype:=varray_type('PM','TS','WEB_PM','WEB_RM','WU','TS_ONLY');
select key_seq_num into vusereng_id from nextkey where key_name='usereng_user_eng_id';
for userrec in usercur loop
for i in engtype.FIRST..engtype.LAST
loop
begin
cnt:=0;
select 1 into cnt from usereng where db_engine_type=engtype(i) and user_id=userrec.user_id and rownum < 2;
exception when no_data_found then 
 null;
end;
if cnt=0 then 
dyn_sql_string:='insert into usereng(user_eng_id,user_id,db_engine_type) values (:1,:2,:3)';
EXECUTE IMMEDIATE dyn_sql_string using vusereng_id,userrec.user_id,engtype(i);
vusereng_id:=vusereng_id+1; 
end if;
end loop;
end loop;
update nextkey set key_seq_num=vusereng_id where key_name='usereng_user_eng_id';  
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;
END;


/ 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG
--METADATA TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA 
declare
vprefid viewpref.view_pref_id%TYPE;
max_view_pref_id viewpref.view_pref_id%TYPE;
CURSOR cur_vpdata IS
SELECT DISTINCT view_pref_id
FROM vwprefdata
WHERE UPPER(view_pref_key) LIKE UPPER('VT_ACTIVITY.Filter')
 AND UPPER(view_pref_value) LIKE UPPER('CustomFilter');
CURSOR cur_vpfilterdata IS
SELECT DISTINCT view_pref_id,
  view_pref_value
FROM vwprefdata
WHERE UPPER(view_pref_key) LIKE UPPER('VT_FILTER.FilterCriteria');
BEGIN
  SELECT key_seq_num
  INTO vprefid
  FROM nextkey
  WHERE key_name = 'viewpref_view_pref_id';
  SELECT MAX(view_pref_id)
  INTO max_view_pref_id
  FROM viewpref;

  IF(vprefid <= max_view_pref_id) THEN
    vprefid := max_view_pref_id + 1;
  END IF;

  FOR r_vpdata IN cur_vpdata
  LOOP
    INSERT
    INTO viewpref(view_pref_id,   view_pref_name,   view_pref_type,   user_id)
    SELECT vprefid,
      view_pref_name,
      'VT_FILTER',
      user_id
    FROM viewpref
    WHERE view_pref_id = r_vpdata.view_pref_id;
    INSERT
    INTO vwprefdata(view_pref_id,   view_pref_key,   view_pref_value)
    SELECT vprefid,
      'VT_FILTER.FilterCriteria',
      view_pref_value
    FROM vwprefdata
    WHERE view_pref_id = r_vpdata.view_pref_id
     AND UPPER(view_pref_key) = UPPER('VT_ACTIVITY.FilterCriteria')
     AND NOT EXISTS
      (SELECT 1
       FROM vwprefdata
       WHERE UPPER(view_pref_key) = UPPER('VT_FILTER.FilterCriteria')
       AND view_pref_id = vprefid)
    AND rownum < 2;
    INSERT
    INTO vwprefuser(view_pref_id,   user_id)
    SELECT vprefid,
      user_id
    FROM vwprefuser
    WHERE view_pref_id = r_vpdata.view_pref_id;

    UPDATE vwprefdata
    SET view_pref_value = 'TreeFilter'
    WHERE view_pref_key = 'VT_ACTIVITY.Filter'
     AND view_pref_id = r_vpdata.view_pref_id;
    INSERT
    INTO vwprefdata(view_pref_id,   view_pref_key,   view_pref_value)
    SELECT r_vpdata.view_pref_id,
      'VT_ACTIVITY.FiltersList',
      vprefid
    FROM dual
    WHERE NOT EXISTS
      (SELECT 1
       FROM vwprefdata
       WHERE UPPER(view_pref_key) = UPPER('VT_ACTIVITY.FiltersList')
       AND view_pref_id = r_vpdata.view_pref_id)
    AND rownum < 2;

    DELETE FROM vwprefdata
    WHERE view_pref_id = r_vpdata.view_pref_id
     AND UPPER(view_pref_key) = UPPER('VT_ACTIVITY.FilterCriteria');
    vprefid := vprefid + 1;
  END LOOP;

  UPDATE nextkey
  SET key_seq_num = vprefid
  WHERE key_name = 'viewpref_view_pref_id';
  COMMIT;
  FOR r_vpfilterdata IN cur_vpfilterdata
  LOOP
    IF instr(UPPER(r_vpfilterdata.view_pref_value),   'UDF:') > 0 THEN
        r_vpfilterdata.view_pref_value:=REPLACE(r_vpfilterdata.view_pref_value,   'UDF:',   'UDF_');
    END IF;
  
    IF instr(UPPER(r_vpfilterdata.view_pref_value),   UPPER('ActivityCodeTypeId:')) > 0 THEN
       r_vpfilterdata.view_pref_value:= REPLACE(r_vpfilterdata.view_pref_value,   'ActivityCodeTypeId:',   'ActivityCodeTypeId_');
    END IF;
    
    UPDATE vwprefdata
      SET view_pref_value = r_vpfilterdata.view_pref_value
      WHERE view_pref_id = r_vpfilterdata.view_pref_id;
  END LOOP;

EXCEPTION
WHEN others THEN
  DBMS_OUTPUT.PUT_LINE('Error while migrating filters');
END;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
declare
  cursor vwcur is select view_pref_id,view_pref_type from viewpref  where view_pref_type='VT_UIVIEW' ;
  dyn_sql_string varchar2(4000);
  TYPE varray_type IS VARRAY(2) OF VARCHAR2(32);
  vwkeys varray_type;  
  vwvalues varray_type; 
BEGIN
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,158,decode(p.prof_id,12,'Y','N'), sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id
and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=158);
 vwkeys:=varray_type('UIView.CreateTemplateProject','UIView.CreateTemplateProjectSeq');
 vwvalues:=varray_type('true','6');
for vwrec in vwcur loop
for i in vwkeys.FIRST..vwkeys.LAST
loop
dyn_sql_string :='insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)'|| 'values(:1,:2,:3)';
EXECUTE IMMEDIATE dyn_sql_string using vwrec.view_pref_id,vwkeys(i),vwvalues(i);
end loop;
end loop;
exception
  when others THEN
    dbms_output.put_line('Error: ' || SQLERRM);
    rollback;
END;



/ 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA 
declare
earnedValue INTEGER:=0;
blobField BLOB;
valuePatternAtCompl VARCHAR2(30) := 'EV_AtCompl';
valuePatternBudgCur VARCHAR2(30) := 'EV_Budg_With_Start_Dates';
valuePatternBudg VARCHAR2(30) := 'EV_Budg';
settingsName VARCHAR2(30):= 'EVCalculation';
insertValueAtCompl VARCHAR2(30):= 'EV_AtCompl';
insertValueBudgCur VARCHAR2(30):= 'EV_BudgCur';
insertValueBudg    VARCHAR2(30):= 'EV_Budg';
begin

  begin
    select 1 into earnedValue from settings where setting_name='EVCalculation';
    exception when no_data_found then
      null;
  end;

  if earnedValue=0 then
    
    begin
      select config_data into blobField from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0';
        exception when no_data_found then
      null;
      return;
    end;
    
    if DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePatternAtCompl), 1, 1) != 0 then
      insert into settings(namespace, setting_name, setting_value) 
      values('Administrator_Settings', settingsName, insertValueAtCompl);
    elsif DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePatternBudgCur), 1, 1) != 0 then
      insert into settings(namespace, setting_name, setting_value) 
      values('Administrator_Settings', settingsName, insertValueBudgCur);
    elsif DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePatternBudg), 1, 1) != 0 then
      insert into settings(namespace, setting_name, setting_value) 
      values('Administrator_Settings', settingsName, insertValueBudg);
    end if;
  end if;
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT 
declare
blobField BLOB;
valuePattern VARCHAR2(30) := 'pvurl';
begin
  begin

    UPDATE settings SET namespace='Administrator_Settings', setting_name='MaxBaselinesCopiedWithProject' WHERE namespace='projectmanager.copyproject.baselines';

    begin
      select config_data into blobField from admin_config where config_name='CS_ADMIN';
        exception when no_data_found then
      null;
      return;
    end;
    
    if DBMS_LOB.INSTR(blobField, UTL_RAW.cast_to_raw(valuePattern), 1, 1) != 0 then
      insert into settings(namespace, setting_name) 
      values('Administrator_Settings', 'WebAccessURL');
    end if;
  end;

  UPDATE project set batch_sum_flag = 'N' where sum_only_flag = 'Y';
  UPDATE project set sum_only_flag = 'N', msp_managed_flag = 'N' where sum_only_flag != 'N' or msp_managed_flag != 'N';

end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES 
begin
  insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,160, case p.prof_id when 12 then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=160);

insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)
select distinct p.prof_id,161,case p.allow_flag when 'Y' then 'Y' else 'N'  end , sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id  and p.priv_num = 18 and not exists(select * from profpriv where prof_id=p.prof_id and priv_num=161);


end;


/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES
--METADATA TYPE:UP2 GROUP:70to71 NAME:DROP_BACKGROUND_JOBS 
begin
 drop_background_procs();
 begin
  DBMS_SCHEDULER.disable(name=>'SYMON', force => TRUE);
  exception when others then null;
  end;
 begin
  DBMS_SCHEDULER.disable(name=>'DAMON', force => TRUE);
   exception when others then null;
  end;
 begin 
 DBMS_SCHEDULER.drop_job(job_name => 'SYMON', force => TRUE);
 exception when others then null;
  end;
 begin 
 DBMS_SCHEDULER.drop_job(job_name => 'DAMON', force => TRUE); 
 exception when others then null;
 end;
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:DROP_BACKGROUND_JOBS
--METADATA TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC 
begin
  DELETE FROM jobsvc WHERE job_type='JT_Batch' OR job_type='JT_XERExport' OR recur_type='RT_ASAP';
  UPDATE jobsvc SET recur_type='RT_WebEnabled' WHERE recur_type='RT_RecurEnabled';
  UPDATE taskrsrc SET ot_factor=0,update_date=sysdate,update_user=sys_context('USERENV','CURRENT_SCHEMA') WHERE rsrc_id IS NULL and (ot_factor is null or ot_factor!=0);
  commit;
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF
declare
vprefid pls_integer;
BEGIN
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignINoWhatIf','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignINoWhatIf' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;

    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignHActive','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignHActive' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
  
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignCInProgress','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignCInProgress' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;

    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignFFinDays','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignFFinDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;

    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignAMyAssign','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignAMyAssign' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignGUnStaffed','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignGUnStaffed' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignEOccurDays','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignEOccurDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignBNotStarted','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignBNotStarted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'AssignDCompleted','VT_ASSGN_FILT_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignDCompleted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'InProgressActivitiesOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ActivitiesFinishingSoon','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesFinishingSoon' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'CompletedActivitiesOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'NotStartedActivitiesOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'MilestoneOnly','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MilestoneOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'MyActivities','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MyActivities' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ActivitiesProgressing','VT_FILTER_STANDARD'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesProgressing' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectBEPS','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectBEPS' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectGWhatIf','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectGWhatIf' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectCActive','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectCActive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectAOpenOnly','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectAOpenOnly' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectFTemplate','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectFTemplate' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectDInactive','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectDInactive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;
    
    vprefid:= copy_utils.Get_Next_Key('viewpref_view_pref_id');
    insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) select vprefid,'ProjectEPlanned','VT_PROJ_FILTER_STAND'
    from dual
    where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectEPlanned' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ;

  commit;
END;
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
DELETE FROM profpriv where priv_num=143
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:COMMIT
commit
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
--METADATA TYPE:UP2 GROUP:70to71 NAME:DELETE_VWPREFDATA
delete from vwprefdata where view_pref_key in ('UIView.ProjectDetailsSeq','UIView.ProjectToolsSeq','UIView.ProjectInvitedUsersSeq','UIView.ProjectIssueFormsSeq','UIView.ProjectDetails','UIView.ProjectTools','UIView.ProjectInvitedUsers','UIView.ProjectIssueForms')
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
update vwprefdata set view_pref_value=to_number(view_pref_value)+1,update_date=sysdate where view_pref_id in (select view_pref_id from viewpref where  view_pref_type='VT_UIVIEW') and view_pref_key<>'UIView.ProjectEPSSeq' and view_pref_key like 'UIView.Pr%Seq' and to_number(view_pref_value)>=1
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
insert into vwprefdata(view_pref_id,View_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPSSeq','1',sysdate from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where   vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPSSeq' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA
insert into vwprefdata(view_pref_id,View_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPS','true',sysdate from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where   vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPS' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
/
--METADATA TYPE:UP2 GROUP:70to71 NAME:COMMIT
commit
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES 
DECLARE
  v_id_list VWPREFDATA.VIEW_PREF_VALUE%TYPE;
begin
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','false' 
  from vwprefdata vwp,viewpref vp
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id not in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') and view_pref_value = 'true'
      ) ;
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','true' 
  from vwprefdata vwp,viewpref vp
  where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') 
        and view_pref_value = 'true'
      ) ;
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','false' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
    and vwp.view_pref_id not in (select distinct view_pref_id
                                 from vwprefdata  
                                 where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
      and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
    and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
      and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','false' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id not in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
 select  distinct  vwp.view_pref_id,'UIView.DetailedPlanning','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select *
                   from vwprefdata vw
                   where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.DetailedPlanning'
                     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
 insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) 
 select  distinct  vwp.view_pref_id,'UIView.EnterpriseResourceData','true' 
 from vwprefdata vwp,viewpref vp 
 where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and  not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.EnterpriseResourceData' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
    
 SELECT MIN(view_pref_id)||','|| MAX(view_pref_id)  INTO v_id_list
 FROM VIEWPREF 
 WHERE view_pref_name IN ('InProgressActivitiesOnly','NotStartedActivitiesOnly') ;
    
 FOR cur_id IN (select view_pref_id from vwprefdata where view_pref_key='VT_ACTIVITY.Filter' and view_pref_value='NotFinishedActivitiesOnly')
 LOOP
   UPDATE VWPREFDATA SET view_pref_value='TreeFilter' WHERE view_pref_key='VT_ACTIVITY.Filter' AND view_pref_id=cur_id.view_pref_id; 
   INSERT INTO VWPREFDATA (view_pref_id,view_pref_key, view_pref_value) values(cur_id.view_pref_id, 'VT_ACTIVITY.FiltersList', v_id_list); 
   INSERT INTO VWPREFDATA (view_pref_id,view_pref_key, view_pref_value) values(cur_id.view_pref_id, 'VT_ACTIVITY.FiltersOperator', 'OR'); 
 END LOOP;
    
end;

/ 
--END TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV
DELETE from usereng
where db_engine_type ='TS' 
  and user_id in (select user_id from usereng where db_engine_type != 'PM' and db_engine_type != 'TS')
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
DELETE FROM profpriv where priv_num=151
/

--METADATA TYPE:UP2 GROUP:70to71 NAME:COMMIT
commit
/

/ 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES 
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,159,case p.allow_flag when 'Y' then 'Y' else 'N' END, sysdate, sys_context('USERENV','CURRENT_SCHEMA') from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=159)
/


/ 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK 
Declare
  CURSOR Priskcur
  IS
    SELECT
      P.Risk_id,
      P.Proj_id,
      Pw.Wbs_name,
      P.Add_date,
      P.Priority_type,
      DECODE(P.Status_code, 'RS_Closed', 'RS_Manage', P.Status_code) status_code,
      P.Risk_name,
      P.Risk_type_id,
      P.Rsrc_id,
      P.Prbly_pct,
      P.Impact_work_qty,
      P.Impact_equip_qty,
      P.Impact_expense_cost,
      P.Impact_date,
      P.Impact_mat_qty,
      p.risk_descr,
      rc.risk_control,
      O.Obs_name,
      R.Rsrc_name
    FROM
      Projrisk P
    LEFT OUTER JOIN Riskctrl rc
    ON
      p.risk_id=rc.risk_id
    LEFT OUTER JOIN projwbs pw
    ON
      p.wbs_id=pw.wbs_id
    LEFT OUTER JOIN Obs O
    ON
      P.Obs_id=O.Obs_id
    LEFT OUTER JOIN Rsrc R
    ON
      P.Rsrc_id=R.Rsrc_id ;
BEGIN
  FOR priskrec IN Priskcur
  LOOP
    UPDATE
      projrisk
    SET
      notes=SUBSTR('Applies to WBS-'
      || priskrec.WBS_name
      || chr(13)
      || 'Responsible Manager-'
      || priskrec.obs_name
      || chr(13)
      ||'Priority-'
      || priskrec.priority_type
      || chr(13)
      || 'Date Identified-'
      || TO_CHAR(priskrec.add_date,'mon-dd-yyyy hh:mi:ss')
      || chr(13)
      || 'Impact Date-'
      || TO_CHAR(priskrec.impact_date,'mon-dd-yyyy hh:mi:ss')
      || chr(13)
      ||'Probability-'
      ||priskrec.prbly_pct
      || chr(13)
      ||'Impact - Labor Units-'
      ||priskrec.impact_work_qty
      || chr(13)
      ||'Impact - Nonlabor Units-'
      ||priskrec.impact_equip_qty
      || chr(13)
      ||'Impact - Material Units-'
      ||priskrec.impact_mat_qty
      || chr(13)
      || 'Impact - Expenses-'
      || priskrec.impact_expense_cost
      || chr(13)
      || utl_raw.cast_to_varchar2(dbms_lob.substr(priskrec.risk_control,2000,1)
      ),1,4000),
      risk_code='PROJRISK-'
      ||risk_id,risk_desc=utl_raw.cast_to_varchar2(dbms_lob.substr(priskrec.risk_descr,4000,1)),status_code=priskrec.status_code
    WHERE
      risk_id=priskrec.risk_id;
  END LOOP;
  COMMIT;
END;


/ 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK
--METADATA TYPE:UP2 GROUP:70to71 NAME:ALTER_PROJRISK 
--METADATA NAME:wbs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  wbs_id CASCADE CONSTRAINTS
/
 
--METADATA NAME:priority_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  priority_type CASCADE CONSTRAINTS
/
 
--METADATA NAME:obs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  obs_id CASCADE CONSTRAINTS
/
 
--METADATA NAME:prbly_pct TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  prbly_pct CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_work_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_work_qty CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_equip_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_equip_qty CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_expense_cost TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_expense_cost CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_date CASCADE CONSTRAINTS
/
 
--METADATA NAME:impact_mat_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_mat_qty CASCADE CONSTRAINTS


/ 
--END TYPE:UP2 GROUP:70to71 NAME:ALTER_PROJRISK
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

INSERT INTO SETTINGS (namespace,setting_name,setting_value) VALUES('Administrator_Settings','OnlineHelpRootUrl','http://docs.oracle.com/cd/E35157_01/client_help/')
/

update udfvalue uv set TABLE_NAME = (select TABLE_NAME from udftype ut where ut.udf_type_id = uv.udf_type_id)
/

merge into settings ss using dual
on ( namespace='Table_Settings' and setting_name='udfvalue_denorm')
when matched then
update set setting_value='N'
When not matched then
insert (namespace,setting_name,setting_value)
values('Table_Settings','udfvalue_denorm','N')
/


--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

  declare
  vpropid pls_integer;
  BEGIN
      vpropid:= copy_utils.Get_Next_Key('viewprop_view_id');
      insert into viewprop(VIEW_ID,VIEW_NAME,VIEW_TYPE) select vpropid,'Default Import Template','VP_XML_IMP_DET_OPT'
      from dual
      where not exists ( select view_id from viewprop where VIEW_NAME = 'Default Import Template' and VIEW_TYPE = 'VP_XML_IMP_DET_OPT') ;
      
        commit;
  END;
/


/ 
--END TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
UPDATE PROJRISK p
SET p.risk_desc =LTRIM(RTRIM(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE((REGEXP_REPLACE(p.risk_desc,'<[^>]*>','')), '&' || 'nbsp;', ''), '&' || 'nbsp', ' '), 'amp;', '&' ), '&' || 'lt;', '<'), '&' || 'gt;', '>'), chr(13), ' '), chr(10), '')))






/ 
--END TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
merge into settings ss using dual
on ( namespace='Administrator_Settings' and setting_name='AlwaysLaunchOnlineHelp')
when matched then
update set setting_value='Y'
When not matched then
insert (namespace,setting_name,setting_value)
values('Administrator_Settings','AlwaysLaunchOnlineHelp','Y')
/


--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set setting_value = 'Y' where setting_name = 'AlwaysLaunchOnlineHelp'
/

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set  setting_value='http://docs.oracle.com/cd/E54700_01/client_help/' where setting_name='OnlineHelpRootUrl'
/

/ 
--END TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E58732_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
declare 
cursor uid_cur is 
 select ue1.user_id from usereng ue1
   where ue1.db_engine_type in ('PM','WEB_PM','WEB_RM');
v_user_eng_id number;
begin
  for r_uid_cur in uid_cur loop
    dbms_output.put_line('userid : ' || r_uid_cur.user_id);
    getnextkeys ('usereng_user_eng_id', 1, v_user_eng_id);
    dbms_output.put_line('usereng_user_eng_id : ' || v_user_eng_id);
    INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
    values(v_user_eng_id, r_uid_cur.user_id,'VIS');
  end loop;
  commit; 
end;
/
/ 
--END TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION 
--METADATA NAME:RT_USESSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:DROP
DECLARE trigger_exist pls_integer;
BEGIN 
SELECT count(*) INTO trigger_exist FROM user_triggers WHERE trigger_name = 'RT_USESSION_DEL';
IF trigger_exist=1
THEN EXECUTE IMMEDIATE 'DROP TRIGGER RT_USESSION_DEL' ;
END IF;
EXCEPTION WHEN no_data_found THEN NULL;
END;
/

--METADATA NAME:RT_USESSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE OR REPLACE TRIGGER RT_USESSION
BEFORE UPDATE OR INSERT ON USESSION
FOR EACH ROW
BEGIN
  if dbms_reputil.from_remote = true then   return; end if;
  
  :NEW.update_date := SYSDATE;
  
  :NEW.update_user := prm_audit.g_prm_user_name;

  IF INSERTING THEN
	:NEW.create_user := prm_audit.g_prm_user_name;
	:NEW.create_date := SYSDATE;
  END IF;		
end; 
/
/ 
--END TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES 
 --METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E63417_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
/
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
/
/ 
--END TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E68202_01' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E75426_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E90748_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
update prefer set license_data=null
/
/ 
--END TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
insert into PROFPRIV (prof_id,priv_num,allow_flag)
select DISTINCT a.PROF_ID,177,'Y' from PROFPRIV a
where not exists ( select 1 from PROFPRIV b where b.PROF_ID=a.PROF_ID and b.priv_num=177 and b.allow_flag='Y') 
/

/ 
--END TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for v_cur in profile_cur loop
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=177;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=177;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=177;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,177,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,177,'N');
end if;
end;
end loop;
end;
/

/ 
--END TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
/
/ 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
/
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/


/ 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
  cursor cur is select IMAGE_NAME ,image_id from IMAGEDATA;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('IMAGEDATA') and column_name=upper('Image_Extension');
  if col_exists > 0 then
   for i in cur loop 
    begin
      if instr(i.image_name,'.')>0 then
      execute immediate 'update imagedata
        set image_name = :1,
            image_extension = :2
      where image_id=:3' using SUBSTR(i.image_name,1,INSTR(i.image_name,'.',-1,1)-1),SUBSTR(i.image_name,INSTR(i.image_name,'.',-1,1)+1),i.image_id;  
      end if;
    exception when others then
      null;
    end;
   end loop;
  end if;
 END;
 /
 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv pp
where exists
(select p.prof_id from profile p 
where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project')
/




/ 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
DECLARE
v_len number;
v_start_point number;
v_final blob;
cursor c is select issue_id,issue_notes 
from projissu where issue_notes is NOT NULL ;
begin
for rec in c loop
v_len := dbms_lob.getlength(rec.issue_notes);
if(v_len is not null and v_len > 0) then
v_start_point:=dbms_lob.instr(rec.issue_notes, utl_raw.cast_to_raw('DOCTYPE'));
if (v_start_point=0 or v_start_point is null) then
  dbms_lob.createtemporary(v_final, true);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'));
  dbms_lob.append(v_final, rec.issue_notes);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('</SPAN></BODY></HTML>'));
  execute immediate 'update projissu set issue_notes = :1 where issue_id= :2' using v_final,rec.issue_id;
commit;
end if;
end if;
end loop;
dbms_lob.freetemporary(v_final);
dbms_lob.close(v_final);
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
DECLARE 
    v_count          NUMBER; 
    v_no_data_found  NUMBER;
    v_start_date     rolelimit.start_date%TYPE; 
    v_max_qty_per_hr rolelimit.max_qty_per_hr%TYPE; 
    v_role_rate_id   rolerate.role_rate_id%TYPE; 
    CURSOR rolerate_cur IS SELECT * FROM rolerate 
      WHERE role_id IS NOT NULL; 
    CURSOR rolelimit_cur(p_role_id IN NUMBER) IS 
      SELECT role_id,rolelimit_id,start_date,max_qty_per_hr 
      FROM rolelimit WHERE  role_id = p_role_id; 
BEGIN 
    FOR v_cur IN rolerate_cur LOOP 
       SELECT count(*) INTO v_count 
        FROM rolelimit WHERE  role_id = v_cur.role_id; 
        CASE WHEN v_count >= 1 THEN 
            FOR v_cur1 IN rolelimit_cur(v_cur.role_id) LOOP 
                DELETE FROM rolerate WHERE role_rate_id = v_cur.role_rate_id; 
                SELECT COUNT(*) INTO v_no_data_found FROM nextkey
                WHERE key_name='rolerate_role_rate_id';
                IF  v_no_data_found = 0 THEN
                INSERT INTO nextkey SELECT 'rolerate_role_rate_id',1 FROM dual 
                WHERE NOT EXISTS (SELECT * FROM nextkey WHERE key_name=lower('rolerate_role_rate_id')); 
                COMMIT;
                END IF;
                SELECT key_seq_num INTO v_role_rate_id 
                FROM  nextkey WHERE  key_name = 'rolerate_role_rate_id'; 
                UPDATE nextkey SET key_seq_num = key_seq_num + 1 
                WHERE  key_name = 'rolerate_role_rate_id'; 
                INSERT INTO rolerate (role_rate_id,role_id,start_date,max_qty_per_hr,cost_per_qty,cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5,update_date,update_user,create_date,create_user,delete_session_id,delete_date)
                VALUES (v_role_rate_id,v_cur.role_id,v_cur1.start_date,v_cur1.max_qty_per_hr,v_cur.cost_per_qty, 
                            v_cur.cost_per_qty2,v_cur.cost_per_qty3,v_cur.cost_per_qty4,v_cur.cost_per_qty5, 
                            v_cur.update_date,v_cur.update_user,v_cur.create_date,v_cur.create_user, 
                            v_cur.delete_session_id,v_cur.delete_date); 
            END LOOP; 
          WHEN v_count = 0 THEN 
            UPDATE rolerate SET max_qty_per_hr = 0 , start_date=to_date('01-JAN-1976','DD-MON-YYYY')
            WHERE  role_id = v_cur.role_id; 
          ELSE 
            NULL; 
        END CASE; 
		COMMIT;
    END LOOP; 
    DELETE FROM rolelimit; 
EXCEPTION 
    WHEN OTHERS THEN 
      NULL; 
END; 
/ 
/ 
--END TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
DECLARE
CURSOR cur_rr_rl IS
SELECT rr.role_rate_id, rr.role_id,rl.rolelimit_id,rl.start_date,rl.max_qty_per_hr,
             rr.cost_per_qty, rr.cost_per_qty2,rr.cost_per_qty3,rr.cost_per_qty4,rr.cost_per_qty5
FROM rolerate rr LEFT OUTER JOIN rolelimit rl ON  rr.role_id = rl.role_id
 WHERE  rr.role_id IS NOT NULL
ORDER BY 3 NULLS LAST;
v_role_rate_id   rolerate.role_rate_id%TYPE;
v_commit_point number := 0;
BEGIN
  FOR v_cur_rec IN cur_rr_rl LOOP
    IF v_cur_rec.rolelimit_id is NOT NULL THEN
       DELETE FROM rolerate WHERE role_rate_id = v_cur_rec.role_rate_id;
       getnextkeys('rolerate_role_rate_id', 1, v_role_rate_id);
       INSERT INTO rolerate (role_rate_id,role_id,start_date,max_qty_per_hr,cost_per_qty,cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5)
           VALUES (v_role_rate_id,v_cur_rec.role_id,v_cur_rec.start_date,v_cur_rec.max_qty_per_hr,v_cur_rec.cost_per_qty,v_cur_rec.cost_per_qty2,
                          v_cur_rec.cost_per_qty3,v_cur_rec.cost_per_qty4,v_cur_rec.cost_per_qty5); 
       IF SQL%FOUND THEN 
          v_commit_point := v_commit_point + 1;
       END IF;
    ELSE
       UPDATE rolerate SET max_qty_per_hr = 0 , start_date=trunc(SYSDATE,'YEAR') WHERE  role_id = v_cur_rec.role_id and start_date=to_date('01-JAN-1976','DD-MON-YYYY');
       IF SQL%FOUND THEN 
          v_commit_point := v_commit_point + 1;
       END IF;
    END IF;
    IF mod (v_commit_point,1000) = 0 THEN
       COMMIT;
    END IF;
  END LOOP;
  DELETE FROM rolelimit;
  COMMIT;
EXCEPTION 
    WHEN OTHERS THEN 
      NULL;  
END;
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='rolecattype_role_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=21
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecattype_role_catg_type_id',21)
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='rolecatval_role_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=56
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecatval_role_catg_id',56)
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for i in 181..183 loop
for v_cur in profile_cur loop
if v_cur.scope_type='ST_Global' then
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=i;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=i;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=i;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'N');
end if;
end;
end if;
end loop;
end loop;
exception when others then
NULL;
end;
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxRoleCodeTreeLevelCnt', '20' FROM DUAL WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxRoleCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
/

/ 
--END TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) 
Select 1, 'Calendar', 'Y', SYSDATE, SYSDATE FROM DUAL 
WHERE NOT EXISTS (SELECT 1 FROM FINTMPL 
WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
UPDATE PROJECT SET FINTMPL_ID = 1 WHERE FINTMPL_ID IS NULL AND PROJECT_FLAG = 'Y'
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='fintmpl_fintmpl_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=2
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('fintmpl_fintmpl_id',2)
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE 
    v_fin_dates_id NUMBER; 
    v_count        NUMBER; 
BEGIN 
    SELECT count(*) 
    INTO   v_count 
    FROM   findates; 
    IF v_count = 0 THEN 
      BEGIN 
          getnextkeys('findates_fin_dates_id', 1, v_fin_dates_id); 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT v_fin_dates_id, to_char(trunc(sysdate,'month'),'YYYY-MM-DD'), trunc(sysdate,'month'), last_day(sysdate), 1, sysdate, 'NotPrmUser', sysdate, 'NotPrmUser'       
          FROM   dual 
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = v_fin_dates_id AND fin_dates_name=to_char(trunc(sysdate,'month'),'YYYY-MM-DD') AND fintmpl_id = 1); 
          COMMIT; 
      EXCEPTION 
          WHEN OTHERS THEN 
            NULL; 
      END; 
    END IF; 
END; 
/ 


/ 
--END TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt', '20' FROM DUAL WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxAssignmentCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for i in 185..187 loop
for v_cur in profile_cur loop
if v_cur.scope_type='ST_Global' then
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=i;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=i;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=i;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'N');
end if;
end;
end if;
end loop;
end loop;
exception when others then
NULL;
end;
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='asgnmntcattype_asgnmnt_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcattype_asgnmnt_catg_type_id',1)
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='asgnmntcatval_asgnmnt_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcatval_asgnmnt_catg_id',1)
/
/ 
--END TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F37128_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
update prefer set min_pro_version = null
/
/ 
--END TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
declare
 v_len NUMBER;
 v_import_point_web NUMBER;
 v_import_point_pro NUMBER;
 v_delete_point_web NUMBER;
 v_delete_point_pro NUMBER;
 v_delete_point NUMBER;
 v_extdep_point NUMBER;
 v_import_value blob;
 v_delete_value blob;
 v_start blob;
 v_end blob;
 v_final blob;
 cursor v is select view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
BEGIN
 for rec in v loop
 v_len := dbms_lob.getlength(rec.view_data);
 if(v_len is not null and v_len > 0) then
  v_extdep_point := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('P_EXTDEP') );
  if (v_extdep_point is null or v_extdep_point = 0) then
   v_import_point_web := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('(0||P_TASKPRED(import_option|') );
   v_delete_point_pro := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('(0||P_TASKPRED(delete_unref|') );

   if(v_import_point_web is not null and v_import_point_web > 0) then
    dbms_lob.createtemporary(v_final, true);
    dbms_lob.createtemporary(v_start, true);
    dbms_lob.createtemporary(v_end, true);
 
    dbms_lob.append(v_start, dbms_lob.substr(rec.view_data,v_import_point_web+48,1 ) );
    dbms_lob.append(v_end, dbms_lob.substr(rec.view_data,v_len,v_import_point_web+49 ) );
	
	v_delete_point_web := v_import_point_web+44;
   
    v_import_value := dbms_lob.substr(rec.view_data,1,v_import_point_web+29) ;
    v_delete_value := dbms_lob.substr(rec.view_data,1,v_delete_point_web) ;

    dbms_lob.append(v_final,v_start);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('(0||P_EXTDEP(import_option|'));
    dbms_lob.append(v_final,v_import_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('|delete_unref|'));
    dbms_lob.append(v_final,v_delete_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw(')())'));
    dbms_lob.append(v_final,v_end);
	update viewprop set view_data=v_final where view_id=rec.view_id;
	
	elsif(v_delete_point_pro is not null and v_delete_point_pro > 0) then
	dbms_lob.createtemporary(v_final, true);
    dbms_lob.createtemporary(v_start, true);
    dbms_lob.createtemporary(v_end, true);
 
    dbms_lob.append(v_start, dbms_lob.substr(rec.view_data,v_delete_point_pro+48,1 ) );
    dbms_lob.append(v_end, dbms_lob.substr(rec.view_data,v_len,v_delete_point_pro+49 ) );
	
    v_import_point_pro := v_delete_point_pro+44;
   
    v_delete_value := dbms_lob.substr(rec.view_data,1,v_delete_point_pro+28) ;
    v_import_value := dbms_lob.substr(rec.view_data,1,v_import_point_pro) ;

    dbms_lob.append(v_final,v_start);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('(0||P_EXTDEP(delete_unref|'));
    dbms_lob.append(v_final,v_delete_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('|import_option|'));
    dbms_lob.append(v_final,v_import_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw(')())'));
    dbms_lob.append(v_final,v_end);
	update viewprop set view_data=v_final where view_id=rec.view_id;
	end if;    
    commit;
  end if;
 end if;
end loop;
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/

/ 
--END TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
DECLARE
  constraint_exists integer;
BEGIN
  select count(*) into constraint_exists from user_constraints where table_name = upper('PROJECT') and constraint_name=upper('CK_PROJ_RSRC_ROLE_MATCH_FLAG');
  if constraint_exists = 0
  then
    EXECUTE IMMEDIATE 'ALTER TABLE PROJECT
    ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))';
  end if;
END;         
/
/ 
--END TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
select 1 from prefer
/
/ 
--END TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51301_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='N' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Approved Budget', 'Bugs Fixed', 'Business Case #', 'Change', 'Comments', 'Cost Status', 'Cost-Budget Variance',
 'Count', 'Current Year Approved Hours', 'Customer Satisfaction', 'Date', 'Delivery Date', 'Description', 'Effort (FTE)', 'Est. Costs', 'Estimated IT Costs $',
 'Estimated PC Costs $', 'Expected Finish', 'Forecasted Revenue', 'FTE Reduction', 'Hardware Budget', 'Next Year Approved Hours',
 'NPV $', 'Original Budget', 'Overall Status', 'Phone', 'Planned Finish', 'Prev. Year Approved Hours', 'Projected Final Cost', 'Proposed Budget', 'Quality',
 'Risk', 'Risk Assessment', 'ROI (%)', 'Safety', 'Schedule Status', 'Scope Changes', 'Scope Status', 'Six Sigma Customer Inquires Reduced',
 'Six Sigma Defects', 'Six Sigma Estimated FTE Saved', 'Six Sigma Total Savings ($)', 'Stored Proj Score', 'sys_schedule_freeze', 'sys_scope_freeze',
 'sys_workdown', 'sys_workdown_date', 'sys_workprocess', 'Target %', 'Total Benefits $')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('forecasted remaining duration', 'Market Risk  (20%)', 'Previous Score', 'Product Innovation  (25%)', 'Product Reliability',
 'Product ROI  (30%)', 'Production Impact  (15%)', 'Risk Level', 'Total Weighted Score')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='N', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Cost Variance', 'Current Score', 'Financial ROI  (30%)', 'Overall Score  (weighted)', 'Resource Capacity  (10%)',
'Resource Constraints  (20%)', 'Strategy Alignment  (40%)', 'Technology Fit  (10%)')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype
set disp_data_flag='Y', disp_indicator_flag='N', udf_code_short_len=7
where table_name = 'PROJECT' 
and logical_data_type like '%DATE'
/

/ 
--END TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
declare
v_tbs varchar2(40);
begin
select tablespace_name into v_tbs from user_ts_quotas where tablespace_name like '%NDX%' and rownum =1;

execute immediate 'ALTER TABLE TASKUSER DROP CONSTRAINT PK_TASKUSER' ;

execute immediate 'ALTER TABLE TASKUSER ADD CONSTRAINT PK_TASKUSER PRIMARY KEY (task_id) USING INDEX TABLESPACE '||v_tbs ;

exception when others then
null;
end;
/

/ 
--END TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
UPDATE Project
SET Def_Duration_Type = 'DT_FixedDUR2',
    Task_Code_Prefix = 'A',
    Task_Code_Base = 1000
WHERE Project_Flag = 'N'
      AND Orig_Proj_Id IS NULL
      AND ((Proj_Short_Name = 'EPS'
            OR Proj_Short_Name = 'Enterprise')
           OR Proj_Id = (
  SELECT MIN (Proj_Id)
  FROM Project P
  WHERE Project_Flag = 'N'
        AND Orig_Proj_Id IS NULL
))
/

/ 
--END TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,2312.0005.0000.0000'
/

--METADATA TYPE:MIN_PRO_VERSION_UPDATE DBTYPE:PPMDB TO:23.10.00
update prefer set min_pro_version='23.10.00'
/
commit
/