
--Run Script as     
SET DEFINE OFF

prompt Creating table ASGNMNTACAT

--METADATA NAME:ASGNMNTACAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTACAT(
  taskrsrc_id  number(10) NOT NULL,
  asgnmnt_catg_type_id  number(10) NOT NULL,
  asgnmnt_catg_id  number(10) NOT NULL,
  proj_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_asgnmntacat PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ASGNMNTCATTYPE

--METADATA NAME:ASGNMNTCATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATTYPE(
  asgnmnt_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  asgnmnt_catg_short_len  number(10) NOT NULL,
  asgnmnt_catg_type  varchar2(60 CHAR) NOT NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_asgnmntcattype PRIMARY KEY (asgnmnt_catg_type_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ASGNMNTCATVAL

--METADATA NAME:ASGNMNTCATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ASGNMNTCATVAL(
  asgnmnt_catg_id  number(10) NOT NULL,
  asgnmnt_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  asgnmnt_catg_short_name  varchar2(60 CHAR) NOT NULL,
  asgnmnt_catg_name  varchar2(100 CHAR) NULL,
  parent_asgnmnt_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_asgnmntcatval PRIMARY KEY (asgnmnt_catg_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table FINTMPL

--METADATA NAME:FINTMPL TYPE:TABLE CHANGE:CREATE
CREATE TABLE FINTMPL(
  fintmpl_id  number(10) NOT NULL,
  fintmpl_name  varchar2(255 CHAR) NOT NULL,
  default_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) DEFAULT 'NotPrmUser' NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) DEFAULT 'NotPrmUser' NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_fintmpl PRIMARY KEY (fintmpl_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA  TYPE:ADHOC_SQL
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) Select 1, 'Calendar', 'Y', SYSDATE, SYSDATE FROM DUAL WHERE NOT EXISTS (SELECT 1 FROM FINTMPL WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
/

prompt Creating table PFOLIOUSER

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  pfolio_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ROLECATTYPE

--METADATA NAME:ROLECATTYPE TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATTYPE(
  role_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  role_catg_short_len  number(10) NOT NULL,
  role_catg_type  varchar2(60 CHAR) NOT NULL,
  super_flag  varchar2(1 CHAR) DEFAULT 'N' NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_rolecattype PRIMARY KEY (role_catg_type_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ROLECATVAL

--METADATA NAME:ROLECATVAL TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLECATVAL(
  role_catg_id  number(10) NOT NULL,
  role_catg_type_id  number(10) NOT NULL,
  seq_num  number(10) NOT NULL,
  role_catg_short_name  varchar2(60 CHAR) NOT NULL,
  role_catg_name  varchar2(100 CHAR) NULL,
  parent_role_catg_id  number(10) NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_rolecatval PRIMARY KEY (role_catg_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
prompt Creating table ROLERCAT

--METADATA NAME:ROLERCAT TYPE:TABLE CHANGE:CREATE
CREATE TABLE ROLERCAT(
  role_id  number(10) NOT NULL,
  role_catg_type_id  number(10) NOT NULL,
  role_catg_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_rolercat PRIMARY KEY (role_id,role_catg_type_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:FINDATES CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('FINDATES') and column_name=upper('fintmpl_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE FINDATES add   fintmpl_id  number(10) DEFAULT 1 NOT NULL
';
  end if;
END;         
/

--METADATA NAME:image_extension TYPE:FIELD TABLE_NAME:IMAGEDATA CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('IMAGEDATA') and column_name=upper('image_extension');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE IMAGEDATA add   image_extension  varchar2(20 CHAR) DEFAULT ''png'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:min_pro_version TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PREFER') and column_name=upper('min_pro_version');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PREFER add   min_pro_version  varchar2(10 CHAR) NULL
';
  end if;
END;         
/

--METADATA NAME:ts_rsrc_def_asgn_out_actv_flag TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PREFER') and column_name=upper('ts_rsrc_def_asgn_out_actv_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PREFER add   ts_rsrc_def_asgn_out_actv_flag  varchar2(1 CHAR) DEFAULT ''Y'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:rsrc_role_match_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('rsrc_role_match_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   rsrc_role_match_flag  varchar2(1 CHAR) DEFAULT ''N'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:last_schedule_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('last_schedule_date');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   last_schedule_date  DATE NULL
';
  end if;
END;         
/

--METADATA NAME:fintmpl_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PROJECT') and column_name=upper('fintmpl_id');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PROJECT add   fintmpl_id  number(10) NULL
';
  end if;
END;         
/

--METADATA NAME:start_date TYPE:FIELD TABLE_NAME:ROLERATE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('ROLERATE') and column_name=upper('start_date');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE ROLERATE add   start_date  DATE DEFAULT sysdate NOT NULL
';
  end if;
END;         
/

--METADATA NAME:max_qty_per_hr TYPE:FIELD TABLE_NAME:ROLERATE CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('ROLERATE') and column_name=upper('max_qty_per_hr');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE ROLERATE add   max_qty_per_hr  number(16,8) DEFAULT 1 NULL
';
  end if;
END;         
/

--METADATA NAME:comments TYPE:FIELD TABLE_NAME:TASKPRED CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('TASKPRED') and column_name=upper('comments');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE TASKPRED add   comments  varchar2(250 CHAR) NULL
';
  end if;
END;         
/

prompt Dropping constraint pk_nextkey on table NEXTKEY


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:DROP
DECLARE
  constraint_exists INTEGER;
BEGIN
  SELECT COUNT(*) INTO constraint_exists FROM user_constraints WHERE constraint_name = UPPER('pk_nextkey');

  IF constraint_exists > 0
  THEN
    EXECUTE IMMEDIATE 'ALTER TABLE NEXTKEY DROP CONSTRAINT pk_nextkey';
  END IF;
END;
  /

prompt Creating constraint fk_asgnmntacat_asgnmntcattype on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgnmntacat_asgnmntcatval on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_asgnmntcatval TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcatval FOREIGN KEY (asgnmnt_catg_id)
REFERENCES ASGNMNTCATVAL (asgnmnt_catg_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgnmntacat_taskrsrc on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_taskrsrc TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgnmntacat_project on table ASGNMNTACAT


--METADATA NAME:fk_asgnmntacat_project TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_asgncatval_asgnmntcattype on table ASGNMNTCATVAL


--METADATA NAME:fk_asgncatval_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
ALTER TABLE ASGNMNTCATVAL
ADD CONSTRAINT fk_asgncatval_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id) 
/

prompt Creating constraint fk_findates_fintmpl on table FINDATES


--METADATA NAME:fk_findates_fintmpl TYPE:CONSTRAINT TABLE_NAME:FINDATES CHANGE:CREATE
ALTER TABLE FINDATES
ADD CONSTRAINT fk_findates_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id)  ON DELETE CASCADE 
/

prompt Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
/

prompt Creating constraint fk_pfoliouser_users on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

prompt Creating constraint fk_project_fintmpl on table PROJECT


--METADATA NAME:fk_project_fintmpl TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id) 
/

prompt Creating constraint fk_rolecatval_rolecattype on table ROLECATVAL


--METADATA NAME:fk_rolecatval_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLECATVAL CHANGE:CREATE
ALTER TABLE ROLECATVAL
ADD CONSTRAINT fk_rolecatval_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
/

prompt Creating constraint fk_rolercat_rolecattype on table ROLERCAT


--METADATA NAME:fk_rolercat_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
/

prompt Creating constraint fk_rolercat_rolecatval on table ROLERCAT


--METADATA NAME:fk_rolercat_rolecatval TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecatval FOREIGN KEY (role_catg_id)
REFERENCES ROLECATVAL (role_catg_id) 
/

prompt Creating constraint fk_rolercat_roles on table ROLERCAT


--METADATA NAME:fk_rolercat_roles TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
/

--METADATA NAME:private_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify private_loc varchar2(4000 CHAR)
/

--METADATA NAME:public_loc TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT modify public_loc varchar2(4000 CHAR)
/

--METADATA NAME:key_name TYPE:FIELD TABLE_NAME:NEXTKEY CHANGE:ALTER
ALTER TABLE NEXTKEY modify key_name varchar2(60 CHAR)
/

--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE modify proj_catg_type varchar2(60 CHAR)
/

--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL modify proj_catg_short_name varchar2(60 CHAR)
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS modify intg_type varchar2(100 CHAR)
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify intg_type varchar2(100 CHAR)
/

prompt Creating index ndx_asgnacat_asgnmntcattype on table ASGNMNTACAT

--METADATA NAME:ndx_asgnacat_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNACAT_ASGNMNTCATTYPE
ON ASGNMNTACAT (asgnmnt_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_asgnmntcatval on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_asgnmntcatval TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_ASGNMNTCATVAL
ON ASGNMNTACAT (asgnmnt_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_update_date1 on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_update_date1 TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_UPDATE_DATE1
ON ASGNMNTACAT (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_dsi on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_dsi TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_DSI
ON ASGNMNTACAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_upd on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_upd TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_UPD
ON ASGNMNTACAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_proj_id on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_proj_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_PROJ_ID
ON ASGNMNTACAT (proj_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntacat_taskrsrc_id on table ASGNMNTACAT

--METADATA NAME:ndx_asgnmntacat_taskrsrc_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTACAT_TASKRSRC_ID
ON ASGNMNTACAT (taskrsrc_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcattype_dsi on table ASGNMNTCATTYPE

--METADATA NAME:ndx_asgnmntcattype_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATTYPE_DSI
ON ASGNMNTCATTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcattype_upd on table ASGNMNTCATTYPE

--METADATA NAME:ndx_asgnmntcattype_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATTYPE_UPD
ON ASGNMNTCATTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgncatval_asgnmntcattype on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgncatval_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX NDX_ASGNCATVAL_ASGNMNTCATTYPE
ON ASGNMNTCATVAL (asgnmnt_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcatval_parent_catg on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgnmntcatval_parent_catg TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATVAL_PARENT_CATG
ON ASGNMNTCATVAL (parent_asgnmnt_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcatval_dsi on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgnmntcatval_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATVAL_DSI
ON ASGNMNTCATVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_asgnmntcatval_upd on table ASGNMNTCATVAL

--METADATA NAME:ndx_asgnmntcatval_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE INDEX NDX_ASGNMNTCATVAL_UPD
ON ASGNMNTCATVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_findates_fintmpl on table FINDATES

--METADATA NAME:ndx_findates_fintmpl TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE INDEX NDX_FINDATES_FINTMPL
ON FINDATES (fintmpl_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fintmpl_dsi on table FINTMPL

--METADATA NAME:ndx_fintmpl_dsi TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE INDEX NDX_FINTMPL_DSI
ON FINTMPL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_fintmpl_upd on table FINTMPL

--METADATA NAME:ndx_fintmpl_upd TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE INDEX NDX_FINTMPL_UPD
ON FINTMPL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_project_fintmpl on table PROJECT

--METADATA NAME:ndx_project_fintmpl TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE INDEX NDX_PROJECT_FINTMPL
ON PROJECT (fintmpl_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecattype_dsi on table ROLECATTYPE

--METADATA NAME:ndx_rolecattype_dsi TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE INDEX NDX_ROLECATTYPE_DSI
ON ROLECATTYPE (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 200K next 200K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecattype_upd on table ROLECATTYPE

--METADATA NAME:ndx_rolecattype_upd TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE INDEX NDX_ROLECATTYPE_UPD
ON ROLECATTYPE (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_rolecattype on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_rolecattype TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX NDX_ROLECATVAL_ROLECATTYPE
ON ROLECATVAL (role_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_parent_catg on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_parent_catg TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX NDX_ROLECATVAL_PARENT_CATG
ON ROLECATVAL (parent_role_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 100k next 100K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_dsi on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_dsi TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX NDX_ROLECATVAL_DSI
ON ROLECATVAL (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolecatval_upd on table ROLECATVAL

--METADATA NAME:ndx_rolecatval_upd TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE INDEX NDX_ROLECATVAL_UPD
ON ROLECATVAL (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_rolecattype on table ROLERCAT

--METADATA NAME:ndx_rolercat_rolecattype TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_ROLECATTYPE
ON ROLERCAT (role_catg_type_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_rolecatval on table ROLERCAT

--METADATA NAME:ndx_rolercat_rolecatval TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_ROLECATVAL
ON ROLERCAT (role_catg_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_update_date1 on table ROLERCAT

--METADATA NAME:ndx_rolercat_update_date1 TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_UPDATE_DATE1
ON ROLERCAT (update_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 1M next 500K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_dsi on table ROLERCAT

--METADATA NAME:ndx_rolercat_dsi TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_DSI
ON ROLERCAT (delete_session_id,delete_date)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

prompt Creating index ndx_rolercat_upd on table ROLERCAT

--METADATA NAME:ndx_rolercat_upd TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE INDEX NDX_ROLERCAT_UPD
ON ROLERCAT (update_date,delete_session_id)
TABLESPACE PMDB_NDX1
    PCTFREE 10
    STORAGE (initial 50K next 50K minextents 1 maxextents unlimited pctincrease 0)
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATTYPE_asgnmnt_catg_type_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATVAL_asgnmnt_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATVAL_asgnmnt_catg_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('FINTMPL_fintmpl_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('FINTMPL_fintmpl_id')) 
/

prompt Creating constraint pk_nextkey on table NEXTKEY


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:CREATE
ALTER TABLE NEXTKEY
ADD CONSTRAINT pk_nextkey PRIMARY KEY (key_name)
USING INDEX
                      TABLESPACE PMDB_NDX1
                PCTFREE 10
                STORAGE (initial 20K next 20K minextents 1 maxextents unlimited pctincrease 0)
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATTYPE_role_catg_type_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATTYPE_role_catg_type_id')) 
/

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATVAL_role_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATVAL_role_catg_id')) 
/



--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
/
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/


/ 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
  cursor cur is select IMAGE_NAME ,image_id from IMAGEDATA;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('IMAGEDATA') and column_name=upper('Image_Extension');
  if col_exists > 0 then
   for i in cur loop 
    begin
      if instr(i.image_name,'.')>0 then
      execute immediate 'update imagedata
        set image_name = :1,
            image_extension = :2
      where image_id=:3' using SUBSTR(i.image_name,1,INSTR(i.image_name,'.',-1,1)-1),SUBSTR(i.image_name,INSTR(i.image_name,'.',-1,1)+1),i.image_id;  
      end if;
    exception when others then
      null;
    end;
   end loop;
  end if;
 END;
 /
 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv pp
where exists
(select p.prof_id from profile p 
where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project')
/




/ 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
DECLARE
v_len number;
v_start_point number;
v_final blob;
cursor c is select issue_id,issue_notes 
from projissu where issue_notes is NOT NULL ;
begin
for rec in c loop
v_len := dbms_lob.getlength(rec.issue_notes);
if(v_len is not null and v_len > 0) then
v_start_point:=dbms_lob.instr(rec.issue_notes, utl_raw.cast_to_raw('DOCTYPE'));
if (v_start_point=0 or v_start_point is null) then
  dbms_lob.createtemporary(v_final, true);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'));
  dbms_lob.append(v_final, rec.issue_notes);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('</SPAN></BODY></HTML>'));
  execute immediate 'update projissu set issue_notes = :1 where issue_id= :2' using v_final,rec.issue_id;
commit;
end if;
end if;
end loop;
dbms_lob.freetemporary(v_final);
dbms_lob.close(v_final);
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
DECLARE 
    v_count          NUMBER; 
    v_no_data_found  NUMBER;
    v_start_date     rolelimit.start_date%TYPE; 
    v_max_qty_per_hr rolelimit.max_qty_per_hr%TYPE; 
    v_role_rate_id   rolerate.role_rate_id%TYPE; 
    CURSOR rolerate_cur IS SELECT * FROM rolerate 
      WHERE role_id IS NOT NULL; 
    CURSOR rolelimit_cur(p_role_id IN NUMBER) IS 
      SELECT role_id,rolelimit_id,start_date,max_qty_per_hr 
      FROM rolelimit WHERE  role_id = p_role_id; 
BEGIN 
    FOR v_cur IN rolerate_cur LOOP 
       SELECT count(*) INTO v_count 
        FROM rolelimit WHERE  role_id = v_cur.role_id; 
        CASE WHEN v_count >= 1 THEN 
            FOR v_cur1 IN rolelimit_cur(v_cur.role_id) LOOP 
                DELETE FROM rolerate WHERE role_rate_id = v_cur.role_rate_id; 
                SELECT COUNT(*) INTO v_no_data_found FROM nextkey
                WHERE key_name='rolerate_role_rate_id';
                IF  v_no_data_found = 0 THEN
                INSERT INTO nextkey SELECT 'rolerate_role_rate_id',1 FROM dual 
                WHERE NOT EXISTS (SELECT * FROM nextkey WHERE key_name=lower('rolerate_role_rate_id')); 
                COMMIT;
                END IF;
                SELECT key_seq_num INTO v_role_rate_id 
                FROM  nextkey WHERE  key_name = 'rolerate_role_rate_id'; 
                UPDATE nextkey SET key_seq_num = key_seq_num + 1 
                WHERE  key_name = 'rolerate_role_rate_id'; 
                INSERT INTO rolerate (role_rate_id,role_id,start_date,max_qty_per_hr,cost_per_qty,cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5,update_date,update_user,create_date,create_user,delete_session_id,delete_date)
                VALUES (v_role_rate_id,v_cur.role_id,v_cur1.start_date,v_cur1.max_qty_per_hr,v_cur.cost_per_qty, 
                            v_cur.cost_per_qty2,v_cur.cost_per_qty3,v_cur.cost_per_qty4,v_cur.cost_per_qty5, 
                            v_cur.update_date,v_cur.update_user,v_cur.create_date,v_cur.create_user, 
                            v_cur.delete_session_id,v_cur.delete_date); 
            END LOOP; 
          WHEN v_count = 0 THEN 
            UPDATE rolerate SET max_qty_per_hr = 0 , start_date=to_date('01-JAN-1976','DD-MON-YYYY')
            WHERE  role_id = v_cur.role_id; 
          ELSE 
            NULL; 
        END CASE; 
		COMMIT;
    END LOOP; 
    DELETE FROM rolelimit; 
EXCEPTION 
    WHEN OTHERS THEN 
      NULL; 
END; 
/ 
/ 
--END TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
DECLARE
CURSOR cur_rr_rl IS
SELECT rr.role_rate_id, rr.role_id,rl.rolelimit_id,rl.start_date,rl.max_qty_per_hr,
             rr.cost_per_qty, rr.cost_per_qty2,rr.cost_per_qty3,rr.cost_per_qty4,rr.cost_per_qty5
FROM rolerate rr LEFT OUTER JOIN rolelimit rl ON  rr.role_id = rl.role_id
 WHERE  rr.role_id IS NOT NULL
ORDER BY 3 NULLS LAST;
v_role_rate_id   rolerate.role_rate_id%TYPE;
v_commit_point number := 0;
BEGIN
  FOR v_cur_rec IN cur_rr_rl LOOP
    IF v_cur_rec.rolelimit_id is NOT NULL THEN
       DELETE FROM rolerate WHERE role_rate_id = v_cur_rec.role_rate_id;
       getnextkeys('rolerate_role_rate_id', 1, v_role_rate_id);
       INSERT INTO rolerate (role_rate_id,role_id,start_date,max_qty_per_hr,cost_per_qty,cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5)
           VALUES (v_role_rate_id,v_cur_rec.role_id,v_cur_rec.start_date,v_cur_rec.max_qty_per_hr,v_cur_rec.cost_per_qty,v_cur_rec.cost_per_qty2,
                          v_cur_rec.cost_per_qty3,v_cur_rec.cost_per_qty4,v_cur_rec.cost_per_qty5); 
       IF SQL%FOUND THEN 
          v_commit_point := v_commit_point + 1;
       END IF;
    ELSE
       UPDATE rolerate SET max_qty_per_hr = 0 , start_date=trunc(SYSDATE,'YEAR') WHERE  role_id = v_cur_rec.role_id and start_date=to_date('01-JAN-1976','DD-MON-YYYY');
       IF SQL%FOUND THEN 
          v_commit_point := v_commit_point + 1;
       END IF;
    END IF;
    IF mod (v_commit_point,1000) = 0 THEN
       COMMIT;
    END IF;
  END LOOP;
  DELETE FROM rolelimit;
  COMMIT;
EXCEPTION 
    WHEN OTHERS THEN 
      NULL;  
END;
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='rolecattype_role_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=21
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecattype_role_catg_type_id',21)
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='rolecatval_role_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=56
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecatval_role_catg_id',56)
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for i in 181..183 loop
for v_cur in profile_cur loop
if v_cur.scope_type='ST_Global' then
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=i;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=i;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=i;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'N');
end if;
end;
end if;
end loop;
end loop;
exception when others then
NULL;
end;
/

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxRoleCodeTreeLevelCnt', '20' FROM DUAL WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxRoleCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
/

/ 
--END TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) 
Select 1, 'Calendar', 'Y', SYSDATE, SYSDATE FROM DUAL 
WHERE NOT EXISTS (SELECT 1 FROM FINTMPL 
WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
UPDATE PROJECT SET FINTMPL_ID = 1 WHERE FINTMPL_ID IS NULL AND PROJECT_FLAG = 'Y'
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='fintmpl_fintmpl_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=2
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('fintmpl_fintmpl_id',2)
/

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE 
    v_fin_dates_id NUMBER; 
    v_count        NUMBER; 
BEGIN 
    SELECT count(*) 
    INTO   v_count 
    FROM   findates; 
    IF v_count = 0 THEN 
      BEGIN 
          getnextkeys('findates_fin_dates_id', 1, v_fin_dates_id); 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT v_fin_dates_id, to_char(trunc(sysdate,'month'),'YYYY-MM-DD'), trunc(sysdate,'month'), last_day(sysdate), 1, sysdate, 'NotPrmUser', sysdate, 'NotPrmUser'       
          FROM   dual 
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = v_fin_dates_id AND fin_dates_name=to_char(trunc(sysdate,'month'),'YYYY-MM-DD') AND fintmpl_id = 1); 
          COMMIT; 
      EXCEPTION 
          WHEN OTHERS THEN 
            NULL; 
      END; 
    END IF; 
END; 
/ 


/ 
--END TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt', '20' FROM DUAL WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxAssignmentCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare
cursor profile_cur is select prof_id,default_flag,superuser_flag,scope_type,prof_name from profile;
v_prof_id profpriv.prof_id%type;
v_priv_num profpriv.priv_num%type;
v_allow_flag profpriv.allow_flag%type;
begin
for i in 185..187 loop
for v_cur in profile_cur loop
if v_cur.scope_type='ST_Global' then
begin
select prof_id,priv_num,allow_flag into v_prof_id,v_priv_num,v_allow_flag from profpriv where prof_id= v_cur.prof_id and priv_num=i;
if v_prof_id=12 then
update profpriv set allow_flag ='Y' where prof_id= v_cur.prof_id and priv_num=i;
else
update profpriv set allow_flag ='N' where prof_id= v_cur.prof_id and priv_num=i;
end if;
exception when no_data_found then
if v_cur.prof_id=12 then
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'Y');
else
insert into profpriv (prof_id,priv_num,allow_flag) values (v_cur.prof_id,i,'N');
end if;
end;
end if;
end loop;
end loop;
exception when others then
NULL;
end;
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='asgnmntcattype_asgnmnt_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcattype_asgnmnt_catg_type_id',1)
/

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING DUAL
    ON ( KEY_NAME='asgnmntcatval_asgnmnt_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcatval_asgnmnt_catg_id',1)
/
/ 
--END TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F37128_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
update prefer set min_pro_version = null
/
/ 
--END TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
declare
 v_len NUMBER;
 v_import_point_web NUMBER;
 v_import_point_pro NUMBER;
 v_delete_point_web NUMBER;
 v_delete_point_pro NUMBER;
 v_delete_point NUMBER;
 v_extdep_point NUMBER;
 v_import_value blob;
 v_delete_value blob;
 v_start blob;
 v_end blob;
 v_final blob;
 cursor v is select view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
BEGIN
 for rec in v loop
 v_len := dbms_lob.getlength(rec.view_data);
 if(v_len is not null and v_len > 0) then
  v_extdep_point := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('P_EXTDEP') );
  if (v_extdep_point is null or v_extdep_point = 0) then
   v_import_point_web := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('(0||P_TASKPRED(import_option|') );
   v_delete_point_pro := dbms_lob.instr(rec.view_data, utl_raw.cast_to_raw('(0||P_TASKPRED(delete_unref|') );

   if(v_import_point_web is not null and v_import_point_web > 0) then
    dbms_lob.createtemporary(v_final, true);
    dbms_lob.createtemporary(v_start, true);
    dbms_lob.createtemporary(v_end, true);
 
    dbms_lob.append(v_start, dbms_lob.substr(rec.view_data,v_import_point_web+48,1 ) );
    dbms_lob.append(v_end, dbms_lob.substr(rec.view_data,v_len,v_import_point_web+49 ) );
	
	v_delete_point_web := v_import_point_web+44;
   
    v_import_value := dbms_lob.substr(rec.view_data,1,v_import_point_web+29) ;
    v_delete_value := dbms_lob.substr(rec.view_data,1,v_delete_point_web) ;

    dbms_lob.append(v_final,v_start);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('(0||P_EXTDEP(import_option|'));
    dbms_lob.append(v_final,v_import_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('|delete_unref|'));
    dbms_lob.append(v_final,v_delete_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw(')())'));
    dbms_lob.append(v_final,v_end);
	update viewprop set view_data=v_final where view_id=rec.view_id;
	
	elsif(v_delete_point_pro is not null and v_delete_point_pro > 0) then
	dbms_lob.createtemporary(v_final, true);
    dbms_lob.createtemporary(v_start, true);
    dbms_lob.createtemporary(v_end, true);
 
    dbms_lob.append(v_start, dbms_lob.substr(rec.view_data,v_delete_point_pro+48,1 ) );
    dbms_lob.append(v_end, dbms_lob.substr(rec.view_data,v_len,v_delete_point_pro+49 ) );
	
    v_import_point_pro := v_delete_point_pro+44;
   
    v_delete_value := dbms_lob.substr(rec.view_data,1,v_delete_point_pro+28) ;
    v_import_value := dbms_lob.substr(rec.view_data,1,v_import_point_pro) ;

    dbms_lob.append(v_final,v_start);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('(0||P_EXTDEP(delete_unref|'));
    dbms_lob.append(v_final,v_delete_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw('|import_option|'));
    dbms_lob.append(v_final,v_import_value);
    dbms_lob.append(v_final,utl_raw.cast_to_raw(')())'));
    dbms_lob.append(v_final,v_end);
	update viewprop set view_data=v_final where view_id=rec.view_id;
	end if;    
    commit;
  end if;
 end if;
end loop;
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/

/ 
--END TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
DECLARE
  constraint_exists integer;
BEGIN
  select count(*) into constraint_exists from user_constraints where table_name = upper('PROJECT') and constraint_name=upper('CK_PROJ_RSRC_ROLE_MATCH_FLAG');
  if constraint_exists = 0
  then
    EXECUTE IMMEDIATE 'ALTER TABLE PROJECT
    ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))';
  end if;
END;         
/
/ 
--END TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
select 1 from prefer
/
/ 
--END TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51301_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='N' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Approved Budget', 'Bugs Fixed', 'Business Case #', 'Change', 'Comments', 'Cost Status', 'Cost-Budget Variance',
 'Count', 'Current Year Approved Hours', 'Customer Satisfaction', 'Date', 'Delivery Date', 'Description', 'Effort (FTE)', 'Est. Costs', 'Estimated IT Costs $',
 'Estimated PC Costs $', 'Expected Finish', 'Forecasted Revenue', 'FTE Reduction', 'Hardware Budget', 'Next Year Approved Hours',
 'NPV $', 'Original Budget', 'Overall Status', 'Phone', 'Planned Finish', 'Prev. Year Approved Hours', 'Projected Final Cost', 'Proposed Budget', 'Quality',
 'Risk', 'Risk Assessment', 'ROI (%)', 'Safety', 'Schedule Status', 'Scope Changes', 'Scope Status', 'Six Sigma Customer Inquires Reduced',
 'Six Sigma Defects', 'Six Sigma Estimated FTE Saved', 'Six Sigma Total Savings ($)', 'Stored Proj Score', 'sys_schedule_freeze', 'sys_scope_freeze',
 'sys_workdown', 'sys_workdown_date', 'sys_workprocess', 'Target %', 'Total Benefits $')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('forecasted remaining duration', 'Market Risk  (20%)', 'Previous Score', 'Product Innovation  (25%)', 'Product Reliability',
 'Product ROI  (30%)', 'Production Impact  (15%)', 'Risk Level', 'Total Weighted Score')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='N', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Cost Variance', 'Current Score', 'Financial ROI  (30%)', 'Overall Score  (weighted)', 'Resource Capacity  (10%)',
'Resource Constraints  (20%)', 'Strategy Alignment  (40%)', 'Technology Fit  (10%)')
/
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype
set disp_data_flag='Y', disp_indicator_flag='N', udf_code_short_len=7
where table_name = 'PROJECT' 
and logical_data_type like '%DATE'
/

/ 
--END TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
declare
v_tbs varchar2(40);
begin
select tablespace_name into v_tbs from user_ts_quotas where tablespace_name like '%NDX%' and rownum =1;

execute immediate 'ALTER TABLE TASKUSER DROP CONSTRAINT PK_TASKUSER' ;

execute immediate 'ALTER TABLE TASKUSER ADD CONSTRAINT PK_TASKUSER PRIMARY KEY (task_id) USING INDEX TABLESPACE '||v_tbs ;

exception when others then
null;
end;
/

/ 
--END TYPE:UP2 GROUP:2211to2212 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:2212to2301 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
UPDATE Project
SET Def_Duration_Type = 'DT_FixedDUR2',
    Task_Code_Prefix = 'A',
    Task_Code_Base = 1000
WHERE Project_Flag = 'N'
      AND Orig_Proj_Id IS NULL
      AND ((Proj_Short_Name = 'EPS'
            OR Proj_Short_Name = 'Enterprise')
           OR Proj_Id = (
  SELECT MIN (Proj_Id)
  FROM Project P
  WHERE Project_Flag = 'N'
        AND Orig_Proj_Id IS NULL
))
/

/ 
--END TYPE:UP2 GROUP:2311to2312 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F74771_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:231201to231202 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,2312.0005.0000.0000'
/

--METADATA TYPE:MIN_PRO_VERSION_UPDATE DBTYPE:PPMDB TO:23.10.00
update prefer set min_pro_version='23.10.00'
/
commit
/