
SET QUOTED_IDENTIFIER ON

print 'Creating constraint pk_account on table ACCOUNT'


--METADATA NAME:pk_account TYPE:CONSTRAINT TABLE_NAME:ACCOUNT CHANGE:CREATE
ALTER TABLE ACCOUNT
ADD CONSTRAINT pk_account PRIMARY KEY (acct_id)
go

print 'Creating constraint pk_actvcode on table ACTVCODE'


--METADATA NAME:pk_actvcode TYPE:CONSTRAINT TABLE_NAME:ACTVCODE CHANGE:CREATE
ALTER TABLE ACTVCODE
ADD CONSTRAINT pk_actvcode PRIMARY KEY (actv_code_id)
go

print 'Creating constraint pk_actvtype on table ACTVTYPE'


--METADATA NAME:pk_actvtype TYPE:CONSTRAINT TABLE_NAME:ACTVTYPE CHANGE:CREATE
ALTER TABLE ACTVTYPE
ADD CONSTRAINT pk_actvtype PRIMARY KEY (actv_code_type_id)
go

print 'Creating constraint pk_admin_config on table ADMIN_CONFIG'


--METADATA NAME:pk_admin_config TYPE:CONSTRAINT TABLE_NAME:ADMIN_CONFIG CHANGE:CREATE
ALTER TABLE ADMIN_CONFIG
ADD CONSTRAINT pk_admin_config PRIMARY KEY (config_name)
go

print 'Creating constraint pk_asgnmntacat on table ASGNMNTACAT'


--METADATA NAME:pk_asgnmntacat TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT pk_asgnmntacat PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id)
go

print 'Creating constraint pk_asgnmntcattype on table ASGNMNTCATTYPE'


--METADATA NAME:pk_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
ALTER TABLE ASGNMNTCATTYPE
ADD CONSTRAINT pk_asgnmntcattype PRIMARY KEY (asgnmnt_catg_type_id)
go

print 'Creating constraint pk_asgnmntcatval on table ASGNMNTCATVAL'


--METADATA NAME:pk_asgnmntcatval TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
ALTER TABLE ASGNMNTCATVAL
ADD CONSTRAINT pk_asgnmntcatval PRIMARY KEY (asgnmnt_catg_id)
go

print 'Creating constraint pk_basetype on table BASETYPE'


--METADATA NAME:pk_basetype TYPE:CONSTRAINT TABLE_NAME:BASETYPE CHANGE:CREATE
ALTER TABLE BASETYPE
ADD CONSTRAINT pk_basetype PRIMARY KEY (base_type_id)
go

print 'Creating constraint pk_bre_registry on table BRE_REGISTRY'


--METADATA NAME:pk_bre_registry TYPE:CONSTRAINT TABLE_NAME:BRE_REGISTRY CHANGE:CREATE
ALTER TABLE BRE_REGISTRY
ADD CONSTRAINT pk_bre_registry PRIMARY KEY (bre_registry_id)
go

print 'Creating constraint pk_budgchng on table BUDGCHNG'


--METADATA NAME:pk_budgchng TYPE:CONSTRAINT TABLE_NAME:BUDGCHNG CHANGE:CREATE
ALTER TABLE BUDGCHNG
ADD CONSTRAINT pk_budgchng PRIMARY KEY (budg_chng_id)
go

print 'Creating constraint pk_calendar on table CALENDAR'


--METADATA NAME:pk_calendar TYPE:CONSTRAINT TABLE_NAME:CALENDAR CHANGE:CREATE
ALTER TABLE CALENDAR
ADD CONSTRAINT pk_calendar PRIMARY KEY (clndr_id)
go

print 'Creating constraint pk_costtype on table COSTTYPE'


--METADATA NAME:pk_costtype TYPE:CONSTRAINT TABLE_NAME:COSTTYPE CHANGE:CREATE
ALTER TABLE COSTTYPE
ADD CONSTRAINT pk_costtype PRIMARY KEY (cost_type_id)
go

print 'Creating constraint pk_currtype on table CURRTYPE'


--METADATA NAME:pk_currtype TYPE:CONSTRAINT TABLE_NAME:CURRTYPE CHANGE:CREATE
ALTER TABLE CURRTYPE
ADD CONSTRAINT pk_currtype PRIMARY KEY (curr_id)
go

print 'Creating constraint pk_dashboard on table DASHBOARD'


--METADATA NAME:pk_dashboard TYPE:CONSTRAINT TABLE_NAME:DASHBOARD CHANGE:CREATE
ALTER TABLE DASHBOARD
ADD CONSTRAINT pk_dashboard PRIMARY KEY (dashboard_id)
go

print 'Creating constraint pk_dashuser on table DASHUSER'


--METADATA NAME:pk_dashuser TYPE:CONSTRAINT TABLE_NAME:DASHUSER CHANGE:CREATE
ALTER TABLE DASHUSER
ADD CONSTRAINT pk_dashuser PRIMARY KEY (dashboard_id,user_id)
go

print 'Creating constraint pk_discussion on table DISCUSSION'


--METADATA NAME:pk_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT pk_discussion PRIMARY KEY (discussion_id)
go

print 'Creating constraint pk_discussion_read on table DISCUSSION_READ'


--METADATA NAME:pk_discussion_read TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT pk_discussion_read PRIMARY KEY (discussion_id,user_id)
go

print 'Creating constraint pk_doccatg on table DOCCATG'


--METADATA NAME:pk_doccatg TYPE:CONSTRAINT TABLE_NAME:DOCCATG CHANGE:CREATE
ALTER TABLE DOCCATG
ADD CONSTRAINT pk_doccatg PRIMARY KEY (doc_catg_id)
go

print 'Creating constraint pk_docreview on table DOCREVIEW'


--METADATA NAME:pk_docreview TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT pk_docreview PRIMARY KEY (doc_review_id)
go

print 'Creating constraint pk_docreviewtask on table DOCREVIEWTASK'


--METADATA NAME:pk_docreviewtask TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT pk_docreviewtask PRIMARY KEY (review_task_id)
go

print 'Creating constraint pk_docstat on table DOCSTAT'


--METADATA NAME:pk_docstat TYPE:CONSTRAINT TABLE_NAME:DOCSTAT CHANGE:CREATE
ALTER TABLE DOCSTAT
ADD CONSTRAINT pk_docstat PRIMARY KEY (doc_status_id)
go

print 'Creating constraint pk_document on table DOCUMENT'


--METADATA NAME:pk_document TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT pk_document PRIMARY KEY (doc_id)
go

print 'Creating constraint pk_expproj on table EXPPROJ'


--METADATA NAME:pk_expproj TYPE:CONSTRAINT TABLE_NAME:EXPPROJ CHANGE:CREATE
ALTER TABLE EXPPROJ
ADD CONSTRAINT pk_expproj PRIMARY KEY (proj_id)
go

print 'Creating constraint pk_extapp on table EXTAPP'


--METADATA NAME:pk_extapp TYPE:CONSTRAINT TABLE_NAME:EXTAPP CHANGE:CREATE
ALTER TABLE EXTAPP
ADD CONSTRAINT pk_extapp PRIMARY KEY (app_id)
go

print 'Creating constraint pk_factor on table FACTOR'


--METADATA NAME:pk_factor TYPE:CONSTRAINT TABLE_NAME:FACTOR CHANGE:CREATE
ALTER TABLE FACTOR
ADD CONSTRAINT pk_factor PRIMARY KEY (fact_id)
go

print 'Creating constraint pk_factval on table FACTVAL'


--METADATA NAME:pk_factval TYPE:CONSTRAINT TABLE_NAME:FACTVAL CHANGE:CREATE
ALTER TABLE FACTVAL
ADD CONSTRAINT pk_factval PRIMARY KEY (fact_val_id)
go

print 'Creating constraint pk_filtprop on table FILTPROP'


--METADATA NAME:pk_filtprop TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT pk_filtprop PRIMARY KEY (filter_id)
go

print 'Creating constraint pk_findates on table FINDATES'


--METADATA NAME:pk_findates TYPE:CONSTRAINT TABLE_NAME:FINDATES CHANGE:CREATE
ALTER TABLE FINDATES
ADD CONSTRAINT pk_findates PRIMARY KEY (fin_dates_id)
go

print 'Creating constraint pk_fintmpl on table FINTMPL'


--METADATA NAME:pk_fintmpl TYPE:CONSTRAINT TABLE_NAME:FINTMPL CHANGE:CREATE
ALTER TABLE FINTMPL
ADD CONSTRAINT pk_fintmpl PRIMARY KEY (fintmpl_id)
go

print 'Creating constraint pk_formcatg on table FORMCATG'


--METADATA NAME:pk_formcatg TYPE:CONSTRAINT TABLE_NAME:FORMCATG CHANGE:CREATE
ALTER TABLE FORMCATG
ADD CONSTRAINT pk_formcatg PRIMARY KEY (form_catg_id)
go

print 'Creating constraint pk_formproj on table FORMPROJ'


--METADATA NAME:pk_formproj TYPE:CONSTRAINT TABLE_NAME:FORMPROJ CHANGE:CREATE
ALTER TABLE FORMPROJ
ADD CONSTRAINT pk_formproj PRIMARY KEY (form_tmpl_id,proj_id)
go

print 'Creating constraint pk_formtmpl on table FORMTMPL'


--METADATA NAME:pk_formtmpl TYPE:CONSTRAINT TABLE_NAME:FORMTMPL CHANGE:CREATE
ALTER TABLE FORMTMPL
ADD CONSTRAINT pk_formtmpl PRIMARY KEY (form_tmpl_id)
go

print 'Creating constraint pk_fundsrc on table FUNDSRC'


--METADATA NAME:pk_fundsrc TYPE:CONSTRAINT TABLE_NAME:FUNDSRC CHANGE:CREATE
ALTER TABLE FUNDSRC
ADD CONSTRAINT pk_fundsrc PRIMARY KEY (fund_id)
go

print 'Creating constraint pk_gchange_id on table GCHANGE'


--METADATA NAME:pk_gchange_id TYPE:CONSTRAINT TABLE_NAME:GCHANGE CHANGE:CREATE
ALTER TABLE GCHANGE
ADD CONSTRAINT pk_gchange_id PRIMARY KEY (gchange_id)
go

print 'Creating constraint pk_hqdata on table HQDATA'


--METADATA NAME:pk_hqdata TYPE:CONSTRAINT TABLE_NAME:HQDATA CHANGE:CREATE
ALTER TABLE HQDATA
ADD CONSTRAINT pk_hqdata PRIMARY KEY (session_id,context_id,fk_id,value)
go

print 'Creating constraint pk_hquery on table HQUERY'


--METADATA NAME:pk_hquery TYPE:CONSTRAINT TABLE_NAME:HQUERY CHANGE:CREATE
ALTER TABLE HQUERY
ADD CONSTRAINT pk_hquery PRIMARY KEY (session_id,context_id,fk_id)
go

print 'Creating constraint pk_imagedata on table IMAGEDATA'


--METADATA NAME:pk_imagedata TYPE:CONSTRAINT TABLE_NAME:IMAGEDATA CHANGE:CREATE
ALTER TABLE IMAGEDATA
ADD CONSTRAINT pk_imagedata PRIMARY KEY (image_id)
go

print 'Creating constraint pk_issuhist on table ISSUHIST'


--METADATA NAME:pk_issuhist TYPE:CONSTRAINT TABLE_NAME:ISSUHIST CHANGE:CREATE
ALTER TABLE ISSUHIST
ADD CONSTRAINT pk_issuhist PRIMARY KEY (issue_id)
go

print 'Creating constraint pk_iteration on table ITERATION'


--METADATA NAME:pk_iteration TYPE:CONSTRAINT TABLE_NAME:ITERATION CHANGE:CREATE
ALTER TABLE ITERATION
ADD CONSTRAINT pk_iteration PRIMARY KEY (iteration_id)
go

print 'Creating constraint pk_iterdays on table ITERDAYS'


--METADATA NAME:pk_iterdays TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:CREATE
ALTER TABLE ITERDAYS
ADD CONSTRAINT pk_iterdays PRIMARY KEY (task_id,day_number)
go

print 'Creating constraint pk_itergoal on table ITERGOAL'


--METADATA NAME:pk_itergoal TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:CREATE
ALTER TABLE ITERGOAL
ADD CONSTRAINT pk_itergoal PRIMARY KEY (iter_goal_id)
go

print 'Creating constraint pk_joblog on table JOBLOG'


--METADATA NAME:pk_joblog TYPE:CONSTRAINT TABLE_NAME:JOBLOG CHANGE:CREATE
ALTER TABLE JOBLOG
ADD CONSTRAINT pk_joblog PRIMARY KEY (job_id)
go

print 'Creating constraint pk_jobrpt on table JOBRPT'


--METADATA NAME:pk_jobrpt TYPE:CONSTRAINT TABLE_NAME:JOBRPT CHANGE:CREATE
ALTER TABLE JOBRPT
ADD CONSTRAINT pk_jobrpt PRIMARY KEY (job_id,rpt_id)
go

print 'Creating constraint pk_jobsvc on table JOBSVC'


--METADATA NAME:pk_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC
ADD CONSTRAINT pk_jobsvc PRIMARY KEY (job_id)
go

print 'Creating constraint pk_location on table LOCATION'


--METADATA NAME:pk_location TYPE:CONSTRAINT TABLE_NAME:LOCATION CHANGE:CREATE
ALTER TABLE LOCATION
ADD CONSTRAINT pk_location PRIMARY KEY (location_id)
go

print 'Creating constraint pk_memotype on table MEMOTYPE'


--METADATA NAME:pk_memotype TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT pk_memotype PRIMARY KEY (memo_type_id)
go

print 'Creating constraint pk_nextkey on table NEXTKEY'


--METADATA NAME:pk_nextkey TYPE:CONSTRAINT TABLE_NAME:NEXTKEY CHANGE:CREATE
ALTER TABLE NEXTKEY
ADD CONSTRAINT pk_nextkey PRIMARY KEY (key_name)
go

print 'Creating constraint pk_nonwork on table NONWORK'


--METADATA NAME:pk_nonwork TYPE:CONSTRAINT TABLE_NAME:NONWORK CHANGE:CREATE
ALTER TABLE NONWORK
ADD CONSTRAINT pk_nonwork PRIMARY KEY (nonwork_type_id)
go

print 'Creating constraint pk_note on table NOTE'


--METADATA NAME:pk_note TYPE:CONSTRAINT TABLE_NAME:NOTE CHANGE:CREATE
ALTER TABLE NOTE
ADD CONSTRAINT pk_note PRIMARY KEY (note_id)
go

print 'Creating constraint pk_obs on table OBS'


--METADATA NAME:pk_obs TYPE:CONSTRAINT TABLE_NAME:OBS CHANGE:CREATE
ALTER TABLE OBS
ADD CONSTRAINT pk_obs PRIMARY KEY (obs_id)
go

print 'Creating constraint pk_obsproj on table OBSPROJ'


--METADATA NAME:pk_obsproj TYPE:CONSTRAINT TABLE_NAME:OBSPROJ CHANGE:CREATE
ALTER TABLE OBSPROJ
ADD CONSTRAINT pk_obsproj PRIMARY KEY (obs_id,proj_id,wbs_id)
go

print 'Creating constraint pk_pcattype on table PCATTYPE'


--METADATA NAME:pk_pcattype TYPE:CONSTRAINT TABLE_NAME:PCATTYPE CHANGE:CREATE
ALTER TABLE PCATTYPE
ADD CONSTRAINT pk_pcattype PRIMARY KEY (proj_catg_type_id)
go

print 'Creating constraint pk_pcatuser on table PCATUSER'


--METADATA NAME:pk_pcatuser TYPE:CONSTRAINT TABLE_NAME:PCATUSER CHANGE:CREATE
ALTER TABLE PCATUSER
ADD CONSTRAINT pk_pcatuser PRIMARY KEY (proj_catg_id,user_id)
go

print 'Creating constraint pk_pcatval on table PCATVAL'


--METADATA NAME:pk_pcatval TYPE:CONSTRAINT TABLE_NAME:PCATVAL CHANGE:CREATE
ALTER TABLE PCATVAL
ADD CONSTRAINT pk_pcatval PRIMARY KEY (proj_catg_id)
go

print 'Creating constraint pk_pfolio on table PFOLIO'


--METADATA NAME:pk_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIO CHANGE:CREATE
ALTER TABLE PFOLIO
ADD CONSTRAINT pk_pfolio PRIMARY KEY (pfolio_id)
go

print 'Creating constraint pk_pfoliouser on table PFOLIOUSER'


--METADATA NAME:pk_pfoliouser TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)
go

print 'Creating constraint pk_phase on table PHASE'


--METADATA NAME:pk_phase TYPE:CONSTRAINT TABLE_NAME:PHASE CHANGE:CREATE
ALTER TABLE PHASE
ADD CONSTRAINT pk_phase PRIMARY KEY (phase_id)
go

print 'Creating constraint pk_pobs on table POBS'


--METADATA NAME:pk_pobs TYPE:CONSTRAINT TABLE_NAME:POBS CHANGE:CREATE
ALTER TABLE POBS
ADD CONSTRAINT pk_pobs PRIMARY KEY (pobs_id)
go

print 'Creating constraint pk_prefer on table PREFER'


--METADATA NAME:pk_prefer TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT pk_prefer PRIMARY KEY (prefer_id)
go

print 'Creating constraint pk_prmqueue on table PRMQUEUE'


--METADATA NAME:pk_prmqueue TYPE:CONSTRAINT TABLE_NAME:PRMQUEUE CHANGE:CREATE
ALTER TABLE PRMQUEUE
ADD CONSTRAINT pk_prmqueue PRIMARY KEY (queue_name,msg_key,enqueue_date)
go

print 'Creating constraint pk_procgroup on table PROCGROUP'


--METADATA NAME:pk_procgroup TYPE:CONSTRAINT TABLE_NAME:PROCGROUP CHANGE:CREATE
ALTER TABLE PROCGROUP
ADD CONSTRAINT pk_procgroup PRIMARY KEY (proc_group_id)
go

print 'Creating constraint pk_procitem on table PROCITEM'


--METADATA NAME:pk_procitem TYPE:CONSTRAINT TABLE_NAME:PROCITEM CHANGE:CREATE
ALTER TABLE PROCITEM
ADD CONSTRAINT pk_procitem PRIMARY KEY (proc_item_id)
go

print 'Creating constraint pk_profile on table PROFILE'


--METADATA NAME:pk_profile TYPE:CONSTRAINT TABLE_NAME:PROFILE CHANGE:CREATE
ALTER TABLE PROFILE
ADD CONSTRAINT pk_profile PRIMARY KEY (prof_id)
go

print 'Creating constraint pk_profpriv on table PROFPRIV'


--METADATA NAME:pk_profpriv TYPE:CONSTRAINT TABLE_NAME:PROFPRIV CHANGE:CREATE
ALTER TABLE PROFPRIV
ADD CONSTRAINT pk_profpriv PRIMARY KEY (prof_id,priv_num)
go

print 'Creating constraint pk_projcost on table PROJCOST'


--METADATA NAME:pk_projcost TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT pk_projcost PRIMARY KEY (cost_item_id)
go

print 'Creating constraint pk_project on table PROJECT'


--METADATA NAME:pk_project TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT pk_project PRIMARY KEY (proj_id)
go

print 'Creating constraint pk_projest on table PROJEST'


--METADATA NAME:pk_projest TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT pk_projest PRIMARY KEY (proj_est_id)
go

print 'Creating constraint pk_projfund on table PROJFUND'


--METADATA NAME:pk_projfund TYPE:CONSTRAINT TABLE_NAME:PROJFUND CHANGE:CREATE
ALTER TABLE PROJFUND
ADD CONSTRAINT pk_projfund PRIMARY KEY (proj_fund_id)
go

print 'Creating constraint pk_projissu on table PROJISSU'


--METADATA NAME:pk_projissu TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT pk_projissu PRIMARY KEY (issue_id)
go

print 'Creating constraint pk_projpcat on table PROJPCAT'


--METADATA NAME:pk_projpcat TYPE:CONSTRAINT TABLE_NAME:PROJPCAT CHANGE:CREATE
ALTER TABLE PROJPCAT
ADD CONSTRAINT pk_projpcat PRIMARY KEY (proj_id,proj_catg_type_id)
go

print 'Creating constraint pk_projprop on table PROJPROP'


--METADATA NAME:pk_projprop TYPE:CONSTRAINT TABLE_NAME:PROJPROP CHANGE:CREATE
ALTER TABLE PROJPROP
ADD CONSTRAINT pk_projprop PRIMARY KEY (proj_id,prop_name)
go

print 'Creating constraint pk_projrisk on table PROJRISK'


--METADATA NAME:pk_projrisk TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK
ADD CONSTRAINT pk_projrisk PRIMARY KEY (risk_id)
go

print 'Creating constraint pk_projshar on table PROJSHAR'


--METADATA NAME:pk_projshar TYPE:CONSTRAINT TABLE_NAME:PROJSHAR CHANGE:CREATE
ALTER TABLE PROJSHAR
ADD CONSTRAINT pk_projshar PRIMARY KEY (proj_id,session_id)
go

print 'Creating constraint pk_projthrs on table PROJTHRS'


--METADATA NAME:pk_projthrs TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT pk_projthrs PRIMARY KEY (thresh_id)
go

print 'Creating constraint pk_projwbs on table PROJWBS'


--METADATA NAME:pk_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT pk_projwbs PRIMARY KEY (wbs_id)
go

print 'Creating constraint pk_projwsrpt on table PROJWSRPT'


--METADATA NAME:pk_projwsrpt TYPE:CONSTRAINT TABLE_NAME:PROJWSRPT CHANGE:CREATE
ALTER TABLE PROJWSRPT
ADD CONSTRAINT pk_projwsrpt PRIMARY KEY (rpt_id,proj_id)
go

print 'Creating constraint pk_prpfolio on table PRPFOLIO'


--METADATA NAME:pk_prpfolio TYPE:CONSTRAINT TABLE_NAME:PRPFOLIO CHANGE:CREATE
ALTER TABLE PRPFOLIO
ADD CONSTRAINT pk_prpfolio PRIMARY KEY (pfolio_id,wbs_id)
go

print 'Creating constraint pk_pubuser on table PUBUSER'


--METADATA NAME:pk_pubuser TYPE:CONSTRAINT TABLE_NAME:PUBUSER CHANGE:CREATE
ALTER TABLE PUBUSER
ADD CONSTRAINT pk_pubuser PRIMARY KEY (public_group_id)
go

print 'Creating constraint pk_querylib on table QUERYLIB'


--METADATA NAME:pk_querylib TYPE:CONSTRAINT TABLE_NAME:QUERYLIB CHANGE:CREATE
ALTER TABLE QUERYLIB
ADD CONSTRAINT pk_querylib PRIMARY KEY (query_lib_id)
go

print 'Creating constraint pk_rcattype on table RCATTYPE'


--METADATA NAME:pk_rcattype TYPE:CONSTRAINT TABLE_NAME:RCATTYPE CHANGE:CREATE
ALTER TABLE RCATTYPE
ADD CONSTRAINT pk_rcattype PRIMARY KEY (rsrc_catg_type_id)
go

print 'Creating constraint pk_rcatval on table RCATVAL'


--METADATA NAME:pk_rcatval TYPE:CONSTRAINT TABLE_NAME:RCATVAL CHANGE:CREATE
ALTER TABLE RCATVAL
ADD CONSTRAINT pk_rcatval PRIMARY KEY (rsrc_catg_id)
go

print 'Creating constraint pk_reittype on table REITTYPE'


--METADATA NAME:pk_reittype TYPE:CONSTRAINT TABLE_NAME:REITTYPE CHANGE:CREATE
ALTER TABLE REITTYPE
ADD CONSTRAINT pk_reittype PRIMARY KEY (related_item_type_id)
go

print 'Creating constraint pk_release on table RELEASE'


--METADATA NAME:pk_release TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:CREATE
ALTER TABLE RELEASE
ADD CONSTRAINT pk_release PRIMARY KEY (release_id)
go

print 'Creating constraint pk_relitems on table RELITEMS'


--METADATA NAME:pk_relitems TYPE:CONSTRAINT TABLE_NAME:RELITEMS CHANGE:CREATE
ALTER TABLE RELITEMS
ADD CONSTRAINT pk_relitems PRIMARY KEY (item_type_id,fk_id,related_item_type_id,related_fk_id)
go

print 'Creating constraint pk_rfolio on table RFOLIO'


--METADATA NAME:pk_rfolio TYPE:CONSTRAINT TABLE_NAME:RFOLIO CHANGE:CREATE
ALTER TABLE RFOLIO
ADD CONSTRAINT pk_rfolio PRIMARY KEY (rfolio_id)
go

print 'Creating constraint pk_riskctrl on table RISKCTRL'


--METADATA NAME:pk_riskctrl TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:CREATE
ALTER TABLE RISKCTRL
ADD CONSTRAINT pk_riskctrl PRIMARY KEY (risk_id)
go

print 'Creating constraint pk_risktype on table RISKTYPE'


--METADATA NAME:pk_risktype TYPE:CONSTRAINT TABLE_NAME:RISKTYPE CHANGE:CREATE
ALTER TABLE RISKTYPE
ADD CONSTRAINT pk_risktype PRIMARY KEY (risk_type_id)
go

print 'Creating constraint pk_rlfolio_id on table RLFOLIO'


--METADATA NAME:pk_rlfolio_id TYPE:CONSTRAINT TABLE_NAME:RLFOLIO CHANGE:CREATE
ALTER TABLE RLFOLIO
ADD CONSTRAINT pk_rlfolio_id PRIMARY KEY (rlfolio_id)
go

print 'Creating constraint pk_rolecattype on table ROLECATTYPE'


--METADATA NAME:pk_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLECATTYPE CHANGE:CREATE
ALTER TABLE ROLECATTYPE
ADD CONSTRAINT pk_rolecattype PRIMARY KEY (role_catg_type_id)
go

print 'Creating constraint pk_rolecatval on table ROLECATVAL'


--METADATA NAME:pk_rolecatval TYPE:CONSTRAINT TABLE_NAME:ROLECATVAL CHANGE:CREATE
ALTER TABLE ROLECATVAL
ADD CONSTRAINT pk_rolecatval PRIMARY KEY (role_catg_id)
go

print 'Creating constraint pk_rolelimit on table ROLELIMIT'


--METADATA NAME:pk_rolelimit TYPE:CONSTRAINT TABLE_NAME:ROLELIMIT CHANGE:CREATE
ALTER TABLE ROLELIMIT
ADD CONSTRAINT pk_rolelimit PRIMARY KEY (rolelimit_id)
go

print 'Creating constraint pk_rolerate on table ROLERATE'


--METADATA NAME:pk_rolerate TYPE:CONSTRAINT TABLE_NAME:ROLERATE CHANGE:CREATE
ALTER TABLE ROLERATE
ADD CONSTRAINT pk_rolerate PRIMARY KEY (role_rate_id)
go

print 'Creating constraint pk_rolercat on table ROLERCAT'


--METADATA NAME:pk_rolercat TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT pk_rolercat PRIMARY KEY (role_id,role_catg_type_id)
go

print 'Creating constraint pk_roles on table ROLES'


--METADATA NAME:pk_roles TYPE:CONSTRAINT TABLE_NAME:ROLES CHANGE:CREATE
ALTER TABLE ROLES
ADD CONSTRAINT pk_roles PRIMARY KEY (role_id)
go

print 'Creating constraint pk_rolfolio on table ROLFOLIO'


--METADATA NAME:pk_rolfolio TYPE:CONSTRAINT TABLE_NAME:ROLFOLIO CHANGE:CREATE
ALTER TABLE ROLFOLIO
ADD CONSTRAINT pk_rolfolio PRIMARY KEY (rlfolio_id,role_id)
go

print 'Creating constraint pk_rpt on table RPT'


--METADATA NAME:pk_rpt TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT pk_rpt PRIMARY KEY (rpt_id)
go

print 'Creating constraint pk_rptbatch on table RPTBATCH'


--METADATA NAME:pk_rptbatch TYPE:CONSTRAINT TABLE_NAME:RPTBATCH CHANGE:CREATE
ALTER TABLE RPTBATCH
ADD CONSTRAINT pk_rptbatch PRIMARY KEY (rpt_batch_id)
go

print 'Creating constraint pk_rptgroup on table RPTGROUP'


--METADATA NAME:pk_rptgroup TYPE:CONSTRAINT TABLE_NAME:RPTGROUP CHANGE:CREATE
ALTER TABLE RPTGROUP
ADD CONSTRAINT pk_rptgroup PRIMARY KEY (rpt_group_id)
go

print 'Creating constraint pk_rptlist on table RPTLIST'


--METADATA NAME:pk_rptlist TYPE:CONSTRAINT TABLE_NAME:RPTLIST CHANGE:CREATE
ALTER TABLE RPTLIST
ADD CONSTRAINT pk_rptlist PRIMARY KEY (rpt_batch_id,rpt_id)
go

print 'Creating constraint pk_rsrc on table RSRC'


--METADATA NAME:pk_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT pk_rsrc PRIMARY KEY (rsrc_id)
go

print 'Creating constraint pk_rsrcandash on table RSRCANDASH'


--METADATA NAME:pk_rsrcandash TYPE:CONSTRAINT TABLE_NAME:RSRCANDASH CHANGE:CREATE
ALTER TABLE RSRCANDASH
ADD CONSTRAINT pk_rsrcandash PRIMARY KEY (dashboard_id,rsrcan_view_id)
go

print 'Creating constraint pk_rsrcanview on table RSRCANVIEW'


--METADATA NAME:pk_rsrcanview TYPE:CONSTRAINT TABLE_NAME:RSRCANVIEW CHANGE:CREATE
ALTER TABLE RSRCANVIEW
ADD CONSTRAINT pk_rsrcanview PRIMARY KEY (rsrcan_view_id)
go

print 'Creating constraint pk_rsrccurv on table RSRCCURV'


--METADATA NAME:pk_rsrccurv TYPE:CONSTRAINT TABLE_NAME:RSRCCURV CHANGE:CREATE
ALTER TABLE RSRCCURV
ADD CONSTRAINT pk_rsrccurv PRIMARY KEY (curv_id)
go

print 'Creating constraint pk_rsrchour on table RSRCHOUR'


--METADATA NAME:pk_rsrchour TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT pk_rsrchour PRIMARY KEY (rsrc_hr_id)
go

print 'Creating constraint pk_rsrcprop on table RSRCPROP'


--METADATA NAME:pk_rsrcprop TYPE:CONSTRAINT TABLE_NAME:RSRCPROP CHANGE:CREATE
ALTER TABLE RSRCPROP
ADD CONSTRAINT pk_rsrcprop PRIMARY KEY (rsrc_id,prop_name)
go

print 'Creating constraint pk_rsrcrate on table RSRCRATE'


--METADATA NAME:pk_rsrcrate TYPE:CONSTRAINT TABLE_NAME:RSRCRATE CHANGE:CREATE
ALTER TABLE RSRCRATE
ADD CONSTRAINT pk_rsrcrate PRIMARY KEY (rsrc_rate_id)
go

print 'Creating constraint pk_rsrcrcat on table RSRCRCAT'


--METADATA NAME:pk_rsrcrcat TYPE:CONSTRAINT TABLE_NAME:RSRCRCAT CHANGE:CREATE
ALTER TABLE RSRCRCAT
ADD CONSTRAINT pk_rsrcrcat PRIMARY KEY (rsrc_id,rsrc_catg_type_id)
go

print 'Creating constraint pk_rsrcrole on table RSRCROLE'


--METADATA NAME:pk_rsrcrole TYPE:CONSTRAINT TABLE_NAME:RSRCROLE CHANGE:CREATE
ALTER TABLE RSRCROLE
ADD CONSTRAINT pk_rsrcrole PRIMARY KEY (rsrc_id,role_id)
go

print 'Creating constraint pk_rsrcsec on table RSRCSEC'


--METADATA NAME:pk_rsrcsec TYPE:CONSTRAINT TABLE_NAME:RSRCSEC CHANGE:CREATE
ALTER TABLE RSRCSEC
ADD CONSTRAINT pk_rsrcsec PRIMARY KEY (user_id,rsrc_id)
go

print 'Creating constraint pk_rsrfolio on table RSRFOLIO'


--METADATA NAME:pk_rsrfolio TYPE:CONSTRAINT TABLE_NAME:RSRFOLIO CHANGE:CREATE
ALTER TABLE RSRFOLIO
ADD CONSTRAINT pk_rsrfolio PRIMARY KEY (rfolio_id,rsrc_id)
go

print 'Creating constraint pk_scenario on table SCENARIO'


--METADATA NAME:pk_scenario TYPE:CONSTRAINT TABLE_NAME:SCENARIO CHANGE:CREATE
ALTER TABLE SCENARIO
ADD CONSTRAINT pk_scenario PRIMARY KEY (scenario_id)
go

print 'Creating constraint pk_scenprog on table SCENPROJ'


--METADATA NAME:pk_scenprog TYPE:CONSTRAINT TABLE_NAME:SCENPROJ CHANGE:CREATE
ALTER TABLE SCENPROJ
ADD CONSTRAINT pk_scenprog PRIMARY KEY (scenario_id,proj_id)
go

print 'Creating constraint pk_scenrole on table SCENROLE'


--METADATA NAME:pk_scenrole TYPE:CONSTRAINT TABLE_NAME:SCENROLE CHANGE:CREATE
ALTER TABLE SCENROLE
ADD CONSTRAINT pk_scenrole PRIMARY KEY (scenario_id,role_id)
go

print 'Creating constraint pk_scenuser on table SCENUSER'


--METADATA NAME:pk_scenuser TYPE:CONSTRAINT TABLE_NAME:SCENUSER CHANGE:CREATE
ALTER TABLE SCENUSER
ADD CONSTRAINT pk_scenuser PRIMARY KEY (scenario_id,user_id)
go

print 'Creating constraint pk_settings on table SETTINGS'


--METADATA NAME:pk_settings TYPE:CONSTRAINT TABLE_NAME:SETTINGS CHANGE:CREATE
ALTER TABLE SETTINGS
ADD CONSTRAINT pk_settings PRIMARY KEY (namespace,setting_name)
go

print 'Creating constraint pk_shift on table SHIFT'


--METADATA NAME:pk_shift TYPE:CONSTRAINT TABLE_NAME:SHIFT CHANGE:CREATE
ALTER TABLE SHIFT
ADD CONSTRAINT pk_shift PRIMARY KEY (shift_id)
go

print 'Creating constraint pk_shiftper on table SHIFTPER'


--METADATA NAME:pk_shiftper TYPE:CONSTRAINT TABLE_NAME:SHIFTPER CHANGE:CREATE
ALTER TABLE SHIFTPER
ADD CONSTRAINT pk_shiftper PRIMARY KEY (shift_period_id)
go

print 'Creating constraint pk_spidmap on table SPIDMAP'


--METADATA NAME:pk_spidmap TYPE:CONSTRAINT TABLE_NAME:SPIDMAP CHANGE:CREATE
ALTER TABLE SPIDMAP
ADD CONSTRAINT pk_spidmap PRIMARY KEY (spid)
go

print 'Creating constraint pk_sumtrsrc on table SUMTRSRC'


--METADATA NAME:pk_sumtrsrc TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT pk_sumtrsrc PRIMARY KEY (sumtrsrc_id)
go

print 'Creating constraint pk_task on table TASK'


--METADATA NAME:pk_task TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT pk_task PRIMARY KEY (task_id)
go

print 'Creating constraint pk_taskactv on table TASKACTV'


--METADATA NAME:pk_taskactv TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT pk_taskactv PRIMARY KEY (task_id,actv_code_type_id)
go

print 'Creating constraint pk_taskdoc on table TASKDOC'


--METADATA NAME:pk_taskdoc TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT pk_taskdoc PRIMARY KEY (taskdoc_id)
go

print 'Creating constraint pk_taskfdbk on table TASKFDBK'


--METADATA NAME:pk_taskfdbk TYPE:CONSTRAINT TABLE_NAME:TASKFDBK CHANGE:CREATE
ALTER TABLE TASKFDBK
ADD CONSTRAINT pk_taskfdbk PRIMARY KEY (task_id)
go

print 'Creating constraint pk_taskfin on table TASKFIN'


--METADATA NAME:pk_taskfin TYPE:CONSTRAINT TABLE_NAME:TASKFIN CHANGE:CREATE
ALTER TABLE TASKFIN
ADD CONSTRAINT pk_taskfin PRIMARY KEY (fin_dates_id,task_id)
go

print 'Creating constraint pk_taskmemo on table TASKMEMO'


--METADATA NAME:pk_taskmemo TYPE:CONSTRAINT TABLE_NAME:TASKMEMO CHANGE:CREATE
ALTER TABLE TASKMEMO
ADD CONSTRAINT pk_taskmemo PRIMARY KEY (memo_id)
go

print 'Creating constraint pk_tasknote on table TASKNOTE'


--METADATA NAME:pk_tasknote TYPE:CONSTRAINT TABLE_NAME:TASKNOTE CHANGE:CREATE
ALTER TABLE TASKNOTE
ADD CONSTRAINT pk_tasknote PRIMARY KEY (task_id)
go

print 'Creating constraint pk_taskpred on table TASKPRED'


--METADATA NAME:pk_taskpred TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT pk_taskpred PRIMARY KEY (task_pred_id)
go

print 'Creating constraint pk_taskproc on table TASKPROC'


--METADATA NAME:pk_taskproc TYPE:CONSTRAINT TABLE_NAME:TASKPROC CHANGE:CREATE
ALTER TABLE TASKPROC
ADD CONSTRAINT pk_taskproc PRIMARY KEY (proc_id)
go

print 'Creating constraint pk_risk_task on table TASKRISK'


--METADATA NAME:pk_risk_task TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT pk_risk_task PRIMARY KEY (risk_id,task_id)
go

print 'Creating constraint pk_taskrsrc on table TASKRSRC'


--METADATA NAME:pk_taskrsrc TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT pk_taskrsrc PRIMARY KEY (taskrsrc_id)
go

print 'Creating constraint pk_tasksum on table TASKSUM'


--METADATA NAME:pk_tasksum TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:CREATE
ALTER TABLE TASKSUM
ADD CONSTRAINT pk_tasksum PRIMARY KEY (task_sum_id)
go

print 'Creating constraint pk_tasksumfin on table TASKSUMFIN'


--METADATA NAME:pk_tasksumfin TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:CREATE
ALTER TABLE TASKSUMFIN
ADD CONSTRAINT pk_tasksumfin PRIMARY KEY (task_sum_fin_id)
go

print 'Creating constraint pk_taskuser on table TASKUSER'


--METADATA NAME:pk_taskuser TYPE:CONSTRAINT TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER
ADD CONSTRAINT pk_taskuser PRIMARY KEY (task_id)
go

print 'Creating constraint pk_taskwksp on table TASKWKSP'


--METADATA NAME:pk_taskwksp TYPE:CONSTRAINT TABLE_NAME:TASKWKSP CHANGE:CREATE
ALTER TABLE TASKWKSP
ADD CONSTRAINT pk_taskwksp PRIMARY KEY (workspace_id,task_id)
go

print 'Creating constraint pk_thrsparm on table THRSPARM'


--METADATA NAME:pk_thrsparm TYPE:CONSTRAINT TABLE_NAME:THRSPARM CHANGE:CREATE
ALTER TABLE THRSPARM
ADD CONSTRAINT pk_thrsparm PRIMARY KEY (thresh_parm_id)
go

print 'Creating constraint pk_timesht on table TIMESHT'


--METADATA NAME:pk_timesht TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:CREATE
ALTER TABLE TIMESHT
ADD CONSTRAINT pk_timesht PRIMARY KEY (ts_id,rsrc_id)
go

print 'Creating constraint pk_tmplcatg on table TMPLCATG'


--METADATA NAME:pk_tmplcatg TYPE:CONSTRAINT TABLE_NAME:TMPLCATG CHANGE:CREATE
ALTER TABLE TMPLCATG
ADD CONSTRAINT pk_tmplcatg PRIMARY KEY (tmplcatg_catg_id)
go

print 'Creating constraint pk_trakview on table TRAKVIEW'


--METADATA NAME:pk_trakview TYPE:CONSTRAINT TABLE_NAME:TRAKVIEW CHANGE:CREATE
ALTER TABLE TRAKVIEW
ADD CONSTRAINT pk_trakview PRIMARY KEY (track_view_id)
go

print 'Creating constraint pk_trsrcfin on table TRSRCFIN'


--METADATA NAME:pk_trsrcfin TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT pk_trsrcfin PRIMARY KEY (fin_dates_id,taskrsrc_id)
go

print 'Creating constraint pk_trsrcsum on table TRSRCSUM'


--METADATA NAME:pk_trsrcsum TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:CREATE
ALTER TABLE TRSRCSUM
ADD CONSTRAINT pk_trsrcsum PRIMARY KEY (taskrsrc_sum_id)
go

print 'Creating constraint pk_trsrcsumfn on table TRSRCSUMFN'


--METADATA NAME:pk_trsrcsumfn TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
ALTER TABLE TRSRCSUMFN
ADD CONSTRAINT pk_trsrcsumfn PRIMARY KEY (trsrc_sum_fin_id)
go

print 'Creating constraint pk_tsaudit on table TSAUDIT'


--METADATA NAME:pk_tsaudit TYPE:CONSTRAINT TABLE_NAME:TSAUDIT CHANGE:CREATE
ALTER TABLE TSAUDIT
ADD CONSTRAINT pk_tsaudit PRIMARY KEY (ts_audit_id)
go

print 'Creating constraint pk_tsdates on table TSDATES'


--METADATA NAME:pk_tsdates TYPE:CONSTRAINT TABLE_NAME:TSDATES CHANGE:CREATE
ALTER TABLE TSDATES
ADD CONSTRAINT pk_tsdates PRIMARY KEY (ts_id)
go

print 'Creating constraint pk_tsdelegate on table TSDELEGATE'


--METADATA NAME:pk_tsdelegate TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT pk_tsdelegate PRIMARY KEY (ts_delegate_id)
go

print 'Creating constraint pk_uaccess on table UACCESS'


--METADATA NAME:pk_uaccess TYPE:CONSTRAINT TABLE_NAME:UACCESS CHANGE:CREATE
ALTER TABLE UACCESS
ADD CONSTRAINT pk_uaccess PRIMARY KEY (user_id,proj_id)
go

print 'Creating constraint pk_udfcode on table UDFCODE'


--METADATA NAME:pk_udfcode TYPE:CONSTRAINT TABLE_NAME:UDFCODE CHANGE:CREATE
ALTER TABLE UDFCODE
ADD CONSTRAINT pk_udfcode PRIMARY KEY (udf_code_id)
go

print 'Creating constraint pk_udftype on table UDFTYPE'


--METADATA NAME:pk_udftype TYPE:CONSTRAINT TABLE_NAME:UDFTYPE CHANGE:CREATE
ALTER TABLE UDFTYPE
ADD CONSTRAINT pk_udftype PRIMARY KEY (udf_type_id)
go

print 'Creating constraint pk_udfvalue on table UDFVALUE'


--METADATA NAME:pk_udfvalue TYPE:CONSTRAINT TABLE_NAME:UDFVALUE CHANGE:CREATE
ALTER TABLE UDFVALUE
ADD CONSTRAINT pk_udfvalue PRIMARY KEY (udf_type_id,fk_id)
go

print 'Creating constraint pk_uevntreg on table UEVNTREG'


--METADATA NAME:pk_uevntreg TYPE:CONSTRAINT TABLE_NAME:UEVNTREG CHANGE:CREATE
ALTER TABLE UEVNTREG
ADD CONSTRAINT pk_uevntreg PRIMARY KEY (user_id,app_name,operation_name,action_name)
go

print 'Creating constraint pk_umeasure on table UMEASURE'


--METADATA NAME:pk_umeasure TYPE:CONSTRAINT TABLE_NAME:UMEASURE CHANGE:CREATE
ALTER TABLE UMEASURE
ADD CONSTRAINT pk_umeasure PRIMARY KEY (unit_id)
go

print 'Creating constraint pk_usercol on table USERCOL'


--METADATA NAME:pk_usercol TYPE:CONSTRAINT TABLE_NAME:USERCOL CHANGE:CREATE
ALTER TABLE USERCOL
ADD CONSTRAINT pk_usercol PRIMARY KEY (user_col_id)
go

print 'Creating constraint pk_userdata on table USERDATA'


--METADATA NAME:pk_userdata TYPE:CONSTRAINT TABLE_NAME:USERDATA CHANGE:CREATE
ALTER TABLE USERDATA
ADD CONSTRAINT pk_userdata PRIMARY KEY (user_data_id)
go

print 'Creating constraint pk_usereng on table USERENG'


--METADATA NAME:pk_usereng TYPE:CONSTRAINT TABLE_NAME:USERENG CHANGE:CREATE
ALTER TABLE USERENG
ADD CONSTRAINT pk_usereng PRIMARY KEY (user_eng_id)
go

print 'Creating constraint pk_userobs on table USEROBS'


--METADATA NAME:pk_userobs TYPE:CONSTRAINT TABLE_NAME:USEROBS CHANGE:CREATE
ALTER TABLE USEROBS
ADD CONSTRAINT pk_userobs PRIMARY KEY (user_id,obs_id)
go

print 'Creating constraint pk_useropen on table USEROPEN'


--METADATA NAME:pk_useropen TYPE:CONSTRAINT TABLE_NAME:USEROPEN CHANGE:CREATE
ALTER TABLE USEROPEN
ADD CONSTRAINT pk_useropen PRIMARY KEY (user_open_id)
go

print 'Creating constraint pk_users on table USERS'


--METADATA NAME:pk_users TYPE:CONSTRAINT TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS
ADD CONSTRAINT pk_users PRIMARY KEY (user_id)
go

print 'Creating constraint pk_userset on table USERSET'


--METADATA NAME:pk_userset TYPE:CONSTRAINT TABLE_NAME:USERSET CHANGE:CREATE
ALTER TABLE USERSET
ADD CONSTRAINT pk_userset PRIMARY KEY (namespace,setting_name,user_id)
go

print 'Creating constraint pk_userwksp on table USERWKSP'


--METADATA NAME:pk_userwksp TYPE:CONSTRAINT TABLE_NAME:USERWKSP CHANGE:CREATE
ALTER TABLE USERWKSP
ADD CONSTRAINT pk_userwksp PRIMARY KEY (user_id,workspace_id)
go

print 'Creating constraint pk_user_acceptance_consent on table USER_ACCEPTANCE_CONSENT'


--METADATA NAME:pk_user_acceptance_consent TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT pk_user_acceptance_consent PRIMARY KEY (user_id,consent_type)
go

print 'Creating constraint pk_usession on table USESSION'


--METADATA NAME:pk_usession TYPE:CONSTRAINT TABLE_NAME:USESSION CHANGE:CREATE
ALTER TABLE USESSION
ADD CONSTRAINT pk_usession PRIMARY KEY (session_id)
go

print 'Creating constraint pk_usropnval on table USROPNVAL'


--METADATA NAME:pk_usropnval TYPE:CONSTRAINT TABLE_NAME:USROPNVAL CHANGE:CREATE
ALTER TABLE USROPNVAL
ADD CONSTRAINT pk_usropnval PRIMARY KEY (user_open_id,pk_id,usropn_type)
go

print 'Creating constraint pk_viewpref on table VIEWPREF'


--METADATA NAME:pk_viewpref TYPE:CONSTRAINT TABLE_NAME:VIEWPREF CHANGE:CREATE
ALTER TABLE VIEWPREF
ADD CONSTRAINT pk_viewpref PRIMARY KEY (view_pref_id)
go

print 'Creating constraint pk_viewprop on table VIEWPROP'


--METADATA NAME:pk_viewprop TYPE:CONSTRAINT TABLE_NAME:VIEWPROP CHANGE:CREATE
ALTER TABLE VIEWPROP
ADD CONSTRAINT pk_viewprop PRIMARY KEY (view_id)
go

print 'Creating constraint pk_vwprefdash on table VWPREFDASH'


--METADATA NAME:pk_vwprefdash TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT pk_vwprefdash PRIMARY KEY (dashboard_id,view_pref_id)
go

print 'Creating constraint pk_vwprefdata on table VWPREFDATA'


--METADATA NAME:pk_vwprefdata TYPE:CONSTRAINT TABLE_NAME:VWPREFDATA CHANGE:CREATE
ALTER TABLE VWPREFDATA
ADD CONSTRAINT pk_vwprefdata PRIMARY KEY (view_pref_id,view_pref_key)
go

print 'Creating constraint pk_vwprefuser on table VWPREFUSER'


--METADATA NAME:pk_vwprefuser TYPE:CONSTRAINT TABLE_NAME:VWPREFUSER CHANGE:CREATE
ALTER TABLE VWPREFUSER
ADD CONSTRAINT pk_vwprefuser PRIMARY KEY (view_pref_id,user_id)
go

print 'Creating constraint pk_wbrscat on table WBRSCAT'


--METADATA NAME:pk_wbrscat TYPE:CONSTRAINT TABLE_NAME:WBRSCAT CHANGE:CREATE
ALTER TABLE WBRSCAT
ADD CONSTRAINT pk_wbrscat PRIMARY KEY (wbrs_cat_id)
go

print 'Creating constraint pk_wbsbudg on table WBSBUDG'


--METADATA NAME:pk_wbsbudg TYPE:CONSTRAINT TABLE_NAME:WBSBUDG CHANGE:CREATE
ALTER TABLE WBSBUDG
ADD CONSTRAINT pk_wbsbudg PRIMARY KEY (wbs_budg_id)
go

print 'Creating constraint pk_wbsmemo on table WBSMEMO'


--METADATA NAME:pk_wbsmemo TYPE:CONSTRAINT TABLE_NAME:WBSMEMO CHANGE:CREATE
ALTER TABLE WBSMEMO
ADD CONSTRAINT pk_wbsmemo PRIMARY KEY (wbs_memo_id)
go

print 'Creating constraint pk_wbsrsrc on table WBSRSRC'


--METADATA NAME:pk_wbsrsrc TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT pk_wbsrsrc PRIMARY KEY (wbsrsrc_id)
go

print 'Creating constraint pk_wbsrsrc_qty on table WBSRSRC_QTY'


--METADATA NAME:pk_wbsrsrc_qty TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT pk_wbsrsrc_qty PRIMARY KEY (wbsrsrc_id,week_start,month_start)
go

print 'Creating constraint pk_wbsstep on table WBSSTEP'


--METADATA NAME:pk_wbsstep TYPE:CONSTRAINT TABLE_NAME:WBSSTEP CHANGE:CREATE
ALTER TABLE WBSSTEP
ADD CONSTRAINT pk_wbsstep PRIMARY KEY (wbs_step_id)
go

print 'Creating constraint pk_wkfltmpl on table WKFLTMPL'


--METADATA NAME:pk_wkfltmpl TYPE:CONSTRAINT TABLE_NAME:WKFLTMPL CHANGE:CREATE
ALTER TABLE WKFLTMPL
ADD CONSTRAINT pk_wkfltmpl PRIMARY KEY (wkfl_tmpl_id)
go

print 'Creating constraint pk_wkfluser on table WKFLUSER'


--METADATA NAME:pk_wkfluser TYPE:CONSTRAINT TABLE_NAME:WKFLUSER CHANGE:CREATE
ALTER TABLE WKFLUSER
ADD CONSTRAINT pk_wkfluser PRIMARY KEY (work_flow_id,user_id,stage_num)
go

print 'Creating constraint pk_workflow on table WORKFLOW'


--METADATA NAME:pk_workflow TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT pk_workflow PRIMARY KEY (work_flow_id)
go

print 'Creating constraint pk_workspace on table WORKSPACE'


--METADATA NAME:pk_workspace TYPE:CONSTRAINT TABLE_NAME:WORKSPACE CHANGE:CREATE
ALTER TABLE WORKSPACE
ADD CONSTRAINT pk_workspace PRIMARY KEY (workspace_id)
go

print 'Creating constraint fk_actvcode_actvtype on table ACTVCODE'


--METADATA NAME:fk_actvcode_actvtype TYPE:CONSTRAINT TABLE_NAME:ACTVCODE CHANGE:CREATE
ALTER TABLE ACTVCODE
ADD CONSTRAINT fk_actvcode_actvtype FOREIGN KEY (actv_code_type_id)
REFERENCES ACTVTYPE (actv_code_type_id) 
go

print 'Creating constraint fk_actvtype_project on table ACTVTYPE'


--METADATA NAME:fk_actvtype_project TYPE:CONSTRAINT TABLE_NAME:ACTVTYPE CHANGE:CREATE
ALTER TABLE ACTVTYPE
ADD CONSTRAINT fk_actvtype_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_asgnmntacat_asgnmntcattype on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_asgnmntcatval on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_asgnmntcatval TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_asgnmntcatval FOREIGN KEY (asgnmnt_catg_id)
REFERENCES ASGNMNTCATVAL (asgnmnt_catg_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_taskrsrc on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_taskrsrc TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgnmntacat_project on table ASGNMNTACAT'


--METADATA NAME:fk_asgnmntacat_project TYPE:CONSTRAINT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
ALTER TABLE ASGNMNTACAT
ADD CONSTRAINT fk_asgnmntacat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_asgncatval_asgnmntcattype on table ASGNMNTCATVAL'


--METADATA NAME:fk_asgncatval_asgnmntcattype TYPE:CONSTRAINT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
ALTER TABLE ASGNMNTCATVAL
ADD CONSTRAINT fk_asgncatval_asgnmntcattype FOREIGN KEY (asgnmnt_catg_type_id)
REFERENCES ASGNMNTCATTYPE (asgnmnt_catg_type_id) 
go

print 'Creating constraint fk_budgchng_project on table BUDGCHNG'


--METADATA NAME:fk_budgchng_project TYPE:CONSTRAINT TABLE_NAME:BUDGCHNG CHANGE:CREATE
ALTER TABLE BUDGCHNG
ADD CONSTRAINT fk_budgchng_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_budgchng_projwbs on table BUDGCHNG'


--METADATA NAME:fk_budgchng_projwbs TYPE:CONSTRAINT TABLE_NAME:BUDGCHNG CHANGE:CREATE
ALTER TABLE BUDGCHNG
ADD CONSTRAINT fk_budgchng_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_calendar_project on table CALENDAR'


--METADATA NAME:fk_calendar_project TYPE:CONSTRAINT TABLE_NAME:CALENDAR CHANGE:CREATE
ALTER TABLE CALENDAR
ADD CONSTRAINT fk_calendar_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_dashboard_users on table DASHBOARD'


--METADATA NAME:fk_dashboard_users TYPE:CONSTRAINT TABLE_NAME:DASHBOARD CHANGE:CREATE
ALTER TABLE DASHBOARD
ADD CONSTRAINT fk_dashboard_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_dashuser_users on table DASHUSER'


--METADATA NAME:fk_dashuser_users TYPE:CONSTRAINT TABLE_NAME:DASHUSER CHANGE:CREATE
ALTER TABLE DASHUSER
ADD CONSTRAINT fk_dashuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_dashuser_dashboard on table DASHUSER'


--METADATA NAME:fk_dashuser_dashboard TYPE:CONSTRAINT TABLE_NAME:DASHUSER CHANGE:CREATE
ALTER TABLE DASHUSER
ADD CONSTRAINT fk_dashuser_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_discussion_task on table DISCUSSION'


--METADATA NAME:fk_discussion_task TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT fk_discussion_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_discussion_read_users on table DISCUSSION_READ'


--METADATA NAME:fk_discussion_read_users TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_discussion_read_discussion on table DISCUSSION_READ'


--METADATA NAME:fk_discussion_read_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_discussion FOREIGN KEY (discussion_id)
REFERENCES DISCUSSION (discussion_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_docreview_document on table DOCREVIEW'


--METADATA NAME:fk_docreview_document TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
go

print 'Creating constraint fk_docreview_users on table DOCREVIEW'


--METADATA NAME:fk_docreview_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_docreviewtask_docreview on table DOCREVIEWTASK'


--METADATA NAME:fk_docreviewtask_docreview TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_docreview FOREIGN KEY (doc_review_id)
REFERENCES DOCREVIEW (doc_review_id) 
go

print 'Creating constraint fk_docreviewtask_users on table DOCREVIEWTASK'


--METADATA NAME:fk_docreviewtask_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_document_doccatg on table DOCUMENT'


--METADATA NAME:fk_document_doccatg TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT fk_document_doccatg FOREIGN KEY (doc_catg_id)
REFERENCES DOCCATG (doc_catg_id) 
go

print 'Creating constraint fk_document_project on table DOCUMENT'


--METADATA NAME:fk_document_project TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT fk_document_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_document_docstat on table DOCUMENT'


--METADATA NAME:fk_document_docstat TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT fk_document_docstat FOREIGN KEY (doc_status_id)
REFERENCES DOCSTAT (doc_status_id) 
go

print 'Creating constraint fk_document_rsrc on table DOCUMENT'


--METADATA NAME:fk_document_rsrc TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT fk_document_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_expproj_project on table EXPPROJ'


--METADATA NAME:fk_expproj_project TYPE:CONSTRAINT TABLE_NAME:EXPPROJ CHANGE:CREATE
ALTER TABLE EXPPROJ
ADD CONSTRAINT fk_expproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_extapp_project on table EXTAPP'


--METADATA NAME:fk_extapp_project TYPE:CONSTRAINT TABLE_NAME:EXTAPP CHANGE:CREATE
ALTER TABLE EXTAPP
ADD CONSTRAINT fk_extapp_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_factval_factor on table FACTVAL'


--METADATA NAME:fk_factval_factor TYPE:CONSTRAINT TABLE_NAME:FACTVAL CHANGE:CREATE
ALTER TABLE FACTVAL
ADD CONSTRAINT fk_factval_factor FOREIGN KEY (fact_id)
REFERENCES FACTOR (fact_id) 
go

print 'Creating constraint fk_filtprop_users on table FILTPROP'


--METADATA NAME:fk_filtprop_users TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_filtprop_rpt on table FILTPROP'


--METADATA NAME:fk_filtprop_rpt TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
go

print 'Creating constraint fk_findates_fintmpl on table FINDATES'


--METADATA NAME:fk_findates_fintmpl TYPE:CONSTRAINT TABLE_NAME:FINDATES CHANGE:CREATE
ALTER TABLE FINDATES
ADD CONSTRAINT fk_findates_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_formproj_formtmpl on table FORMPROJ'


--METADATA NAME:fk_formproj_formtmpl TYPE:CONSTRAINT TABLE_NAME:FORMPROJ CHANGE:CREATE
ALTER TABLE FORMPROJ
ADD CONSTRAINT fk_formproj_formtmpl FOREIGN KEY (form_tmpl_id)
REFERENCES FORMTMPL (form_tmpl_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_formproj_project on table FORMPROJ'


--METADATA NAME:fk_formproj_project TYPE:CONSTRAINT TABLE_NAME:FORMPROJ CHANGE:CREATE
ALTER TABLE FORMPROJ
ADD CONSTRAINT fk_formproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_formtmpl_formcatg on table FORMTMPL'


--METADATA NAME:fk_formtmpl_formcatg TYPE:CONSTRAINT TABLE_NAME:FORMTMPL CHANGE:CREATE
ALTER TABLE FORMTMPL
ADD CONSTRAINT fk_formtmpl_formcatg FOREIGN KEY (form_catg_id)
REFERENCES FORMCATG (form_catg_id) 
go

print 'Creating constraint fk_gchange_user on table GCHANGE'


--METADATA NAME:fk_gchange_user TYPE:CONSTRAINT TABLE_NAME:GCHANGE CHANGE:CREATE
ALTER TABLE GCHANGE
ADD CONSTRAINT fk_gchange_user FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_hqdata_usession on table HQDATA'


--METADATA NAME:fk_hqdata_usession TYPE:CONSTRAINT TABLE_NAME:HQDATA CHANGE:CREATE
ALTER TABLE HQDATA
ADD CONSTRAINT fk_hqdata_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_hquery_usession on table HQUERY'


--METADATA NAME:fk_hquery_usession TYPE:CONSTRAINT TABLE_NAME:HQUERY CHANGE:CREATE
ALTER TABLE HQUERY
ADD CONSTRAINT fk_hquery_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_issuhist_project on table ISSUHIST'


--METADATA NAME:fk_issuhist_project TYPE:CONSTRAINT TABLE_NAME:ISSUHIST CHANGE:CREATE
ALTER TABLE ISSUHIST
ADD CONSTRAINT fk_issuhist_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_issuhist_projissu on table ISSUHIST'


--METADATA NAME:fk_issuhist_projissu TYPE:CONSTRAINT TABLE_NAME:ISSUHIST CHANGE:CREATE
ALTER TABLE ISSUHIST
ADD CONSTRAINT fk_issuhist_projissu FOREIGN KEY (issue_id)
REFERENCES PROJISSU (issue_id) 
go

print 'Creating constraint fk_iteration_release on table ITERATION'


--METADATA NAME:fk_iteration_release TYPE:CONSTRAINT TABLE_NAME:ITERATION CHANGE:CREATE
ALTER TABLE ITERATION
ADD CONSTRAINT fk_iteration_release FOREIGN KEY (release_id)
REFERENCES RELEASE (release_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_iterdays_project on table ITERDAYS'


--METADATA NAME:fk_iterdays_project TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:CREATE
ALTER TABLE ITERDAYS
ADD CONSTRAINT fk_iterdays_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_iterdays_iteration on table ITERDAYS'


--METADATA NAME:fk_iterdays_iteration TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:CREATE
ALTER TABLE ITERDAYS
ADD CONSTRAINT fk_iterdays_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_iterdays_task on table ITERDAYS'


--METADATA NAME:fk_iterdays_task TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:CREATE
ALTER TABLE ITERDAYS
ADD CONSTRAINT fk_iterdays_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_itergoal_iteration on table ITERGOAL'


--METADATA NAME:fk_itergoal_iteration TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:CREATE
ALTER TABLE ITERGOAL
ADD CONSTRAINT fk_itergoal_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_itergoal_rfolio on table ITERGOAL'


--METADATA NAME:fk_itergoal_rfolio TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:CREATE
ALTER TABLE ITERGOAL
ADD CONSTRAINT fk_itergoal_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
go

print 'Creating constraint fk_joblog_jobsvc on table JOBLOG'


--METADATA NAME:fk_joblog_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBLOG CHANGE:CREATE
ALTER TABLE JOBLOG
ADD CONSTRAINT fk_joblog_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_jobrpt_jobsvc on table JOBRPT'


--METADATA NAME:fk_jobrpt_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBRPT CHANGE:CREATE
ALTER TABLE JOBRPT
ADD CONSTRAINT fk_jobrpt_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_jobrpt_rpt on table JOBRPT'


--METADATA NAME:fk_jobrpt_rpt TYPE:CONSTRAINT TABLE_NAME:JOBRPT CHANGE:CREATE
ALTER TABLE JOBRPT
ADD CONSTRAINT fk_jobrpt_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_jobsvc_users on table JOBSVC'


--METADATA NAME:fk_jobsvc_users TYPE:CONSTRAINT TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC
ADD CONSTRAINT fk_jobsvc_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_obsproj_obs on table OBSPROJ'


--METADATA NAME:fk_obsproj_obs TYPE:CONSTRAINT TABLE_NAME:OBSPROJ CHANGE:CREATE
ALTER TABLE OBSPROJ
ADD CONSTRAINT fk_obsproj_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_obsproj_project on table OBSPROJ'


--METADATA NAME:fk_obsproj_project TYPE:CONSTRAINT TABLE_NAME:OBSPROJ CHANGE:CREATE
ALTER TABLE OBSPROJ
ADD CONSTRAINT fk_obsproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_pcatuser_user on table PCATUSER'


--METADATA NAME:fk_pcatuser_user TYPE:CONSTRAINT TABLE_NAME:PCATUSER CHANGE:CREATE
ALTER TABLE PCATUSER
ADD CONSTRAINT fk_pcatuser_user FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_pcatuser_pcatval on table PCATUSER'


--METADATA NAME:fk_pcatuser_pcatval TYPE:CONSTRAINT TABLE_NAME:PCATUSER CHANGE:CREATE
ALTER TABLE PCATUSER
ADD CONSTRAINT fk_pcatuser_pcatval FOREIGN KEY (proj_catg_id)
REFERENCES PCATVAL (proj_catg_id) 
go

print 'Creating constraint fk_pcatval_pcattype on table PCATVAL'


--METADATA NAME:fk_pcatval_pcattype TYPE:CONSTRAINT TABLE_NAME:PCATVAL CHANGE:CREATE
ALTER TABLE PCATVAL
ADD CONSTRAINT fk_pcatval_pcattype FOREIGN KEY (proj_catg_type_id)
REFERENCES PCATTYPE (proj_catg_type_id) 
go

print 'Creating constraint fk_pfolio_users on table PFOLIO'


--METADATA NAME:fk_pfolio_users TYPE:CONSTRAINT TABLE_NAME:PFOLIO CHANGE:CREATE
ALTER TABLE PFOLIO
ADD CONSTRAINT fk_pfolio_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
go

print 'Creating constraint fk_pfoliouser_users on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_prefer_currtype on table PREFER'


--METADATA NAME:fk_prefer_currtype TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT fk_prefer_currtype FOREIGN KEY (curr_id)
REFERENCES CURRTYPE (curr_id) 
go

print 'Creating constraint fk_prefer_users on table PREFER'


--METADATA NAME:fk_prefer_users TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT fk_prefer_users FOREIGN KEY (ts_approve_user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_prefer_rsrc on table PREFER'


--METADATA NAME:fk_prefer_rsrc TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT fk_prefer_rsrc FOREIGN KEY (default_rsrc_sec_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_procitem_procgroup on table PROCITEM'


--METADATA NAME:fk_procitem_procgroup TYPE:CONSTRAINT TABLE_NAME:PROCITEM CHANGE:CREATE
ALTER TABLE PROCITEM
ADD CONSTRAINT fk_procitem_procgroup FOREIGN KEY (proc_group_id)
REFERENCES PROCGROUP (proc_group_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_profpriv_profile on table PROFPRIV'


--METADATA NAME:fk_profpriv_profile TYPE:CONSTRAINT TABLE_NAME:PROFPRIV CHANGE:CREATE
ALTER TABLE PROFPRIV
ADD CONSTRAINT fk_profpriv_profile FOREIGN KEY (prof_id)
REFERENCES PROFILE (prof_id) 
go

print 'Creating constraint fk_projcost_account on table PROJCOST'


--METADATA NAME:fk_projcost_account TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_account FOREIGN KEY (acct_id)
REFERENCES ACCOUNT (acct_id) 
go

print 'Creating constraint fk_projcost_project on table PROJCOST'


--METADATA NAME:fk_projcost_project TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_projcost_task on table PROJCOST'


--METADATA NAME:fk_projcost_task TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_projcost_costtype on table PROJCOST'


--METADATA NAME:fk_projcost_costtype TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id) 
go

print 'Creating constraint fk_projcost_pobs on table PROJCOST'


--METADATA NAME:fk_projcost_pobs TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT fk_projcost_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
go

print 'Creating constraint fk_project_account on table PROJECT'


--METADATA NAME:fk_project_account TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_account FOREIGN KEY (acct_id)
REFERENCES ACCOUNT (acct_id) 
go

print 'Creating constraint fk_project_basetype on table PROJECT'


--METADATA NAME:fk_project_basetype TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_basetype FOREIGN KEY (base_type_id)
REFERENCES BASETYPE (base_type_id) 
go

print 'Creating constraint fk_project_findates on table PROJECT'


--METADATA NAME:fk_project_findates TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_findates FOREIGN KEY (last_fin_dates_id)
REFERENCES FINDATES (fin_dates_id) 
go

print 'Creating constraint fk_project_users on table PROJECT'


--METADATA NAME:fk_project_users TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_users FOREIGN KEY (checkout_user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_project_fintmpl on table PROJECT'


--METADATA NAME:fk_project_fintmpl TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT fk_project_fintmpl FOREIGN KEY (fintmpl_id)
REFERENCES FINTMPL (fintmpl_id) 
go

print 'Creating constraint fk_projest_project on table PROJEST'


--METADATA NAME:fk_projest_project TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT fk_projest_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_projest_rsrc on table PROJEST'


--METADATA NAME:fk_projest_rsrc TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT fk_projest_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_projest_projwbs on table PROJEST'


--METADATA NAME:fk_projest_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT fk_projest_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_projfund_fundsrc on table PROJFUND'


--METADATA NAME:fk_projfund_fundsrc TYPE:CONSTRAINT TABLE_NAME:PROJFUND CHANGE:CREATE
ALTER TABLE PROJFUND
ADD CONSTRAINT fk_projfund_fundsrc FOREIGN KEY (fund_id)
REFERENCES FUNDSRC (fund_id) 
go

print 'Creating constraint fk_projfund_project on table PROJFUND'


--METADATA NAME:fk_projfund_project TYPE:CONSTRAINT TABLE_NAME:PROJFUND CHANGE:CREATE
ALTER TABLE PROJFUND
ADD CONSTRAINT fk_projfund_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_projissu_obs on table PROJISSU'


--METADATA NAME:fk_projissu_obs TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
go

print 'Creating constraint fk_projissu_project on table PROJISSU'


--METADATA NAME:fk_projissu_project TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_projissu_projwbs on table PROJISSU'


--METADATA NAME:fk_projissu_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_projissu_task on table PROJISSU'


--METADATA NAME:fk_projissu_task TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_projissu_trakview on table PROJISSU'


--METADATA NAME:fk_projissu_trakview TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_trakview FOREIGN KEY (track_view_id)
REFERENCES TRAKVIEW (track_view_id) 
go

print 'Creating constraint fk_projissu_thrsparm on table PROJISSU'


--METADATA NAME:fk_projissu_thrsparm TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_thrsparm FOREIGN KEY (thresh_parm_id)
REFERENCES THRSPARM (thresh_parm_id) 
go

print 'Creating constraint fk_projissu_rsrc on table PROJISSU'


--METADATA NAME:fk_projissu_rsrc TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_projissu_projthrs on table PROJISSU'


--METADATA NAME:fk_projissu_projthrs TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_projthrs FOREIGN KEY (thresh_id)
REFERENCES PROJTHRS (thresh_id) 
go

print 'Creating constraint fk_projissu_workspace on table PROJISSU'


--METADATA NAME:fk_projissu_workspace TYPE:CONSTRAINT TABLE_NAME:PROJISSU CHANGE:CREATE
ALTER TABLE PROJISSU
ADD CONSTRAINT fk_projissu_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
go

print 'Creating constraint fk_projpcat_pcattype on table PROJPCAT'


--METADATA NAME:fk_projpcat_pcattype TYPE:CONSTRAINT TABLE_NAME:PROJPCAT CHANGE:CREATE
ALTER TABLE PROJPCAT
ADD CONSTRAINT fk_projpcat_pcattype FOREIGN KEY (proj_catg_type_id)
REFERENCES PCATTYPE (proj_catg_type_id) 
go

print 'Creating constraint fk_projpcat_pcatval on table PROJPCAT'


--METADATA NAME:fk_projpcat_pcatval TYPE:CONSTRAINT TABLE_NAME:PROJPCAT CHANGE:CREATE
ALTER TABLE PROJPCAT
ADD CONSTRAINT fk_projpcat_pcatval FOREIGN KEY (proj_catg_id)
REFERENCES PCATVAL (proj_catg_id) 
go

print 'Creating constraint fk_projpcat_project on table PROJPCAT'


--METADATA NAME:fk_projpcat_project TYPE:CONSTRAINT TABLE_NAME:PROJPCAT CHANGE:CREATE
ALTER TABLE PROJPCAT
ADD CONSTRAINT fk_projpcat_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_projprop_project on table PROJPROP'


--METADATA NAME:fk_projprop_project TYPE:CONSTRAINT TABLE_NAME:PROJPROP CHANGE:CREATE
ALTER TABLE PROJPROP
ADD CONSTRAINT fk_projprop_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_projshar_project on table PROJSHAR'


--METADATA NAME:fk_projshar_project TYPE:CONSTRAINT TABLE_NAME:PROJSHAR CHANGE:CREATE
ALTER TABLE PROJSHAR
ADD CONSTRAINT fk_projshar_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_projshar_usession on table PROJSHAR'


--METADATA NAME:fk_projshar_usession TYPE:CONSTRAINT TABLE_NAME:PROJSHAR CHANGE:CREATE
ALTER TABLE PROJSHAR
ADD CONSTRAINT fk_projshar_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_projthrs_obs on table PROJTHRS'


--METADATA NAME:fk_projthrs_obs TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
go

print 'Creating constraint fk_projthrs_trakview on table PROJTHRS'


--METADATA NAME:fk_projthrs_trakview TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_trakview FOREIGN KEY (track_view_id)
REFERENCES TRAKVIEW (track_view_id) 
go

print 'Creating constraint fk_projthrs_thrsparm on table PROJTHRS'


--METADATA NAME:fk_projthrs_thrsparm TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_thrsparm FOREIGN KEY (thresh_parm_id)
REFERENCES THRSPARM (thresh_parm_id) 
go

print 'Creating constraint fk_projthrs_project on table PROJTHRS'


--METADATA NAME:fk_projthrs_project TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_projthrs_projwbs on table PROJTHRS'


--METADATA NAME:fk_projthrs_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJTHRS CHANGE:CREATE
ALTER TABLE PROJTHRS
ADD CONSTRAINT fk_projthrs_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_projwbs_obs on table PROJWBS'


--METADATA NAME:fk_projwbs_obs TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
go

print 'Creating constraint fk_projwbs_project on table PROJWBS'


--METADATA NAME:fk_projwbs_project TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_projwbs_phase on table PROJWBS'


--METADATA NAME:fk_projwbs_phase TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_phase FOREIGN KEY (phase_id)
REFERENCES PHASE (phase_id) 
go

print 'Creating constraint fk_projwbs_rfolio_team on table PROJWBS'


--METADATA NAME:fk_projwbs_rfolio_team TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_rfolio_team FOREIGN KEY (resp_team_id)
REFERENCES RFOLIO (rfolio_id) 
go

print 'Creating constraint fk_projwbs_iteration on table PROJWBS'


--METADATA NAME:fk_projwbs_iteration TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT fk_projwbs_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id) 
go

print 'Creating constraint fk_projwsrpt_rpt on table PROJWSRPT'


--METADATA NAME:fk_projwsrpt_rpt TYPE:CONSTRAINT TABLE_NAME:PROJWSRPT CHANGE:CREATE
ALTER TABLE PROJWSRPT
ADD CONSTRAINT fk_projwsrpt_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_projwsrpt_project on table PROJWSRPT'


--METADATA NAME:fk_projwsrpt_project TYPE:CONSTRAINT TABLE_NAME:PROJWSRPT CHANGE:CREATE
ALTER TABLE PROJWSRPT
ADD CONSTRAINT fk_projwsrpt_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_prpfolio_pfolio on table PRPFOLIO'


--METADATA NAME:fk_prpfolio_pfolio TYPE:CONSTRAINT TABLE_NAME:PRPFOLIO CHANGE:CREATE
ALTER TABLE PRPFOLIO
ADD CONSTRAINT fk_prpfolio_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
go

print 'Creating constraint fk_prpfolio_projwbs on table PRPFOLIO'


--METADATA NAME:fk_prpfolio_projwbs TYPE:CONSTRAINT TABLE_NAME:PRPFOLIO CHANGE:CREATE
ALTER TABLE PRPFOLIO
ADD CONSTRAINT fk_prpfolio_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_rcatval_rcattype on table RCATVAL'


--METADATA NAME:fk_rcatval_rcattype TYPE:CONSTRAINT TABLE_NAME:RCATVAL CHANGE:CREATE
ALTER TABLE RCATVAL
ADD CONSTRAINT fk_rcatval_rcattype FOREIGN KEY (rsrc_catg_type_id)
REFERENCES RCATTYPE (rsrc_catg_type_id) 
go

print 'Creating constraint fk_release_rfolio on table RELEASE'


--METADATA NAME:fk_release_rfolio TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:CREATE
ALTER TABLE RELEASE
ADD CONSTRAINT fk_release_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
go

print 'Creating constraint fk_release_proj_id on table RELEASE'


--METADATA NAME:fk_release_proj_id TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:CREATE
ALTER TABLE RELEASE
ADD CONSTRAINT fk_release_proj_id FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_relitems_project on table RELITEMS'


--METADATA NAME:fk_relitems_project TYPE:CONSTRAINT TABLE_NAME:RELITEMS CHANGE:CREATE
ALTER TABLE RELITEMS
ADD CONSTRAINT fk_relitems_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_relitems_reittype on table RELITEMS'


--METADATA NAME:fk_relitems_reittype TYPE:CONSTRAINT TABLE_NAME:RELITEMS CHANGE:CREATE
ALTER TABLE RELITEMS
ADD CONSTRAINT fk_relitems_reittype FOREIGN KEY (item_type_id)
REFERENCES REITTYPE (related_item_type_id) 
go

print 'Creating constraint fk_relitems_reittype_related on table RELITEMS'


--METADATA NAME:fk_relitems_reittype_related TYPE:CONSTRAINT TABLE_NAME:RELITEMS CHANGE:CREATE
ALTER TABLE RELITEMS
ADD CONSTRAINT fk_relitems_reittype_related FOREIGN KEY (related_item_type_id)
REFERENCES REITTYPE (related_item_type_id) 
go

print 'Creating constraint fk_rfolio_users on table RFOLIO'


--METADATA NAME:fk_rfolio_users TYPE:CONSTRAINT TABLE_NAME:RFOLIO CHANGE:CREATE
ALTER TABLE RFOLIO
ADD CONSTRAINT fk_rfolio_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_rlfolio_user on table RLFOLIO'


--METADATA NAME:fk_rlfolio_user TYPE:CONSTRAINT TABLE_NAME:RLFOLIO CHANGE:CREATE
ALTER TABLE RLFOLIO
ADD CONSTRAINT fk_rlfolio_user FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_rolecatval_rolecattype on table ROLECATVAL'


--METADATA NAME:fk_rolecatval_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLECATVAL CHANGE:CREATE
ALTER TABLE ROLECATVAL
ADD CONSTRAINT fk_rolecatval_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
go

print 'Creating constraint fk_rolelimit_roles on table ROLELIMIT'


--METADATA NAME:fk_rolelimit_roles TYPE:CONSTRAINT TABLE_NAME:ROLELIMIT CHANGE:CREATE
ALTER TABLE ROLELIMIT
ADD CONSTRAINT fk_rolelimit_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_rolerate_roles on table ROLERATE'


--METADATA NAME:fk_rolerate_roles TYPE:CONSTRAINT TABLE_NAME:ROLERATE CHANGE:CREATE
ALTER TABLE ROLERATE
ADD CONSTRAINT fk_rolerate_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_rolercat_rolecattype on table ROLERCAT'


--METADATA NAME:fk_rolercat_rolecattype TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecattype FOREIGN KEY (role_catg_type_id)
REFERENCES ROLECATTYPE (role_catg_type_id) 
go

print 'Creating constraint fk_rolercat_rolecatval on table ROLERCAT'


--METADATA NAME:fk_rolercat_rolecatval TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_rolecatval FOREIGN KEY (role_catg_id)
REFERENCES ROLECATVAL (role_catg_id) 
go

print 'Creating constraint fk_rolercat_roles on table ROLERCAT'


--METADATA NAME:fk_rolercat_roles TYPE:CONSTRAINT TABLE_NAME:ROLERCAT CHANGE:CREATE
ALTER TABLE ROLERCAT
ADD CONSTRAINT fk_rolercat_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
go

print 'Creating constraint fk_roles_pobs on table ROLES'


--METADATA NAME:fk_roles_pobs TYPE:CONSTRAINT TABLE_NAME:ROLES CHANGE:CREATE
ALTER TABLE ROLES
ADD CONSTRAINT fk_roles_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
go

print 'Creating constraint fk_rolfolio_rlfolio on table ROLFOLIO'


--METADATA NAME:fk_rolfolio_rlfolio TYPE:CONSTRAINT TABLE_NAME:ROLFOLIO CHANGE:CREATE
ALTER TABLE ROLFOLIO
ADD CONSTRAINT fk_rolfolio_rlfolio FOREIGN KEY (rlfolio_id)
REFERENCES RLFOLIO (rlfolio_id) 
go

print 'Creating constraint fk_rolfolio_role on table ROLFOLIO'


--METADATA NAME:fk_rolfolio_role TYPE:CONSTRAINT TABLE_NAME:ROLFOLIO CHANGE:CREATE
ALTER TABLE ROLFOLIO
ADD CONSTRAINT fk_rolfolio_role FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
go

print 'Creating constraint fk_rpt_project on table RPT'


--METADATA NAME:fk_rpt_project TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_rpt_rptgroup on table RPT'


--METADATA NAME:fk_rpt_rptgroup TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_rptgroup FOREIGN KEY (rpt_group_id)
REFERENCES RPTGROUP (rpt_group_id) 
go

print 'Creating constraint fk_rpt_users on table RPT'


--METADATA NAME:fk_rpt_users TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_rptbatch_project on table RPTBATCH'


--METADATA NAME:fk_rptbatch_project TYPE:CONSTRAINT TABLE_NAME:RPTBATCH CHANGE:CREATE
ALTER TABLE RPTBATCH
ADD CONSTRAINT fk_rptbatch_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_rptlist_rpt on table RPTLIST'


--METADATA NAME:fk_rptlist_rpt TYPE:CONSTRAINT TABLE_NAME:RPTLIST CHANGE:CREATE
ALTER TABLE RPTLIST
ADD CONSTRAINT fk_rptlist_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
go

print 'Creating constraint fk_rptlist_rptbatch on table RPTLIST'


--METADATA NAME:fk_rptlist_rptbatch TYPE:CONSTRAINT TABLE_NAME:RPTLIST CHANGE:CREATE
ALTER TABLE RPTLIST
ADD CONSTRAINT fk_rptlist_rptbatch FOREIGN KEY (rpt_batch_id)
REFERENCES RPTBATCH (rpt_batch_id) 
go

print 'Creating constraint fk_rsrc_calendar on table RSRC'


--METADATA NAME:fk_rsrc_calendar TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_calendar FOREIGN KEY (clndr_id)
REFERENCES CALENDAR (clndr_id) 
go

print 'Creating constraint fk_rsrc_currtype on table RSRC'


--METADATA NAME:fk_rsrc_currtype TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_currtype FOREIGN KEY (curr_id)
REFERENCES CURRTYPE (curr_id) 
go

print 'Creating constraint fk_rsrc_shift on table RSRC'


--METADATA NAME:fk_rsrc_shift TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_shift FOREIGN KEY (shift_id)
REFERENCES SHIFT (shift_id) 
go

print 'Creating constraint fk_rsrc_users on table RSRC'


--METADATA NAME:fk_rsrc_users TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_rsrc_roles on table RSRC'


--METADATA NAME:fk_rsrc_roles TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
go

print 'Creating constraint fk_rsrc_umeasure on table RSRC'


--METADATA NAME:fk_rsrc_umeasure TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_umeasure FOREIGN KEY (unit_id)
REFERENCES UMEASURE (unit_id) 
go

print 'Creating constraint fk_rsrc_pobs on table RSRC'


--METADATA NAME:fk_rsrc_pobs TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT fk_rsrc_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
go

print 'Creating constraint fk_rsrcandash_dashboard on table RSRCANDASH'


--METADATA NAME:fk_rsrcandash_dashboard TYPE:CONSTRAINT TABLE_NAME:RSRCANDASH CHANGE:CREATE
ALTER TABLE RSRCANDASH
ADD CONSTRAINT fk_rsrcandash_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_rsrcandash_rsrcanview on table RSRCANDASH'


--METADATA NAME:fk_rsrcandash_rsrcanview TYPE:CONSTRAINT TABLE_NAME:RSRCANDASH CHANGE:CREATE
ALTER TABLE RSRCANDASH
ADD CONSTRAINT fk_rsrcandash_rsrcanview FOREIGN KEY (rsrcan_view_id)
REFERENCES RSRCANVIEW (rsrcan_view_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_rsrcanview_users on table RSRCANVIEW'


--METADATA NAME:fk_rsrcanview_users TYPE:CONSTRAINT TABLE_NAME:RSRCANVIEW CHANGE:CREATE
ALTER TABLE RSRCANVIEW
ADD CONSTRAINT fk_rsrcanview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_rsrchour_nonwork on table RSRCHOUR'


--METADATA NAME:fk_rsrchour_nonwork TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT fk_rsrchour_nonwork FOREIGN KEY (nonwork_type_id)
REFERENCES NONWORK (nonwork_type_id) 
go

print 'Creating constraint fk_rsrchour_taskrsrc on table RSRCHOUR'


--METADATA NAME:fk_rsrchour_taskrsrc TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT fk_rsrchour_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id) 
go

print 'Creating constraint fk_rsrchour_timesht on table RSRCHOUR'


--METADATA NAME:fk_rsrchour_timesht TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT fk_rsrchour_timesht FOREIGN KEY (ts_id,rsrc_id)
REFERENCES TIMESHT (ts_id,rsrc_id) 
go

print 'Creating constraint fk_rsrchour_rsrc on table RSRCHOUR'


--METADATA NAME:fk_rsrchour_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT fk_rsrchour_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_rsrcprop_rsrc on table RSRCPROP'


--METADATA NAME:fk_rsrcprop_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCPROP CHANGE:CREATE
ALTER TABLE RSRCPROP
ADD CONSTRAINT fk_rsrcprop_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_rsrcrate_rsrc on table RSRCRATE'


--METADATA NAME:fk_rsrcrate_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCRATE CHANGE:CREATE
ALTER TABLE RSRCRATE
ADD CONSTRAINT fk_rsrcrate_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_rsrcrate_shiftper on table RSRCRATE'


--METADATA NAME:fk_rsrcrate_shiftper TYPE:CONSTRAINT TABLE_NAME:RSRCRATE CHANGE:CREATE
ALTER TABLE RSRCRATE
ADD CONSTRAINT fk_rsrcrate_shiftper FOREIGN KEY (shift_period_id)
REFERENCES SHIFTPER (shift_period_id) 
go

print 'Creating constraint fk_rsrcrcat_rcattype on table RSRCRCAT'


--METADATA NAME:fk_rsrcrcat_rcattype TYPE:CONSTRAINT TABLE_NAME:RSRCRCAT CHANGE:CREATE
ALTER TABLE RSRCRCAT
ADD CONSTRAINT fk_rsrcrcat_rcattype FOREIGN KEY (rsrc_catg_type_id)
REFERENCES RCATTYPE (rsrc_catg_type_id) 
go

print 'Creating constraint fk_rsrcrcat_rcatval on table RSRCRCAT'


--METADATA NAME:fk_rsrcrcat_rcatval TYPE:CONSTRAINT TABLE_NAME:RSRCRCAT CHANGE:CREATE
ALTER TABLE RSRCRCAT
ADD CONSTRAINT fk_rsrcrcat_rcatval FOREIGN KEY (rsrc_catg_id)
REFERENCES RCATVAL (rsrc_catg_id) 
go

print 'Creating constraint fk_rsrcrcat_rsrc on table RSRCRCAT'


--METADATA NAME:fk_rsrcrcat_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCRCAT CHANGE:CREATE
ALTER TABLE RSRCRCAT
ADD CONSTRAINT fk_rsrcrcat_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_rsrcrole_roles on table RSRCROLE'


--METADATA NAME:fk_rsrcrole_roles TYPE:CONSTRAINT TABLE_NAME:RSRCROLE CHANGE:CREATE
ALTER TABLE RSRCROLE
ADD CONSTRAINT fk_rsrcrole_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
go

print 'Creating constraint fk_rsrcrole_rsrc on table RSRCROLE'


--METADATA NAME:fk_rsrcrole_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCROLE CHANGE:CREATE
ALTER TABLE RSRCROLE
ADD CONSTRAINT fk_rsrcrole_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_rsrcsec_users on table RSRCSEC'


--METADATA NAME:fk_rsrcsec_users TYPE:CONSTRAINT TABLE_NAME:RSRCSEC CHANGE:CREATE
ALTER TABLE RSRCSEC
ADD CONSTRAINT fk_rsrcsec_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_rsrcsec_rsrc on table RSRCSEC'


--METADATA NAME:fk_rsrcsec_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCSEC CHANGE:CREATE
ALTER TABLE RSRCSEC
ADD CONSTRAINT fk_rsrcsec_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_rsrfolio_rfolio on table RSRFOLIO'


--METADATA NAME:fk_rsrfolio_rfolio TYPE:CONSTRAINT TABLE_NAME:RSRFOLIO CHANGE:CREATE
ALTER TABLE RSRFOLIO
ADD CONSTRAINT fk_rsrfolio_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
go

print 'Creating constraint fk_rsrfolio_rsrc on table RSRFOLIO'


--METADATA NAME:fk_rsrfolio_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRFOLIO CHANGE:CREATE
ALTER TABLE RSRFOLIO
ADD CONSTRAINT fk_rsrfolio_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_scenario_users on table SCENARIO'


--METADATA NAME:fk_scenario_users TYPE:CONSTRAINT TABLE_NAME:SCENARIO CHANGE:CREATE
ALTER TABLE SCENARIO
ADD CONSTRAINT fk_scenario_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_scenario_viewpref on table SCENARIO'


--METADATA NAME:fk_scenario_viewpref TYPE:CONSTRAINT TABLE_NAME:SCENARIO CHANGE:CREATE
ALTER TABLE SCENARIO
ADD CONSTRAINT fk_scenario_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id) 
go

print 'Creating constraint fk_scenproj_project on table SCENPROJ'


--METADATA NAME:fk_scenproj_project TYPE:CONSTRAINT TABLE_NAME:SCENPROJ CHANGE:CREATE
ALTER TABLE SCENPROJ
ADD CONSTRAINT fk_scenproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_scenproj_scenario on table SCENPROJ'


--METADATA NAME:fk_scenproj_scenario TYPE:CONSTRAINT TABLE_NAME:SCENPROJ CHANGE:CREATE
ALTER TABLE SCENPROJ
ADD CONSTRAINT fk_scenproj_scenario FOREIGN KEY (scenario_id)
REFERENCES SCENARIO (scenario_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_scenrole_roles on table SCENROLE'


--METADATA NAME:fk_scenrole_roles TYPE:CONSTRAINT TABLE_NAME:SCENROLE CHANGE:CREATE
ALTER TABLE SCENROLE
ADD CONSTRAINT fk_scenrole_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_scenrole_scenario on table SCENROLE'


--METADATA NAME:fk_scenrole_scenario TYPE:CONSTRAINT TABLE_NAME:SCENROLE CHANGE:CREATE
ALTER TABLE SCENROLE
ADD CONSTRAINT fk_scenrole_scenario FOREIGN KEY (scenario_id)
REFERENCES SCENARIO (scenario_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_scenuser_users on table SCENUSER'


--METADATA NAME:fk_scenuser_users TYPE:CONSTRAINT TABLE_NAME:SCENUSER CHANGE:CREATE
ALTER TABLE SCENUSER
ADD CONSTRAINT fk_scenuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_scenuser_scenario on table SCENUSER'


--METADATA NAME:fk_scenuser_scenario TYPE:CONSTRAINT TABLE_NAME:SCENUSER CHANGE:CREATE
ALTER TABLE SCENUSER
ADD CONSTRAINT fk_scenuser_scenario FOREIGN KEY (scenario_id)
REFERENCES SCENARIO (scenario_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_shiftper_shift on table SHIFTPER'


--METADATA NAME:fk_shiftper_shift TYPE:CONSTRAINT TABLE_NAME:SHIFTPER CHANGE:CREATE
ALTER TABLE SHIFTPER
ADD CONSTRAINT fk_shiftper_shift FOREIGN KEY (shift_id)
REFERENCES SHIFT (shift_id) 
go

print 'Creating constraint fk_sumprojcost_project on table SUMPROJCOST'


--METADATA NAME:fk_sumprojcost_project TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumprojcost_projwbs on table SUMPROJCOST'


--METADATA NAME:fk_sumprojcost_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumprojcost_costtype on table SUMPROJCOST'


--METADATA NAME:fk_sumprojcost_costtype TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtask_project on table SUMTASK'


--METADATA NAME:fk_sumtask_project TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtask_projwbs on table SUMTASK'


--METADATA NAME:fk_sumtask_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtaskspread_project on table SUMTASKSPREAD'


--METADATA NAME:fk_sumtaskspread_project TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtaskspread_projwbs on table SUMTASKSPREAD'


--METADATA NAME:fk_sumtaskspread_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtrsrc_project on table SUMTRSRC'


--METADATA NAME:fk_sumtrsrc_project TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtrsrc_projwbs on table SUMTRSRC'


--METADATA NAME:fk_sumtrsrc_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_task_calendar on table TASK'


--METADATA NAME:fk_task_calendar TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_calendar FOREIGN KEY (clndr_id)
REFERENCES CALENDAR (clndr_id) 
go

print 'Creating constraint fk_task_rsrc on table TASK'


--METADATA NAME:fk_task_rsrc TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_task_project on table TASK'


--METADATA NAME:fk_task_project TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_task_projwbs on table TASK'


--METADATA NAME:fk_task_projwbs TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT fk_task_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_taskactv_actvcode on table TASKACTV'


--METADATA NAME:fk_taskactv_actvcode TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT fk_taskactv_actvcode FOREIGN KEY (actv_code_id)
REFERENCES ACTVCODE (actv_code_id) 
go

print 'Creating constraint fk_taskactv_actvtype on table TASKACTV'


--METADATA NAME:fk_taskactv_actvtype TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT fk_taskactv_actvtype FOREIGN KEY (actv_code_type_id)
REFERENCES ACTVTYPE (actv_code_type_id) 
go

print 'Creating constraint fk_taskactv_task on table TASKACTV'


--METADATA NAME:fk_taskactv_task TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT fk_taskactv_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskactv_project on table TASKACTV'


--METADATA NAME:fk_taskactv_project TYPE:CONSTRAINT TABLE_NAME:TASKACTV CHANGE:CREATE
ALTER TABLE TASKACTV
ADD CONSTRAINT fk_taskactv_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_taskdoc_document on table TASKDOC'


--METADATA NAME:fk_taskdoc_document TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT fk_taskdoc_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
go

print 'Creating constraint fk_taskdoc_projwbs on table TASKDOC'


--METADATA NAME:fk_taskdoc_projwbs TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT fk_taskdoc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_taskdoc_project on table TASKDOC'


--METADATA NAME:fk_taskdoc_project TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT fk_taskdoc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_taskdoc_task on table TASKDOC'


--METADATA NAME:fk_taskdoc_task TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT fk_taskdoc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskfdbk_project on table TASKFDBK'


--METADATA NAME:fk_taskfdbk_project TYPE:CONSTRAINT TABLE_NAME:TASKFDBK CHANGE:CREATE
ALTER TABLE TASKFDBK
ADD CONSTRAINT fk_taskfdbk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_taskfdbk_task on table TASKFDBK'


--METADATA NAME:fk_taskfdbk_task TYPE:CONSTRAINT TABLE_NAME:TASKFDBK CHANGE:CREATE
ALTER TABLE TASKFDBK
ADD CONSTRAINT fk_taskfdbk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskfin_project on table TASKFIN'


--METADATA NAME:fk_taskfin_project TYPE:CONSTRAINT TABLE_NAME:TASKFIN CHANGE:CREATE
ALTER TABLE TASKFIN
ADD CONSTRAINT fk_taskfin_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_taskfin_task on table TASKFIN'


--METADATA NAME:fk_taskfin_task TYPE:CONSTRAINT TABLE_NAME:TASKFIN CHANGE:CREATE
ALTER TABLE TASKFIN
ADD CONSTRAINT fk_taskfin_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_taskfin_findates on table TASKFIN'


--METADATA NAME:fk_taskfin_findates TYPE:CONSTRAINT TABLE_NAME:TASKFIN CHANGE:CREATE
ALTER TABLE TASKFIN
ADD CONSTRAINT fk_taskfin_findates FOREIGN KEY (fin_dates_id)
REFERENCES FINDATES (fin_dates_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_taskmemo_memotype on table TASKMEMO'


--METADATA NAME:fk_taskmemo_memotype TYPE:CONSTRAINT TABLE_NAME:TASKMEMO CHANGE:CREATE
ALTER TABLE TASKMEMO
ADD CONSTRAINT fk_taskmemo_memotype FOREIGN KEY (memo_type_id)
REFERENCES MEMOTYPE (memo_type_id) 
go

print 'Creating constraint fk_taskmemo_project on table TASKMEMO'


--METADATA NAME:fk_taskmemo_project TYPE:CONSTRAINT TABLE_NAME:TASKMEMO CHANGE:CREATE
ALTER TABLE TASKMEMO
ADD CONSTRAINT fk_taskmemo_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_taskmemo_task on table TASKMEMO'


--METADATA NAME:fk_taskmemo_task TYPE:CONSTRAINT TABLE_NAME:TASKMEMO CHANGE:CREATE
ALTER TABLE TASKMEMO
ADD CONSTRAINT fk_taskmemo_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_tasknote_project on table TASKNOTE'


--METADATA NAME:fk_tasknote_project TYPE:CONSTRAINT TABLE_NAME:TASKNOTE CHANGE:CREATE
ALTER TABLE TASKNOTE
ADD CONSTRAINT fk_tasknote_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_tasknote_task on table TASKNOTE'


--METADATA NAME:fk_tasknote_task TYPE:CONSTRAINT TABLE_NAME:TASKNOTE CHANGE:CREATE
ALTER TABLE TASKNOTE
ADD CONSTRAINT fk_tasknote_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskpred_project on table TASKPRED'


--METADATA NAME:fk_taskpred_project TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT fk_taskpred_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_taskpred_project_2 on table TASKPRED'


--METADATA NAME:fk_taskpred_project_2 TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT fk_taskpred_project_2 FOREIGN KEY (pred_proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_taskpred_task_2 on table TASKPRED'


--METADATA NAME:fk_taskpred_task_2 TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT fk_taskpred_task_2 FOREIGN KEY (pred_task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskpred_task on table TASKPRED'


--METADATA NAME:fk_taskpred_task TYPE:CONSTRAINT TABLE_NAME:TASKPRED CHANGE:CREATE
ALTER TABLE TASKPRED
ADD CONSTRAINT fk_taskpred_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskproc_project on table TASKPROC'


--METADATA NAME:fk_taskproc_project TYPE:CONSTRAINT TABLE_NAME:TASKPROC CHANGE:CREATE
ALTER TABLE TASKPROC
ADD CONSTRAINT fk_taskproc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_taskproc_task on table TASKPROC'


--METADATA NAME:fk_taskproc_task TYPE:CONSTRAINT TABLE_NAME:TASKPROC CHANGE:CREATE
ALTER TABLE TASKPROC
ADD CONSTRAINT fk_taskproc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_risk_riskid on table TASKRISK'


--METADATA NAME:fk_risk_riskid TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_riskid FOREIGN KEY (risk_id)
REFERENCES PROJRISK (risk_id) 
go

print 'Creating constraint fk_risk_task on table TASKRISK'


--METADATA NAME:fk_risk_task TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskrisk_project on table TASKRISK'


--METADATA NAME:fk_taskrisk_project TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_taskrisk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_taskrsrc_account on table TASKRSRC'


--METADATA NAME:fk_taskrsrc_account TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_account FOREIGN KEY (acct_id)
REFERENCES ACCOUNT (acct_id) 
go

print 'Creating constraint fk_taskrsrc_roles on table TASKRSRC'


--METADATA NAME:fk_taskrsrc_roles TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_roles FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
go

print 'Creating constraint fk_taskrsrc_rsrc on table TASKRSRC'


--METADATA NAME:fk_taskrsrc_rsrc TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_taskrsrc_project on table TASKRSRC'


--METADATA NAME:fk_taskrsrc_project TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_taskrsrc_task on table TASKRSRC'


--METADATA NAME:fk_taskrsrc_task TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskrsrc_rsrccurv on table TASKRSRC'


--METADATA NAME:fk_taskrsrc_rsrccurv TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_rsrccurv FOREIGN KEY (curv_id)
REFERENCES RSRCCURV (curv_id) 
go

print 'Creating constraint fk_taskrsrc_pobs on table TASKRSRC'


--METADATA NAME:fk_taskrsrc_pobs TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT fk_taskrsrc_pobs FOREIGN KEY (pobs_id)
REFERENCES POBS (pobs_id) 
go

print 'Creating constraint fk_taskuser_users on table TASKUSER'


--METADATA NAME:fk_taskuser_users TYPE:CONSTRAINT TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER
ADD CONSTRAINT fk_taskuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_taskuser_task on table TASKUSER'


--METADATA NAME:fk_taskuser_task TYPE:CONSTRAINT TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER
ADD CONSTRAINT fk_taskuser_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_taskuser_project on table TASKUSER'


--METADATA NAME:fk_taskuser_project TYPE:CONSTRAINT TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER
ADD CONSTRAINT fk_taskuser_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_taskwksp_workspace on table TASKWKSP'


--METADATA NAME:fk_taskwksp_workspace TYPE:CONSTRAINT TABLE_NAME:TASKWKSP CHANGE:CREATE
ALTER TABLE TASKWKSP
ADD CONSTRAINT fk_taskwksp_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
go

print 'Creating constraint fk_taskwksp_task on table TASKWKSP'


--METADATA NAME:fk_taskwksp_task TYPE:CONSTRAINT TABLE_NAME:TASKWKSP CHANGE:CREATE
ALTER TABLE TASKWKSP
ADD CONSTRAINT fk_taskwksp_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskwksp_project on table TASKWKSP'


--METADATA NAME:fk_taskwksp_project TYPE:CONSTRAINT TABLE_NAME:TASKWKSP CHANGE:CREATE
ALTER TABLE TASKWKSP
ADD CONSTRAINT fk_taskwksp_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_trakview_users on table TRAKVIEW'


--METADATA NAME:fk_trakview_users TYPE:CONSTRAINT TABLE_NAME:TRAKVIEW CHANGE:CREATE
ALTER TABLE TRAKVIEW
ADD CONSTRAINT fk_trakview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_trsrcfin_project on table TRSRCFIN'


--METADATA NAME:fk_trsrcfin_project TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT fk_trsrcfin_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_trsrcfin_task on table TRSRCFIN'


--METADATA NAME:fk_trsrcfin_task TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT fk_trsrcfin_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_trsrcfin_taskrsrc on table TRSRCFIN'


--METADATA NAME:fk_trsrcfin_taskrsrc TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT fk_trsrcfin_taskrsrc FOREIGN KEY (taskrsrc_id)
REFERENCES TASKRSRC (taskrsrc_id) 
go

print 'Creating constraint fk_trsrcfin_findates on table TRSRCFIN'


--METADATA NAME:fk_trsrcfin_findates TYPE:CONSTRAINT TABLE_NAME:TRSRCFIN CHANGE:CREATE
ALTER TABLE TRSRCFIN
ADD CONSTRAINT fk_trsrcfin_findates FOREIGN KEY (fin_dates_id)
REFERENCES FINDATES (fin_dates_id) 
go

print 'Creating constraint fk_tsdelegate_users on table TSDELEGATE'


--METADATA NAME:fk_tsdelegate_users TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_tsdelegate_users2 on table TSDELEGATE'


--METADATA NAME:fk_tsdelegate_users2 TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_users2 FOREIGN KEY (ts_delegate_user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_tsdelegate_project on table TSDELEGATE'


--METADATA NAME:fk_tsdelegate_project TYPE:CONSTRAINT TABLE_NAME:TSDELEGATE CHANGE:CREATE
ALTER TABLE TSDELEGATE
ADD CONSTRAINT fk_tsdelegate_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_uaccess_users on table UACCESS'


--METADATA NAME:fk_uaccess_users TYPE:CONSTRAINT TABLE_NAME:UACCESS CHANGE:CREATE
ALTER TABLE UACCESS
ADD CONSTRAINT fk_uaccess_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_udfcode_udftype on table UDFCODE'


--METADATA NAME:fk_udfcode_udftype TYPE:CONSTRAINT TABLE_NAME:UDFCODE CHANGE:CREATE
ALTER TABLE UDFCODE
ADD CONSTRAINT fk_udfcode_udftype FOREIGN KEY (udf_type_id)
REFERENCES UDFTYPE (udf_type_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_udfvalue_project on table UDFVALUE'


--METADATA NAME:fk_udfvalue_project TYPE:CONSTRAINT TABLE_NAME:UDFVALUE CHANGE:CREATE
ALTER TABLE UDFVALUE
ADD CONSTRAINT fk_udfvalue_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_udfvalue_udftype on table UDFVALUE'


--METADATA NAME:fk_udfvalue_udftype TYPE:CONSTRAINT TABLE_NAME:UDFVALUE CHANGE:CREATE
ALTER TABLE UDFVALUE
ADD CONSTRAINT fk_udfvalue_udftype FOREIGN KEY (udf_type_id)
REFERENCES UDFTYPE (udf_type_id) 
go

print 'Creating constraint fk_udfvalue_udfcode on table UDFVALUE'


--METADATA NAME:fk_udfvalue_udfcode TYPE:CONSTRAINT TABLE_NAME:UDFVALUE CHANGE:CREATE
ALTER TABLE UDFVALUE
ADD CONSTRAINT fk_udfvalue_udfcode FOREIGN KEY (udf_code_id)
REFERENCES UDFCODE (udf_code_id) 
go

print 'Creating constraint fk_uevntreg_users on table UEVNTREG'


--METADATA NAME:fk_uevntreg_users TYPE:CONSTRAINT TABLE_NAME:UEVNTREG CHANGE:CREATE
ALTER TABLE UEVNTREG
ADD CONSTRAINT fk_uevntreg_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_upklist_usession on table UPKLIST'


--METADATA NAME:fk_upklist_usession TYPE:CONSTRAINT TABLE_NAME:UPKLIST CHANGE:CREATE
ALTER TABLE UPKLIST
ADD CONSTRAINT fk_upklist_usession FOREIGN KEY (session_id)
REFERENCES USESSION (session_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_userdata_users on table USERDATA'


--METADATA NAME:fk_userdata_users TYPE:CONSTRAINT TABLE_NAME:USERDATA CHANGE:CREATE
ALTER TABLE USERDATA
ADD CONSTRAINT fk_userdata_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_usereng_users on table USERENG'


--METADATA NAME:fk_usereng_users TYPE:CONSTRAINT TABLE_NAME:USERENG CHANGE:CREATE
ALTER TABLE USERENG
ADD CONSTRAINT fk_usereng_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_userobs_obs on table USEROBS'


--METADATA NAME:fk_userobs_obs TYPE:CONSTRAINT TABLE_NAME:USEROBS CHANGE:CREATE
ALTER TABLE USEROBS
ADD CONSTRAINT fk_userobs_obs FOREIGN KEY (obs_id)
REFERENCES OBS (obs_id) 
go

print 'Creating constraint fk_userobs_users on table USEROBS'


--METADATA NAME:fk_userobs_users TYPE:CONSTRAINT TABLE_NAME:USEROBS CHANGE:CREATE
ALTER TABLE USEROBS
ADD CONSTRAINT fk_userobs_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_userobs_profile on table USEROBS'


--METADATA NAME:fk_userobs_profile TYPE:CONSTRAINT TABLE_NAME:USEROBS CHANGE:CREATE
ALTER TABLE USEROBS
ADD CONSTRAINT fk_userobs_profile FOREIGN KEY (prof_id)
REFERENCES PROFILE (prof_id) 
go

print 'Creating constraint fk_useropen_users on table USEROPEN'


--METADATA NAME:fk_useropen_users TYPE:CONSTRAINT TABLE_NAME:USEROPEN CHANGE:CREATE
ALTER TABLE USEROPEN
ADD CONSTRAINT fk_useropen_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_users_currtype on table USERS'


--METADATA NAME:fk_users_currtype TYPE:CONSTRAINT TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS
ADD CONSTRAINT fk_users_currtype FOREIGN KEY (curr_id)
REFERENCES CURRTYPE (curr_id) 
go

print 'Creating constraint fk_users_profile on table USERS'


--METADATA NAME:fk_users_profile TYPE:CONSTRAINT TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS
ADD CONSTRAINT fk_users_profile FOREIGN KEY (prof_id)
REFERENCES PROFILE (prof_id) 
go

print 'Creating constraint fk_userset_users on table USERSET'


--METADATA NAME:fk_userset_users TYPE:CONSTRAINT TABLE_NAME:USERSET CHANGE:CREATE
ALTER TABLE USERSET
ADD CONSTRAINT fk_userset_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_userwksp_users on table USERWKSP'


--METADATA NAME:fk_userwksp_users TYPE:CONSTRAINT TABLE_NAME:USERWKSP CHANGE:CREATE
ALTER TABLE USERWKSP
ADD CONSTRAINT fk_userwksp_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_userwksp_workspace on table USERWKSP'


--METADATA NAME:fk_userwksp_workspace TYPE:CONSTRAINT TABLE_NAME:USERWKSP CHANGE:CREATE
ALTER TABLE USERWKSP
ADD CONSTRAINT fk_userwksp_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
go

print 'Creating constraint fk_userwksp_project on table USERWKSP'


--METADATA NAME:fk_userwksp_project TYPE:CONSTRAINT TABLE_NAME:USERWKSP CHANGE:CREATE
ALTER TABLE USERWKSP
ADD CONSTRAINT fk_userwksp_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_user_acpt_consent_users on table USER_ACCEPTANCE_CONSENT'


--METADATA NAME:fk_user_acpt_consent_users TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT fk_user_acpt_consent_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_usession_users on table USESSION'


--METADATA NAME:fk_usession_users TYPE:CONSTRAINT TABLE_NAME:USESSION CHANGE:CREATE
ALTER TABLE USESSION
ADD CONSTRAINT fk_usession_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_usropnval_useropen on table USROPNVAL'


--METADATA NAME:fk_usropnval_useropen TYPE:CONSTRAINT TABLE_NAME:USROPNVAL CHANGE:CREATE
ALTER TABLE USROPNVAL
ADD CONSTRAINT fk_usropnval_useropen FOREIGN KEY (user_open_id)
REFERENCES USEROPEN (user_open_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_viewpref_users on table VIEWPREF'


--METADATA NAME:fk_viewpref_users TYPE:CONSTRAINT TABLE_NAME:VIEWPREF CHANGE:CREATE
ALTER TABLE VIEWPREF
ADD CONSTRAINT fk_viewpref_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_viewprop_users on table VIEWPROP'


--METADATA NAME:fk_viewprop_users TYPE:CONSTRAINT TABLE_NAME:VIEWPROP CHANGE:CREATE
ALTER TABLE VIEWPROP
ADD CONSTRAINT fk_viewprop_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_viewprop_project on table VIEWPROP'


--METADATA NAME:fk_viewprop_project TYPE:CONSTRAINT TABLE_NAME:VIEWPROP CHANGE:CREATE
ALTER TABLE VIEWPROP
ADD CONSTRAINT fk_viewprop_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_vwprefdash_dashboard on table VWPREFDASH'


--METADATA NAME:fk_vwprefdash_dashboard TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT fk_vwprefdash_dashboard FOREIGN KEY (dashboard_id)
REFERENCES DASHBOARD (dashboard_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_vwprefdash_viewpref on table VWPREFDASH'


--METADATA NAME:fk_vwprefdash_viewpref TYPE:CONSTRAINT TABLE_NAME:VWPREFDASH CHANGE:CREATE
ALTER TABLE VWPREFDASH
ADD CONSTRAINT fk_vwprefdash_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_vwprefdata_viewpref on table VWPREFDATA'


--METADATA NAME:fk_vwprefdata_viewpref TYPE:CONSTRAINT TABLE_NAME:VWPREFDATA CHANGE:CREATE
ALTER TABLE VWPREFDATA
ADD CONSTRAINT fk_vwprefdata_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_vwprefuser_viewpref on table VWPREFUSER'


--METADATA NAME:fk_vwprefuser_viewpref TYPE:CONSTRAINT TABLE_NAME:VWPREFUSER CHANGE:CREATE
ALTER TABLE VWPREFUSER
ADD CONSTRAINT fk_vwprefuser_viewpref FOREIGN KEY (view_pref_id)
REFERENCES VIEWPREF (view_pref_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_vwprefuser_users on table VWPREFUSER'


--METADATA NAME:fk_vwprefuser_users TYPE:CONSTRAINT TABLE_NAME:VWPREFUSER CHANGE:CREATE
ALTER TABLE VWPREFUSER
ADD CONSTRAINT fk_vwprefuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_wbsbudg_project on table WBSBUDG'


--METADATA NAME:fk_wbsbudg_project TYPE:CONSTRAINT TABLE_NAME:WBSBUDG CHANGE:CREATE
ALTER TABLE WBSBUDG
ADD CONSTRAINT fk_wbsbudg_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_wbsbudg_projwbs on table WBSBUDG'


--METADATA NAME:fk_wbsbudg_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSBUDG CHANGE:CREATE
ALTER TABLE WBSBUDG
ADD CONSTRAINT fk_wbsbudg_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_wbsmemo_memotype on table WBSMEMO'


--METADATA NAME:fk_wbsmemo_memotype TYPE:CONSTRAINT TABLE_NAME:WBSMEMO CHANGE:CREATE
ALTER TABLE WBSMEMO
ADD CONSTRAINT fk_wbsmemo_memotype FOREIGN KEY (memo_type_id)
REFERENCES MEMOTYPE (memo_type_id) 
go

print 'Creating constraint fk_wbsmemo_project on table WBSMEMO'


--METADATA NAME:fk_wbsmemo_project TYPE:CONSTRAINT TABLE_NAME:WBSMEMO CHANGE:CREATE
ALTER TABLE WBSMEMO
ADD CONSTRAINT fk_wbsmemo_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_wbsmemo_projwbs on table WBSMEMO'


--METADATA NAME:fk_wbsmemo_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSMEMO CHANGE:CREATE
ALTER TABLE WBSMEMO
ADD CONSTRAINT fk_wbsmemo_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_wbsrsrc_project on table WBSRSRC'


--METADATA NAME:fk_wbsrsrc_project TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_wbsrsrc_projwbs on table WBSRSRC'


--METADATA NAME:fk_wbsrsrc_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_wbsrsrc_rsrc on table WBSRSRC'


--METADATA NAME:fk_wbsrsrc_rsrc TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go

print 'Creating constraint fk_wbsrsrc_role on table WBSRSRC'


--METADATA NAME:fk_wbsrsrc_role TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_role FOREIGN KEY (role_id)
REFERENCES ROLES (role_id) 
go

print 'Creating constraint fk_wbsrsrc_wbrscat on table WBSRSRC'


--METADATA NAME:fk_wbsrsrc_wbrscat TYPE:CONSTRAINT TABLE_NAME:WBSRSRC CHANGE:CREATE
ALTER TABLE WBSRSRC
ADD CONSTRAINT fk_wbsrsrc_wbrscat FOREIGN KEY (wbrs_cat_id)
REFERENCES WBRSCAT (wbrs_cat_id) 
go

print 'Creating constraint fk_wbsrsrc_qty_wbsrsrc on table WBSRSRC_QTY'


--METADATA NAME:fk_wbsrsrc_qty_wbsrsrc TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_wbsrsrc FOREIGN KEY (wbsrsrc_id)
REFERENCES WBSRSRC (wbsrsrc_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_wbsrsrc_qty_findates1 on table WBSRSRC_QTY'


--METADATA NAME:fk_wbsrsrc_qty_findates1 TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_findates1 FOREIGN KEY (fin_dates_id1)
REFERENCES FINDATES (fin_dates_id) 
go

print 'Creating constraint fk_wbsrsrc_qty_findates2 on table WBSRSRC_QTY'


--METADATA NAME:fk_wbsrsrc_qty_findates2 TYPE:CONSTRAINT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
ALTER TABLE WBSRSRC_QTY
ADD CONSTRAINT fk_wbsrsrc_qty_findates2 FOREIGN KEY (fin_dates_id2)
REFERENCES FINDATES (fin_dates_id) 
go

print 'Creating constraint fk_wbsstep_project on table WBSSTEP'


--METADATA NAME:fk_wbsstep_project TYPE:CONSTRAINT TABLE_NAME:WBSSTEP CHANGE:CREATE
ALTER TABLE WBSSTEP
ADD CONSTRAINT fk_wbsstep_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_wbsstep_projwbs on table WBSSTEP'


--METADATA NAME:fk_wbsstep_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSSTEP CHANGE:CREATE
ALTER TABLE WBSSTEP
ADD CONSTRAINT fk_wbsstep_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go

print 'Creating constraint fk_wkfltmpl_tmplcatg on table WKFLTMPL'


--METADATA NAME:fk_wkfltmpl_tmplcatg TYPE:CONSTRAINT TABLE_NAME:WKFLTMPL CHANGE:CREATE
ALTER TABLE WKFLTMPL
ADD CONSTRAINT fk_wkfltmpl_tmplcatg FOREIGN KEY (tmplcatg_catg_id)
REFERENCES TMPLCATG (tmplcatg_catg_id) 
go

print 'Creating constraint fk_wkfluser_workflow on table WKFLUSER'


--METADATA NAME:fk_wkfluser_workflow TYPE:CONSTRAINT TABLE_NAME:WKFLUSER CHANGE:CREATE
ALTER TABLE WKFLUSER
ADD CONSTRAINT fk_wkfluser_workflow FOREIGN KEY (work_flow_id)
REFERENCES WORKFLOW (work_flow_id) 
go

print 'Creating constraint ndx_wkfluser_users on table WKFLUSER'


--METADATA NAME:ndx_wkfluser_users TYPE:CONSTRAINT TABLE_NAME:WKFLUSER CHANGE:CREATE
ALTER TABLE WKFLUSER
ADD CONSTRAINT ndx_wkfluser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_workflow_project on table WORKFLOW'


--METADATA NAME:fk_workflow_project TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT fk_workflow_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint fk_workflow_users on table WORKFLOW'


--METADATA NAME:fk_workflow_users TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT fk_workflow_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_workflow_workspace on table WORKFLOW'


--METADATA NAME:fk_workflow_workspace TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT fk_workflow_workspace FOREIGN KEY (workspace_id)
REFERENCES WORKSPACE (workspace_id) 
go

print 'Creating constraint fk_workspace_project on table WORKSPACE'


--METADATA NAME:fk_workspace_project TYPE:CONSTRAINT TABLE_NAME:WORKSPACE CHANGE:CREATE
ALTER TABLE WORKSPACE
ADD CONSTRAINT fk_workspace_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go

print 'Creating constraint ck_calendar_default_flag on table CALENDAR'


--METADATA NAME:ck_calendar_default_flag TYPE:CONSTRAINT TABLE_NAME:CALENDAR CHANGE:CREATE
ALTER TABLE CALENDAR
ADD CONSTRAINT ck_calendar_default_flag CHECK (default_flag in ('Y', 'N'))
go

print 'Creating constraint ck_document_deliv_flag on table DOCUMENT'


--METADATA NAME:ck_document_deliv_flag TYPE:CONSTRAINT TABLE_NAME:DOCUMENT CHANGE:CREATE
ALTER TABLE DOCUMENT
ADD CONSTRAINT ck_document_deliv_flag CHECK (deliv_flag in ('Y', 'N'))
go

print 'Creating constraint ck_expproj_login_supplied_flag on table EXPPROJ'


--METADATA NAME:ck_expproj_login_supplied_flag TYPE:CONSTRAINT TABLE_NAME:EXPPROJ CHANGE:CREATE
ALTER TABLE EXPPROJ
ADD CONSTRAINT ck_expproj_login_supplied_flag CHECK (login_supplied_flag in ('Y', 'N'))
go

print 'Creating constraint ck_extapp_login_supply_flag on table EXTAPP'


--METADATA NAME:ck_extapp_login_supply_flag TYPE:CONSTRAINT TABLE_NAME:EXTAPP CHANGE:CREATE
ALTER TABLE EXTAPP
ADD CONSTRAINT ck_extapp_login_supply_flag CHECK (login_supply_flag in ('Y', 'N'))
go

print 'Creating constraint ck_jobsvc_audit_flag on table JOBSVC'


--METADATA NAME:ck_jobsvc_audit_flag TYPE:CONSTRAINT TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC
ADD CONSTRAINT ck_jobsvc_audit_flag CHECK (audit_flag in ('Y', 'N'))
go

print 'Creating constraint ck_memotype_eps_flag on table MEMOTYPE'


--METADATA NAME:ck_memotype_eps_flag TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT ck_memotype_eps_flag CHECK (eps_flag in ('Y', 'N'))
go

print 'Creating constraint ck_memotype_proj_flag on table MEMOTYPE'


--METADATA NAME:ck_memotype_proj_flag TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT ck_memotype_proj_flag CHECK (proj_flag in ('Y', 'N'))
go

print 'Creating constraint ck_memotype_task_flag on table MEMOTYPE'


--METADATA NAME:ck_memotype_task_flag TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT ck_memotype_task_flag CHECK (task_flag in ('Y', 'N'))
go

print 'Creating constraint ck_memotype_wbs_flag on table MEMOTYPE'


--METADATA NAME:ck_memotype_wbs_flag TYPE:CONSTRAINT TABLE_NAME:MEMOTYPE CHANGE:CREATE
ALTER TABLE MEMOTYPE
ADD CONSTRAINT ck_memotype_wbs_flag CHECK (wbs_flag in ('Y', 'N'))
go

print 'Creating constraint ck_pfolio_closed_flag on table PFOLIO'


--METADATA NAME:ck_pfolio_closed_flag TYPE:CONSTRAINT TABLE_NAME:PFOLIO CHANGE:CREATE
ALTER TABLE PFOLIO
ADD CONSTRAINT ck_pfolio_closed_flag CHECK (closed_proj_flag in ('Y', 'N'))
go

print 'Creating constraint ck_pfolio_whatif_flag on table PFOLIO'


--METADATA NAME:ck_pfolio_whatif_flag TYPE:CONSTRAINT TABLE_NAME:PFOLIO CHANGE:CREATE
ALTER TABLE PFOLIO
ADD CONSTRAINT ck_pfolio_whatif_flag CHECK (whatif_proj_flag in ('Y', 'N'))
go

print 'Creating constraint ck_prefer_complete_task_hrs on table PREFER'


--METADATA NAME:ck_prefer_complete_task_hrs TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_complete_task_hrs CHECK (complete_task_hrs_flag in ('Y', 'N'))
go

print 'Creating constraint ck_prefer_default_timesheet on table PREFER'


--METADATA NAME:ck_prefer_default_timesheet TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_default_timesheet CHECK (default_timesheet_flag in ('Y', 'N'))
go

print 'Creating constraint ck_prefer_ev_fix_cost_flag on table PREFER'


--METADATA NAME:ck_prefer_ev_fix_cost_flag TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_ev_fix_cost_flag CHECK (ev_fix_cost_flag in ('Y', 'N'))
go

print 'Creating constraint ck_prefer_future_ts_hrs_flag on table PREFER'


--METADATA NAME:ck_prefer_future_ts_hrs_flag TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_future_ts_hrs_flag CHECK (future_ts_hrs_flag in ('Y', 'N'))
go

print 'Creating constraint ck_prefer_notstart_task_hrs on table PREFER'


--METADATA NAME:ck_prefer_notstart_task_hrs TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_notstart_task_hrs CHECK (notstart_task_hrs_flag in ('Y', 'N'))
go

print 'Creating constraint ck_prefer_postend_task_hrs on table PREFER'


--METADATA NAME:ck_prefer_postend_task_hrs TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_postend_task_hrs CHECK (postend_task_hrs_flag in ('Y', 'N'))
go

print 'Creating constraint ck_prefer_prestart_task_hrs on table PREFER'


--METADATA NAME:ck_prefer_prestart_task_hrs TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_prestart_task_hrs CHECK (prestart_task_hrs_flag in ('Y', 'N'))
go

print 'Creating constraint ck_prefer_ts_daily_flag on table PREFER'


--METADATA NAME:ck_prefer_ts_daily_flag TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER
ADD CONSTRAINT ck_prefer_ts_daily_flag CHECK (ts_daily_flag in ('Y', 'N'))
go

print 'Creating constraint ck_profile_default_flag on table PROFILE'


--METADATA NAME:ck_profile_default_flag TYPE:CONSTRAINT TABLE_NAME:PROFILE CHANGE:CREATE
ALTER TABLE PROFILE
ADD CONSTRAINT ck_profile_default_flag CHECK (default_flag in ('Y', 'N'))
go

print 'Creating constraint ck_profile_superuser_flag on table PROFILE'


--METADATA NAME:ck_profile_superuser_flag TYPE:CONSTRAINT TABLE_NAME:PROFILE CHANGE:CREATE
ALTER TABLE PROFILE
ADD CONSTRAINT ck_profile_superuser_flag CHECK (superuser_flag in ('Y', 'N'))
go

print 'Creating constraint ck_profpriv_allow_flag on table PROFPRIV'


--METADATA NAME:ck_profpriv_allow_flag TYPE:CONSTRAINT TABLE_NAME:PROFPRIV CHANGE:CREATE
ALTER TABLE PROFPRIV
ADD CONSTRAINT ck_profpriv_allow_flag CHECK (allow_flag in ('Y', 'N'))
go

print 'Creating constraint ck_projcost_auto_compute_act on table PROJCOST'


--METADATA NAME:ck_projcost_auto_compute_act TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
ADD CONSTRAINT ck_projcost_auto_compute_act CHECK (auto_compute_act_flag in ('Y', 'N'))
go

print 'Creating constraint ck_project_allow_complete_flag on table PROJECT'


--METADATA NAME:ck_project_allow_complete_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_allow_complete_flag CHECK (allow_complete_flag in ('Y', 'N'))
go

print 'Creating constraint ck_project_batch_sum_flag on table PROJECT'


--METADATA NAME:ck_project_batch_sum_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_batch_sum_flag CHECK (batch_sum_flag in ('Y', 'N'))
go

print 'Creating constraint ck_project_chng_eff_cmp_pct on table PROJECT'


--METADATA NAME:ck_project_chng_eff_cmp_pct TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_chng_eff_cmp_pct CHECK (chng_eff_cmp_pct_flag in ('Y', 'N'))
go

print 'Creating constraint ck_project_project_flag on table PROJECT'


--METADATA NAME:ck_project_project_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_project_flag CHECK (project_flag in ('Y', 'N'))
go

print 'Creating constraint ck_proj_cost_qty_recalc_flag on table PROJECT'


--METADATA NAME:ck_proj_cost_qty_recalc_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_proj_cost_qty_recalc_flag CHECK (cost_qty_recalc_flag in ('Y', 'N'))
go

print 'Creating constraint ck_project_rsrc_self_add_flag on table PROJECT'


--METADATA NAME:ck_project_rsrc_self_add_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_rsrc_self_add_flag CHECK (rsrc_self_add_flag in ('Y', 'N'))
go

print 'Creating constraint ck_proj_rsrc_role_match_flag on table PROJECT'


--METADATA NAME:ck_proj_rsrc_role_match_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in ('Y', 'N'))
go

print 'Creating constraint ck_project_step_complete_flag on table PROJECT'


--METADATA NAME:ck_project_step_complete_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_step_complete_flag CHECK (step_complete_flag in ('Y', 'N'))
go

print 'Creating constraint ck_project_sum_only_flag on table PROJECT'


--METADATA NAME:ck_project_sum_only_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_sum_only_flag CHECK (sum_only_flag in ('Y', 'N'))
go

print 'Creating constraint ck_act_this_lnk_flag on table PROJECT'


--METADATA NAME:ck_act_this_lnk_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_act_this_lnk_flag CHECK (act_this_per_link_flag in ('Y', 'N'))
go

print 'Creating constraint ck_act_pct_link_flag on table PROJECT'


--METADATA NAME:ck_act_pct_link_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_act_pct_link_flag CHECK (act_pct_link_flag in ('Y', 'N'))
go

print 'Creating constraint ck_add_act_remain_flag on table PROJECT'


--METADATA NAME:ck_add_act_remain_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_add_act_remain_flag CHECK (add_act_remain_flag in ('Y', 'N'))
go

print 'Creating constraint ck_project_tsk_cd_prfx_flag on table PROJECT'


--METADATA NAME:ck_project_tsk_cd_prfx_flag TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
ADD CONSTRAINT ck_project_tsk_cd_prfx_flag CHECK (task_code_prefix_flag in ('Y', 'N'))
go

print 'Creating constraint ck_projest_applied_flag on table PROJEST'


--METADATA NAME:ck_projest_applied_flag TYPE:CONSTRAINT TABLE_NAME:PROJEST CHANGE:CREATE
ALTER TABLE PROJEST
ADD CONSTRAINT ck_projest_applied_flag CHECK (applied_flag in ('Y', 'N'))
go

print 'Creating constraint ck_projwbs_proj_node_flag on table PROJWBS'


--METADATA NAME:ck_projwbs_proj_node_flag TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT ck_projwbs_proj_node_flag CHECK (proj_node_flag in ('Y', 'N'))
go

print 'Creating constraint ck_projwbs_sum_data_flag on table PROJWBS'


--METADATA NAME:ck_projwbs_sum_data_flag TYPE:CONSTRAINT TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS
ADD CONSTRAINT ck_projwbs_sum_data_flag CHECK (sum_data_flag in ('Y', 'N'))
go

print 'Creating constraint ck_rpt_global_flag on table RPT'


--METADATA NAME:ck_rpt_global_flag TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT ck_rpt_global_flag CHECK (global_flag in ('Y', 'N'))
go

print 'Creating constraint ck_rsrc_active_flag on table RSRC'


--METADATA NAME:ck_rsrc_active_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_active_flag CHECK (active_flag in ('Y', 'N'))
go

print 'Creating constraint ck_rsrc_auto_compute_act_flag on table RSRC'


--METADATA NAME:ck_rsrc_auto_compute_act_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_auto_compute_act_flag CHECK (auto_compute_act_flag in ('Y', 'N'))
go

print 'Creating constraint ck_rsrc_ot_flag on table RSRC'


--METADATA NAME:ck_rsrc_ot_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_ot_flag CHECK (ot_flag in ('Y', 'N'))
go

print 'Creating constraint ck_rsrc_timesheet_flag on table RSRC'


--METADATA NAME:ck_rsrc_timesheet_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_timesheet_flag CHECK (timesheet_flag in ('Y', 'N'))
go

print 'Creating constraint ck_rsrc_def_cost_qty_flag on table RSRC'


--METADATA NAME:ck_rsrc_def_cost_qty_flag TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
ADD CONSTRAINT ck_rsrc_def_cost_qty_flag CHECK (def_cost_qty_link_flag in ('Y', 'N'))
go

print 'Creating constraint ck_rsrccurv_default_flag on table RSRCCURV'


--METADATA NAME:ck_rsrccurv_default_flag TYPE:CONSTRAINT TABLE_NAME:RSRCCURV CHANGE:CREATE
ALTER TABLE RSRCCURV
ADD CONSTRAINT ck_rsrccurv_default_flag CHECK (default_flag in ('Y', 'N'))
go

print 'Creating constraint ck_rsrchour_task_ts_flag on table RSRCHOUR'


--METADATA NAME:ck_rsrchour_task_ts_flag TYPE:CONSTRAINT TABLE_NAME:RSRCHOUR CHANGE:CREATE
ALTER TABLE RSRCHOUR
ADD CONSTRAINT ck_rsrchour_task_ts_flag CHECK (task_ts_flag in ('Y', 'N'))
go

print 'Creating constraint ck_task_auto_compute_act_flag on table TASK'


--METADATA NAME:ck_task_auto_compute_act_flag TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT ck_task_auto_compute_act_flag CHECK (auto_compute_act_flag in ('Y', 'N'))
go

print 'Creating constraint ck_task_rev_fdbk_flag on table TASK'


--METADATA NAME:ck_task_rev_fdbk_flag TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT ck_task_rev_fdbk_flag CHECK (rev_fdbk_flag in ('Y', 'N'))
go

print 'Creating constraint ck_task_lock_plan_flag on table TASK'


--METADATA NAME:ck_task_lock_plan_flag TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT ck_task_lock_plan_flag CHECK (lock_plan_flag in ('Y', 'N'))
go

print 'Creating constraint ck_driving_path_flag on table TASK'


--METADATA NAME:ck_driving_path_flag TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
ADD CONSTRAINT ck_driving_path_flag CHECK (driving_path_flag in ('Y', 'N'))
go

print 'Creating constraint ck_taskdoc_wp_flag on table TASKDOC'


--METADATA NAME:ck_taskdoc_wp_flag TYPE:CONSTRAINT TABLE_NAME:TASKDOC CHANGE:CREATE
ALTER TABLE TASKDOC
ADD CONSTRAINT ck_taskdoc_wp_flag CHECK (wp_flag in ('Y', 'N'))
go

print 'Creating constraint ck_taskproc_complete_flag on table TASKPROC'


--METADATA NAME:ck_taskproc_complete_flag TYPE:CONSTRAINT TABLE_NAME:TASKPROC CHANGE:CREATE
ALTER TABLE TASKPROC
ADD CONSTRAINT ck_taskproc_complete_flag CHECK (complete_flag in ('Y', 'N'))
go

print 'Creating constraint ck_taskrsrc_cost_qty_flag on table TASKRSRC'


--METADATA NAME:ck_taskrsrc_cost_qty_flag TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
ADD CONSTRAINT ck_taskrsrc_cost_qty_flag CHECK (cost_qty_link_flag in ('Y', 'N'))
go

print 'Creating constraint ck_thrsparm_rsrc_flag on table THRSPARM'


--METADATA NAME:ck_thrsparm_rsrc_flag TYPE:CONSTRAINT TABLE_NAME:THRSPARM CHANGE:CREATE
ALTER TABLE THRSPARM
ADD CONSTRAINT ck_thrsparm_rsrc_flag CHECK (rsrc_flag in ('Y', 'N'))
go

print 'Creating constraint ck_thrsparm_task_flag on table THRSPARM'


--METADATA NAME:ck_thrsparm_task_flag TYPE:CONSTRAINT TABLE_NAME:THRSPARM CHANGE:CREATE
ALTER TABLE THRSPARM
ADD CONSTRAINT ck_thrsparm_task_flag CHECK (task_flag in ('Y', 'N'))
go

print 'Creating constraint ck_thrsparm_wbs_flag on table THRSPARM'


--METADATA NAME:ck_thrsparm_wbs_flag TYPE:CONSTRAINT TABLE_NAME:THRSPARM CHANGE:CREATE
ALTER TABLE THRSPARM
ADD CONSTRAINT ck_thrsparm_wbs_flag CHECK (wbs_flag in ('Y', 'N'))
go

print 'Creating constraint ck_timesht_daily_flag on table TIMESHT'


--METADATA NAME:ck_timesht_daily_flag TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:CREATE
ALTER TABLE TIMESHT
ADD CONSTRAINT ck_timesht_daily_flag CHECK (daily_flag in ('Y', 'N'))
go

print 'Creating constraint ck_trakview_web_view_flag on table TRAKVIEW'


--METADATA NAME:ck_trakview_web_view_flag TYPE:CONSTRAINT TABLE_NAME:TRAKVIEW CHANGE:CREATE
ALTER TABLE TRAKVIEW
ADD CONSTRAINT ck_trakview_web_view_flag CHECK (web_view_flag in ('Y', 'N'))
go

print 'Creating constraint ck_users_global_flag on table USERS'


--METADATA NAME:ck_users_global_flag TYPE:CONSTRAINT TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS
ADD CONSTRAINT ck_users_global_flag CHECK (global_flag in ('Y', 'N'))
go

print 'Creating constraint ck_wbsstep_complete_flag on table WBSSTEP'


--METADATA NAME:ck_wbsstep_complete_flag TYPE:CONSTRAINT TABLE_NAME:WBSSTEP CHANGE:CREATE
ALTER TABLE WBSSTEP
ADD CONSTRAINT ck_wbsstep_complete_flag CHECK (complete_flag in ('Y', 'N'))
go

print 'Creating constraint ck_workflow_existing_proj_flag on table WORKFLOW'


--METADATA NAME:ck_workflow_existing_proj_flag TYPE:CONSTRAINT TABLE_NAME:WORKFLOW CHANGE:CREATE
ALTER TABLE WORKFLOW
ADD CONSTRAINT ck_workflow_existing_proj_flag CHECK (existing_project_flag in ('Y', 'N'))
go

print 'Creating index ndx_account_parent_acct on table ACCOUNT'

--METADATA NAME:ndx_account_parent_acct TYPE:INDEX TABLE_NAME:ACCOUNT CHANGE:CREATE
CREATE  INDEX ndx_account_parent_acct
ON ACCOUNT (parent_acct_id)
go

print 'Creating index ndx_account_dsi on table ACCOUNT'

--METADATA NAME:ndx_account_dsi TYPE:INDEX TABLE_NAME:ACCOUNT CHANGE:CREATE
CREATE  INDEX ndx_account_dsi
ON ACCOUNT (delete_session_id,delete_date)
go

print 'Creating index ndx_account_upd on table ACCOUNT'

--METADATA NAME:ndx_account_upd TYPE:INDEX TABLE_NAME:ACCOUNT CHANGE:CREATE
CREATE  INDEX ndx_account_upd
ON ACCOUNT (update_date,delete_session_id)
go

print 'Creating index ndx_actvcode_1 on table ACTVCODE'

--METADATA NAME:ndx_actvcode_1 TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE  INDEX ndx_actvcode_1
ON ACTVCODE (actv_code_type_id)
go

print 'Creating index ndx_actvcode_parent_actv on table ACTVCODE'

--METADATA NAME:ndx_actvcode_parent_actv TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE  INDEX ndx_actvcode_parent_actv
ON ACTVCODE (parent_actv_code_id)
go

print 'Creating index ndx_actvcode_update_date1 on table ACTVCODE'

--METADATA NAME:ndx_actvcode_update_date1 TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE  INDEX ndx_actvcode_update_date1
ON ACTVCODE (update_date)
go

print 'Creating index ndx_actvcode_dsi on table ACTVCODE'

--METADATA NAME:ndx_actvcode_dsi TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE  INDEX ndx_actvcode_dsi
ON ACTVCODE (delete_session_id,delete_date)
go

print 'Creating index ndx_actvcode_upd on table ACTVCODE'

--METADATA NAME:ndx_actvcode_upd TYPE:INDEX TABLE_NAME:ACTVCODE CHANGE:CREATE
CREATE  INDEX ndx_actvcode_upd
ON ACTVCODE (update_date,delete_session_id)
go

print 'Creating index ndx_actvtype_1 on table ACTVTYPE'

--METADATA NAME:ndx_actvtype_1 TYPE:INDEX TABLE_NAME:ACTVTYPE CHANGE:CREATE
CREATE  INDEX ndx_actvtype_1
ON ACTVTYPE (proj_id)
go

print 'Creating index ndx_actvtype_dsi on table ACTVTYPE'

--METADATA NAME:ndx_actvtype_dsi TYPE:INDEX TABLE_NAME:ACTVTYPE CHANGE:CREATE
CREATE  INDEX ndx_actvtype_dsi
ON ACTVTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_actvtype_upd on table ACTVTYPE'

--METADATA NAME:ndx_actvtype_upd TYPE:INDEX TABLE_NAME:ACTVTYPE CHANGE:CREATE
CREATE  INDEX ndx_actvtype_upd
ON ACTVTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_admin_config_dsi on table ADMIN_CONFIG'

--METADATA NAME:ndx_admin_config_dsi TYPE:INDEX TABLE_NAME:ADMIN_CONFIG CHANGE:CREATE
CREATE  INDEX ndx_admin_config_dsi
ON ADMIN_CONFIG (delete_session_id,delete_date)
go

print 'Creating index ndx_admin_config_upd on table ADMIN_CONFIG'

--METADATA NAME:ndx_admin_config_upd TYPE:INDEX TABLE_NAME:ADMIN_CONFIG CHANGE:CREATE
CREATE  INDEX ndx_admin_config_upd
ON ADMIN_CONFIG (update_date,delete_session_id)
go

print 'Creating index ndx_asgnacat_asgnmntcattype on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnacat_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnacat_asgnmntcattype
ON ASGNMNTACAT (asgnmnt_catg_type_id)
go

print 'Creating index ndx_asgnmntacat_asgnmntcatval on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_asgnmntcatval TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_asgnmntcatval
ON ASGNMNTACAT (asgnmnt_catg_id)
go

print 'Creating index ndx_asgnmntacat_update_date1 on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_update_date1 TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_update_date1
ON ASGNMNTACAT (update_date)
go

print 'Creating index ndx_asgnmntacat_dsi on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_dsi TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_dsi
ON ASGNMNTACAT (delete_session_id,delete_date)
go

print 'Creating index ndx_asgnmntacat_upd on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_upd TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_upd
ON ASGNMNTACAT (update_date,delete_session_id)
go

print 'Creating index ndx_asgnmntacat_proj_id on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_proj_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_proj_id
ON ASGNMNTACAT (proj_id)
go

print 'Creating index ndx_asgnmntacat_taskrsrc_id on table ASGNMNTACAT'

--METADATA NAME:ndx_asgnmntacat_taskrsrc_id TYPE:INDEX TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
CREATE  INDEX ndx_asgnmntacat_taskrsrc_id
ON ASGNMNTACAT (taskrsrc_id)
go

print 'Creating index ndx_asgnmntcattype_dsi on table ASGNMNTCATTYPE'

--METADATA NAME:ndx_asgnmntcattype_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcattype_dsi
ON ASGNMNTCATTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_asgnmntcattype_upd on table ASGNMNTCATTYPE'

--METADATA NAME:ndx_asgnmntcattype_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcattype_upd
ON ASGNMNTCATTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_asgncatval_asgnmntcattype on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgncatval_asgnmntcattype TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgncatval_asgnmntcattype
ON ASGNMNTCATVAL (asgnmnt_catg_type_id)
go

print 'Creating index ndx_asgnmntcatval_parent_catg on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_parent_catg TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_parent_catg
ON ASGNMNTCATVAL (parent_asgnmnt_catg_id)
go

print 'Creating index ndx_asgnmntcatval_dsi on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_dsi TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_dsi
ON ASGNMNTCATVAL (delete_session_id,delete_date)
go

print 'Creating index ndx_asgnmntcatval_upd on table ASGNMNTCATVAL'

--METADATA NAME:ndx_asgnmntcatval_upd TYPE:INDEX TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
CREATE  INDEX ndx_asgnmntcatval_upd
ON ASGNMNTCATVAL (update_date,delete_session_id)
go

print 'Creating index ndx_basetype_dsi on table BASETYPE'

--METADATA NAME:ndx_basetype_dsi TYPE:INDEX TABLE_NAME:BASETYPE CHANGE:CREATE
CREATE  INDEX ndx_basetype_dsi
ON BASETYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_basetype_upd on table BASETYPE'

--METADATA NAME:ndx_basetype_upd TYPE:INDEX TABLE_NAME:BASETYPE CHANGE:CREATE
CREATE  INDEX ndx_basetype_upd
ON BASETYPE (update_date,delete_session_id)
go

print 'Creating index ndx_bgplog on table BGPLOG'

--METADATA NAME:ndx_bgplog TYPE:INDEX TABLE_NAME:BGPLOG CHANGE:CREATE
CREATE  INDEX ndx_bgplog
ON BGPLOG (log_time)
go

print 'Creating index ndx_bre_registry_dsi on table BRE_REGISTRY'

--METADATA NAME:ndx_bre_registry_dsi TYPE:INDEX TABLE_NAME:BRE_REGISTRY CHANGE:CREATE
CREATE  INDEX ndx_bre_registry_dsi
ON BRE_REGISTRY (delete_session_id,delete_date)
go

print 'Creating index ndx_budgchng_1 on table BUDGCHNG'

--METADATA NAME:ndx_budgchng_1 TYPE:INDEX TABLE_NAME:BUDGCHNG CHANGE:CREATE
CREATE  INDEX ndx_budgchng_1
ON BUDGCHNG (proj_id)
go

print 'Creating index ndx_budgchng_2 on table BUDGCHNG'

--METADATA NAME:ndx_budgchng_2 TYPE:INDEX TABLE_NAME:BUDGCHNG CHANGE:CREATE
CREATE  INDEX ndx_budgchng_2
ON BUDGCHNG (wbs_id)
go

print 'Creating index ndx_budgchng_dsi on table BUDGCHNG'

--METADATA NAME:ndx_budgchng_dsi TYPE:INDEX TABLE_NAME:BUDGCHNG CHANGE:CREATE
CREATE  INDEX ndx_budgchng_dsi
ON BUDGCHNG (delete_session_id,delete_date)
go

print 'Creating index ndx_calendar_1 on table CALENDAR'

--METADATA NAME:ndx_calendar_1 TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE
CREATE  INDEX ndx_calendar_1
ON CALENDAR (proj_id)
go

print 'Creating index ndx_calendar_dsi on table CALENDAR'

--METADATA NAME:ndx_calendar_dsi TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE
CREATE  INDEX ndx_calendar_dsi
ON CALENDAR (delete_session_id,delete_date)
go

print 'Creating index ndx_calendar_upd on table CALENDAR'

--METADATA NAME:ndx_calendar_upd TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE
CREATE  INDEX ndx_calendar_upd
ON CALENDAR (update_date,delete_session_id)
go

print 'Creating index ndx_costtype_dsi on table COSTTYPE'

--METADATA NAME:ndx_costtype_dsi TYPE:INDEX TABLE_NAME:COSTTYPE CHANGE:CREATE
CREATE  INDEX ndx_costtype_dsi
ON COSTTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_costtype_upd on table COSTTYPE'

--METADATA NAME:ndx_costtype_upd TYPE:INDEX TABLE_NAME:COSTTYPE CHANGE:CREATE
CREATE  INDEX ndx_costtype_upd
ON COSTTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_curr_short_name on table CURRTYPE'

--METADATA NAME:ndx_curr_short_name TYPE:INDEX TABLE_NAME:CURRTYPE CHANGE:CREATE
CREATE UNIQUE  INDEX ndx_curr_short_name
ON CURRTYPE (curr_short_name)
go

print 'Creating index ndx_currtype_dsi on table CURRTYPE'

--METADATA NAME:ndx_currtype_dsi TYPE:INDEX TABLE_NAME:CURRTYPE CHANGE:CREATE
CREATE  INDEX ndx_currtype_dsi
ON CURRTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_currtype_upd on table CURRTYPE'

--METADATA NAME:ndx_currtype_upd TYPE:INDEX TABLE_NAME:CURRTYPE CHANGE:CREATE
CREATE  INDEX ndx_currtype_upd
ON CURRTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_dashboard_1 on table DASHBOARD'

--METADATA NAME:ndx_dashboard_1 TYPE:INDEX TABLE_NAME:DASHBOARD CHANGE:CREATE
CREATE  INDEX ndx_dashboard_1
ON DASHBOARD (user_id)
go

print 'Creating index ndx_dashboard_dsi on table DASHBOARD'

--METADATA NAME:ndx_dashboard_dsi TYPE:INDEX TABLE_NAME:DASHBOARD CHANGE:CREATE
CREATE  INDEX ndx_dashboard_dsi
ON DASHBOARD (delete_session_id,delete_date)
go

print 'Creating index ndx_dashboard_upd on table DASHBOARD'

--METADATA NAME:ndx_dashboard_upd TYPE:INDEX TABLE_NAME:DASHBOARD CHANGE:CREATE
CREATE  INDEX ndx_dashboard_upd
ON DASHBOARD (update_date,delete_session_id)
go

print 'Creating index ndx_dashuser_1 on table DASHUSER'

--METADATA NAME:ndx_dashuser_1 TYPE:INDEX TABLE_NAME:DASHUSER CHANGE:CREATE
CREATE  INDEX ndx_dashuser_1
ON DASHUSER (user_id,dashboard_id)
go

print 'Creating index ndx_dashuser_dsi on table DASHUSER'

--METADATA NAME:ndx_dashuser_dsi TYPE:INDEX TABLE_NAME:DASHUSER CHANGE:CREATE
CREATE  INDEX ndx_dashuser_dsi
ON DASHUSER (delete_session_id,delete_date)
go

print 'Creating index ndx_dashuser_upd on table DASHUSER'

--METADATA NAME:ndx_dashuser_upd TYPE:INDEX TABLE_NAME:DASHUSER CHANGE:CREATE
CREATE  INDEX ndx_dashuser_upd
ON DASHUSER (update_date,delete_session_id)
go

print 'Creating index ndx_discussion_1 on table DISCUSSION'

--METADATA NAME:ndx_discussion_1 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_1
ON DISCUSSION (task_id,discussion_date)
go

print 'Creating index ndx_discussion_2 on table DISCUSSION'

--METADATA NAME:ndx_discussion_2 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_2
ON DISCUSSION (user_id,discussion_date)
go

print 'Creating index ndx_discussion_dsi on table DISCUSSION'

--METADATA NAME:ndx_discussion_dsi TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_dsi
ON DISCUSSION (delete_session_id,delete_date)
go

print 'Creating index ndx_discussion_read_dsi on table DISCUSSION_READ'

--METADATA NAME:ndx_discussion_read_dsi TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
CREATE  INDEX ndx_discussion_read_dsi
ON DISCUSSION_READ (delete_session_id,delete_date)
go

print 'Creating index ndx_dltacct_usession on table DLTACCT'

--METADATA NAME:ndx_dltacct_usession TYPE:INDEX TABLE_NAME:DLTACCT CHANGE:CREATE
CREATE  INDEX ndx_dltacct_usession
ON DLTACCT (session_id)
go

print 'Creating index ndx_dltactv_usession on table DLTACTV'

--METADATA NAME:ndx_dltactv_usession TYPE:INDEX TABLE_NAME:DLTACTV CHANGE:CREATE
CREATE  INDEX ndx_dltactv_usession
ON DLTACTV (session_id)
go

print 'Creating index ndx_dltobs_usession on table DLTOBS'

--METADATA NAME:ndx_dltobs_usession TYPE:INDEX TABLE_NAME:DLTOBS CHANGE:CREATE
CREATE  INDEX ndx_dltobs_usession
ON DLTOBS (session_id)
go

print 'Creating index ndx_dltrole_usession on table DLTROLE'

--METADATA NAME:ndx_dltrole_usession TYPE:INDEX TABLE_NAME:DLTROLE CHANGE:CREATE
CREATE  INDEX ndx_dltrole_usession
ON DLTROLE (session_id)
go

print 'Creating index ndx_dltrsrc_usession on table DLTRSRC'

--METADATA NAME:ndx_dltrsrc_usession TYPE:INDEX TABLE_NAME:DLTRSRC CHANGE:CREATE
CREATE  INDEX ndx_dltrsrc_usession
ON DLTRSRC (session_id)
go

print 'Creating index ndx_dltrsrl_usession on table DLTRSRL'

--METADATA NAME:ndx_dltrsrl_usession TYPE:INDEX TABLE_NAME:DLTRSRL CHANGE:CREATE
CREATE  INDEX ndx_dltrsrl_usession
ON DLTRSRL (session_id)
go

print 'Creating index ndx_dltuser_usession on table DLTUSER'

--METADATA NAME:ndx_dltuser_usession TYPE:INDEX TABLE_NAME:DLTUSER CHANGE:CREATE
CREATE  INDEX ndx_dltuser_usession
ON DLTUSER (session_id)
go

print 'Creating index ndx_doccatg_dsi on table DOCCATG'

--METADATA NAME:ndx_doccatg_dsi TYPE:INDEX TABLE_NAME:DOCCATG CHANGE:CREATE
CREATE  INDEX ndx_doccatg_dsi
ON DOCCATG (delete_session_id,delete_date)
go

print 'Creating index ndx_doccatg_upd on table DOCCATG'

--METADATA NAME:ndx_doccatg_upd TYPE:INDEX TABLE_NAME:DOCCATG CHANGE:CREATE
CREATE  INDEX ndx_doccatg_upd
ON DOCCATG (update_date,delete_session_id)
go

print 'Creating index ndx_docreview_document on table DOCREVIEW'

--METADATA NAME:ndx_docreview_document TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE  INDEX ndx_docreview_document
ON DOCREVIEW (doc_id)
go

print 'Creating index ndx_docreview_users on table DOCREVIEW'

--METADATA NAME:ndx_docreview_users TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE  INDEX ndx_docreview_users
ON DOCREVIEW (user_id)
go

print 'Creating index ndx_docreviewtask_docreview on table DOCREVIEWTASK'

--METADATA NAME:ndx_docreviewtask_docreview TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE  INDEX ndx_docreviewtask_docreview
ON DOCREVIEWTASK (doc_review_id)
go

print 'Creating index ndx_docreviewtask_users on table DOCREVIEWTASK'

--METADATA NAME:ndx_docreviewtask_users TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE  INDEX ndx_docreviewtask_users
ON DOCREVIEWTASK (user_id)
go

print 'Creating index ndx_docstat_dsi on table DOCSTAT'

--METADATA NAME:ndx_docstat_dsi TYPE:INDEX TABLE_NAME:DOCSTAT CHANGE:CREATE
CREATE  INDEX ndx_docstat_dsi
ON DOCSTAT (delete_session_id,delete_date)
go

print 'Creating index ndx_docstat_upd on table DOCSTAT'

--METADATA NAME:ndx_docstat_upd TYPE:INDEX TABLE_NAME:DOCSTAT CHANGE:CREATE
CREATE  INDEX ndx_docstat_upd
ON DOCSTAT (update_date,delete_session_id)
go

print 'Creating index ndx_document_1 on table DOCUMENT'

--METADATA NAME:ndx_document_1 TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE  INDEX ndx_document_1
ON DOCUMENT (proj_id)
go

print 'Creating index ndx_document_doccatg on table DOCUMENT'

--METADATA NAME:ndx_document_doccatg TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE  INDEX ndx_document_doccatg
ON DOCUMENT (doc_catg_id)
go

print 'Creating index ndx_document_docstat on table DOCUMENT'

--METADATA NAME:ndx_document_docstat TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE  INDEX ndx_document_docstat
ON DOCUMENT (doc_status_id)
go

print 'Creating index ndx_document_parent_doc on table DOCUMENT'

--METADATA NAME:ndx_document_parent_doc TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE  INDEX ndx_document_parent_doc
ON DOCUMENT (parent_doc_id)
go

print 'Creating index ndx_document_dsi on table DOCUMENT'

--METADATA NAME:ndx_document_dsi TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE  INDEX ndx_document_dsi
ON DOCUMENT (delete_session_id,delete_date)
go

print 'Creating index ndx_document_rsrc on table DOCUMENT'

--METADATA NAME:ndx_document_rsrc TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE  INDEX ndx_document_rsrc
ON DOCUMENT (rsrc_id)
go

print 'Creating index ndx_document_cr_external_key on table DOCUMENT'

--METADATA NAME:ndx_document_cr_external_key TYPE:INDEX TABLE_NAME:DOCUMENT CHANGE:CREATE
CREATE  INDEX ndx_document_cr_external_key
ON DOCUMENT (cr_external_doc_key)
go

print 'Creating index ndx_expproj_dsi on table EXPPROJ'

--METADATA NAME:ndx_expproj_dsi TYPE:INDEX TABLE_NAME:EXPPROJ CHANGE:CREATE
CREATE  INDEX ndx_expproj_dsi
ON EXPPROJ (delete_session_id,delete_date)
go

print 'Creating index ndx_expproj_upd on table EXPPROJ'

--METADATA NAME:ndx_expproj_upd TYPE:INDEX TABLE_NAME:EXPPROJ CHANGE:CREATE
CREATE  INDEX ndx_expproj_upd
ON EXPPROJ (update_date,delete_session_id)
go

print 'Creating index ndx_extapp_1 on table EXTAPP'

--METADATA NAME:ndx_extapp_1 TYPE:INDEX TABLE_NAME:EXTAPP CHANGE:CREATE
CREATE  INDEX ndx_extapp_1
ON EXTAPP (proj_id)
go

print 'Creating index ndx_extapp_dsi on table EXTAPP'

--METADATA NAME:ndx_extapp_dsi TYPE:INDEX TABLE_NAME:EXTAPP CHANGE:CREATE
CREATE  INDEX ndx_extapp_dsi
ON EXTAPP (delete_session_id,delete_date)
go

print 'Creating index ndx_extapp_upd on table EXTAPP'

--METADATA NAME:ndx_extapp_upd TYPE:INDEX TABLE_NAME:EXTAPP CHANGE:CREATE
CREATE  INDEX ndx_extapp_upd
ON EXTAPP (update_date,delete_session_id)
go

print 'Creating index ndx_factor_dsi on table FACTOR'

--METADATA NAME:ndx_factor_dsi TYPE:INDEX TABLE_NAME:FACTOR CHANGE:CREATE
CREATE  INDEX ndx_factor_dsi
ON FACTOR (delete_session_id,delete_date)
go

print 'Creating index ndx_factor_upd on table FACTOR'

--METADATA NAME:ndx_factor_upd TYPE:INDEX TABLE_NAME:FACTOR CHANGE:CREATE
CREATE  INDEX ndx_factor_upd
ON FACTOR (update_date,delete_session_id)
go

print 'Creating index ndx_factval_factor on table FACTVAL'

--METADATA NAME:ndx_factval_factor TYPE:INDEX TABLE_NAME:FACTVAL CHANGE:CREATE
CREATE  INDEX ndx_factval_factor
ON FACTVAL (fact_id)
go

print 'Creating index ndx_factval_dsi on table FACTVAL'

--METADATA NAME:ndx_factval_dsi TYPE:INDEX TABLE_NAME:FACTVAL CHANGE:CREATE
CREATE  INDEX ndx_factval_dsi
ON FACTVAL (delete_session_id,delete_date)
go

print 'Creating index ndx_factval_upd on table FACTVAL'

--METADATA NAME:ndx_factval_upd TYPE:INDEX TABLE_NAME:FACTVAL CHANGE:CREATE
CREATE  INDEX ndx_factval_upd
ON FACTVAL (update_date,delete_session_id)
go

print 'Creating index ndx_filtprop_1 on table FILTPROP'

--METADATA NAME:ndx_filtprop_1 TYPE:INDEX TABLE_NAME:FILTPROP CHANGE:CREATE
CREATE  INDEX ndx_filtprop_1
ON FILTPROP (user_id)
go

print 'Creating index ndx_filtprop_dsi on table FILTPROP'

--METADATA NAME:ndx_filtprop_dsi TYPE:INDEX TABLE_NAME:FILTPROP CHANGE:CREATE
CREATE  INDEX ndx_filtprop_dsi
ON FILTPROP (delete_session_id,delete_date)
go

print 'Creating index ndx_filtprop_upd on table FILTPROP'

--METADATA NAME:ndx_filtprop_upd TYPE:INDEX TABLE_NAME:FILTPROP CHANGE:CREATE
CREATE  INDEX ndx_filtprop_upd
ON FILTPROP (update_date,delete_session_id)
go

print 'Creating index ndx_findates_dsi on table FINDATES'

--METADATA NAME:ndx_findates_dsi TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE  INDEX ndx_findates_dsi
ON FINDATES (delete_session_id,delete_date)
go

print 'Creating index ndx_findates_upd on table FINDATES'

--METADATA NAME:ndx_findates_upd TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE  INDEX ndx_findates_upd
ON FINDATES (update_date,delete_session_id)
go

print 'Creating index ndx_findates_1 on table FINDATES'

--METADATA NAME:ndx_findates_1 TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE  INDEX ndx_findates_1
ON FINDATES (start_date,end_date)
go

print 'Creating index ndx_findates_fintmpl on table FINDATES'

--METADATA NAME:ndx_findates_fintmpl TYPE:INDEX TABLE_NAME:FINDATES CHANGE:CREATE
CREATE  INDEX ndx_findates_fintmpl
ON FINDATES (fintmpl_id)
go

print 'Creating index ndx_fintmpl_dsi on table FINTMPL'

--METADATA NAME:ndx_fintmpl_dsi TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE  INDEX ndx_fintmpl_dsi
ON FINTMPL (delete_session_id,delete_date)
go

print 'Creating index ndx_fintmpl_upd on table FINTMPL'

--METADATA NAME:ndx_fintmpl_upd TYPE:INDEX TABLE_NAME:FINTMPL CHANGE:CREATE
CREATE  INDEX ndx_fintmpl_upd
ON FINTMPL (update_date,delete_session_id)
go

print 'Creating index ndx_formcatg_dsi on table FORMCATG'

--METADATA NAME:ndx_formcatg_dsi TYPE:INDEX TABLE_NAME:FORMCATG CHANGE:CREATE
CREATE  INDEX ndx_formcatg_dsi
ON FORMCATG (delete_session_id,delete_date)
go

print 'Creating index ndx_formproj_formtmpl on table FORMPROJ'

--METADATA NAME:ndx_formproj_formtmpl TYPE:INDEX TABLE_NAME:FORMPROJ CHANGE:CREATE
CREATE  INDEX ndx_formproj_formtmpl
ON FORMPROJ (form_tmpl_id)
go

print 'Creating index ndx_formproj_project on table FORMPROJ'

--METADATA NAME:ndx_formproj_project TYPE:INDEX TABLE_NAME:FORMPROJ CHANGE:CREATE
CREATE  INDEX ndx_formproj_project
ON FORMPROJ (proj_id)
go

print 'Creating index ndx_formproj_dsi on table FORMPROJ'

--METADATA NAME:ndx_formproj_dsi TYPE:INDEX TABLE_NAME:FORMPROJ CHANGE:CREATE
CREATE  INDEX ndx_formproj_dsi
ON FORMPROJ (delete_session_id,delete_date)
go

print 'Creating index ndx_formtmpl_formcatg on table FORMTMPL'

--METADATA NAME:ndx_formtmpl_formcatg TYPE:INDEX TABLE_NAME:FORMTMPL CHANGE:CREATE
CREATE  INDEX ndx_formtmpl_formcatg
ON FORMTMPL (form_catg_id)
go

print 'Creating index ndx_formtmpl_dsi on table FORMTMPL'

--METADATA NAME:ndx_formtmpl_dsi TYPE:INDEX TABLE_NAME:FORMTMPL CHANGE:CREATE
CREATE  INDEX ndx_formtmpl_dsi
ON FORMTMPL (delete_session_id,delete_date)
go

print 'Creating index ndx_fundsrc_parent_fund on table FUNDSRC'

--METADATA NAME:ndx_fundsrc_parent_fund TYPE:INDEX TABLE_NAME:FUNDSRC CHANGE:CREATE
CREATE  INDEX ndx_fundsrc_parent_fund
ON FUNDSRC (parent_fund_id)
go

print 'Creating index ndx_fundsrc_dsi on table FUNDSRC'

--METADATA NAME:ndx_fundsrc_dsi TYPE:INDEX TABLE_NAME:FUNDSRC CHANGE:CREATE
CREATE  INDEX ndx_fundsrc_dsi
ON FUNDSRC (delete_session_id,delete_date)
go

print 'Creating index ndx_fundsrc_upd on table FUNDSRC'

--METADATA NAME:ndx_fundsrc_upd TYPE:INDEX TABLE_NAME:FUNDSRC CHANGE:CREATE
CREATE  INDEX ndx_fundsrc_upd
ON FUNDSRC (update_date,delete_session_id)
go

print 'Creating index ndx_gchange_user on table GCHANGE'

--METADATA NAME:ndx_gchange_user TYPE:INDEX TABLE_NAME:GCHANGE CHANGE:CREATE
CREATE  INDEX ndx_gchange_user
ON GCHANGE (user_id)
go

print 'Creating index ndx_gchange_dsi on table GCHANGE'

--METADATA NAME:ndx_gchange_dsi TYPE:INDEX TABLE_NAME:GCHANGE CHANGE:CREATE
CREATE  INDEX ndx_gchange_dsi
ON GCHANGE (delete_session_id,delete_date)
go

print 'Creating index ndx_gchange_upd on table GCHANGE'

--METADATA NAME:ndx_gchange_upd TYPE:INDEX TABLE_NAME:GCHANGE CHANGE:CREATE
CREATE  INDEX ndx_gchange_upd
ON GCHANGE (update_date,delete_session_id)
go

print 'Creating index ndx_imagedata_image_name on table IMAGEDATA'

--METADATA NAME:ndx_imagedata_image_name TYPE:INDEX TABLE_NAME:IMAGEDATA CHANGE:CREATE
CREATE UNIQUE  INDEX ndx_imagedata_image_name
ON IMAGEDATA (image_name)
go

print 'Creating index ndx_issuhist_1 on table ISSUHIST'

--METADATA NAME:ndx_issuhist_1 TYPE:INDEX TABLE_NAME:ISSUHIST CHANGE:CREATE
CREATE  INDEX ndx_issuhist_1
ON ISSUHIST (proj_id)
go

print 'Creating index ndx_issuhist_dsi on table ISSUHIST'

--METADATA NAME:ndx_issuhist_dsi TYPE:INDEX TABLE_NAME:ISSUHIST CHANGE:CREATE
CREATE  INDEX ndx_issuhist_dsi
ON ISSUHIST (delete_session_id,delete_date)
go

print 'Creating index ndx_iteration_release on table ITERATION'

--METADATA NAME:ndx_iteration_release TYPE:INDEX TABLE_NAME:ITERATION CHANGE:CREATE
CREATE  INDEX ndx_iteration_release
ON ITERATION (release_id)
go

print 'Creating index ndx_iteration_dsi on table ITERATION'

--METADATA NAME:ndx_iteration_dsi TYPE:INDEX TABLE_NAME:ITERATION CHANGE:CREATE
CREATE  INDEX ndx_iteration_dsi
ON ITERATION (delete_session_id,delete_date)
go

print 'Creating index ndx_iterdays_project on table ITERDAYS'

--METADATA NAME:ndx_iterdays_project TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:CREATE
CREATE  INDEX ndx_iterdays_project
ON ITERDAYS (proj_id)
go

print 'Creating index ndx_iterdays_iteration on table ITERDAYS'

--METADATA NAME:ndx_iterdays_iteration TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:CREATE
CREATE  INDEX ndx_iterdays_iteration
ON ITERDAYS (iteration_id)
go

print 'Creating index ndx_iterdays_task on table ITERDAYS'

--METADATA NAME:ndx_iterdays_task TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:CREATE
CREATE  INDEX ndx_iterdays_task
ON ITERDAYS (task_id)
go

print 'Creating index ndx_iterdays_dsi on table ITERDAYS'

--METADATA NAME:ndx_iterdays_dsi TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:CREATE
CREATE  INDEX ndx_iterdays_dsi
ON ITERDAYS (delete_session_id,delete_date)
go

print 'Creating index ndx_itergoal_iteration on table ITERGOAL'

--METADATA NAME:ndx_itergoal_iteration TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:CREATE
CREATE  INDEX ndx_itergoal_iteration
ON ITERGOAL (iteration_id)
go

print 'Creating index ndx_itergoal_rfolio on table ITERGOAL'

--METADATA NAME:ndx_itergoal_rfolio TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:CREATE
CREATE  INDEX ndx_itergoal_rfolio
ON ITERGOAL (rfolio_id)
go

print 'Creating index ndx_itergoal_dsi on table ITERGOAL'

--METADATA NAME:ndx_itergoal_dsi TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:CREATE
CREATE  INDEX ndx_itergoal_dsi
ON ITERGOAL (delete_session_id,delete_date)
go

print 'Creating index ndx_joblog_dsi on table JOBLOG'

--METADATA NAME:ndx_joblog_dsi TYPE:INDEX TABLE_NAME:JOBLOG CHANGE:CREATE
CREATE  INDEX ndx_joblog_dsi
ON JOBLOG (delete_session_id,delete_date)
go

print 'Creating index ndx_joblog_upd on table JOBLOG'

--METADATA NAME:ndx_joblog_upd TYPE:INDEX TABLE_NAME:JOBLOG CHANGE:CREATE
CREATE  INDEX ndx_joblog_upd
ON JOBLOG (update_date,delete_session_id)
go

print 'Creating index ndx_jobrpt_jobsvc on table JOBRPT'

--METADATA NAME:ndx_jobrpt_jobsvc TYPE:INDEX TABLE_NAME:JOBRPT CHANGE:CREATE
CREATE UNIQUE  INDEX ndx_jobrpt_jobsvc
ON JOBRPT (job_id)
go

print 'Creating index ndx_jobrpt_rpt on table JOBRPT'

--METADATA NAME:ndx_jobrpt_rpt TYPE:INDEX TABLE_NAME:JOBRPT CHANGE:CREATE
CREATE  INDEX ndx_jobrpt_rpt
ON JOBRPT (rpt_id)
go

print 'Creating index ndx_jobrpt_dsi on table JOBRPT'

--METADATA NAME:ndx_jobrpt_dsi TYPE:INDEX TABLE_NAME:JOBRPT CHANGE:CREATE
CREATE  INDEX ndx_jobrpt_dsi
ON JOBRPT (delete_session_id,delete_date)
go

print 'Creating index ndx_jobrpt_upd on table JOBRPT'

--METADATA NAME:ndx_jobrpt_upd TYPE:INDEX TABLE_NAME:JOBRPT CHANGE:CREATE
CREATE  INDEX ndx_jobrpt_upd
ON JOBRPT (update_date,delete_session_id)
go

print 'Creating index ndx_jobsvc_users on table JOBSVC'

--METADATA NAME:ndx_jobsvc_users TYPE:INDEX TABLE_NAME:JOBSVC CHANGE:CREATE
CREATE  INDEX ndx_jobsvc_users
ON JOBSVC (user_id)
go

print 'Creating index ndx_jobsvc_dsi on table JOBSVC'

--METADATA NAME:ndx_jobsvc_dsi TYPE:INDEX TABLE_NAME:JOBSVC CHANGE:CREATE
CREATE  INDEX ndx_jobsvc_dsi
ON JOBSVC (delete_session_id,delete_date)
go

print 'Creating index ndx_jobsvc_upd on table JOBSVC'

--METADATA NAME:ndx_jobsvc_upd TYPE:INDEX TABLE_NAME:JOBSVC CHANGE:CREATE
CREATE  INDEX ndx_jobsvc_upd
ON JOBSVC (update_date,delete_session_id)
go

print 'Creating index ndx_memotype_dsi on table MEMOTYPE'

--METADATA NAME:ndx_memotype_dsi TYPE:INDEX TABLE_NAME:MEMOTYPE CHANGE:CREATE
CREATE  INDEX ndx_memotype_dsi
ON MEMOTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_memotype_upd on table MEMOTYPE'

--METADATA NAME:ndx_memotype_upd TYPE:INDEX TABLE_NAME:MEMOTYPE CHANGE:CREATE
CREATE  INDEX ndx_memotype_upd
ON MEMOTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_nonwork_dsi on table NONWORK'

--METADATA NAME:ndx_nonwork_dsi TYPE:INDEX TABLE_NAME:NONWORK CHANGE:CREATE
CREATE  INDEX ndx_nonwork_dsi
ON NONWORK (delete_session_id,delete_date)
go

print 'Creating index ndx_nonwork_upd on table NONWORK'

--METADATA NAME:ndx_nonwork_upd TYPE:INDEX TABLE_NAME:NONWORK CHANGE:CREATE
CREATE  INDEX ndx_nonwork_upd
ON NONWORK (update_date,delete_session_id)
go

print 'Creating index ndx_note_dsi on table NOTE'

--METADATA NAME:ndx_note_dsi TYPE:INDEX TABLE_NAME:NOTE CHANGE:CREATE
CREATE  INDEX ndx_note_dsi
ON NOTE (delete_session_id,delete_date)
go

print 'Creating index ndx_note_upd on table NOTE'

--METADATA NAME:ndx_note_upd TYPE:INDEX TABLE_NAME:NOTE CHANGE:CREATE
CREATE  INDEX ndx_note_upd
ON NOTE (update_date,delete_session_id)
go

print 'Creating index ndx_obs_parent_obs on table OBS'

--METADATA NAME:ndx_obs_parent_obs TYPE:INDEX TABLE_NAME:OBS CHANGE:CREATE
CREATE  INDEX ndx_obs_parent_obs
ON OBS (parent_obs_id)
go

print 'Creating index ndx_obs_dsi on table OBS'

--METADATA NAME:ndx_obs_dsi TYPE:INDEX TABLE_NAME:OBS CHANGE:CREATE
CREATE  INDEX ndx_obs_dsi
ON OBS (delete_session_id,delete_date)
go

print 'Creating index ndx_obs_upd on table OBS'

--METADATA NAME:ndx_obs_upd TYPE:INDEX TABLE_NAME:OBS CHANGE:CREATE
CREATE  INDEX ndx_obs_upd
ON OBS (update_date,delete_session_id)
go

print 'Creating index ndx_obsproj_project on table OBSPROJ'

--METADATA NAME:ndx_obsproj_project TYPE:INDEX TABLE_NAME:OBSPROJ CHANGE:CREATE
CREATE  INDEX ndx_obsproj_project
ON OBSPROJ (proj_id,obs_id,wbs_id)
go

print 'Creating index ndx_obsproj_wbs on table OBSPROJ'

--METADATA NAME:ndx_obsproj_wbs TYPE:INDEX TABLE_NAME:OBSPROJ CHANGE:CREATE
CREATE  INDEX ndx_obsproj_wbs
ON OBSPROJ (wbs_id,proj_id,obs_id)
go

print 'Creating index ndx_pcattype_dsi on table PCATTYPE'

--METADATA NAME:ndx_pcattype_dsi TYPE:INDEX TABLE_NAME:PCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_pcattype_dsi
ON PCATTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_pcattype_upd on table PCATTYPE'

--METADATA NAME:ndx_pcattype_upd TYPE:INDEX TABLE_NAME:PCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_pcattype_upd
ON PCATTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_pcatuser_user on table PCATUSER'

--METADATA NAME:ndx_pcatuser_user TYPE:INDEX TABLE_NAME:PCATUSER CHANGE:CREATE
CREATE  INDEX ndx_pcatuser_user
ON PCATUSER (user_id)
go

print 'Creating index ndx_pcatuser_dsi on table PCATUSER'

--METADATA NAME:ndx_pcatuser_dsi TYPE:INDEX TABLE_NAME:PCATUSER CHANGE:CREATE
CREATE  INDEX ndx_pcatuser_dsi
ON PCATUSER (delete_session_id,delete_date)
go

print 'Creating index ndx_pcatuser_upd on table PCATUSER'

--METADATA NAME:ndx_pcatuser_upd TYPE:INDEX TABLE_NAME:PCATUSER CHANGE:CREATE
CREATE  INDEX ndx_pcatuser_upd
ON PCATUSER (update_date,delete_session_id)
go

print 'Creating index ndx_pcatval_pcattype on table PCATVAL'

--METADATA NAME:ndx_pcatval_pcattype TYPE:INDEX TABLE_NAME:PCATVAL CHANGE:CREATE
CREATE  INDEX ndx_pcatval_pcattype
ON PCATVAL (proj_catg_type_id)
go

print 'Creating index ndx_pcatval_parent_catg on table PCATVAL'

--METADATA NAME:ndx_pcatval_parent_catg TYPE:INDEX TABLE_NAME:PCATVAL CHANGE:CREATE
CREATE  INDEX ndx_pcatval_parent_catg
ON PCATVAL (parent_proj_catg_id)
go

print 'Creating index ndx_pcatval_dsi on table PCATVAL'

--METADATA NAME:ndx_pcatval_dsi TYPE:INDEX TABLE_NAME:PCATVAL CHANGE:CREATE
CREATE  INDEX ndx_pcatval_dsi
ON PCATVAL (delete_session_id,delete_date)
go

print 'Creating index ndx_pcatval_upd on table PCATVAL'

--METADATA NAME:ndx_pcatval_upd TYPE:INDEX TABLE_NAME:PCATVAL CHANGE:CREATE
CREATE  INDEX ndx_pcatval_upd
ON PCATVAL (update_date,delete_session_id)
go

print 'Creating index ndx_pfolio_1 on table PFOLIO'

--METADATA NAME:ndx_pfolio_1 TYPE:INDEX TABLE_NAME:PFOLIO CHANGE:CREATE
CREATE  INDEX ndx_pfolio_1
ON PFOLIO (user_id)
go

print 'Creating index ndx_pfolio_dsi on table PFOLIO'

--METADATA NAME:ndx_pfolio_dsi TYPE:INDEX TABLE_NAME:PFOLIO CHANGE:CREATE
CREATE  INDEX ndx_pfolio_dsi
ON PFOLIO (delete_session_id,delete_date)
go

print 'Creating index ndx_pfolio_upd on table PFOLIO'

--METADATA NAME:ndx_pfolio_upd TYPE:INDEX TABLE_NAME:PFOLIO CHANGE:CREATE
CREATE  INDEX ndx_pfolio_upd
ON PFOLIO (update_date,delete_session_id)
go

print 'Creating index ndx_phase_dsi on table PHASE'

--METADATA NAME:ndx_phase_dsi TYPE:INDEX TABLE_NAME:PHASE CHANGE:CREATE
CREATE  INDEX ndx_phase_dsi
ON PHASE (delete_session_id,delete_date)
go

print 'Creating index ndx_phase_upd on table PHASE'

--METADATA NAME:ndx_phase_upd TYPE:INDEX TABLE_NAME:PHASE CHANGE:CREATE
CREATE  INDEX ndx_phase_upd
ON PHASE (update_date,delete_session_id)
go

print 'Creating index ndx_pkxref_1 on table PKXREF'

--METADATA NAME:ndx_pkxref_1 TYPE:INDEX TABLE_NAME:PKXREF CHANGE:CREATE
CREATE  INDEX ndx_pkxref_1
ON PKXREF (system_id,context_name,pk1,pk2)
go

print 'Creating index ndx_pkxref_2 on table PKXREF'

--METADATA NAME:ndx_pkxref_2 TYPE:INDEX TABLE_NAME:PKXREF CHANGE:CREATE
CREATE  INDEX ndx_pkxref_2
ON PKXREF (system_id,context_name,old_pk1,old_pk2)
go

print 'Creating index ndx_pobs_parent_id on table POBS'

--METADATA NAME:ndx_pobs_parent_id TYPE:INDEX TABLE_NAME:POBS CHANGE:CREATE
CREATE  INDEX ndx_pobs_parent_id
ON POBS (pobs_parent_id)
go

print 'Creating index ndx_pobs_dsi on table POBS'

--METADATA NAME:ndx_pobs_dsi TYPE:INDEX TABLE_NAME:POBS CHANGE:CREATE
CREATE  INDEX ndx_pobs_dsi
ON POBS (delete_session_id,delete_date)
go

print 'Creating index ndx_pobs_upd on table POBS'

--METADATA NAME:ndx_pobs_upd TYPE:INDEX TABLE_NAME:POBS CHANGE:CREATE
CREATE  INDEX ndx_pobs_upd
ON POBS (update_date,delete_session_id)
go

print 'Creating index ndx_prefer_users on table PREFER'

--METADATA NAME:ndx_prefer_users TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE  INDEX ndx_prefer_users
ON PREFER (ts_approve_user_id)
go

print 'Creating index ndx_prefer_users2 on table PREFER'

--METADATA NAME:ndx_prefer_users2 TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE  INDEX ndx_prefer_users2
ON PREFER (projinit_admin_user_id)
go

print 'Creating index ndx_prefer_rsrc on table PREFER'

--METADATA NAME:ndx_prefer_rsrc TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE  INDEX ndx_prefer_rsrc
ON PREFER (default_rsrc_sec_id)
go

print 'Creating index ndx_prefer_dsi on table PREFER'

--METADATA NAME:ndx_prefer_dsi TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE  INDEX ndx_prefer_dsi
ON PREFER (delete_session_id,delete_date)
go

print 'Creating index ndx_prefer_upd on table PREFER'

--METADATA NAME:ndx_prefer_upd TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE
CREATE  INDEX ndx_prefer_upd
ON PREFER (update_date,delete_session_id)
go

print 'Creating index ndx_prmaudit_audit_date on table PRMAUDIT'

--METADATA NAME:ndx_prmaudit_audit_date TYPE:INDEX TABLE_NAME:PRMAUDIT CHANGE:CREATE
CREATE  INDEX ndx_prmaudit_audit_date
ON PRMAUDIT (audit_date)
go

print 'Creating index ndx_prmqueue_lookup on table PRMQUEUE'

--METADATA NAME:ndx_prmqueue_lookup TYPE:INDEX TABLE_NAME:PRMQUEUE CHANGE:CREATE
CREATE  INDEX ndx_prmqueue_lookup
ON PRMQUEUE (queue_name,msg_type,msg_sub_type)
go

print 'Creating index ndx_procgroup_dsi on table PROCGROUP'

--METADATA NAME:ndx_procgroup_dsi TYPE:INDEX TABLE_NAME:PROCGROUP CHANGE:CREATE
CREATE  INDEX ndx_procgroup_dsi
ON PROCGROUP (delete_session_id,delete_date)
go

print 'Creating index ndx_procgroup_upd on table PROCGROUP'

--METADATA NAME:ndx_procgroup_upd TYPE:INDEX TABLE_NAME:PROCGROUP CHANGE:CREATE
CREATE  INDEX ndx_procgroup_upd
ON PROCGROUP (update_date,delete_session_id)
go

print 'Creating index ndx_procitem on table PROCITEM'

--METADATA NAME:ndx_procitem TYPE:INDEX TABLE_NAME:PROCITEM CHANGE:CREATE
CREATE  INDEX ndx_procitem
ON PROCITEM (proc_group_id)
go

print 'Creating index ndx_procitem_dsi on table PROCITEM'

--METADATA NAME:ndx_procitem_dsi TYPE:INDEX TABLE_NAME:PROCITEM CHANGE:CREATE
CREATE  INDEX ndx_procitem_dsi
ON PROCITEM (delete_session_id,delete_date)
go

print 'Creating index ndx_procitem_upd on table PROCITEM'

--METADATA NAME:ndx_procitem_upd TYPE:INDEX TABLE_NAME:PROCITEM CHANGE:CREATE
CREATE  INDEX ndx_procitem_upd
ON PROCITEM (update_date,delete_session_id)
go

print 'Creating index ndx_profile_dsi on table PROFILE'

--METADATA NAME:ndx_profile_dsi TYPE:INDEX TABLE_NAME:PROFILE CHANGE:CREATE
CREATE  INDEX ndx_profile_dsi
ON PROFILE (delete_session_id,delete_date)
go

print 'Creating index ndx_profile_upd on table PROFILE'

--METADATA NAME:ndx_profile_upd TYPE:INDEX TABLE_NAME:PROFILE CHANGE:CREATE
CREATE  INDEX ndx_profile_upd
ON PROFILE (update_date,delete_session_id)
go

print 'Creating index ndx_profpriv_dsi on table PROFPRIV'

--METADATA NAME:ndx_profpriv_dsi TYPE:INDEX TABLE_NAME:PROFPRIV CHANGE:CREATE
CREATE  INDEX ndx_profpriv_dsi
ON PROFPRIV (delete_session_id,delete_date)
go

print 'Creating index ndx_profpriv_upd on table PROFPRIV'

--METADATA NAME:ndx_profpriv_upd TYPE:INDEX TABLE_NAME:PROFPRIV CHANGE:CREATE
CREATE  INDEX ndx_profpriv_upd
ON PROFPRIV (update_date,delete_session_id)
go

print 'Creating index ndx_projcost_1 on table PROJCOST'

--METADATA NAME:ndx_projcost_1 TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE  INDEX ndx_projcost_1
ON PROJCOST (proj_id)
go

print 'Creating index ndx_projcost_account on table PROJCOST'

--METADATA NAME:ndx_projcost_account TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE  INDEX ndx_projcost_account
ON PROJCOST (acct_id)
go

print 'Creating index ndx_projcost_costtype on table PROJCOST'

--METADATA NAME:ndx_projcost_costtype TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE  INDEX ndx_projcost_costtype
ON PROJCOST (cost_type_id)
go

print 'Creating index ndx_projcost_task on table PROJCOST'

--METADATA NAME:ndx_projcost_task TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE  INDEX ndx_projcost_task
ON PROJCOST (task_id)
go

print 'Creating index ndx_projcost_pobs on table PROJCOST'

--METADATA NAME:ndx_projcost_pobs TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE  INDEX ndx_projcost_pobs
ON PROJCOST (pobs_id)
go

print 'Creating index ndx_projcost_update_date1 on table PROJCOST'

--METADATA NAME:ndx_projcost_update_date1 TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE  INDEX ndx_projcost_update_date1
ON PROJCOST (update_date)
go

print 'Creating index ndx_projcost_dsi on table PROJCOST'

--METADATA NAME:ndx_projcost_dsi TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE
CREATE  INDEX ndx_projcost_dsi
ON PROJCOST (delete_session_id,delete_date)
go

print 'Creating index ndx_project_account on table PROJECT'

--METADATA NAME:ndx_project_account TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_account
ON PROJECT (acct_id)
go

print 'Creating index ndx_project_basetype on table PROJECT'

--METADATA NAME:ndx_project_basetype TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_basetype
ON PROJECT (base_type_id)
go

print 'Creating index ndx_project_orig_proj_id on table PROJECT'

--METADATA NAME:ndx_project_orig_proj_id TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_orig_proj_id
ON PROJECT (orig_proj_id)
go

print 'Creating index ndx_project_checkout_user_id on table PROJECT'

--METADATA NAME:ndx_project_checkout_user_id TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_checkout_user_id
ON PROJECT (checkout_user_id)
go

print 'Creating index ndx_project_update_date1 on table PROJECT'

--METADATA NAME:ndx_project_update_date1 TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_update_date1
ON PROJECT (update_date)
go

print 'Creating index ndx_project_source_proj_id on table PROJECT'

--METADATA NAME:ndx_project_source_proj_id TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_source_proj_id
ON PROJECT (source_proj_id)
go

print 'Creating index ndx_project_calendar on table PROJECT'

--METADATA NAME:ndx_project_calendar TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_calendar
ON PROJECT (clndr_id,delete_session_id)
go

print 'Creating index ndx_project_last_fin_dates on table PROJECT'

--METADATA NAME:ndx_project_last_fin_dates TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_last_fin_dates
ON PROJECT (last_fin_dates_id)
go

print 'Creating index ndx_project_matrix on table PROJECT'

--METADATA NAME:ndx_project_matrix TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_matrix
ON PROJECT (matrix_id)
go

print 'Creating index ndx_project_dsi on table PROJECT'

--METADATA NAME:ndx_project_dsi TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_dsi
ON PROJECT (delete_session_id,delete_date)
go

print 'Creating index ndx_project_upd on table PROJECT'

--METADATA NAME:ndx_project_upd TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_upd
ON PROJECT (update_date,delete_session_id)
go

print 'Creating index ndx_project_fintmpl on table PROJECT'

--METADATA NAME:ndx_project_fintmpl TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_fintmpl
ON PROJECT (fintmpl_id)
go

print 'Creating index ndx_projest_1 on table PROJEST'

--METADATA NAME:ndx_projest_1 TYPE:INDEX TABLE_NAME:PROJEST CHANGE:CREATE
CREATE  INDEX ndx_projest_1
ON PROJEST (proj_id)
go

print 'Creating index ndx_projest_projwbs on table PROJEST'

--METADATA NAME:ndx_projest_projwbs TYPE:INDEX TABLE_NAME:PROJEST CHANGE:CREATE
CREATE  INDEX ndx_projest_projwbs
ON PROJEST (wbs_id)
go

print 'Creating index ndx_projest_rsrc on table PROJEST'

--METADATA NAME:ndx_projest_rsrc TYPE:INDEX TABLE_NAME:PROJEST CHANGE:CREATE
CREATE  INDEX ndx_projest_rsrc
ON PROJEST (rsrc_id)
go

print 'Creating index ndx_projest_dsi on table PROJEST'

--METADATA NAME:ndx_projest_dsi TYPE:INDEX TABLE_NAME:PROJEST CHANGE:CREATE
CREATE  INDEX ndx_projest_dsi
ON PROJEST (delete_session_id,delete_date)
go

print 'Creating index ndx_projfund_1 on table PROJFUND'

--METADATA NAME:ndx_projfund_1 TYPE:INDEX TABLE_NAME:PROJFUND CHANGE:CREATE
CREATE  INDEX ndx_projfund_1
ON PROJFUND (proj_id)
go

print 'Creating index ndx_projfund_fundsrc on table PROJFUND'

--METADATA NAME:ndx_projfund_fundsrc TYPE:INDEX TABLE_NAME:PROJFUND CHANGE:CREATE
CREATE  INDEX ndx_projfund_fundsrc
ON PROJFUND (fund_id)
go

print 'Creating index ndx_projfund_dsi on table PROJFUND'

--METADATA NAME:ndx_projfund_dsi TYPE:INDEX TABLE_NAME:PROJFUND CHANGE:CREATE
CREATE  INDEX ndx_projfund_dsi
ON PROJFUND (delete_session_id,delete_date)
go

print 'Creating index ndx_projissu_1 on table PROJISSU'

--METADATA NAME:ndx_projissu_1 TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_1
ON PROJISSU (proj_id)
go

print 'Creating index ndx_projissu_obs on table PROJISSU'

--METADATA NAME:ndx_projissu_obs TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_obs
ON PROJISSU (obs_id)
go

print 'Creating index ndx_projissu_projthrs on table PROJISSU'

--METADATA NAME:ndx_projissu_projthrs TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_projthrs
ON PROJISSU (thresh_id)
go

print 'Creating index ndx_projissu_projwbs on table PROJISSU'

--METADATA NAME:ndx_projissu_projwbs TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_projwbs
ON PROJISSU (wbs_id)
go

print 'Creating index ndx_projissu_rsrc on table PROJISSU'

--METADATA NAME:ndx_projissu_rsrc TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_rsrc
ON PROJISSU (rsrc_id)
go

print 'Creating index ndx_projissu_task on table PROJISSU'

--METADATA NAME:ndx_projissu_task TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_task
ON PROJISSU (task_id)
go

print 'Creating index ndx_projissu_thrsparm on table PROJISSU'

--METADATA NAME:ndx_projissu_thrsparm TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_thrsparm
ON PROJISSU (thresh_parm_id)
go

print 'Creating index ndx_projissu_trakview on table PROJISSU'

--METADATA NAME:ndx_projissu_trakview TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_trakview
ON PROJISSU (track_view_id)
go

print 'Creating index ndx_projissu_workspace on table PROJISSU'

--METADATA NAME:ndx_projissu_workspace TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_workspace
ON PROJISSU (workspace_id)
go

print 'Creating index ndx_projissu_dsi on table PROJISSU'

--METADATA NAME:ndx_projissu_dsi TYPE:INDEX TABLE_NAME:PROJISSU CHANGE:CREATE
CREATE  INDEX ndx_projissu_dsi
ON PROJISSU (delete_session_id,delete_date)
go

print 'Creating index ndx_projpcat_pcattype on table PROJPCAT'

--METADATA NAME:ndx_projpcat_pcattype TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE  INDEX ndx_projpcat_pcattype
ON PROJPCAT (proj_catg_type_id)
go

print 'Creating index ndx_projpcat_pcatval on table PROJPCAT'

--METADATA NAME:ndx_projpcat_pcatval TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE  INDEX ndx_projpcat_pcatval
ON PROJPCAT (proj_catg_id)
go

print 'Creating index ndx_projpcat_update_date1 on table PROJPCAT'

--METADATA NAME:ndx_projpcat_update_date1 TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE  INDEX ndx_projpcat_update_date1
ON PROJPCAT (update_date)
go

print 'Creating index ndx_projpcat_dsi on table PROJPCAT'

--METADATA NAME:ndx_projpcat_dsi TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE  INDEX ndx_projpcat_dsi
ON PROJPCAT (delete_session_id,delete_date)
go

print 'Creating index ndx_projpcat_upd on table PROJPCAT'

--METADATA NAME:ndx_projpcat_upd TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE
CREATE  INDEX ndx_projpcat_upd
ON PROJPCAT (update_date,delete_session_id)
go

print 'Creating index ndx_projprop_dsi on table PROJPROP'

--METADATA NAME:ndx_projprop_dsi TYPE:INDEX TABLE_NAME:PROJPROP CHANGE:CREATE
CREATE  INDEX ndx_projprop_dsi
ON PROJPROP (delete_session_id,delete_date)
go

print 'Creating index ndx_projrisk_1 on table PROJRISK'

--METADATA NAME:ndx_projrisk_1 TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE
CREATE  INDEX ndx_projrisk_1
ON PROJRISK (proj_id)
go

print 'Creating index ndx_projrisk_risktype on table PROJRISK'

--METADATA NAME:ndx_projrisk_risktype TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE
CREATE  INDEX ndx_projrisk_risktype
ON PROJRISK (risk_type_id)
go

print 'Creating index ndx_projrisk_rsrc on table PROJRISK'

--METADATA NAME:ndx_projrisk_rsrc TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE
CREATE  INDEX ndx_projrisk_rsrc
ON PROJRISK (rsrc_id)
go

print 'Creating index ndx_projrisk_dsi on table PROJRISK'

--METADATA NAME:ndx_projrisk_dsi TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE
CREATE  INDEX ndx_projrisk_dsi
ON PROJRISK (delete_session_id,delete_date)
go

print 'Creating index ndx_projshar_usession on table PROJSHAR'

--METADATA NAME:ndx_projshar_usession TYPE:INDEX TABLE_NAME:PROJSHAR CHANGE:CREATE
CREATE  INDEX ndx_projshar_usession
ON PROJSHAR (session_id)
go

print 'Creating index ndx_projthrs_1 on table PROJTHRS'

--METADATA NAME:ndx_projthrs_1 TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE  INDEX ndx_projthrs_1
ON PROJTHRS (proj_id)
go

print 'Creating index ndx_projthrs_obs on table PROJTHRS'

--METADATA NAME:ndx_projthrs_obs TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE  INDEX ndx_projthrs_obs
ON PROJTHRS (obs_id)
go

print 'Creating index ndx_projthrs_projwbs on table PROJTHRS'

--METADATA NAME:ndx_projthrs_projwbs TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE  INDEX ndx_projthrs_projwbs
ON PROJTHRS (wbs_id)
go

print 'Creating index ndx_projthrs_thrsparm on table PROJTHRS'

--METADATA NAME:ndx_projthrs_thrsparm TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE  INDEX ndx_projthrs_thrsparm
ON PROJTHRS (thresh_parm_id)
go

print 'Creating index ndx_projthrs_trakview on table PROJTHRS'

--METADATA NAME:ndx_projthrs_trakview TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE  INDEX ndx_projthrs_trakview
ON PROJTHRS (track_view_id)
go

print 'Creating index ndx_projthrs_dsi on table PROJTHRS'

--METADATA NAME:ndx_projthrs_dsi TYPE:INDEX TABLE_NAME:PROJTHRS CHANGE:CREATE
CREATE  INDEX ndx_projthrs_dsi
ON PROJTHRS (delete_session_id,delete_date)
go

print 'Creating index ndx_projwbs_1 on table PROJWBS'

--METADATA NAME:ndx_projwbs_1 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_1
ON PROJWBS (proj_id)
go

print 'Creating index ndx_projwbs_obs on table PROJWBS'

--METADATA NAME:ndx_projwbs_obs TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_obs
ON PROJWBS (obs_id,proj_id,delete_session_id)
go

print 'Creating index ndx_projwbs_parent_wbs_id on table PROJWBS'

--METADATA NAME:ndx_projwbs_parent_wbs_id TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_parent_wbs_id
ON PROJWBS (parent_wbs_id)
go

print 'Creating index ndx_projwbs_phase on table PROJWBS'

--METADATA NAME:ndx_projwbs_phase TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_phase
ON PROJWBS (phase_id)
go

print 'Creating index ndx_projwbs_update_date1 on table PROJWBS'

--METADATA NAME:ndx_projwbs_update_date1 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_update_date1
ON PROJWBS (update_date)
go

print 'Creating index ndx_projwbs_rfolio_team on table PROJWBS'

--METADATA NAME:ndx_projwbs_rfolio_team TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_rfolio_team
ON PROJWBS (resp_team_id)
go

print 'Creating index ndx_projwbs_iteration on table PROJWBS'

--METADATA NAME:ndx_projwbs_iteration TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_iteration
ON PROJWBS (iteration_id)
go

print 'Creating index ndx_projwbs_perf1 on table PROJWBS'

--METADATA NAME:ndx_projwbs_perf1 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_perf1
ON PROJWBS (proj_node_flag,proj_id,wbs_id,parent_wbs_id,delete_session_id)
go

print 'Creating index ndx_projwbs_perf2 on table PROJWBS'

--METADATA NAME:ndx_projwbs_perf2 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_perf2
ON PROJWBS (proj_node_flag,obs_id,wbs_id,proj_id,parent_wbs_id,delete_session_id)
go

print 'Creating index ndx_projwbs_dsi on table PROJWBS'

--METADATA NAME:ndx_projwbs_dsi TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_dsi
ON PROJWBS (delete_session_id,delete_date)
go

print 'Creating index ndx_projwbs_upd on table PROJWBS'

--METADATA NAME:ndx_projwbs_upd TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE
CREATE  INDEX ndx_projwbs_upd
ON PROJWBS (update_date,delete_session_id)
go

print 'Creating index ndx_projwsrpt_dsi on table PROJWSRPT'

--METADATA NAME:ndx_projwsrpt_dsi TYPE:INDEX TABLE_NAME:PROJWSRPT CHANGE:CREATE
CREATE  INDEX ndx_projwsrpt_dsi
ON PROJWSRPT (delete_session_id,delete_date)
go

print 'Creating index ndx_projwsrpt_rpt on table PROJWSRPT'

--METADATA NAME:ndx_projwsrpt_rpt TYPE:INDEX TABLE_NAME:PROJWSRPT CHANGE:CREATE
CREATE  INDEX ndx_projwsrpt_rpt
ON PROJWSRPT (rpt_id)
go

print 'Creating index ndx_projwsrpt_project on table PROJWSRPT'

--METADATA NAME:ndx_projwsrpt_project TYPE:INDEX TABLE_NAME:PROJWSRPT CHANGE:CREATE
CREATE  INDEX ndx_projwsrpt_project
ON PROJWSRPT (proj_id)
go

print 'Creating index ndx_prpfolio_projwbs on table PRPFOLIO'

--METADATA NAME:ndx_prpfolio_projwbs TYPE:INDEX TABLE_NAME:PRPFOLIO CHANGE:CREATE
CREATE  INDEX ndx_prpfolio_projwbs
ON PRPFOLIO (wbs_id)
go

print 'Creating index ndx_prpfolio_dsi on table PRPFOLIO'

--METADATA NAME:ndx_prpfolio_dsi TYPE:INDEX TABLE_NAME:PRPFOLIO CHANGE:CREATE
CREATE  INDEX ndx_prpfolio_dsi
ON PRPFOLIO (delete_session_id,delete_date)
go

print 'Creating index ndx_prpfolio_upd on table PRPFOLIO'

--METADATA NAME:ndx_prpfolio_upd TYPE:INDEX TABLE_NAME:PRPFOLIO CHANGE:CREATE
CREATE  INDEX ndx_prpfolio_upd
ON PRPFOLIO (update_date,delete_session_id)
go

print 'Creating index ndx_querylib_dsi on table QUERYLIB'

--METADATA NAME:ndx_querylib_dsi TYPE:INDEX TABLE_NAME:QUERYLIB CHANGE:CREATE
CREATE  INDEX ndx_querylib_dsi
ON QUERYLIB (delete_session_id,delete_date)
go

print 'Creating index ndx_rcattype_dsi on table RCATTYPE'

--METADATA NAME:ndx_rcattype_dsi TYPE:INDEX TABLE_NAME:RCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_rcattype_dsi
ON RCATTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_rcattype_upd on table RCATTYPE'

--METADATA NAME:ndx_rcattype_upd TYPE:INDEX TABLE_NAME:RCATTYPE CHANGE:CREATE
CREATE  INDEX ndx_rcattype_upd
ON RCATTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_rcatval_rcattype on table RCATVAL'

--METADATA NAME:ndx_rcatval_rcattype TYPE:INDEX TABLE_NAME:RCATVAL CHANGE:CREATE
CREATE  INDEX ndx_rcatval_rcattype
ON RCATVAL (rsrc_catg_type_id)
go

print 'Creating index ndx_rcatval_parent_catg on table RCATVAL'

--METADATA NAME:ndx_rcatval_parent_catg TYPE:INDEX TABLE_NAME:RCATVAL CHANGE:CREATE
CREATE  INDEX ndx_rcatval_parent_catg
ON RCATVAL (parent_rsrc_catg_id)
go

print 'Creating index ndx_rcatval_dsi on table RCATVAL'

--METADATA NAME:ndx_rcatval_dsi TYPE:INDEX TABLE_NAME:RCATVAL CHANGE:CREATE
CREATE  INDEX ndx_rcatval_dsi
ON RCATVAL (delete_session_id,delete_date)
go

print 'Creating index ndx_rcatval_upd on table RCATVAL'

--METADATA NAME:ndx_rcatval_upd TYPE:INDEX TABLE_NAME:RCATVAL CHANGE:CREATE
CREATE  INDEX ndx_rcatval_upd
ON RCATVAL (update_date,delete_session_id)
go

print 'Creating index ndx_refrdel_delete_date on table REFRDEL'

--METADATA NAME:ndx_refrdel_delete_date TYPE:INDEX TABLE_NAME:REFRDEL CHANGE:CREATE
CREATE  INDEX ndx_refrdel_delete_date
ON REFRDEL (delete_date)
go

print 'Creating index ndx_refrdel_table_pk on table REFRDEL'

--METADATA NAME:ndx_refrdel_table_pk TYPE:INDEX TABLE_NAME:REFRDEL CHANGE:CREATE
CREATE  INDEX ndx_refrdel_table_pk
ON REFRDEL (table_name,pk1,pk2)
go

print 'Creating index ndx_reittype_dsi on table REITTYPE'

--METADATA NAME:ndx_reittype_dsi TYPE:INDEX TABLE_NAME:REITTYPE CHANGE:CREATE
CREATE  INDEX ndx_reittype_dsi
ON REITTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_release_rfolio on table RELEASE'

--METADATA NAME:ndx_release_rfolio TYPE:INDEX TABLE_NAME:RELEASE CHANGE:CREATE
CREATE  INDEX ndx_release_rfolio
ON RELEASE (rfolio_id)
go

print 'Creating index ndx_release_project on table RELEASE'

--METADATA NAME:ndx_release_project TYPE:INDEX TABLE_NAME:RELEASE CHANGE:CREATE
CREATE  INDEX ndx_release_project
ON RELEASE (proj_id)
go

print 'Creating index ndx_release_dsi on table RELEASE'

--METADATA NAME:ndx_release_dsi TYPE:INDEX TABLE_NAME:RELEASE CHANGE:CREATE
CREATE  INDEX ndx_release_dsi
ON RELEASE (delete_session_id,delete_date)
go

print 'Creating index ndx_relitems_project on table RELITEMS'

--METADATA NAME:ndx_relitems_project TYPE:INDEX TABLE_NAME:RELITEMS CHANGE:CREATE
CREATE  INDEX ndx_relitems_project
ON RELITEMS (proj_id)
go

print 'Creating index ndx_relitems_related on table RELITEMS'

--METADATA NAME:ndx_relitems_related TYPE:INDEX TABLE_NAME:RELITEMS CHANGE:CREATE
CREATE  INDEX ndx_relitems_related
ON RELITEMS (related_item_type_id,related_fk_id)
go

print 'Creating index ndx_relitems_dsi on table RELITEMS'

--METADATA NAME:ndx_relitems_dsi TYPE:INDEX TABLE_NAME:RELITEMS CHANGE:CREATE
CREATE  INDEX ndx_relitems_dsi
ON RELITEMS (delete_session_id,delete_date)
go

print 'Creating index ndx_rfolio_user on table RFOLIO'

--METADATA NAME:ndx_rfolio_user TYPE:INDEX TABLE_NAME:RFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rfolio_user
ON RFOLIO (user_id)
go

print 'Creating index ndx_rfolio_dsi on table RFOLIO'

--METADATA NAME:ndx_rfolio_dsi TYPE:INDEX TABLE_NAME:RFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rfolio_dsi
ON RFOLIO (delete_session_id,delete_date)
go

print 'Creating index ndx_rfolio_upd on table RFOLIO'

--METADATA NAME:ndx_rfolio_upd TYPE:INDEX TABLE_NAME:RFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rfolio_upd
ON RFOLIO (update_date,delete_session_id)
go

print 'Creating index ndx_riskctrl_1 on table RISKCTRL'

--METADATA NAME:ndx_riskctrl_1 TYPE:INDEX TABLE_NAME:RISKCTRL CHANGE:CREATE
CREATE  INDEX ndx_riskctrl_1
ON RISKCTRL (proj_id)
go

print 'Creating index ndx_riskctrl_dsi on table RISKCTRL'

--METADATA NAME:ndx_riskctrl_dsi TYPE:INDEX TABLE_NAME:RISKCTRL CHANGE:CREATE
CREATE  INDEX ndx_riskctrl_dsi
ON RISKCTRL (delete_session_id,delete_date)
go

print 'Creating index ndx_risktype_dsi on table RISKTYPE'

--METADATA NAME:ndx_risktype_dsi TYPE:INDEX TABLE_NAME:RISKTYPE CHANGE:CREATE
CREATE  INDEX ndx_risktype_dsi
ON RISKTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_risktype_upd on table RISKTYPE'

--METADATA NAME:ndx_risktype_upd TYPE:INDEX TABLE_NAME:RISKTYPE CHANGE:CREATE
CREATE  INDEX ndx_risktype_upd
ON RISKTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_rlfolio_user on table RLFOLIO'

--METADATA NAME:ndx_rlfolio_user TYPE:INDEX TABLE_NAME:RLFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rlfolio_user
ON RLFOLIO (user_id)
go

print 'Creating index ndx_rlfolio_dsi on table RLFOLIO'

--METADATA NAME:ndx_rlfolio_dsi TYPE:INDEX TABLE_NAME:RLFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rlfolio_dsi
ON RLFOLIO (delete_session_id,delete_date)
go

print 'Creating index ndx_rlfolio_upd on table RLFOLIO'

--METADATA NAME:ndx_rlfolio_upd TYPE:INDEX TABLE_NAME:RLFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rlfolio_upd
ON RLFOLIO (update_date,delete_session_id)
go

print 'Creating index ndx_rolecattype_dsi on table ROLECATTYPE'

--METADATA NAME:ndx_rolecattype_dsi TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE  INDEX ndx_rolecattype_dsi
ON ROLECATTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_rolecattype_upd on table ROLECATTYPE'

--METADATA NAME:ndx_rolecattype_upd TYPE:INDEX TABLE_NAME:ROLECATTYPE CHANGE:CREATE
CREATE  INDEX ndx_rolecattype_upd
ON ROLECATTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_rolecatval_rolecattype on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_rolecattype TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_rolecattype
ON ROLECATVAL (role_catg_type_id)
go

print 'Creating index ndx_rolecatval_parent_catg on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_parent_catg TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_parent_catg
ON ROLECATVAL (parent_role_catg_id)
go

print 'Creating index ndx_rolecatval_dsi on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_dsi TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_dsi
ON ROLECATVAL (delete_session_id,delete_date)
go

print 'Creating index ndx_rolecatval_upd on table ROLECATVAL'

--METADATA NAME:ndx_rolecatval_upd TYPE:INDEX TABLE_NAME:ROLECATVAL CHANGE:CREATE
CREATE  INDEX ndx_rolecatval_upd
ON ROLECATVAL (update_date,delete_session_id)
go

print 'Creating index ndx_rolelimit_roles on table ROLELIMIT'

--METADATA NAME:ndx_rolelimit_roles TYPE:INDEX TABLE_NAME:ROLELIMIT CHANGE:CREATE
CREATE  INDEX ndx_rolelimit_roles
ON ROLELIMIT (role_id)
go

print 'Creating index ndx_rolelimit_dsi on table ROLELIMIT'

--METADATA NAME:ndx_rolelimit_dsi TYPE:INDEX TABLE_NAME:ROLELIMIT CHANGE:CREATE
CREATE  INDEX ndx_rolelimit_dsi
ON ROLELIMIT (delete_session_id,delete_date)
go

print 'Creating index ndx_rolelimit_upd on table ROLELIMIT'

--METADATA NAME:ndx_rolelimit_upd TYPE:INDEX TABLE_NAME:ROLELIMIT CHANGE:CREATE
CREATE  INDEX ndx_rolelimit_upd
ON ROLELIMIT (update_date,delete_session_id)
go

print 'Creating index ndx_rolerate_rsrc on table ROLERATE'

--METADATA NAME:ndx_rolerate_rsrc TYPE:INDEX TABLE_NAME:ROLERATE CHANGE:CREATE
CREATE  INDEX ndx_rolerate_rsrc
ON ROLERATE (role_id)
go

print 'Creating index ndx_rolerate_dsi on table ROLERATE'

--METADATA NAME:ndx_rolerate_dsi TYPE:INDEX TABLE_NAME:ROLERATE CHANGE:CREATE
CREATE  INDEX ndx_rolerate_dsi
ON ROLERATE (delete_session_id,delete_date)
go

print 'Creating index ndx_rolerate_upd on table ROLERATE'

--METADATA NAME:ndx_rolerate_upd TYPE:INDEX TABLE_NAME:ROLERATE CHANGE:CREATE
CREATE  INDEX ndx_rolerate_upd
ON ROLERATE (update_date,delete_session_id)
go

print 'Creating index ndx_rolercat_rolecattype on table ROLERCAT'

--METADATA NAME:ndx_rolercat_rolecattype TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_rolecattype
ON ROLERCAT (role_catg_type_id)
go

print 'Creating index ndx_rolercat_rolecatval on table ROLERCAT'

--METADATA NAME:ndx_rolercat_rolecatval TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_rolecatval
ON ROLERCAT (role_catg_id)
go

print 'Creating index ndx_rolercat_update_date1 on table ROLERCAT'

--METADATA NAME:ndx_rolercat_update_date1 TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_update_date1
ON ROLERCAT (update_date)
go

print 'Creating index ndx_rolercat_dsi on table ROLERCAT'

--METADATA NAME:ndx_rolercat_dsi TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_dsi
ON ROLERCAT (delete_session_id,delete_date)
go

print 'Creating index ndx_rolercat_upd on table ROLERCAT'

--METADATA NAME:ndx_rolercat_upd TYPE:INDEX TABLE_NAME:ROLERCAT CHANGE:CREATE
CREATE  INDEX ndx_rolercat_upd
ON ROLERCAT (update_date,delete_session_id)
go

print 'Creating index ndx_roles_parent_role on table ROLES'

--METADATA NAME:ndx_roles_parent_role TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE  INDEX ndx_roles_parent_role
ON ROLES (parent_role_id)
go

print 'Creating index ndx_roles_pobs on table ROLES'

--METADATA NAME:ndx_roles_pobs TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE  INDEX ndx_roles_pobs
ON ROLES (pobs_id)
go

print 'Creating index ndx_roles_update_date1 on table ROLES'

--METADATA NAME:ndx_roles_update_date1 TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE  INDEX ndx_roles_update_date1
ON ROLES (update_date)
go

print 'Creating index ndx_roles_dsi on table ROLES'

--METADATA NAME:ndx_roles_dsi TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE  INDEX ndx_roles_dsi
ON ROLES (delete_session_id,delete_date)
go

print 'Creating index ndx_roles_upd on table ROLES'

--METADATA NAME:ndx_roles_upd TYPE:INDEX TABLE_NAME:ROLES CHANGE:CREATE
CREATE  INDEX ndx_roles_upd
ON ROLES (update_date,delete_session_id)
go

print 'Creating index ndx_rolfolio_role on table ROLFOLIO'

--METADATA NAME:ndx_rolfolio_role TYPE:INDEX TABLE_NAME:ROLFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rolfolio_role
ON ROLFOLIO (role_id)
go

print 'Creating index ndx_rolfolio_dsi on table ROLFOLIO'

--METADATA NAME:ndx_rolfolio_dsi TYPE:INDEX TABLE_NAME:ROLFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rolfolio_dsi
ON ROLFOLIO (delete_session_id,delete_date)
go

print 'Creating index ndx_rolfolio_upd on table ROLFOLIO'

--METADATA NAME:ndx_rolfolio_upd TYPE:INDEX TABLE_NAME:ROLFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rolfolio_upd
ON ROLFOLIO (update_date,delete_session_id)
go

print 'Creating index ndx_rpt_1 on table RPT'

--METADATA NAME:ndx_rpt_1 TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE
CREATE  INDEX ndx_rpt_1
ON RPT (proj_id)
go

print 'Creating index ndx_rpt_rptgroup on table RPT'

--METADATA NAME:ndx_rpt_rptgroup TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE
CREATE  INDEX ndx_rpt_rptgroup
ON RPT (rpt_group_id)
go

print 'Creating index ndx_rpt_dsi on table RPT'

--METADATA NAME:ndx_rpt_dsi TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE
CREATE  INDEX ndx_rpt_dsi
ON RPT (delete_session_id,delete_date)
go

print 'Creating index ndx_rpt_upd on table RPT'

--METADATA NAME:ndx_rpt_upd TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE
CREATE  INDEX ndx_rpt_upd
ON RPT (update_date,delete_session_id)
go

print 'Creating index ndx_rptbatch_1 on table RPTBATCH'

--METADATA NAME:ndx_rptbatch_1 TYPE:INDEX TABLE_NAME:RPTBATCH CHANGE:CREATE
CREATE  INDEX ndx_rptbatch_1
ON RPTBATCH (proj_id)
go

print 'Creating index ndx_rptbatch_dsi on table RPTBATCH'

--METADATA NAME:ndx_rptbatch_dsi TYPE:INDEX TABLE_NAME:RPTBATCH CHANGE:CREATE
CREATE  INDEX ndx_rptbatch_dsi
ON RPTBATCH (delete_session_id,delete_date)
go

print 'Creating index ndx_rptbatch_upd on table RPTBATCH'

--METADATA NAME:ndx_rptbatch_upd TYPE:INDEX TABLE_NAME:RPTBATCH CHANGE:CREATE
CREATE  INDEX ndx_rptbatch_upd
ON RPTBATCH (update_date,delete_session_id)
go

print 'Creating index ndx_rptgroup_parent_group on table RPTGROUP'

--METADATA NAME:ndx_rptgroup_parent_group TYPE:INDEX TABLE_NAME:RPTGROUP CHANGE:CREATE
CREATE  INDEX ndx_rptgroup_parent_group
ON RPTGROUP (parent_group_id)
go

print 'Creating index ndx_rptgroup_dsi on table RPTGROUP'

--METADATA NAME:ndx_rptgroup_dsi TYPE:INDEX TABLE_NAME:RPTGROUP CHANGE:CREATE
CREATE  INDEX ndx_rptgroup_dsi
ON RPTGROUP (delete_session_id,delete_date)
go

print 'Creating index ndx_rptgroup_upd on table RPTGROUP'

--METADATA NAME:ndx_rptgroup_upd TYPE:INDEX TABLE_NAME:RPTGROUP CHANGE:CREATE
CREATE  INDEX ndx_rptgroup_upd
ON RPTGROUP (update_date,delete_session_id)
go

print 'Creating index ndx_rptlist_rpt on table RPTLIST'

--METADATA NAME:ndx_rptlist_rpt TYPE:INDEX TABLE_NAME:RPTLIST CHANGE:CREATE
CREATE  INDEX ndx_rptlist_rpt
ON RPTLIST (rpt_id)
go

print 'Creating index ndx_rptlist_dsi on table RPTLIST'

--METADATA NAME:ndx_rptlist_dsi TYPE:INDEX TABLE_NAME:RPTLIST CHANGE:CREATE
CREATE  INDEX ndx_rptlist_dsi
ON RPTLIST (delete_session_id,delete_date)
go

print 'Creating index ndx_rptlist_upd on table RPTLIST'

--METADATA NAME:ndx_rptlist_upd TYPE:INDEX TABLE_NAME:RPTLIST CHANGE:CREATE
CREATE  INDEX ndx_rptlist_upd
ON RPTLIST (update_date,delete_session_id)
go

print 'Creating index ndx_rsrc_calendar on table RSRC'

--METADATA NAME:ndx_rsrc_calendar TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_calendar
ON RSRC (clndr_id)
go

print 'Creating index ndx_rsrc_roles on table RSRC'

--METADATA NAME:ndx_rsrc_roles TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_roles
ON RSRC (role_id)
go

print 'Creating index ndx_rsrc_shift on table RSRC'

--METADATA NAME:ndx_rsrc_shift TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_shift
ON RSRC (shift_id)
go

print 'Creating index ndx_rsrc_users on table RSRC'

--METADATA NAME:ndx_rsrc_users TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_users
ON RSRC (user_id)
go

print 'Creating index ndx_rsrc_parent_rsrc_id on table RSRC'

--METADATA NAME:ndx_rsrc_parent_rsrc_id TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_parent_rsrc_id
ON RSRC (parent_rsrc_id)
go

print 'Creating index ndx_rsrc_pobs on table RSRC'

--METADATA NAME:ndx_rsrc_pobs TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_pobs
ON RSRC (pobs_id)
go

print 'Creating index ndx_rsrc_update_date1 on table RSRC'

--METADATA NAME:ndx_rsrc_update_date1 TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_update_date1
ON RSRC (update_date)
go

print 'Creating index ndx_rsrc_unit on table RSRC'

--METADATA NAME:ndx_rsrc_unit TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_unit
ON RSRC (unit_id)
go

print 'Creating index ndx_rsrc_curr on table RSRC'

--METADATA NAME:ndx_rsrc_curr TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_curr
ON RSRC (curr_id)
go

print 'Creating index ndx_rsrc_dsi on table RSRC'

--METADATA NAME:ndx_rsrc_dsi TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_dsi
ON RSRC (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrc_upd on table RSRC'

--METADATA NAME:ndx_rsrc_upd TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_upd
ON RSRC (update_date,delete_session_id)
go

print 'Creating index ndx_rsrcandash_1 on table RSRCANDASH'

--METADATA NAME:ndx_rsrcandash_1 TYPE:INDEX TABLE_NAME:RSRCANDASH CHANGE:CREATE
CREATE  INDEX ndx_rsrcandash_1
ON RSRCANDASH (rsrcan_view_id,dashboard_id)
go

print 'Creating index ndx_rsrcandash_dsi on table RSRCANDASH'

--METADATA NAME:ndx_rsrcandash_dsi TYPE:INDEX TABLE_NAME:RSRCANDASH CHANGE:CREATE
CREATE  INDEX ndx_rsrcandash_dsi
ON RSRCANDASH (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrcandash_upd on table RSRCANDASH'

--METADATA NAME:ndx_rsrcandash_upd TYPE:INDEX TABLE_NAME:RSRCANDASH CHANGE:CREATE
CREATE  INDEX ndx_rsrcandash_upd
ON RSRCANDASH (update_date,delete_session_id)
go

print 'Creating index ndx_rsrcanview_1 on table RSRCANVIEW'

--METADATA NAME:ndx_rsrcanview_1 TYPE:INDEX TABLE_NAME:RSRCANVIEW CHANGE:CREATE
CREATE  INDEX ndx_rsrcanview_1
ON RSRCANVIEW (user_id)
go

print 'Creating index ndx_rsrcanview_dsi on table RSRCANVIEW'

--METADATA NAME:ndx_rsrcanview_dsi TYPE:INDEX TABLE_NAME:RSRCANVIEW CHANGE:CREATE
CREATE  INDEX ndx_rsrcanview_dsi
ON RSRCANVIEW (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrcanview_upd on table RSRCANVIEW'

--METADATA NAME:ndx_rsrcanview_upd TYPE:INDEX TABLE_NAME:RSRCANVIEW CHANGE:CREATE
CREATE  INDEX ndx_rsrcanview_upd
ON RSRCANVIEW (update_date,delete_session_id)
go

print 'Creating index ndx_rsrccurv_dsi on table RSRCCURV'

--METADATA NAME:ndx_rsrccurv_dsi TYPE:INDEX TABLE_NAME:RSRCCURV CHANGE:CREATE
CREATE  INDEX ndx_rsrccurv_dsi
ON RSRCCURV (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrccurv_upd on table RSRCCURV'

--METADATA NAME:ndx_rsrccurv_upd TYPE:INDEX TABLE_NAME:RSRCCURV CHANGE:CREATE
CREATE  INDEX ndx_rsrccurv_upd
ON RSRCCURV (update_date,delete_session_id)
go

print 'Creating index ndx_rsrchour_project on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_project TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_project
ON RSRCHOUR (proj_id,ts_id,task_ts_flag,rsrc_id,delete_session_id)
go

print 'Creating index ndx_rsrchour_nonwork on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_nonwork TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_nonwork
ON RSRCHOUR (nonwork_type_id)
go

print 'Creating index ndx_rsrchour_rsrc on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_rsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_rsrc
ON RSRCHOUR (rsrc_id)
go

print 'Creating index ndx_rsrchour_taskrsrc on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_taskrsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_taskrsrc
ON RSRCHOUR (taskrsrc_id)
go

print 'Creating index ndx_rsrchour_timesht on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_timesht TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_timesht
ON RSRCHOUR (rsrc_id,ts_id)
go

print 'Creating index ndx_rsrchour_work_date on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_work_date TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_work_date
ON RSRCHOUR (work_date)
go

print 'Creating index ndx_rsrchour_status_code on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_status_code TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_status_code
ON RSRCHOUR (status_code,proj_id,ts_id,rsrc_id,delete_session_id)
go

print 'Creating index ndx_rsrchour_dsi on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_dsi TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_dsi
ON RSRCHOUR (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrchour_ts_rsrc on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_ts_rsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_ts_rsrc
ON RSRCHOUR (ts_id,rsrc_id)
go

print 'Creating index ndx_rsrcprop_dsi on table RSRCPROP'

--METADATA NAME:ndx_rsrcprop_dsi TYPE:INDEX TABLE_NAME:RSRCPROP CHANGE:CREATE
CREATE  INDEX ndx_rsrcprop_dsi
ON RSRCPROP (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrcrate_rsrc on table RSRCRATE'

--METADATA NAME:ndx_rsrcrate_rsrc TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE  INDEX ndx_rsrcrate_rsrc
ON RSRCRATE (rsrc_id)
go

print 'Creating index ndx_rsrcrate_shiftper on table RSRCRATE'

--METADATA NAME:ndx_rsrcrate_shiftper TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE  INDEX ndx_rsrcrate_shiftper
ON RSRCRATE (shift_period_id)
go

print 'Creating index ndx_rsrcrate_update_date1 on table RSRCRATE'

--METADATA NAME:ndx_rsrcrate_update_date1 TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE  INDEX ndx_rsrcrate_update_date1
ON RSRCRATE (update_date)
go

print 'Creating index ndx_rsrcrate_dsi on table RSRCRATE'

--METADATA NAME:ndx_rsrcrate_dsi TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE  INDEX ndx_rsrcrate_dsi
ON RSRCRATE (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrcrate_upd on table RSRCRATE'

--METADATA NAME:ndx_rsrcrate_upd TYPE:INDEX TABLE_NAME:RSRCRATE CHANGE:CREATE
CREATE  INDEX ndx_rsrcrate_upd
ON RSRCRATE (update_date,delete_session_id)
go

print 'Creating index ndx_rsrcrcat_rcattype on table RSRCRCAT'

--METADATA NAME:ndx_rsrcrcat_rcattype TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE  INDEX ndx_rsrcrcat_rcattype
ON RSRCRCAT (rsrc_catg_type_id)
go

print 'Creating index ndx_rsrcrcat_rcatval on table RSRCRCAT'

--METADATA NAME:ndx_rsrcrcat_rcatval TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE  INDEX ndx_rsrcrcat_rcatval
ON RSRCRCAT (rsrc_catg_id)
go

print 'Creating index ndx_rsrcrcat_update_date1 on table RSRCRCAT'

--METADATA NAME:ndx_rsrcrcat_update_date1 TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE  INDEX ndx_rsrcrcat_update_date1
ON RSRCRCAT (update_date)
go

print 'Creating index ndx_rsrcrcat_dsi on table RSRCRCAT'

--METADATA NAME:ndx_rsrcrcat_dsi TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE  INDEX ndx_rsrcrcat_dsi
ON RSRCRCAT (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrcrcat_upd on table RSRCRCAT'

--METADATA NAME:ndx_rsrcrcat_upd TYPE:INDEX TABLE_NAME:RSRCRCAT CHANGE:CREATE
CREATE  INDEX ndx_rsrcrcat_upd
ON RSRCRCAT (update_date,delete_session_id)
go

print 'Creating index ndx_rsrcrole_roles on table RSRCROLE'

--METADATA NAME:ndx_rsrcrole_roles TYPE:INDEX TABLE_NAME:RSRCROLE CHANGE:CREATE
CREATE  INDEX ndx_rsrcrole_roles
ON RSRCROLE (role_id)
go

print 'Creating index ndx_rsrcrole_dsi on table RSRCROLE'

--METADATA NAME:ndx_rsrcrole_dsi TYPE:INDEX TABLE_NAME:RSRCROLE CHANGE:CREATE
CREATE  INDEX ndx_rsrcrole_dsi
ON RSRCROLE (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrcrole_upd on table RSRCROLE'

--METADATA NAME:ndx_rsrcrole_upd TYPE:INDEX TABLE_NAME:RSRCROLE CHANGE:CREATE
CREATE  INDEX ndx_rsrcrole_upd
ON RSRCROLE (update_date,delete_session_id)
go

print 'Creating index ndx_rsrcsec_rsrc on table RSRCSEC'

--METADATA NAME:ndx_rsrcsec_rsrc TYPE:INDEX TABLE_NAME:RSRCSEC CHANGE:CREATE
CREATE  INDEX ndx_rsrcsec_rsrc
ON RSRCSEC (rsrc_id)
go

print 'Creating index ndx_rsrcsec_dsi on table RSRCSEC'

--METADATA NAME:ndx_rsrcsec_dsi TYPE:INDEX TABLE_NAME:RSRCSEC CHANGE:CREATE
CREATE  INDEX ndx_rsrcsec_dsi
ON RSRCSEC (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrcsec_upd on table RSRCSEC'

--METADATA NAME:ndx_rsrcsec_upd TYPE:INDEX TABLE_NAME:RSRCSEC CHANGE:CREATE
CREATE  INDEX ndx_rsrcsec_upd
ON RSRCSEC (update_date,delete_session_id)
go

print 'Creating index ndx_rsrfolio_rsrc on table RSRFOLIO'

--METADATA NAME:ndx_rsrfolio_rsrc TYPE:INDEX TABLE_NAME:RSRFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rsrfolio_rsrc
ON RSRFOLIO (rsrc_id)
go

print 'Creating index ndx_rsrfolio_dsi on table RSRFOLIO'

--METADATA NAME:ndx_rsrfolio_dsi TYPE:INDEX TABLE_NAME:RSRFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rsrfolio_dsi
ON RSRFOLIO (delete_session_id,delete_date)
go

print 'Creating index ndx_rsrfolio_upd on table RSRFOLIO'

--METADATA NAME:ndx_rsrfolio_upd TYPE:INDEX TABLE_NAME:RSRFOLIO CHANGE:CREATE
CREATE  INDEX ndx_rsrfolio_upd
ON RSRFOLIO (update_date,delete_session_id)
go

print 'Creating index ndx_scenario_1 on table SCENARIO'

--METADATA NAME:ndx_scenario_1 TYPE:INDEX TABLE_NAME:SCENARIO CHANGE:CREATE
CREATE  INDEX ndx_scenario_1
ON SCENARIO (user_id)
go

print 'Creating index ndx_scenario_viewpref on table SCENARIO'

--METADATA NAME:ndx_scenario_viewpref TYPE:INDEX TABLE_NAME:SCENARIO CHANGE:CREATE
CREATE  INDEX ndx_scenario_viewpref
ON SCENARIO (view_pref_id)
go

print 'Creating index ndx_scenario_dsi on table SCENARIO'

--METADATA NAME:ndx_scenario_dsi TYPE:INDEX TABLE_NAME:SCENARIO CHANGE:CREATE
CREATE  INDEX ndx_scenario_dsi
ON SCENARIO (delete_session_id,delete_date)
go

print 'Creating index ndx_scenario_upd on table SCENARIO'

--METADATA NAME:ndx_scenario_upd TYPE:INDEX TABLE_NAME:SCENARIO CHANGE:CREATE
CREATE  INDEX ndx_scenario_upd
ON SCENARIO (update_date,delete_session_id)
go

print 'Creating index ndx_scenproj_1 on table SCENPROJ'

--METADATA NAME:ndx_scenproj_1 TYPE:INDEX TABLE_NAME:SCENPROJ CHANGE:CREATE
CREATE  INDEX ndx_scenproj_1
ON SCENPROJ (proj_id,scenario_id)
go

print 'Creating index ndx_scenproj_dsi on table SCENPROJ'

--METADATA NAME:ndx_scenproj_dsi TYPE:INDEX TABLE_NAME:SCENPROJ CHANGE:CREATE
CREATE  INDEX ndx_scenproj_dsi
ON SCENPROJ (delete_session_id,delete_date)
go

print 'Creating index ndx_scenproj_upd on table SCENPROJ'

--METADATA NAME:ndx_scenproj_upd TYPE:INDEX TABLE_NAME:SCENPROJ CHANGE:CREATE
CREATE  INDEX ndx_scenproj_upd
ON SCENPROJ (update_date,delete_session_id)
go

print 'Creating index ndx_scenrole_roles on table SCENROLE'

--METADATA NAME:ndx_scenrole_roles TYPE:INDEX TABLE_NAME:SCENROLE CHANGE:CREATE
CREATE  INDEX ndx_scenrole_roles
ON SCENROLE (role_id,scenario_id)
go

print 'Creating index ndx_scenrole_dsi on table SCENROLE'

--METADATA NAME:ndx_scenrole_dsi TYPE:INDEX TABLE_NAME:SCENROLE CHANGE:CREATE
CREATE  INDEX ndx_scenrole_dsi
ON SCENROLE (delete_session_id,delete_date)
go

print 'Creating index ndx_scenrole_upd on table SCENROLE'

--METADATA NAME:ndx_scenrole_upd TYPE:INDEX TABLE_NAME:SCENROLE CHANGE:CREATE
CREATE  INDEX ndx_scenrole_upd
ON SCENROLE (update_date,delete_session_id)
go

print 'Creating index ndx_scenuser_1 on table SCENUSER'

--METADATA NAME:ndx_scenuser_1 TYPE:INDEX TABLE_NAME:SCENUSER CHANGE:CREATE
CREATE  INDEX ndx_scenuser_1
ON SCENUSER (user_id,scenario_id)
go

print 'Creating index ndx_scenuser_dsi on table SCENUSER'

--METADATA NAME:ndx_scenuser_dsi TYPE:INDEX TABLE_NAME:SCENUSER CHANGE:CREATE
CREATE  INDEX ndx_scenuser_dsi
ON SCENUSER (delete_session_id,delete_date)
go

print 'Creating index ndx_scenuser_upd on table SCENUSER'

--METADATA NAME:ndx_scenuser_upd TYPE:INDEX TABLE_NAME:SCENUSER CHANGE:CREATE
CREATE  INDEX ndx_scenuser_upd
ON SCENUSER (update_date,delete_session_id)
go

print 'Creating index ndx_settings_dsi on table SETTINGS'

--METADATA NAME:ndx_settings_dsi TYPE:INDEX TABLE_NAME:SETTINGS CHANGE:CREATE
CREATE  INDEX ndx_settings_dsi
ON SETTINGS (delete_session_id,delete_date)
go

print 'Creating index ndx_shift_dsi on table SHIFT'

--METADATA NAME:ndx_shift_dsi TYPE:INDEX TABLE_NAME:SHIFT CHANGE:CREATE
CREATE  INDEX ndx_shift_dsi
ON SHIFT (delete_session_id,delete_date)
go

print 'Creating index ndx_shift_upd on table SHIFT'

--METADATA NAME:ndx_shift_upd TYPE:INDEX TABLE_NAME:SHIFT CHANGE:CREATE
CREATE  INDEX ndx_shift_upd
ON SHIFT (update_date,delete_session_id)
go

print 'Creating index ndx_shiftper_shift on table SHIFTPER'

--METADATA NAME:ndx_shiftper_shift TYPE:INDEX TABLE_NAME:SHIFTPER CHANGE:CREATE
CREATE  INDEX ndx_shiftper_shift
ON SHIFTPER (shift_id)
go

print 'Creating index ndx_shiftper_shift_start on table SHIFTPER'

--METADATA NAME:ndx_shiftper_shift_start TYPE:INDEX TABLE_NAME:SHIFTPER CHANGE:CREATE
CREATE UNIQUE  INDEX ndx_shiftper_shift_start
ON SHIFTPER (shift_id,shift_start_hr_num)
go

print 'Creating index ndx_shiftper_dsi on table SHIFTPER'

--METADATA NAME:ndx_shiftper_dsi TYPE:INDEX TABLE_NAME:SHIFTPER CHANGE:CREATE
CREATE  INDEX ndx_shiftper_dsi
ON SHIFTPER (delete_session_id,delete_date)
go

print 'Creating index ndx_shiftper_upd on table SHIFTPER'

--METADATA NAME:ndx_shiftper_upd TYPE:INDEX TABLE_NAME:SHIFTPER CHANGE:CREATE
CREATE  INDEX ndx_shiftper_upd
ON SHIFTPER (update_date,delete_session_id)
go

print 'Creating index ndx_sumprojcost_wbs on table SUMPROJCOST'

--METADATA NAME:ndx_sumprojcost_wbs TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE  INDEX ndx_sumprojcost_wbs
ON SUMPROJCOST (wbs_id)
go

print 'Creating index ndx_sumprojcost_cost_type on table SUMPROJCOST'

--METADATA NAME:ndx_sumprojcost_cost_type TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE  INDEX ndx_sumprojcost_cost_type
ON SUMPROJCOST (cost_type_id)
go

print 'Creating index ndx_sumprojcost_proj on table SUMPROJCOST'

--METADATA NAME:ndx_sumprojcost_proj TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE  INDEX ndx_sumprojcost_proj
ON SUMPROJCOST (proj_id)
go

print 'Creating index ndx_sumtask_proj on table SUMTASK'

--METADATA NAME:ndx_sumtask_proj TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE  INDEX ndx_sumtask_proj
ON SUMTASK (proj_id)
go

print 'Creating index ndx_sumtask_wbs on table SUMTASK'

--METADATA NAME:ndx_sumtask_wbs TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE  INDEX ndx_sumtask_wbs
ON SUMTASK (wbs_id)
go

print 'Creating index ndx_sumtaskspread_proj on table SUMTASKSPREAD'

--METADATA NAME:ndx_sumtaskspread_proj TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE  INDEX ndx_sumtaskspread_proj
ON SUMTASKSPREAD (proj_id)
go

print 'Creating index ndx_sumtaskspread_wbs on table SUMTASKSPREAD'

--METADATA NAME:ndx_sumtaskspread_wbs TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE  INDEX ndx_sumtaskspread_wbs
ON SUMTASKSPREAD (wbs_id)
go

print 'Creating index ndx_sumtrsrc_project on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_project TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_project
ON SUMTRSRC (proj_id,spread_type)
go

print 'Creating index ndx_sumtrsrc_projwbs on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_projwbs TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_projwbs
ON SUMTRSRC (wbs_id,spread_type)
go

print 'Creating index ndx_sumtrsrc_rsrcrole on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_rsrcrole TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_rsrcrole
ON SUMTRSRC (rsrc_id,role_id,spread_type)
go

print 'Creating index ndx_sumtrsrc_projrsrcrole_id on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_projrsrcrole_id TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_projrsrcrole_id
ON SUMTRSRC (proj_id,rsrc_id,role_id)
go

print 'Creating index ndx_task_1 on table TASK'

--METADATA NAME:ndx_task_1 TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE  INDEX ndx_task_1
ON TASK (proj_id)
go

print 'Creating index ndx_task_calendar on table TASK'

--METADATA NAME:ndx_task_calendar TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE  INDEX ndx_task_calendar
ON TASK (clndr_id,delete_session_id)
go

print 'Creating index ndx_task_projwbs on table TASK'

--METADATA NAME:ndx_task_projwbs TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE  INDEX ndx_task_projwbs
ON TASK (wbs_id)
go

print 'Creating index ndx_task_rsrc on table TASK'

--METADATA NAME:ndx_task_rsrc TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE  INDEX ndx_task_rsrc
ON TASK (rsrc_id)
go

print 'Creating index ndx_task_guid on table TASK'

--METADATA NAME:ndx_task_guid TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE  INDEX ndx_task_guid
ON TASK (guid)
go

print 'Creating index ndx_task_proj_rsrc on table TASK'

--METADATA NAME:ndx_task_proj_rsrc TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE  INDEX ndx_task_proj_rsrc
ON TASK (proj_id,rsrc_id,delete_session_id)
go

print 'Creating index ndx_task_dsi on table TASK'

--METADATA NAME:ndx_task_dsi TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE
CREATE  INDEX ndx_task_dsi
ON TASK (delete_session_id,delete_date)
go

print 'Creating index ndx_taskactv_1 on table TASKACTV'

--METADATA NAME:ndx_taskactv_1 TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE  INDEX ndx_taskactv_1
ON TASKACTV (proj_id)
go

print 'Creating index ndx_taskactv_actvcode on table TASKACTV'

--METADATA NAME:ndx_taskactv_actvcode TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE  INDEX ndx_taskactv_actvcode
ON TASKACTV (actv_code_id)
go

print 'Creating index ndx_taskactv_actvtype on table TASKACTV'

--METADATA NAME:ndx_taskactv_actvtype TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE  INDEX ndx_taskactv_actvtype
ON TASKACTV (actv_code_type_id)
go

print 'Creating index ndx_taskactv_task on table TASKACTV'

--METADATA NAME:ndx_taskactv_task TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE  INDEX ndx_taskactv_task
ON TASKACTV (task_id)
go

print 'Creating index ndx_taskactv_proj_actv_code on table TASKACTV'

--METADATA NAME:ndx_taskactv_proj_actv_code TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE  INDEX ndx_taskactv_proj_actv_code
ON TASKACTV (proj_id,actv_code_id,delete_session_id)
go

print 'Creating index ndx_taskactv_proj_task_actv on table TASKACTV'

--METADATA NAME:ndx_taskactv_proj_task_actv TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE  INDEX ndx_taskactv_proj_task_actv
ON TASKACTV (proj_id,task_id,actv_code_type_id,actv_code_id,delete_session_id)
go

print 'Creating index ndx_taskactv_dsi on table TASKACTV'

--METADATA NAME:ndx_taskactv_dsi TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE
CREATE  INDEX ndx_taskactv_dsi
ON TASKACTV (delete_session_id,delete_date)
go

print 'Creating index ndx_taskdoc_1 on table TASKDOC'

--METADATA NAME:ndx_taskdoc_1 TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE  INDEX ndx_taskdoc_1
ON TASKDOC (proj_id)
go

print 'Creating index ndx_taskdoc_document on table TASKDOC'

--METADATA NAME:ndx_taskdoc_document TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE  INDEX ndx_taskdoc_document
ON TASKDOC (doc_id)
go

print 'Creating index ndx_taskdoc_projwbs on table TASKDOC'

--METADATA NAME:ndx_taskdoc_projwbs TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE  INDEX ndx_taskdoc_projwbs
ON TASKDOC (wbs_id)
go

print 'Creating index ndx_taskdoc_task on table TASKDOC'

--METADATA NAME:ndx_taskdoc_task TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE  INDEX ndx_taskdoc_task
ON TASKDOC (task_id)
go

print 'Creating index ndx_taskdoc_dsi on table TASKDOC'

--METADATA NAME:ndx_taskdoc_dsi TYPE:INDEX TABLE_NAME:TASKDOC CHANGE:CREATE
CREATE  INDEX ndx_taskdoc_dsi
ON TASKDOC (delete_session_id,delete_date)
go

print 'Creating index ndx_taskfdbk_1 on table TASKFDBK'

--METADATA NAME:ndx_taskfdbk_1 TYPE:INDEX TABLE_NAME:TASKFDBK CHANGE:CREATE
CREATE  INDEX ndx_taskfdbk_1
ON TASKFDBK (proj_id)
go

print 'Creating index ndx_taskfdbk_dsi on table TASKFDBK'

--METADATA NAME:ndx_taskfdbk_dsi TYPE:INDEX TABLE_NAME:TASKFDBK CHANGE:CREATE
CREATE  INDEX ndx_taskfdbk_dsi
ON TASKFDBK (delete_session_id,delete_date)
go

print 'Creating index ndx_taskfin_project on table TASKFIN'

--METADATA NAME:ndx_taskfin_project TYPE:INDEX TABLE_NAME:TASKFIN CHANGE:CREATE
CREATE  INDEX ndx_taskfin_project
ON TASKFIN (proj_id)
go

print 'Creating index ndx_taskfin_task on table TASKFIN'

--METADATA NAME:ndx_taskfin_task TYPE:INDEX TABLE_NAME:TASKFIN CHANGE:CREATE
CREATE  INDEX ndx_taskfin_task
ON TASKFIN (task_id)
go

print 'Creating index ndx_taskfin_findates on table TASKFIN'

--METADATA NAME:ndx_taskfin_findates TYPE:INDEX TABLE_NAME:TASKFIN CHANGE:CREATE
CREATE  INDEX ndx_taskfin_findates
ON TASKFIN (fin_dates_id)
go

print 'Creating index ndx_taskfin_dsi on table TASKFIN'

--METADATA NAME:ndx_taskfin_dsi TYPE:INDEX TABLE_NAME:TASKFIN CHANGE:CREATE
CREATE  INDEX ndx_taskfin_dsi
ON TASKFIN (delete_session_id,delete_date)
go

print 'Creating index ndx_taskmemo_1 on table TASKMEMO'

--METADATA NAME:ndx_taskmemo_1 TYPE:INDEX TABLE_NAME:TASKMEMO CHANGE:CREATE
CREATE  INDEX ndx_taskmemo_1
ON TASKMEMO (proj_id)
go

print 'Creating index ndx_taskmemo_memotype on table TASKMEMO'

--METADATA NAME:ndx_taskmemo_memotype TYPE:INDEX TABLE_NAME:TASKMEMO CHANGE:CREATE
CREATE  INDEX ndx_taskmemo_memotype
ON TASKMEMO (memo_type_id)
go

print 'Creating index ndx_taskmemo_task on table TASKMEMO'

--METADATA NAME:ndx_taskmemo_task TYPE:INDEX TABLE_NAME:TASKMEMO CHANGE:CREATE
CREATE  INDEX ndx_taskmemo_task
ON TASKMEMO (task_id)
go

print 'Creating index ndx_taskmemo_dsi on table TASKMEMO'

--METADATA NAME:ndx_taskmemo_dsi TYPE:INDEX TABLE_NAME:TASKMEMO CHANGE:CREATE
CREATE  INDEX ndx_taskmemo_dsi
ON TASKMEMO (delete_session_id,delete_date)
go

print 'Creating index ndx_tasknote_1 on table TASKNOTE'

--METADATA NAME:ndx_tasknote_1 TYPE:INDEX TABLE_NAME:TASKNOTE CHANGE:CREATE
CREATE  INDEX ndx_tasknote_1
ON TASKNOTE (proj_id)
go

print 'Creating index ndx_tasknote_dsi on table TASKNOTE'

--METADATA NAME:ndx_tasknote_dsi TYPE:INDEX TABLE_NAME:TASKNOTE CHANGE:CREATE
CREATE  INDEX ndx_tasknote_dsi
ON TASKNOTE (delete_session_id,delete_date)
go

print 'Creating index ndx_taskpred_1 on table TASKPRED'

--METADATA NAME:ndx_taskpred_1 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE  INDEX ndx_taskpred_1
ON TASKPRED (proj_id)
go

print 'Creating index ndx_taskpred_pred_proj on table TASKPRED'

--METADATA NAME:ndx_taskpred_pred_proj TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE  INDEX ndx_taskpred_pred_proj
ON TASKPRED (pred_proj_id,proj_id,delete_session_id)
go

print 'Creating index ndx_taskpred_task on table TASKPRED'

--METADATA NAME:ndx_taskpred_task TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE  INDEX ndx_taskpred_task
ON TASKPRED (task_id)
go

print 'Creating index ndx_taskpred_task_2 on table TASKPRED'

--METADATA NAME:ndx_taskpred_task_2 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE  INDEX ndx_taskpred_task_2
ON TASKPRED (pred_task_id)
go

print 'Creating index ndx_taskpred_perfc1 on table TASKPRED'

--METADATA NAME:ndx_taskpred_perfc1 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE  INDEX ndx_taskpred_perfc1
ON TASKPRED (proj_id, pred_proj_id, task_pred_id, task_id, pred_task_id, pred_type, lag_hr_cnt, delete_session_id)
go

print 'Creating index ndx_taskpred_perfc2 on table TASKPRED'

--METADATA NAME:ndx_taskpred_perfc2 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE  INDEX ndx_taskpred_perfc2
ON TASKPRED (pred_proj_id,proj_id, task_id, pred_task_id, task_pred_id, pred_type, lag_hr_cnt, delete_session_id)
go

print 'Creating index ndx_taskpred_dsi on table TASKPRED'

--METADATA NAME:ndx_taskpred_dsi TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE
CREATE  INDEX ndx_taskpred_dsi
ON TASKPRED (delete_session_id,delete_date)
go

print 'Creating index ndx_taskproc_1 on table TASKPROC'

--METADATA NAME:ndx_taskproc_1 TYPE:INDEX TABLE_NAME:TASKPROC CHANGE:CREATE
CREATE  INDEX ndx_taskproc_1
ON TASKPROC (proj_id)
go

print 'Creating index ndx_taskproc_task on table TASKPROC'

--METADATA NAME:ndx_taskproc_task TYPE:INDEX TABLE_NAME:TASKPROC CHANGE:CREATE
CREATE  INDEX ndx_taskproc_task
ON TASKPROC (task_id)
go

print 'Creating index ndx_taskproc_dsi on table TASKPROC'

--METADATA NAME:ndx_taskproc_dsi TYPE:INDEX TABLE_NAME:TASKPROC CHANGE:CREATE
CREATE  INDEX ndx_taskproc_dsi
ON TASKPROC (delete_session_id,delete_date)
go

print 'Creating index ndx_taskrisk_risk on table TASKRISK'

--METADATA NAME:ndx_taskrisk_risk TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE  INDEX ndx_taskrisk_risk
ON TASKRISK (risk_id)
go

print 'Creating index ndx_taskrisk_proj on table TASKRISK'

--METADATA NAME:ndx_taskrisk_proj TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE  INDEX ndx_taskrisk_proj
ON TASKRISK (proj_id)
go

print 'Creating index ndx_taskrisk_task on table TASKRISK'

--METADATA NAME:ndx_taskrisk_task TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE  INDEX ndx_taskrisk_task
ON TASKRISK (task_id)
go

print 'Creating index ndx_taskrsrc_1 on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_1 TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_1
ON TASKRSRC (proj_id)
go

print 'Creating index ndx_taskrsrc_account on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_account TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_account
ON TASKRSRC (acct_id)
go

print 'Creating index ndx_taskrsrc_roles on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_roles TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_roles
ON TASKRSRC (role_id)
go

print 'Creating index ndx_taskrsrc_rsrc on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_rsrc TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_rsrc
ON TASKRSRC (rsrc_id)
go

print 'Creating index ndx_taskrsrc_task on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_task TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_task
ON TASKRSRC (task_id)
go

print 'Creating index ndx_taskrsrc_rsrccurv on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_rsrccurv TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_rsrccurv
ON TASKRSRC (curv_id)
go

print 'Creating index ndx_taskrsrc_pobs on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_pobs TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_pobs
ON TASKRSRC (pobs_id)
go

print 'Creating index ndx_taskrsrc_proj_rsrc on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_proj_rsrc TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_proj_rsrc
ON TASKRSRC (proj_id,rsrc_id, delete_session_id)
go

print 'Creating index ndx_taskrsrc_proj_role on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_proj_role TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_proj_role
ON TASKRSRC (proj_id,role_id, delete_session_id)
go

print 'Creating index ndx_taskrsrc_proj_acct on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_proj_acct TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_proj_acct
ON TASKRSRC (proj_id,acct_id, delete_session_id)
go

print 'Creating index ndx_taskrsrc_dsi on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_dsi TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE
CREATE  INDEX ndx_taskrsrc_dsi
ON TASKRSRC (delete_session_id,delete_date)
go

print 'Creating index ndx_tasksum_1 on table TASKSUM'

--METADATA NAME:ndx_tasksum_1 TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE  INDEX ndx_tasksum_1
ON TASKSUM (proj_id)
go

print 'Creating index ndx_tasksum_projwbs on table TASKSUM'

--METADATA NAME:ndx_tasksum_projwbs TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE  INDEX ndx_tasksum_projwbs
ON TASKSUM (wbs_id)
go

print 'Creating index ndx_tasksum_update_date on table TASKSUM'

--METADATA NAME:ndx_tasksum_update_date TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE  INDEX ndx_tasksum_update_date
ON TASKSUM (update_date)
go

print 'Creating index ndx_tasksum_dsi on table TASKSUM'

--METADATA NAME:ndx_tasksum_dsi TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE  INDEX ndx_tasksum_dsi
ON TASKSUM (delete_session_id,delete_date)
go

print 'Creating index ndx_tasksum_upd on table TASKSUM'

--METADATA NAME:ndx_tasksum_upd TYPE:INDEX TABLE_NAME:TASKSUM CHANGE:CREATE
CREATE  INDEX ndx_tasksum_upd
ON TASKSUM (update_date,delete_session_id)
go

print 'Creating index ndx_tasksumfin_1 on table TASKSUMFIN'

--METADATA NAME:ndx_tasksumfin_1 TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE  INDEX ndx_tasksumfin_1
ON TASKSUMFIN (proj_id)
go

print 'Creating index ndx_tasksumfin_projwbs on table TASKSUMFIN'

--METADATA NAME:ndx_tasksumfin_projwbs TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE  INDEX ndx_tasksumfin_projwbs
ON TASKSUMFIN (wbs_id)
go

print 'Creating index ndx_tasksumfin_findates on table TASKSUMFIN'

--METADATA NAME:ndx_tasksumfin_findates TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE  INDEX ndx_tasksumfin_findates
ON TASKSUMFIN (fin_dates_id)
go

print 'Creating index ndx_tasksumfin_tasksum on table TASKSUMFIN'

--METADATA NAME:ndx_tasksumfin_tasksum TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE  INDEX ndx_tasksumfin_tasksum
ON TASKSUMFIN (task_sum_id)
go

print 'Creating index ndx_tasksumfin_dsi on table TASKSUMFIN'

--METADATA NAME:ndx_tasksumfin_dsi TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE  INDEX ndx_tasksumfin_dsi
ON TASKSUMFIN (delete_session_id,delete_date)
go

print 'Creating index ndx_tasksumfin_upd on table TASKSUMFIN'

--METADATA NAME:ndx_tasksumfin_upd TYPE:INDEX TABLE_NAME:TASKSUMFIN CHANGE:CREATE
CREATE  INDEX ndx_tasksumfin_upd
ON TASKSUMFIN (update_date,delete_session_id)
go

print 'Creating index ndx_taskuser_user on table TASKUSER'

--METADATA NAME:ndx_taskuser_user TYPE:INDEX TABLE_NAME:TASKUSER CHANGE:CREATE
CREATE  INDEX ndx_taskuser_user
ON TASKUSER (user_id,task_id)
go

print 'Creating index ndx_taskuser_project on table TASKUSER'

--METADATA NAME:ndx_taskuser_project TYPE:INDEX TABLE_NAME:TASKUSER CHANGE:CREATE
CREATE  INDEX ndx_taskuser_project
ON TASKUSER (proj_id)
go

print 'Creating index ndx_taskuser_dsi on table TASKUSER'

--METADATA NAME:ndx_taskuser_dsi TYPE:INDEX TABLE_NAME:TASKUSER CHANGE:CREATE
CREATE  INDEX ndx_taskuser_dsi
ON TASKUSER (delete_session_id,delete_date)
go

print 'Creating index ndx_taskwksp_project on table TASKWKSP'

--METADATA NAME:ndx_taskwksp_project TYPE:INDEX TABLE_NAME:TASKWKSP CHANGE:CREATE
CREATE  INDEX ndx_taskwksp_project
ON TASKWKSP (proj_id)
go

print 'Creating index ndx_taskwksp_task on table TASKWKSP'

--METADATA NAME:ndx_taskwksp_task TYPE:INDEX TABLE_NAME:TASKWKSP CHANGE:CREATE
CREATE  INDEX ndx_taskwksp_task
ON TASKWKSP (task_id)
go

print 'Creating index ndx_taskwksp_dsi on table TASKWKSP'

--METADATA NAME:ndx_taskwksp_dsi TYPE:INDEX TABLE_NAME:TASKWKSP CHANGE:CREATE
CREATE  INDEX ndx_taskwksp_dsi
ON TASKWKSP (delete_session_id,delete_date)
go

print 'Creating index ndx_thrsparm_dsi on table THRSPARM'

--METADATA NAME:ndx_thrsparm_dsi TYPE:INDEX TABLE_NAME:THRSPARM CHANGE:CREATE
CREATE  INDEX ndx_thrsparm_dsi
ON THRSPARM (delete_session_id,delete_date)
go

print 'Creating index ndx_timesht_1 on table TIMESHT'

--METADATA NAME:ndx_timesht_1 TYPE:INDEX TABLE_NAME:TIMESHT CHANGE:CREATE
CREATE  INDEX ndx_timesht_1
ON TIMESHT (user_id)
go

print 'Creating index ndx_timesht_rsrc on table TIMESHT'

--METADATA NAME:ndx_timesht_rsrc TYPE:INDEX TABLE_NAME:TIMESHT CHANGE:CREATE
CREATE  INDEX ndx_timesht_rsrc
ON TIMESHT (rsrc_id)
go

print 'Creating index ndx_timesht_ts_user on table TIMESHT'

--METADATA NAME:ndx_timesht_ts_user TYPE:INDEX TABLE_NAME:TIMESHT CHANGE:CREATE
CREATE  INDEX ndx_timesht_ts_user
ON TIMESHT (ts_id,user_id)
go

print 'Creating index ndx_timesht_dsi on table TIMESHT'

--METADATA NAME:ndx_timesht_dsi TYPE:INDEX TABLE_NAME:TIMESHT CHANGE:CREATE
CREATE  INDEX ndx_timesht_dsi
ON TIMESHT (delete_session_id,delete_date)
go

print 'Creating index ndx_tmplcatg_dsi on table TMPLCATG'

--METADATA NAME:ndx_tmplcatg_dsi TYPE:INDEX TABLE_NAME:TMPLCATG CHANGE:CREATE
CREATE  INDEX ndx_tmplcatg_dsi
ON TMPLCATG (delete_session_id,delete_date)
go

print 'Creating index ndx_trakview_1 on table TRAKVIEW'

--METADATA NAME:ndx_trakview_1 TYPE:INDEX TABLE_NAME:TRAKVIEW CHANGE:CREATE
CREATE  INDEX ndx_trakview_1
ON TRAKVIEW (user_id)
go

print 'Creating index ndx_trakview_dsi on table TRAKVIEW'

--METADATA NAME:ndx_trakview_dsi TYPE:INDEX TABLE_NAME:TRAKVIEW CHANGE:CREATE
CREATE  INDEX ndx_trakview_dsi
ON TRAKVIEW (delete_session_id,delete_date)
go

print 'Creating index ndx_trakview_upd on table TRAKVIEW'

--METADATA NAME:ndx_trakview_upd TYPE:INDEX TABLE_NAME:TRAKVIEW CHANGE:CREATE
CREATE  INDEX ndx_trakview_upd
ON TRAKVIEW (update_date,delete_session_id)
go

print 'Creating index ndx_trsrcfin_project on table TRSRCFIN'

--METADATA NAME:ndx_trsrcfin_project TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE  INDEX ndx_trsrcfin_project
ON TRSRCFIN (proj_id)
go

print 'Creating index ndx_trsrcfin_task on table TRSRCFIN'

--METADATA NAME:ndx_trsrcfin_task TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE  INDEX ndx_trsrcfin_task
ON TRSRCFIN (task_id)
go

print 'Creating index ndx_trsrcfin_taskrsrc on table TRSRCFIN'

--METADATA NAME:ndx_trsrcfin_taskrsrc TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE  INDEX ndx_trsrcfin_taskrsrc
ON TRSRCFIN (taskrsrc_id)
go

print 'Creating index ndx_trsrcfin_findates on table TRSRCFIN'

--METADATA NAME:ndx_trsrcfin_findates TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE  INDEX ndx_trsrcfin_findates
ON TRSRCFIN (fin_dates_id)
go

print 'Creating index ndx_trsrcfin_dsi on table TRSRCFIN'

--METADATA NAME:ndx_trsrcfin_dsi TYPE:INDEX TABLE_NAME:TRSRCFIN CHANGE:CREATE
CREATE  INDEX ndx_trsrcfin_dsi
ON TRSRCFIN (delete_session_id,delete_date)
go

print 'Creating index ndx_trsrcsum_1 on table TRSRCSUM'

--METADATA NAME:ndx_trsrcsum_1 TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE  INDEX ndx_trsrcsum_1
ON TRSRCSUM (proj_id,rsrc_id)
go

print 'Creating index ndx_trsrcsum_roles on table TRSRCSUM'

--METADATA NAME:ndx_trsrcsum_roles TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE  INDEX ndx_trsrcsum_roles
ON TRSRCSUM (role_id)
go

print 'Creating index ndx_trsrcsum_rsrc on table TRSRCSUM'

--METADATA NAME:ndx_trsrcsum_rsrc TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE  INDEX ndx_trsrcsum_rsrc
ON TRSRCSUM (rsrc_id)
go

print 'Creating index ndx_trsrcsum_update_date on table TRSRCSUM'

--METADATA NAME:ndx_trsrcsum_update_date TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE  INDEX ndx_trsrcsum_update_date
ON TRSRCSUM (update_date)
go

print 'Creating index ndx_trsrcsum_dsi on table TRSRCSUM'

--METADATA NAME:ndx_trsrcsum_dsi TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE  INDEX ndx_trsrcsum_dsi
ON TRSRCSUM (delete_session_id,delete_date)
go

print 'Creating index ndx_trsrcsum_upd on table TRSRCSUM'

--METADATA NAME:ndx_trsrcsum_upd TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE  INDEX ndx_trsrcsum_upd
ON TRSRCSUM (update_date,delete_session_id)
go

print 'Creating index ndx_trsrcsum_role_dialog on table TRSRCSUM'

--METADATA NAME:ndx_trsrcsum_role_dialog TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE  INDEX ndx_trsrcsum_role_dialog
ON TRSRCSUM (proj_id,taskrsrc_sum_id,rsrc_id,role_id,skill_level,overalloc_date,delete_session_id)
go

print 'Creating index ndx_trsrcsumfn_1 on table TRSRCSUMFN'

--METADATA NAME:ndx_trsrcsumfn_1 TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE  INDEX ndx_trsrcsumfn_1
ON TRSRCSUMFN (fin_dates_id)
go

print 'Creating index ndx_trsrcsumfn_project on table TRSRCSUMFN'

--METADATA NAME:ndx_trsrcsumfn_project TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE  INDEX ndx_trsrcsumfn_project
ON TRSRCSUMFN (proj_id)
go

print 'Creating index ndx_trsrcsumfn_roles on table TRSRCSUMFN'

--METADATA NAME:ndx_trsrcsumfn_roles TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE  INDEX ndx_trsrcsumfn_roles
ON TRSRCSUMFN (role_id)
go

print 'Creating index ndx_trsrcsumfn_rsrc on table TRSRCSUMFN'

--METADATA NAME:ndx_trsrcsumfn_rsrc TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE  INDEX ndx_trsrcsumfn_rsrc
ON TRSRCSUMFN (rsrc_id)
go

print 'Creating index ndx_trsrcsumfn_trsrcsum on table TRSRCSUMFN'

--METADATA NAME:ndx_trsrcsumfn_trsrcsum TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE  INDEX ndx_trsrcsumfn_trsrcsum
ON TRSRCSUMFN (taskrsrc_sum_id)
go

print 'Creating index ndx_trsrcsumfn_dsi on table TRSRCSUMFN'

--METADATA NAME:ndx_trsrcsumfn_dsi TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE  INDEX ndx_trsrcsumfn_dsi
ON TRSRCSUMFN (delete_session_id,delete_date)
go

print 'Creating index ndx_trsrcsumfn_upd on table TRSRCSUMFN'

--METADATA NAME:ndx_trsrcsumfn_upd TYPE:INDEX TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
CREATE  INDEX ndx_trsrcsumfn_upd
ON TRSRCSUMFN (update_date,delete_session_id)
go

print 'Creating index ndx_tsaudit_audit_date on table TSAUDIT'

--METADATA NAME:ndx_tsaudit_audit_date TYPE:INDEX TABLE_NAME:TSAUDIT CHANGE:CREATE
CREATE  INDEX ndx_tsaudit_audit_date
ON TSAUDIT (audit_date)
go

print 'Creating index ndx_tsdates_dsi on table TSDATES'

--METADATA NAME:ndx_tsdates_dsi TYPE:INDEX TABLE_NAME:TSDATES CHANGE:CREATE
CREATE  INDEX ndx_tsdates_dsi
ON TSDATES (delete_session_id,delete_date)
go

print 'Creating index ndx_tsdates_upd on table TSDATES'

--METADATA NAME:ndx_tsdates_upd TYPE:INDEX TABLE_NAME:TSDATES CHANGE:CREATE
CREATE  INDEX ndx_tsdates_upd
ON TSDATES (update_date,delete_session_id)
go

print 'Creating index ndx_tsdelegate_1 on table TSDELEGATE'

--METADATA NAME:ndx_tsdelegate_1 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE  INDEX ndx_tsdelegate_1
ON TSDELEGATE (proj_id)
go

print 'Creating index ndx_tsdelegate_users1 on table TSDELEGATE'

--METADATA NAME:ndx_tsdelegate_users1 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE  INDEX ndx_tsdelegate_users1
ON TSDELEGATE (user_id)
go

print 'Creating index ndx_tsdelegate_users2 on table TSDELEGATE'

--METADATA NAME:ndx_tsdelegate_users2 TYPE:INDEX TABLE_NAME:TSDELEGATE CHANGE:CREATE
CREATE  INDEX ndx_tsdelegate_users2
ON TSDELEGATE (ts_delegate_user_id)
go

print 'Creating index ndx_uaccess_project on table UACCESS'

--METADATA NAME:ndx_uaccess_project TYPE:INDEX TABLE_NAME:UACCESS CHANGE:CREATE
CREATE  INDEX ndx_uaccess_project
ON UACCESS (proj_id)
go

print 'Creating index ndx_uaccess_user_wbs on table UACCESS'

--METADATA NAME:ndx_uaccess_user_wbs TYPE:INDEX TABLE_NAME:UACCESS CHANGE:CREATE
CREATE  INDEX ndx_uaccess_user_wbs
ON UACCESS (user_id,wbs_id)
go

print 'Creating index ndx_uaccess_user_parent on table UACCESS'

--METADATA NAME:ndx_uaccess_user_parent TYPE:INDEX TABLE_NAME:UACCESS CHANGE:CREATE
CREATE  INDEX ndx_uaccess_user_parent
ON UACCESS (user_id,parent_wbs_id)
go

print 'Creating index ndx_udfcode_udf_type_id on table UDFCODE'

--METADATA NAME:ndx_udfcode_udf_type_id TYPE:INDEX TABLE_NAME:UDFCODE CHANGE:CREATE
CREATE  INDEX ndx_udfcode_udf_type_id
ON UDFCODE (udf_type_id)
go

print 'Creating index ndx_udfcode_dsi on table UDFCODE'

--METADATA NAME:ndx_udfcode_dsi TYPE:INDEX TABLE_NAME:UDFCODE CHANGE:CREATE
CREATE  INDEX ndx_udfcode_dsi
ON UDFCODE (delete_session_id,delete_date)
go

print 'Creating index ndx_udfcode_upd on table UDFCODE'

--METADATA NAME:ndx_udfcode_upd TYPE:INDEX TABLE_NAME:UDFCODE CHANGE:CREATE
CREATE  INDEX ndx_udfcode_upd
ON UDFCODE (update_date,delete_session_id)
go

print 'Creating index ndx_udftype_table_name on table UDFTYPE'

--METADATA NAME:ndx_udftype_table_name TYPE:INDEX TABLE_NAME:UDFTYPE CHANGE:CREATE
CREATE  INDEX ndx_udftype_table_name
ON UDFTYPE (table_name)
go

print 'Creating index ndx_udftype_dsi on table UDFTYPE'

--METADATA NAME:ndx_udftype_dsi TYPE:INDEX TABLE_NAME:UDFTYPE CHANGE:CREATE
CREATE  INDEX ndx_udftype_dsi
ON UDFTYPE (delete_session_id,delete_date)
go

print 'Creating index ndx_udftype_upd on table UDFTYPE'

--METADATA NAME:ndx_udftype_upd TYPE:INDEX TABLE_NAME:UDFTYPE CHANGE:CREATE
CREATE  INDEX ndx_udftype_upd
ON UDFTYPE (update_date,delete_session_id)
go

print 'Creating index ndx_udfvalue_project on table UDFVALUE'

--METADATA NAME:ndx_udfvalue_project TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE  INDEX ndx_udfvalue_project
ON UDFVALUE (proj_id)
go

print 'Creating index ndx_udfvalue_fk on table UDFVALUE'

--METADATA NAME:ndx_udfvalue_fk TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE  INDEX ndx_udfvalue_fk
ON UDFVALUE (fk_id)
go

print 'Creating index ndx_udfvalue_update_date1 on table UDFVALUE'

--METADATA NAME:ndx_udfvalue_update_date1 TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE  INDEX ndx_udfvalue_update_date1
ON UDFVALUE (update_date)
go

print 'Creating index ndx_udfvalue_udfcode on table UDFVALUE'

--METADATA NAME:ndx_udfvalue_udfcode TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE  INDEX ndx_udfvalue_udfcode
ON UDFVALUE (udf_code_id)
go

print 'Creating index ndx_udfvalue_dsi on table UDFVALUE'

--METADATA NAME:ndx_udfvalue_dsi TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE  INDEX ndx_udfvalue_dsi
ON UDFVALUE (delete_session_id,delete_date)
go

print 'Creating index ndx_udfvalue_upd on table UDFVALUE'

--METADATA NAME:ndx_udfvalue_upd TYPE:INDEX TABLE_NAME:UDFVALUE CHANGE:CREATE
CREATE  INDEX ndx_udfvalue_upd
ON UDFVALUE (update_date,delete_session_id)
go

print 'Creating index ndx_uevntreg_users on table UEVNTREG'

--METADATA NAME:ndx_uevntreg_users TYPE:INDEX TABLE_NAME:UEVNTREG CHANGE:CREATE
CREATE  INDEX ndx_uevntreg_users
ON UEVNTREG (user_id)
go

print 'Creating index ndx_uevntreg_user_name on table UEVNTREG'

--METADATA NAME:ndx_uevntreg_user_name TYPE:INDEX TABLE_NAME:UEVNTREG CHANGE:CREATE
CREATE  INDEX ndx_uevntreg_user_name
ON UEVNTREG (user_name)
go

print 'Creating index ndx_umeasure_dsi on table UMEASURE'

--METADATA NAME:ndx_umeasure_dsi TYPE:INDEX TABLE_NAME:UMEASURE CHANGE:CREATE
CREATE  INDEX ndx_umeasure_dsi
ON UMEASURE (delete_session_id,delete_date)
go

print 'Creating index ndx_umeasure_upd on table UMEASURE'

--METADATA NAME:ndx_umeasure_upd TYPE:INDEX TABLE_NAME:UMEASURE CHANGE:CREATE
CREATE  INDEX ndx_umeasure_upd
ON UMEASURE (update_date,delete_session_id)
go

print 'Creating index ndx_upklist_session_pk on table UPKLIST'

--METADATA NAME:ndx_upklist_session_pk TYPE:INDEX TABLE_NAME:UPKLIST CHANGE:CREATE
CREATE  INDEX ndx_upklist_session_pk
ON UPKLIST (session_id,pk_id)
go

print 'Creating index ndx_usercol_dsi on table USERCOL'

--METADATA NAME:ndx_usercol_dsi TYPE:INDEX TABLE_NAME:USERCOL CHANGE:CREATE
CREATE  INDEX ndx_usercol_dsi
ON USERCOL (delete_session_id,delete_date)
go

print 'Creating index ndx_usercol_upd on table USERCOL'

--METADATA NAME:ndx_usercol_upd TYPE:INDEX TABLE_NAME:USERCOL CHANGE:CREATE
CREATE  INDEX ndx_usercol_upd
ON USERCOL (update_date,delete_session_id)
go

print 'Creating index ndx_userdata_1 on table USERDATA'

--METADATA NAME:ndx_userdata_1 TYPE:INDEX TABLE_NAME:USERDATA CHANGE:CREATE
CREATE  INDEX ndx_userdata_1
ON USERDATA (user_id)
go

print 'Creating index ndx_userdata_dsi on table USERDATA'

--METADATA NAME:ndx_userdata_dsi TYPE:INDEX TABLE_NAME:USERDATA CHANGE:CREATE
CREATE  INDEX ndx_userdata_dsi
ON USERDATA (delete_session_id,delete_date)
go

print 'Creating index ndx_userdata_upd on table USERDATA'

--METADATA NAME:ndx_userdata_upd TYPE:INDEX TABLE_NAME:USERDATA CHANGE:CREATE
CREATE  INDEX ndx_userdata_upd
ON USERDATA (update_date,delete_session_id)
go

print 'Creating index ndx_usereng_users on table USERENG'

--METADATA NAME:ndx_usereng_users TYPE:INDEX TABLE_NAME:USERENG CHANGE:CREATE
CREATE  INDEX ndx_usereng_users
ON USERENG (user_id)
go

print 'Creating index ndx_usereng_dsi on table USERENG'

--METADATA NAME:ndx_usereng_dsi TYPE:INDEX TABLE_NAME:USERENG CHANGE:CREATE
CREATE  INDEX ndx_usereng_dsi
ON USERENG (delete_session_id,delete_date)
go

print 'Creating index ndx_usereng_upd on table USERENG'

--METADATA NAME:ndx_usereng_upd TYPE:INDEX TABLE_NAME:USERENG CHANGE:CREATE
CREATE  INDEX ndx_usereng_upd
ON USERENG (update_date,delete_session_id)
go

print 'Creating index ndx_userobs_obs on table USEROBS'

--METADATA NAME:ndx_userobs_obs TYPE:INDEX TABLE_NAME:USEROBS CHANGE:CREATE
CREATE  INDEX ndx_userobs_obs
ON USEROBS (obs_id)
go

print 'Creating index ndx_userobs_profile on table USEROBS'

--METADATA NAME:ndx_userobs_profile TYPE:INDEX TABLE_NAME:USEROBS CHANGE:CREATE
CREATE  INDEX ndx_userobs_profile
ON USEROBS (prof_id)
go

print 'Creating index ndx_userobs_dsi on table USEROBS'

--METADATA NAME:ndx_userobs_dsi TYPE:INDEX TABLE_NAME:USEROBS CHANGE:CREATE
CREATE  INDEX ndx_userobs_dsi
ON USEROBS (delete_session_id,delete_date)
go

print 'Creating index ndx_userobs_upd on table USEROBS'

--METADATA NAME:ndx_userobs_upd TYPE:INDEX TABLE_NAME:USEROBS CHANGE:CREATE
CREATE  INDEX ndx_userobs_upd
ON USEROBS (update_date,delete_session_id)
go

print 'Creating index ndx_useropen_users on table USEROPEN'

--METADATA NAME:ndx_useropen_users TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE UNIQUE  INDEX ndx_useropen_users
ON USEROPEN (user_id,user_open_name,delete_session_id)
go

print 'Creating index ndx_useropen_dsi on table USEROPEN'

--METADATA NAME:ndx_useropen_dsi TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE  INDEX ndx_useropen_dsi
ON USEROPEN (delete_session_id,delete_date)
go

print 'Creating index ndx_useropen_upd on table USEROPEN'

--METADATA NAME:ndx_useropen_upd TYPE:INDEX TABLE_NAME:USEROPEN CHANGE:CREATE
CREATE  INDEX ndx_useropen_upd
ON USEROPEN (update_date,delete_session_id)
go

print 'Creating index ndx_users_profile on table USERS'

--METADATA NAME:ndx_users_profile TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE  INDEX ndx_users_profile
ON USERS (prof_id)
go

print 'Creating index ndx_users_dsi on table USERS'

--METADATA NAME:ndx_users_dsi TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE  INDEX ndx_users_dsi
ON USERS (delete_session_id,delete_date)
go

print 'Creating index ndx_users_upd on table USERS'

--METADATA NAME:ndx_users_upd TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE  INDEX ndx_users_upd
ON USERS (update_date,delete_session_id)
go

print 'Creating index ndx_users_curr on table USERS'

--METADATA NAME:ndx_users_curr TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE  INDEX ndx_users_curr
ON USERS (curr_id)
go

print 'Creating index ndx_userset_dsi on table USERSET'

--METADATA NAME:ndx_userset_dsi TYPE:INDEX TABLE_NAME:USERSET CHANGE:CREATE
CREATE  INDEX ndx_userset_dsi
ON USERSET (delete_session_id,delete_date)
go

print 'Creating index ndx_userset_user on table USERSET'

--METADATA NAME:ndx_userset_user TYPE:INDEX TABLE_NAME:USERSET CHANGE:CREATE
CREATE  INDEX ndx_userset_user
ON USERSET (user_id)
go

print 'Creating index ndx_userwksp_project on table USERWKSP'

--METADATA NAME:ndx_userwksp_project TYPE:INDEX TABLE_NAME:USERWKSP CHANGE:CREATE
CREATE  INDEX ndx_userwksp_project
ON USERWKSP (proj_id)
go

print 'Creating index ndx_userwksp_workspace on table USERWKSP'

--METADATA NAME:ndx_userwksp_workspace TYPE:INDEX TABLE_NAME:USERWKSP CHANGE:CREATE
CREATE  INDEX ndx_userwksp_workspace
ON USERWKSP (workspace_id)
go

print 'Creating index ndx_userwksp_dsi on table USERWKSP'

--METADATA NAME:ndx_userwksp_dsi TYPE:INDEX TABLE_NAME:USERWKSP CHANGE:CREATE
CREATE  INDEX ndx_userwksp_dsi
ON USERWKSP (delete_session_id,delete_date)
go

print 'Creating index ndx_usessaud_logout_date on table USESSAUD'

--METADATA NAME:ndx_usessaud_logout_date TYPE:INDEX TABLE_NAME:USESSAUD CHANGE:CREATE
CREATE  INDEX ndx_usessaud_logout_date
ON USESSAUD (logout_date)
go

print 'Creating index ndx_usession_users on table USESSION'

--METADATA NAME:ndx_usession_users TYPE:INDEX TABLE_NAME:USESSION CHANGE:CREATE
CREATE  INDEX ndx_usession_users
ON USESSION (user_id)
go

print 'Creating index ndx_usession_spid on table USESSION'

--METADATA NAME:ndx_usession_spid TYPE:INDEX TABLE_NAME:USESSION CHANGE:CREATE
CREATE  INDEX ndx_usession_spid
ON USESSION (spid,user_id,delete_session_id)
go

print 'Creating index ndx_ussesion_dsi on table USESSION'

--METADATA NAME:ndx_ussesion_dsi TYPE:INDEX TABLE_NAME:USESSION CHANGE:CREATE
CREATE  INDEX ndx_ussesion_dsi
ON USESSION (delete_session_id,delete_date)
go

print 'Creating index ndx_usropnval_user_open_id on table USROPNVAL'

--METADATA NAME:ndx_usropnval_user_open_id TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE  INDEX ndx_usropnval_user_open_id
ON USROPNVAL (user_open_id)
go

print 'Creating index ndx_usropnval_dsi on table USROPNVAL'

--METADATA NAME:ndx_usropnval_dsi TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE  INDEX ndx_usropnval_dsi
ON USROPNVAL (delete_session_id,delete_date)
go

print 'Creating index ndx_usropnval_upd on table USROPNVAL'

--METADATA NAME:ndx_usropnval_upd TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE  INDEX ndx_usropnval_upd
ON USROPNVAL (update_date,delete_session_id)
go

print 'Creating index ndx_viewpref_user on table VIEWPREF'

--METADATA NAME:ndx_viewpref_user TYPE:INDEX TABLE_NAME:VIEWPREF CHANGE:CREATE
CREATE  INDEX ndx_viewpref_user
ON VIEWPREF (user_id)
go

print 'Creating index ndx_viewpref_type on table VIEWPREF'

--METADATA NAME:ndx_viewpref_type TYPE:INDEX TABLE_NAME:VIEWPREF CHANGE:CREATE
CREATE  INDEX ndx_viewpref_type
ON VIEWPREF (view_pref_type,user_id)
go

print 'Creating index ndx_viewpref_dsi on table VIEWPREF'

--METADATA NAME:ndx_viewpref_dsi TYPE:INDEX TABLE_NAME:VIEWPREF CHANGE:CREATE
CREATE  INDEX ndx_viewpref_dsi
ON VIEWPREF (delete_session_id,delete_date)
go

print 'Creating index ndx_viewpref_upd on table VIEWPREF'

--METADATA NAME:ndx_viewpref_upd TYPE:INDEX TABLE_NAME:VIEWPREF CHANGE:CREATE
CREATE  INDEX ndx_viewpref_upd
ON VIEWPREF (update_date,delete_session_id)
go

print 'Creating index ndx_viewprop_1 on table VIEWPROP'

--METADATA NAME:ndx_viewprop_1 TYPE:INDEX TABLE_NAME:VIEWPROP CHANGE:CREATE
CREATE  INDEX ndx_viewprop_1
ON VIEWPROP (user_id)
go

print 'Creating index ndx_viewprop_project on table VIEWPROP'

--METADATA NAME:ndx_viewprop_project TYPE:INDEX TABLE_NAME:VIEWPROP CHANGE:CREATE
CREATE  INDEX ndx_viewprop_project
ON VIEWPROP (proj_id)
go

print 'Creating index ndx_viewprop_dsi on table VIEWPROP'

--METADATA NAME:ndx_viewprop_dsi TYPE:INDEX TABLE_NAME:VIEWPROP CHANGE:CREATE
CREATE  INDEX ndx_viewprop_dsi
ON VIEWPROP (delete_session_id,delete_date)
go

print 'Creating index ndx_viewprop_upd on table VIEWPROP'

--METADATA NAME:ndx_viewprop_upd TYPE:INDEX TABLE_NAME:VIEWPROP CHANGE:CREATE
CREATE  INDEX ndx_viewprop_upd
ON VIEWPROP (update_date,delete_session_id)
go

print 'Creating index ndx_vwprefdash_viewpref on table VWPREFDASH'

--METADATA NAME:ndx_vwprefdash_viewpref TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE  INDEX ndx_vwprefdash_viewpref
ON VWPREFDASH (view_pref_id,dashboard_id)
go

print 'Creating index ndx_vwprefdash_dsi on table VWPREFDASH'

--METADATA NAME:ndx_vwprefdash_dsi TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE  INDEX ndx_vwprefdash_dsi
ON VWPREFDASH (delete_session_id,delete_date)
go

print 'Creating index ndx_vwprefdash_upd on table VWPREFDASH'

--METADATA NAME:ndx_vwprefdash_upd TYPE:INDEX TABLE_NAME:VWPREFDASH CHANGE:CREATE
CREATE  INDEX ndx_vwprefdash_upd
ON VWPREFDASH (update_date,delete_session_id)
go

print 'Creating index ndx_vwprefdata_dsi on table VWPREFDATA'

--METADATA NAME:ndx_vwprefdata_dsi TYPE:INDEX TABLE_NAME:VWPREFDATA CHANGE:CREATE
CREATE  INDEX ndx_vwprefdata_dsi
ON VWPREFDATA (delete_session_id,delete_date)
go

print 'Creating index ndx_vwprefdata_upd on table VWPREFDATA'

--METADATA NAME:ndx_vwprefdata_upd TYPE:INDEX TABLE_NAME:VWPREFDATA CHANGE:CREATE
CREATE  INDEX ndx_vwprefdata_upd
ON VWPREFDATA (update_date,delete_session_id)
go

print 'Creating index ndx_vwprefuser_users on table VWPREFUSER'

--METADATA NAME:ndx_vwprefuser_users TYPE:INDEX TABLE_NAME:VWPREFUSER CHANGE:CREATE
CREATE  INDEX ndx_vwprefuser_users
ON VWPREFUSER (user_id,view_pref_id)
go

print 'Creating index ndx_vwprefuser_dsi on table VWPREFUSER'

--METADATA NAME:ndx_vwprefuser_dsi TYPE:INDEX TABLE_NAME:VWPREFUSER CHANGE:CREATE
CREATE  INDEX ndx_vwprefuser_dsi
ON VWPREFUSER (delete_session_id,delete_date)
go

print 'Creating index ndx_vwprefuser_upd on table VWPREFUSER'

--METADATA NAME:ndx_vwprefuser_upd TYPE:INDEX TABLE_NAME:VWPREFUSER CHANGE:CREATE
CREATE  INDEX ndx_vwprefuser_upd
ON VWPREFUSER (update_date,delete_session_id)
go

print 'Creating index ndx_wbrscat_dsi on table WBRSCAT'

--METADATA NAME:ndx_wbrscat_dsi TYPE:INDEX TABLE_NAME:WBRSCAT CHANGE:CREATE
CREATE  INDEX ndx_wbrscat_dsi
ON WBRSCAT (delete_session_id,delete_date)
go

print 'Creating index ndx_wbsbudg_1 on table WBSBUDG'

--METADATA NAME:ndx_wbsbudg_1 TYPE:INDEX TABLE_NAME:WBSBUDG CHANGE:CREATE
CREATE  INDEX ndx_wbsbudg_1
ON WBSBUDG (proj_id)
go

print 'Creating index ndx_wbsbudg_2 on table WBSBUDG'

--METADATA NAME:ndx_wbsbudg_2 TYPE:INDEX TABLE_NAME:WBSBUDG CHANGE:CREATE
CREATE  INDEX ndx_wbsbudg_2
ON WBSBUDG (wbs_id)
go

print 'Creating index ndx_wbsbudg_dsi on table WBSBUDG'

--METADATA NAME:ndx_wbsbudg_dsi TYPE:INDEX TABLE_NAME:WBSBUDG CHANGE:CREATE
CREATE  INDEX ndx_wbsbudg_dsi
ON WBSBUDG (delete_session_id,delete_date)
go

print 'Creating index ndx_wbsbudg_upd on table WBSBUDG'

--METADATA NAME:ndx_wbsbudg_upd TYPE:INDEX TABLE_NAME:WBSBUDG CHANGE:CREATE
CREATE  INDEX ndx_wbsbudg_upd
ON WBSBUDG (update_date,delete_session_id)
go

print 'Creating index ndx_wbsmemo_1 on table WBSMEMO'

--METADATA NAME:ndx_wbsmemo_1 TYPE:INDEX TABLE_NAME:WBSMEMO CHANGE:CREATE
CREATE  INDEX ndx_wbsmemo_1
ON WBSMEMO (proj_id)
go

print 'Creating index ndx_wbsmemo_2 on table WBSMEMO'

--METADATA NAME:ndx_wbsmemo_2 TYPE:INDEX TABLE_NAME:WBSMEMO CHANGE:CREATE
CREATE  INDEX ndx_wbsmemo_2
ON WBSMEMO (wbs_id)
go

print 'Creating index ndx_wbsmemo_memotype on table WBSMEMO'

--METADATA NAME:ndx_wbsmemo_memotype TYPE:INDEX TABLE_NAME:WBSMEMO CHANGE:CREATE
CREATE  INDEX ndx_wbsmemo_memotype
ON WBSMEMO (memo_type_id)
go

print 'Creating index ndx_wbsmemo_dsi on table WBSMEMO'

--METADATA NAME:ndx_wbsmemo_dsi TYPE:INDEX TABLE_NAME:WBSMEMO CHANGE:CREATE
CREATE  INDEX ndx_wbsmemo_dsi
ON WBSMEMO (delete_session_id,delete_date)
go

print 'Creating index ndx_wbsrsrc_project on table WBSRSRC'

--METADATA NAME:ndx_wbsrsrc_project TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_project
ON WBSRSRC (proj_id)
go

print 'Creating index ndx_wbsrsrc_projwbs on table WBSRSRC'

--METADATA NAME:ndx_wbsrsrc_projwbs TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_projwbs
ON WBSRSRC (wbs_id)
go

print 'Creating index ndx_wbsrsrc_rsrc on table WBSRSRC'

--METADATA NAME:ndx_wbsrsrc_rsrc TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_rsrc
ON WBSRSRC (rsrc_id)
go

print 'Creating index ndx_wbsrsrc_wbrscat on table WBSRSRC'

--METADATA NAME:ndx_wbsrsrc_wbrscat TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_wbrscat
ON WBSRSRC (wbrs_cat_id)
go

print 'Creating index ndx_wbsrsrc_role on table WBSRSRC'

--METADATA NAME:ndx_wbsrsrc_role TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_role
ON WBSRSRC (role_id)
go

print 'Creating index ndx_wbsrsrc_dsi on table WBSRSRC'

--METADATA NAME:ndx_wbsrsrc_dsi TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_dsi
ON WBSRSRC (delete_session_id,delete_date)
go

print 'Creating index ndx_wbsrsrc_qty_dsi on table WBSRSRC_QTY'

--METADATA NAME:ndx_wbsrsrc_qty_dsi TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_qty_dsi
ON WBSRSRC_QTY (delete_session_id,delete_date)
go

print 'Creating index ndx_wbsrsrc_qty_fin_dates_id2 on table WBSRSRC_QTY'

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id2 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_qty_fin_dates_id2
ON WBSRSRC_QTY (fin_dates_id2)
go

print 'Creating index ndx_wbsrsrc_qty_fin_dates_id1 on table WBSRSRC_QTY'

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id1 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_qty_fin_dates_id1
ON WBSRSRC_QTY (fin_dates_id1)
go

print 'Creating index ndx_wbsstep_1 on table WBSSTEP'

--METADATA NAME:ndx_wbsstep_1 TYPE:INDEX TABLE_NAME:WBSSTEP CHANGE:CREATE
CREATE  INDEX ndx_wbsstep_1
ON WBSSTEP (proj_id)
go

print 'Creating index ndx_wbsstep_2 on table WBSSTEP'

--METADATA NAME:ndx_wbsstep_2 TYPE:INDEX TABLE_NAME:WBSSTEP CHANGE:CREATE
CREATE  INDEX ndx_wbsstep_2
ON WBSSTEP (wbs_id)
go

print 'Creating index ndx_wbsstep_dsi on table WBSSTEP'

--METADATA NAME:ndx_wbsstep_dsi TYPE:INDEX TABLE_NAME:WBSSTEP CHANGE:CREATE
CREATE  INDEX ndx_wbsstep_dsi
ON WBSSTEP (delete_session_id,delete_date)
go

print 'Creating index ndx_wkfltmpl_tmplcatg on table WKFLTMPL'

--METADATA NAME:ndx_wkfltmpl_tmplcatg TYPE:INDEX TABLE_NAME:WKFLTMPL CHANGE:CREATE
CREATE  INDEX ndx_wkfltmpl_tmplcatg
ON WKFLTMPL (tmplcatg_catg_id,delete_session_id)
go

print 'Creating index ndx_wkfltmpl_dsi on table WKFLTMPL'

--METADATA NAME:ndx_wkfltmpl_dsi TYPE:INDEX TABLE_NAME:WKFLTMPL CHANGE:CREATE
CREATE  INDEX ndx_wkfltmpl_dsi
ON WKFLTMPL (delete_session_id,delete_date)
go

print 'Creating index ndx_wkfluser_workflow on table WKFLUSER'

--METADATA NAME:ndx_wkfluser_workflow TYPE:INDEX TABLE_NAME:WKFLUSER CHANGE:CREATE
CREATE  INDEX ndx_wkfluser_workflow
ON WKFLUSER (work_flow_id)
go

print 'Creating index ndx_wkfluser_users on table WKFLUSER'

--METADATA NAME:ndx_wkfluser_users TYPE:INDEX TABLE_NAME:WKFLUSER CHANGE:CREATE
CREATE  INDEX ndx_wkfluser_users
ON WKFLUSER (user_id)
go

print 'Creating index ndx_wkfluser_dsi on table WKFLUSER'

--METADATA NAME:ndx_wkfluser_dsi TYPE:INDEX TABLE_NAME:WKFLUSER CHANGE:CREATE
CREATE  INDEX ndx_wkfluser_dsi
ON WKFLUSER (delete_session_id,delete_date)
go

print 'Creating index ndx_workflow_project on table WORKFLOW'

--METADATA NAME:ndx_workflow_project TYPE:INDEX TABLE_NAME:WORKFLOW CHANGE:CREATE
CREATE  INDEX ndx_workflow_project
ON WORKFLOW (proj_id)
go

print 'Creating index ndx_workflow_users on table WORKFLOW'

--METADATA NAME:ndx_workflow_users TYPE:INDEX TABLE_NAME:WORKFLOW CHANGE:CREATE
CREATE  INDEX ndx_workflow_users
ON WORKFLOW (user_id)
go

print 'Creating index ndx_workflow_workspace on table WORKFLOW'

--METADATA NAME:ndx_workflow_workspace TYPE:INDEX TABLE_NAME:WORKFLOW CHANGE:CREATE
CREATE  INDEX ndx_workflow_workspace
ON WORKFLOW (workspace_id)
go

print 'Creating index ndx_workflow_dsi on table WORKFLOW'

--METADATA NAME:ndx_workflow_dsi TYPE:INDEX TABLE_NAME:WORKFLOW CHANGE:CREATE
CREATE  INDEX ndx_workflow_dsi
ON WORKFLOW (delete_session_id,delete_date)
go

print 'Creating index ndx_workspace_project on table WORKSPACE'

--METADATA NAME:ndx_workspace_project TYPE:INDEX TABLE_NAME:WORKSPACE CHANGE:CREATE
CREATE  INDEX ndx_workspace_project
ON WORKSPACE (proj_id)
go

print 'Creating index ndx_workspace_dsi on table WORKSPACE'

--METADATA NAME:ndx_workspace_dsi TYPE:INDEX TABLE_NAME:WORKSPACE CHANGE:CREATE
CREATE  INDEX ndx_workspace_dsi
ON WORKSPACE (delete_session_id,delete_date)
go
