/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util;

import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.NodeLink;
import com.primavera.database.tools.dbmt.xml.util.SimpleHandler;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.ContextNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.menus.MenuNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.workflow.SchemaNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class GenerateStringProperties {
    private static final NodeLink createStartHandler(final PrintStream out) {
        return new NodeLink(){

            @Override
            public NodeHandler nextNode(String elemName, Attributes attr) {
                if ("context".equals(elemName)) {
                    return new ContextNode(attr, out);
                }
                if ("menu".equals(elemName)) {
                    return new MenuNode(attr, out);
                }
                if ("schema".equals(elemName)) {
                    return new SchemaNode(attr, out);
                }
                return null;
            }

            @Override
            public String path() {
                return "";
            }
        };
    }

    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                System.err.println("Please specify an Action XML file to create strings from");
                System.exit(1);
            }
            HashSet<File> actionXmlFiles = new HashSet<File>();
            for (int i = 0; i < args.length - 1; ++i) {
                File actionXmlFile = new File(args[i]);
                if (!actionXmlFile.exists()) {
                    System.err.println("The file " + actionXmlFile.getAbsolutePath() + " could not be found");
                    continue;
                }
                actionXmlFiles.add(actionXmlFile);
            }
            PrintStream propStream = System.out;
            if (args.length > 1 && !args[args.length - 1].equals("-")) {
                File outFile = new File(args[args.length - 1]);
                if (!outFile.exists()) {
                    outFile.createNewFile();
                }
                propStream = new PrintStream(new FileOutputStream(outFile));
            }
            NodeLink start = GenerateStringProperties.createStartHandler(propStream);
            SimpleHandler handler = new SimpleHandler(start);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            for (File file : actionXmlFiles) {
                parser.parse(file, (DefaultHandler)handler);
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

