/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.CustomColumnUtil;
import com.primavera.database.tools.RetrieveExpCustomFieldInfo;
import com.primavera.database.tools.ScriptRunner.ScriptEvent;
import com.primavera.database.tools.ScriptRunner.ScriptFile;
import com.primavera.database.tools.ScriptRunner.ScriptListener;
import com.primavera.database.tools.ScriptRunner.ScriptRunner;
import com.primavera.database.tools.dbmt.AbstractJob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public abstract class ExpeditionCustomColumnJob<T>
extends AbstractJob {
    private final String m_targetConnection;
    private final RetrieveExpCustomFieldInfo<T> m_customColumnRetriever;
    private final ServerType m_dbType;
    private final CustomColumnUtil.WorklistCreator<T> m_creator;

    public ExpeditionCustomColumnJob(RetrieveExpCustomFieldInfo<T> customColumnRetriever, CustomColumnUtil.WorklistCreator<T> creator, String targetConnection) {
        ConnectStringParse parse = new ConnectStringParse(targetConnection);
        this.m_dbType = parse.getDbtype();
        this.m_creator = creator;
        this.m_targetConnection = targetConnection;
        this.m_customColumnRetriever = customColumnRetriever;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        CustomColumnUtil<T> customColumnScriptUtil = new CustomColumnUtil<T>();
        InputStream xsltStream = ClassLoader.getSystemClassLoader().getResourceAsStream("ddl_generator.xsl");
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer trans = factory.newTransformer(new StreamSource(xsltStream));
        final String updateScript = customColumnScriptUtil.createCustomColumnScript(this.m_customColumnRetriever, this.m_creator, this.m_dbType, trans);
        DBMTLogger.info(Channel.DEV, "The script file to run is " + updateScript);
        ScriptRunner runner = new ScriptRunner();
        runner.setContinueOnError(false);
        DatabaseConnection connection = new DatabaseConnection(this.m_targetConnection);
        runner.setDbconn(connection);
        ScriptFile.InputStreamFactory inputStreamFactory = new ScriptFile.InputStreamFactory(){

            @Override
            public InputStream createInputStream() throws IOException {
                return new ByteArrayInputStream(updateScript.getBytes());
            }

            @Override
            public String getLocation() {
                return "No Location";
            }
        };
        runner.setScriptInputStreamFactory(inputStreamFactory);
        runner.addListener(this.getScriptListener(listener));
        try {
            if (!watcher.isContinue()) {
                boolean bl = false;
                return bl;
            }
            runner.run();
        }
        finally {
            connection.close();
            connection = null;
        }
        return true;
    }

    private ScriptListener getScriptListener(final JobListener listener) {
        return new ScriptListener(){

            @Override
            public void scriptBegin(ScriptEvent event) {
                listener.jobProgressed(0, event.getTotalStatements());
            }

            @Override
            public void scriptComplete(ScriptEvent event) {
                listener.jobProgressed(event.getTotalStatements(), event.getTotalStatements());
            }

            @Override
            public void scriptError(ScriptEvent event) {
            }

            @Override
            public void scriptEvent(ScriptEvent event) {
            }

            @Override
            public void statementBegin(ScriptEvent event) {
                listener.jobProgressed(event.getProcessedStatements(), event.getTotalStatements());
                DBMTLogger.info(event.getScriptStatement().getLastSQL());
            }

            @Override
            public void statementComplete(ScriptEvent event) {
            }
        };
    }

    @Override
    public boolean isIndeterminateProgress() {
        return true;
    }
}

