/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.tools.dbmt.gui.PageLayoutLogic;
import com.primavera.database.tools.dbmt.gui.dialogs.LayoutContext;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ORCreateUsersLayout
extends PageLayoutLogic {
    protected final String USER_NAME_TEXTPANEL = "textpanel";
    protected final String USER_NAME_LISTPANEL = "listpanel";
    private static final int LABEL_WIDTH = 200;
    JPanel m_diffPasswdPanel;
    JPanel m_samePasswdPanel;
    JRadioButton m_samepasswdradioButton;
    JRadioButton m_diffPasswdRadioButton;

    protected String[][] getComponentsIDs() {
        String[][] comps = new String[][]{{"admuser", "admpass", "admpassconfirm"}, {"privuser", "privpass", "privpassconfirm"}, {"pubuser", "pubpass", "pubpassconfirm"}, {"bgjobuser", "bgjobpass", "bgjobpassconfirm"}, {"pxrptuser", "pxrptpass", "pxrptpassconfirm"}};
        return comps;
    }

    protected String[] getHeaderIds() {
        return new String[]{"username", "password", "confirmPassword"};
    }

    @Override
    public void layoutPanel(LayoutContext context) {
        this.initComponents(context);
        JPanel contentPane = context.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.m_diffPasswdPanel.setBorder(null);
        contentPane.add((Component)this.m_diffPasswdPanel, "North");
    }

    public void layoutPanel2(LayoutContext context) {
        this.initComponents(context);
        JPanel contentPane = context.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.createLeftJustifiedPanel(this.m_diffPasswdRadioButton));
        contentPane.add(this.m_diffPasswdPanel);
        contentPane.add(Box.createVerticalStrut(15));
        contentPane.add(this.createLeftJustifiedPanel(this.m_samepasswdradioButton));
        contentPane.add(this.m_samePasswdPanel);
        JCheckBox jcbUsediffpasswd = (JCheckBox)context.getBinding("usediffpasswd").getComponents()[0];
        if (jcbUsediffpasswd.isSelected()) {
            this.m_diffPasswdRadioButton.doClick();
        } else {
            this.m_samepasswdradioButton.doClick();
        }
    }

    protected void initComponents(final LayoutContext context) {
        String samePasswdLbl = context.getName("usesamepasswd");
        String diffPasswdLbl = context.getName("usediffpasswd");
        this.m_samepasswdradioButton = new JRadioButton(samePasswdLbl);
        this.m_diffPasswdRadioButton = new JRadioButton(diffPasswdLbl);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_diffPasswdRadioButton);
        group.add(this.m_samepasswdradioButton);
        this.m_diffPasswdPanel = this.initDiffPasswdPanel(context);
        this.m_samePasswdPanel = this.initSamePasswdPanel(context);
        ActionListener radioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean useDiffPasswd = ORCreateUsersLayout.this.m_diffPasswdRadioButton.isSelected();
                ORCreateUsersLayout.this.enableComponents(ORCreateUsersLayout.this.m_diffPasswdPanel, useDiffPasswd);
                ORCreateUsersLayout.this.enableComponents(ORCreateUsersLayout.this.m_samePasswdPanel, !useDiffPasswd);
                JCheckBox jcbUsediffpasswd = (JCheckBox)context.getBinding("usediffpasswd").getComponents()[0];
                jcbUsediffpasswd.setSelected(useDiffPasswd);
                JCheckBox jcbUsesamepasswd = (JCheckBox)context.getBinding("usesamepasswd").getComponents()[0];
                jcbUsesamepasswd.setSelected(!useDiffPasswd);
            }
        };
        this.m_diffPasswdRadioButton.addActionListener(radioButtonListener);
        this.m_samepasswdradioButton.addActionListener(radioButtonListener);
    }

    private void enableComponents(Component container, boolean isSelected) {
        container.setEnabled(isSelected);
        if (container instanceof Container) {
            Component[] subComps;
            for (Component subComp : subComps = ((Container)container).getComponents()) {
                this.enableComponents(subComp, isSelected);
            }
        }
    }

    private JPanel initSamePasswdPanel(LayoutContext context) {
        String[][] comps = new String[][]{{"password"}, {"confirmPassword"}};
        return this.initPanelComponents(context, comps);
    }

    private JPanel initPanelComponents(LayoutContext context, String[][] comps) {
        JPanel center = new JPanel();
        int rowCnt = comps.length;
        center.setLayout(new GridLayout(rowCnt, 1, 3, 3));
        for (String[] comp : comps) {
            center.add(this.getPanel(context, comp));
        }
        center.setBorder(BorderFactory.createTitledBorder(""));
        return center;
    }

    private void setPreferredLableSize(JComponent lbl) {
        Dimension d = lbl.getPreferredSize();
        lbl.setPreferredSize(new Dimension(200, d.height));
    }

    private JPanel initDiffPasswdPanel(LayoutContext context) {
        String[][] comps = this.getComponentsIDs();
        JPanel center = new JPanel();
        int rowCnts = comps.length + 1;
        center.setLayout(new GridLayout(rowCnts, 1, 3, 3));
        center.add(this.getColumnHeaderPanel(context, this.getHeaderIds()));
        for (String[] comp : comps) {
            center.add(this.getPanel(context, comp));
        }
        center.setBorder(BorderFactory.createTitledBorder(""));
        return center;
    }

    private JPanel createLeftJustifiedPanel(JComponent c) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(c);
        Dimension dPref = c.getPreferredSize();
        Dimension dMax = c.getMaximumSize();
        dMax.height = dPref.height;
        c.setMaximumSize(dMax);
        p.add(Box.createHorizontalGlue());
        p.setPreferredSize(c.getPreferredSize());
        return p;
    }

    private Component getPanel(LayoutContext context, String ... comp) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(4, 4));
        JLabel lbl = new JLabel(context.getName(comp[0]), 4);
        this.setPreferredLableSize(lbl);
        panel.add((Component)lbl, "West");
        JPanel center = new JPanel();
        ArrayList<JComponent> allComps = new ArrayList<JComponent>();
        AbstractButton useExisting = null;
        JComponent existingList = null;
        JComponent passwd = null;
        Container userNamePanel = null;
        for (int i = 0; i < comp.length; ++i) {
            Container component = context.getBinding(comp[i]).getComponents()[0];
            if (component instanceof JCheckBox) {
                useExisting = (JCheckBox)component;
                useExisting.setHorizontalAlignment(0);
                existingList = context.getBinding(comp[i + 1]).getComponents()[0];
                passwd = context.getBinding(comp[i + 2]).getComponents()[0];
                JPanel p = new JPanel();
                p.setBorder(BorderFactory.createLoweredBevelBorder());
                p.add(useExisting);
                component = p;
            } else if (component instanceof JTextField) {
                ((JTextField)component).setHorizontalAlignment(10);
            } else if (component instanceof JComboBox) {
                userNamePanel.add("listpanel", component);
                continue;
            }
            if (i == 0) {
                userNamePanel = new UserNamePanel();
                userNamePanel.add("textpanel", component);
                component = userNamePanel;
            }
            Dimension compDim = component.getPreferredSize();
            Dimension d = lbl.getPreferredSize();
            component.setPreferredSize(new Dimension(compDim.width, d.height * 2));
            allComps.add((JComponent)component);
        }
        if (useExisting != null) {
            ActionListener lns = this.createCheckBoxListener((JCheckBox)useExisting, (List<JComponent>)allComps, existingList, passwd, (UserNamePanel)userNamePanel);
            useExisting.addActionListener(lns);
            lns.actionPerformed(null);
        }
        center.setLayout(new GridLayout(1, allComps.size()));
        for (Container component : allComps) {
            center.add(component);
        }
        panel.add((Component)center, "Center");
        return panel;
    }

    private ActionListener createCheckBoxListener(final JCheckBox src, final List<JComponent> allComps, final JComponent existingList, final JComponent passwd, final UserNamePanel userNamePanel) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean useExisting = src.isSelected();
                for (JComponent aComp : allComps) {
                    aComp.setEnabled(!useExisting);
                }
                existingList.setEnabled(useExisting);
                passwd.setEnabled(true);
                userNamePanel.showCard(useExisting);
            }
        };
    }

    private JPanel getColumnHeaderPanel(LayoutContext context, String ... comp) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(4, 4));
        JLabel lbl = new JLabel();
        this.setPreferredLableSize(lbl);
        panel.add((Component)lbl, "West");
        JPanel center = new JPanel();
        ArrayList<JLabel> allComps = new ArrayList<JLabel>();
        for (int i = 0; i < comp.length; ++i) {
            String string = "<HTML><BODY><B>" + context.getName(comp[i]) + "</B></BODY></HTML>";
            JLabel headerLbl = new JLabel(string);
            headerLbl.setHorizontalAlignment(0);
            allComps.add(headerLbl);
        }
        center.setLayout(new GridLayout(1, allComps.size()));
        for (JComponent jComponent : allComps) {
            center.add(jComponent);
        }
        panel.add((Component)center, "Center");
        return panel;
    }

    private class UserNamePanel
    extends JPanel {
        private static final long serialVersionUID = 3484024187424598994L;

        public UserNamePanel() {
            this.setLayout(new CardLayout());
        }

        protected void showCard(boolean showList) {
            CardLayout cl = (CardLayout)this.getLayout();
            if (showList) {
                cl.show(this, "listpanel");
            } else {
                cl.show(this, "textpanel");
            }
        }
    }
}

