/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.dbservers.oracle;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.DatabaseInfo;
import com.primavera.database.tools.dbmt.ServerInfo;
import com.primavera.database.tools.dbmt.ServerLogic;
import com.primavera.database.tools.dbmt.dbservers.SchemaTypeNotFoundError;
import com.primavera.database.tools.dbmt.dbservers.TablespaceNotFoundException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OracleLogic
extends ServerLogic {
    static final Comparator<UserNameAndGrantCount> s_pubUserComparator = new Comparator<UserNameAndGrantCount>(){

        @Override
        public int compare(UserNameAndGrantCount arg0, UserNameAndGrantCount arg1) {
            if (arg0.getGrantCnt() == arg1.getGrantCnt()) {
                String name0 = arg0.getUserName().toUpperCase();
                String name1 = arg1.getUserName().toUpperCase();
                int pubIndex0 = name0.indexOf("PUB");
                int pubIndex1 = name1.indexOf("PUB");
                if (pubIndex0 < 0 && pubIndex1 < 0 || pubIndex0 == pubIndex1) {
                    return name0.compareTo(name1);
                }
                if (pubIndex0 < 0 || pubIndex1 < 0) {
                    return pubIndex1 - pubIndex0;
                }
                return pubIndex0 - pubIndex1;
            }
            return arg0.getGrantCnt() - arg1.getGrantCnt();
        }
    };
    static final String TABLESPACE_QUERY = "SELECT f.tablespace_name, f.file_name, t.contents FROM sys.dba_data_files  f, sys.dba_tablespaces t WHERE t.tablespace_name = f.tablespace_name AND t.contents = 'PERMANENT'";
    static final String TEMPORARY_TABLESPACE_QUERY = "SELECT tablespace_name FROM sys.dba_tablespaces WHERE contents = 'TEMPORARY'";
    static final String TABLESPACE_LOCATION_QUERY = "SELECT file_name FROM sys.dba_data_files WHERE tablespace_name = 'SYSTEM'";
    static final String EXISTING_USERS_QUERY = "SELECT username FROM sys.dba_users";
    static final String POSSIBLE_PUBUSERS_QUERY = "SELECT grantee username, COUNT(*) grantcount FROM user_tab_privs_made WHERE table_name IN ('PUBUSER')  and privilege='SELECT'  GROUP BY grantee minus SELECT grantee username, COUNT(*) grantcount FROM user_tab_privs_made WHERE table_name IN ('NEXTKEY') and privilege='SELECT' GROUP BY grantee";
    static final String POSSIBLE_PRIVUSERS_QUERY = "SELECT grantee username FROM user_tab_privs_made u, pubuser pu WHERE table_name = 'NEXTKEY' and privilege = 'SELECT' and grantee = UPPER(private_db_user_name)";
    static final String POSSIBLE_PXRPTUSERS_QUERY = "SELECT grantee username, COUNT(*) grantcount FROM user_tab_privs_made  WHERE table_name = 'TASKX'  GROUP BY grantee having count(*)=1";
    static final String PM_SCHEMATYPE_QUERY = "SELECT SUBSTR (database_version, 1, instr (database_version, ',')-1) SCHEMA from prefer";
    static final String CM_SCHEMATYPE_QUERY = "SELECT username APPLICATION FROM CVRT";
    static final String PM_DATA_TABLESPACE_QUERY = "SELECT DISTINCT tablespace_name FROM user_tables WHERE table_name = 'USERS'";
    static final String PM_INDEX_TABLESPACE_QUERY = "SELECT DISTINCT tablespace_name FROM user_indexes WHERE table_name = 'USERS'";
    static final String PM_LOB_TABLESPACE_QUERY = "SELECT DISTINCT tablespace_name FROM user_indexes WHERE index_type = 'LOB' AND table_name = 'USERDATA'";
    static final String PM_PX_TABLESPACE_QUERY = "SELECT DISTINCT tablespace_name FROM user_tables WHERE table_name = 'TASKX'";
    static final String EXP_DATA_TABLESPACE_QUERY = "SELECT DISTINCT tablespace_name FROM user_tables WHERE table_name = 'CVRT'";
    static final String EXP_INDEX_TABLESPACE_QUERY = "SELECT DISTINCT tablespace_name FROM user_indexes WHERE table_name = 'CVRT'";
    static final String EXP_LOB_TABLESPACE_QUERY = "SELECT DISTINCT tablespace_name FROM user_indexes WHERE index_type = 'LOB' AND table_name = 'PREF_TABLE'";
    static final String EXPADMIN_DATA_TABLESPACE_QUERY = "SELECT DISTINCT tablespace_name FROM user_tables WHERE table_name = 'CVRT'";
    static final String EXISTING_BGJOBUSERS_QUERY = "select  grantee from dba_role_privs rp where granted_role = 'PM_BG_JOB_ROLE' and admin_option='NO' and exists (select 1 from dba_synonyms where owner=rp.grantee and table_owner=? and synonym_name in('DATA_MONITOR')) order by grantee";
    static final String PARTITIONING_OPTION = "SELECT value FROM v$option WHERE parameter = 'Partitioning'";

    private static String getPossibleROUserQuery(String admuser) {
        return "SELECT owner FROM dba_synonyms WHERE synonym_name like 'T6%' AND table_owner = '" + admuser + "' GROUP BY owner";
    }

    private static boolean tablespaceFilter(String tablespaceName) {
        if (tablespaceName.toUpperCase().equals("SYSTEM")) {
            return false;
        }
        return !tablespaceName.toUpperCase().equals("SYSAUX");
    }

    @Override
    public Set<DatabaseInfo> getDatabases(ServerInfo server) {
        return null;
    }

    public static String getDefaultOracleUserName(Set<String> existingOracleUsers, String defaultName) {
        String normalizedName = defaultName.toLowerCase();
        if (!existingOracleUsers.contains(normalizedName)) {
            return normalizedName;
        }
        int firstTerminalDigit = normalizedName.length();
        while (Character.isDigit(normalizedName.charAt(firstTerminalDigit - 1))) {
            --firstTerminalDigit;
        }
        if (firstTerminalDigit < normalizedName.length()) {
            normalizedName = normalizedName.substring(0, firstTerminalDigit);
        }
        int appendedNumber = 1;
        String constructedName;
        while (existingOracleUsers.contains(constructedName = normalizedName + appendedNumber)) {
            ++appendedNumber;
        }
        return constructedName;
    }

    public static String setTbspFileLocation(String tbspName, String tbspFileLoc) {
        String nameField = "";
        if (tbspName != null) {
            nameField = tbspName.trim();
        }
        String dataFileText = "";
        if (tbspFileLoc != null) {
            dataFileText = tbspFileLoc.trim();
        }
        String dataFileDirectory = OracleLogic.getDirectory(dataFileText) + nameField + ".DBF";
        return dataFileDirectory;
    }

    public static Map<String, String> getTablespaceMap(DatabaseConnection dbconn) {
        HashMap<String, String> tablespaceMap = new HashMap<String, String>();
        try {
            Statement stmt = dbconn.getConnection().createStatement();
            stmt.execute(TABLESPACE_QUERY);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                String tablespaceName = rs.getString("tablespace_name");
                String tablespaceFile = rs.getString("file_name");
                if (!OracleLogic.tablespaceFilter(tablespaceName)) continue;
                tablespaceMap.put(tablespaceName.toUpperCase(), tablespaceFile);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        for (String tablespaceName : tablespaceMap.keySet()) {
            StringLocalizer.setAsOwnTranslation(tablespaceName);
        }
        return tablespaceMap;
    }

    public static Collection<String> getTemporaryTablespaces(DatabaseConnection connection) {
        HashSet<String> temporaryTablespaces = new HashSet<String>();
        try {
            Statement stmt = connection.getConnection().createStatement();
            stmt.execute(TEMPORARY_TABLESPACE_QUERY);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                temporaryTablespaces.add(rs.getString("tablespace_name"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        for (String tablespaceName : temporaryTablespaces) {
            StringLocalizer.setAsOwnTranslation(tablespaceName);
        }
        return temporaryTablespaces;
    }

    public static String getDefaultDirectory(DatabaseConnection dbconn) {
        try {
            Statement stmt = dbconn.getConnection().createStatement();
            stmt.execute(TABLESPACE_LOCATION_QUERY);
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                String[] paths = rs.getString("file_name").split("/|\\\\");
                return rs.getString("file_name").trim().substring(0, rs.getString("file_name").length() - paths[paths.length - 1].length());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Set<String> getExistingUsers(DatabaseConnection dbconn) {
        HashSet<String> usersSet = new HashSet<String>();
        try {
            Statement stmt = dbconn.getConnection().createStatement();
            stmt.execute(EXISTING_USERS_QUERY);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                usersSet.add(rs.getString("username").toLowerCase());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return usersSet;
    }

    public static Set<String> getExistingUsers(String connectionString) {
        DatabaseConnection conn = null;
        try {
            conn = new DatabaseConnection(connectionString);
            Set<String> set = OracleLogic.getExistingUsers(conn);
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    public static Set<String> getPossibleROUser(DatabaseConnection dbconn, String admuser) {
        HashSet<String> usersSet = new HashSet<String>();
        try {
            Statement stmt = dbconn.getConnection().createStatement();
            stmt.execute(OracleLogic.getPossibleROUserQuery(admuser));
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                usersSet.add(rs.getString("owner").toLowerCase());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return usersSet;
    }

    @Override
    protected ResultSet getPrivUsersResultSet(DatabaseConnection dbconn) throws SQLException {
        Statement stmt = dbconn.getConnection().createStatement();
        stmt.execute(this.getPrivUsersSQL());
        ResultSet rs = stmt.getResultSet();
        return rs;
    }

    @Override
    protected ResultSet getPubUsersResultSet(DatabaseConnection dbconn) throws SQLException {
        Statement stmt = dbconn.getConnection().createStatement();
        stmt.execute(this.getPubUsersSQL());
        ResultSet rs = stmt.getResultSet();
        return rs;
    }

    @Override
    protected ResultSet getPxrptUsersResultSet(DatabaseConnection dbconn) throws SQLException {
        Statement stmt = dbconn.getConnection().createStatement();
        stmt.execute(this.getPxtUsersSQL());
        ResultSet rs = stmt.getResultSet();
        return rs;
    }

    @Override
    protected String getPubUsersSQL() {
        return POSSIBLE_PUBUSERS_QUERY;
    }

    @Override
    protected String getPrivUsersSQL() {
        return POSSIBLE_PRIVUSERS_QUERY;
    }

    @Override
    protected String getPxtUsersSQL() {
        return POSSIBLE_PXRPTUSERS_QUERY;
    }

    @Override
    public List<String> getSortedPossiblePubusers(DatabaseConnection dbconn) {
        ArrayList<String> sortedUsernames = new ArrayList<String>();
        ArrayList<UserNameAndGrantCount> usernamesAndGrants = new ArrayList<UserNameAndGrantCount>();
        try {
            ResultSet rs = this.getPubUsersResultSet(dbconn);
            while (rs.next()) {
                usernamesAndGrants.add(new UserNameAndGrantCount(rs.getString("username"), rs.getInt("grantcount")));
            }
            UserNameAndGrantCount[] userArray = usernamesAndGrants.toArray(new UserNameAndGrantCount[0]);
            Arrays.sort(userArray, s_pubUserComparator);
            for (UserNameAndGrantCount userAndGrant : userArray) {
                sortedUsernames.add(userAndGrant.getUserName());
                StringLocalizer.setAsOwnTranslation(userAndGrant.getUserName());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sortedUsernames;
    }

    @Override
    protected void getPossiblePxrptusers(DatabaseConnection dbconn, List<String> usernames) throws SQLException {
        ResultSet rs = this.getPxrptUsersResultSet(dbconn);
        while (rs.next()) {
            usernames.add(rs.getString("username"));
        }
    }

    @Override
    protected void getPossiblePrivusers(DatabaseConnection dbconn, List<String> usernames) throws SQLException {
        ResultSet rs = this.getPrivUsersResultSet(dbconn);
        while (rs.next()) {
            usernames.add(rs.getString("username"));
        }
    }

    public static List<String> getBGJobUsers(DatabaseConnection dbconn, String admUserName) {
        ArrayList<String> usernames = new ArrayList<String>();
        try {
            PreparedStatement prepareStatement = dbconn.getConnection().prepareStatement(EXISTING_BGJOBUSERS_QUERY);
            prepareStatement.setString(1, admUserName.toUpperCase());
            ResultSet rs = prepareStatement.executeQuery();
            while (rs.next()) {
                usernames.add(rs.getString("grantee"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String[] userArray = usernames.toArray(new String[0]);
        usernames.clear();
        for (String username : userArray) {
            usernames.add(username);
            StringLocalizer.setAsOwnTranslation(username);
        }
        return usernames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SchemaType getSchemaType(DatabaseConnection dbconn, ProductSuiteType suite) throws SchemaTypeNotFoundError {
        try {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = dbconn.getConnection().createStatement();
                if (suite == ProductSuiteType.EXP) {
                    stmt.execute(CM_SCHEMATYPE_QUERY);
                    rs = stmt.getResultSet();
                    if (!rs.next()) throw new SchemaTypeNotFoundError(dbconn.getServer());
                    SchemaType schemaType = SchemaType.valueOf(rs.getString("APPLICATION"));
                    return schemaType;
                }
                stmt.execute(PM_SCHEMATYPE_QUERY);
                rs = stmt.getResultSet();
                if (!rs.next()) throw new SchemaTypeNotFoundError(dbconn.getServer());
                if (rs.getString(1).equalsIgnoreCase("PMDB")) {
                    SchemaType schemaType = SchemaType.PM;
                    return schemaType;
                }
                if (rs.getString(1).equalsIgnoreCase("PPMDB")) {
                    SchemaType schemaType = SchemaType.PPM;
                    return schemaType;
                }
                if (!rs.getString(1).equalsIgnoreCase("MMDB")) throw new SchemaTypeNotFoundError(dbconn.getServer());
                SchemaType schemaType = SchemaType.MM;
                return schemaType;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TablespaceSet getPmdbTablespaces(DatabaseConnection connection) throws SQLException, TablespaceNotFoundException {
        String dataTablespace = OracleLogic.getPmdbDefaultTablespace(connection);
        Set<String> indexTablespaces = OracleLogic.getTablespaces(connection, PM_INDEX_TABLESPACE_QUERY);
        Set<String> lobTablespaces = OracleLogic.getTablespaces(connection, PM_LOB_TABLESPACE_QUERY);
        Set<String> pxTablespaces = OracleLogic.getTablespaces(connection, PM_PX_TABLESPACE_QUERY);
        lobTablespaces.remove(dataTablespace);
        indexTablespaces.remove(dataTablespace);
        pxTablespaces.remove(dataTablespace);
        String indexTablespace = null;
        String lobTablespace = null;
        String pxTablespace = null;
        indexTablespace = indexTablespaces.size() == 0 ? dataTablespace : indexTablespaces.iterator().next();
        lobTablespace = lobTablespaces.size() == 0 ? dataTablespace : lobTablespaces.iterator().next();
        pxTablespace = pxTablespaces.size() == 0 ? dataTablespace : pxTablespaces.iterator().next();
        return new TablespaceSet(dataTablespace, indexTablespace, lobTablespace, pxTablespace);
    }

    public static TablespaceSet getExpTablespaces(DatabaseConnection connection) throws SQLException, TablespaceNotFoundException {
        String dataTablespace = OracleLogic.getExpDefaultTablespace(connection);
        Set<String> indexTablespaces = OracleLogic.getTablespaces(connection, EXP_INDEX_TABLESPACE_QUERY);
        Set<String> lobTablespaces = OracleLogic.getTablespaces(connection, EXP_LOB_TABLESPACE_QUERY);
        lobTablespaces.remove(dataTablespace);
        indexTablespaces.remove(dataTablespace);
        String indexTablespace = null;
        String lobTablespace = null;
        indexTablespace = indexTablespaces.size() == 0 ? dataTablespace : indexTablespaces.iterator().next();
        lobTablespace = lobTablespaces.size() == 0 ? dataTablespace : lobTablespaces.iterator().next();
        return new TablespaceSet(dataTablespace, indexTablespace, lobTablespace, null);
    }

    public static String getExpAdminTablespace(DatabaseConnection connection) throws SQLException, TablespaceNotFoundException {
        return OracleLogic.getExpAdminDefaultTablespace(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getTablespaces(DatabaseConnection connection, String query) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        HashSet<String> tablespaces = new HashSet<String>();
        try {
            stmt = connection.getConnection().createStatement();
            stmt.execute(query);
            rs = stmt.getResultSet();
            while (rs.next()) {
                tablespaces.add(rs.getString(1));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        return tablespaces;
    }

    private static String getExpAdminDefaultTablespace(DatabaseConnection connection) throws SQLException, TablespaceNotFoundException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.getConnection().createStatement();
            stmt.execute("SELECT DISTINCT tablespace_name FROM user_tables WHERE table_name = 'CVRT'");
            rs = stmt.getResultSet();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            throw new TablespaceNotFoundException(connection, StringLocalizer.get("dbmt.tablespace.type.data"), "SELECT DISTINCT tablespace_name FROM user_tables WHERE table_name = 'CVRT'");
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
    }

    private static String getExpDefaultTablespace(DatabaseConnection connection) throws SQLException, TablespaceNotFoundException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.getConnection().createStatement();
            stmt.execute("SELECT DISTINCT tablespace_name FROM user_tables WHERE table_name = 'CVRT'");
            rs = stmt.getResultSet();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            throw new TablespaceNotFoundException(connection, StringLocalizer.get("dbmt.tablespace.type.data"), "SELECT DISTINCT tablespace_name FROM user_tables WHERE table_name = 'CVRT'");
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
    }

    private static String getPmdbDefaultTablespace(DatabaseConnection connection) throws SQLException, TablespaceNotFoundException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.getConnection().createStatement();
            stmt.execute(PM_DATA_TABLESPACE_QUERY);
            rs = stmt.getResultSet();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            throw new TablespaceNotFoundException(connection, StringLocalizer.get("dbmt.tablespace.type.data"), PM_DATA_TABLESPACE_QUERY);
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
    }

    public static String getPartitioningOption(DatabaseConnection dbconn) {
        try {
            Statement stmt = dbconn.getConnection().createStatement();
            stmt.execute(PARTITIONING_OPTION);
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    static class UserNameAndGrantCount {
        private final String m_userName;
        private final int m_grantCnt;

        public UserNameAndGrantCount(String userName, int grantCnt) {
            this.m_userName = userName;
            this.m_grantCnt = grantCnt;
        }

        protected final int getGrantCnt() {
            return this.m_grantCnt;
        }

        protected final String getUserName() {
            return this.m_userName;
        }
    }

    public static final class TablespaceSet {
        private final String m_dataTablespaceName;
        private final String m_indexTablespaceName;
        private final String m_lobTablespaceName;
        private final String m_pxTablespaceName;

        public TablespaceSet(String dataTablespaceName, String indexTablespaceName, String lobTablespaceName, String pxTablespaceName) {
            this.m_dataTablespaceName = dataTablespaceName;
            this.m_indexTablespaceName = indexTablespaceName;
            this.m_lobTablespaceName = lobTablespaceName;
            this.m_pxTablespaceName = pxTablespaceName;
        }

        public final String getDataTablespaceName() {
            return this.m_dataTablespaceName;
        }

        public final String getLobTablespaceName() {
            return this.m_lobTablespaceName;
        }

        public final String getIndexTablespaceName() {
            return this.m_indexTablespaceName;
        }

        public final String getPxTablespaceName() {
            return this.m_pxTablespaceName;
        }
    }
}

