/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DSType;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.InvalidWizardPageData;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.CommandLineActionObject;
import com.primavera.database.tools.dbmt.cmd.ConnectionFieldSpec;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;
import com.primavera.database.tools.dbmt.cmd.InvalidCommandLineArgument;
import com.primavera.database.tools.dbmt.cmd.InvalidCommandLineSpec;
import com.primavera.schema.pmdbs.command._1.TConnection;
import com.primavera.schema.pmdbs.command._1.TConnectionField;
import com.primavera.schema.pmdbs.command._1.TDBField;
import com.primavera.schema.pmdbs.command._1.TDatabasePage;
import com.primavera.schema.pmdbs.command._1.TDatabaseType;
import com.primavera.schema.pmdbs.command._1.TField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectionProcessor
extends CommandLineActionObject.ParameterProcessor {
    private final String m_dbTypePage;
    private final String m_dbTypeField;
    private Map<TDatabaseType, DBPageInfo> m_connectionInfo = new HashMap<TDatabaseType, DBPageInfo>();

    public ConnectionProcessor(TConnection conn) throws Exception {
        super(conn.getId());
        String[] splitField = conn.getTypeField().split("/");
        if (splitField.length != 2) {
            throw new InvalidCommandLineSpec("Invalid command database type field: " + conn.getTypeField());
        }
        this.m_dbTypePage = splitField[0];
        this.m_dbTypeField = splitField[1];
        List<TDatabasePage> pages = conn.getDb();
        for (TDatabasePage page : pages) {
            DBPageInfo pageInfo = new DBPageInfo(page.getPage());
            this.m_connectionInfo.put(page.getDb(), pageInfo);
            for (TDBField tDBField : page.getField()) {
                ConnectionFieldSpec spec = this.getFieldSpec(tDBField.getAspect());
                pageInfo.setFieldName(spec, tDBField.getId());
                String pageId = tDBField.getPage();
                if (pageId == null) continue;
                pageInfo.setPageName(spec, pageId);
            }
            for (TField tField : page.getExtra()) {
                int seq = tField.getSeq() == null ? 0 : tField.getSeq().intValue();
                pageInfo.addExtra(new ExtraDataInfo(tField.getPage(), tField.getField(), this.createFieldProcessorInstance(tField.getProcessor()), seq));
            }
        }
    }

    private ConnectionFieldSpec getFieldSpec(TConnectionField aspect) throws InvalidCommandLineSpec {
        if (aspect == TConnectionField.HOST) {
            return ConnectionFieldSpec.HOST;
        }
        if (aspect == TConnectionField.INSTANCE) {
            return ConnectionFieldSpec.NAME;
        }
        if (aspect == TConnectionField.PASSWORD) {
            return ConnectionFieldSpec.PASS;
        }
        if (aspect == TConnectionField.PORT) {
            return ConnectionFieldSpec.PORT;
        }
        if (aspect == TConnectionField.USERNAME) {
            return ConnectionFieldSpec.USER;
        }
        throw new InvalidCommandLineSpec("Unknown connection aspect: " + (Object)((Object)aspect));
    }

    @Override
    public void prepareArgumentValue(Map<String, String> paramMap, Map<String, Map<String, Set<CommandLineActionObject.ValueAndProcessor>>> valueMap) throws InvalidCommandLineArgument {
        String connectionString = paramMap.get(this.getId());
        if (connectionString == null) {
            return;
        }
        ConnectStringParse parsedConnectString = new ConnectStringParse(connectionString);
        if (parsedConnectString.getConnectionType() != DSType.DATABASE) {
            throw new RuntimeException("Invalid parameter: " + this.getId() + ", connection must be a database");
        }
        DBMTLogger.info(Channel.DEV, "Databse Type = " + parsedConnectString.getDbtype().getShortName());
        this.setInPageMap(ConnectionProcessor.getPageMap(this.m_dbTypePage, valueMap), this.m_dbTypeField, new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getDbtype().getShortName(), 0));
        TDatabaseType type = this.getDatabaseType(parsedConnectString.getDbtype());
        DBPageInfo pageInfo = this.m_connectionInfo.get((Object)type);
        if (type == TDatabaseType.ORACLEATP) {
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.USER), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.USER), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getUsername(), 0));
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.PASS), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.PASS), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getPassword(), 0));
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.SERVICE), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.SERVICE), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getDatabase(), 0));
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.DBWALLET), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.DBWALLET), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getDatabaseWalletLocation(), 0));
        } else {
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.USER), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.USER), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getUsername(), 0));
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.PASS), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.PASS), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getPassword(), 0));
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.HOST), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.HOST), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getServer(), 0));
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.PORT), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.PORT), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getPort(), 0));
        }
        if (type == TDatabaseType.ORACLE) {
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.CTYPE), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.CTYPE), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.isOracleService() ? "SERVICE" : "SID", 0));
        }
        if (type == TDatabaseType.ORACLE || type == TDatabaseType.MSSQL) {
            this.setInPageMap(ConnectionProcessor.getPageMap(pageInfo.getPageId(ConnectionFieldSpec.NAME), valueMap), pageInfo.getFieldName(ConnectionFieldSpec.NAME), new CommandLineActionObject.ValueAndProcessor(parsedConnectString.getDatabase(), 0));
        }
        for (ExtraDataInfo info : pageInfo.getExtras()) {
            this.setExtraInfo(valueMap, info, connectionString);
        }
    }

    private void setExtraInfo(Map<String, Map<String, Set<CommandLineActionObject.ValueAndProcessor>>> valueMap, ExtraDataInfo info, String connectionString) {
        Set<CommandLineActionObject.ValueAndProcessor> fieldValueSet;
        Map<String, Set<CommandLineActionObject.ValueAndProcessor>> pageMap = valueMap.get(info.getPageId());
        if (pageMap == null) {
            pageMap = new HashMap<String, Set<CommandLineActionObject.ValueAndProcessor>>();
            valueMap.put(info.getPageId(), pageMap);
        }
        if ((fieldValueSet = pageMap.get(info.getFieldId())) == null) {
            fieldValueSet = new HashSet<CommandLineActionObject.ValueAndProcessor>();
            pageMap.put(info.getFieldId(), fieldValueSet);
        }
        fieldValueSet.add(new CommandLineActionObject.ValueAndProcessor(connectionString, info.getProc(), info.getSeq()));
    }

    private FieldProcessor createFieldProcessorInstance(String proc) throws Exception {
        return (FieldProcessor)Class.forName(proc).newInstance();
    }

    private void setInPageMap(Map<String, Set<CommandLineActionObject.ValueAndProcessor>> pageMap, String fieldId, CommandLineActionObject.ValueAndProcessor processor) {
        Set<CommandLineActionObject.ValueAndProcessor> valueSet = pageMap.get(fieldId);
        if (valueSet == null) {
            valueSet = new HashSet<CommandLineActionObject.ValueAndProcessor>();
            pageMap.put(fieldId, valueSet);
        }
        valueSet.add(processor);
    }

    private static Map<String, Set<CommandLineActionObject.ValueAndProcessor>> getPageMap(String pageId, Map<String, Map<String, Set<CommandLineActionObject.ValueAndProcessor>>> valueMap) {
        Map<String, Set<CommandLineActionObject.ValueAndProcessor>> pageMap = valueMap.get(pageId);
        if (pageMap == null) {
            pageMap = new HashMap<String, Set<CommandLineActionObject.ValueAndProcessor>>();
            valueMap.put(pageId, pageMap);
        }
        return pageMap;
    }

    public int setInWizardData(Map<String, String> paramMap, WizardInteractorData data) throws InvalidWizardPageData, InvalidCommandLineArgument {
        String connectionString = paramMap.get(this.getId());
        if (connectionString == null) {
            return 0;
        }
        ConnectStringParse parsedConnectString = new ConnectStringParse(connectionString);
        if (parsedConnectString.getConnectionType() != DSType.DATABASE) {
            throw new RuntimeException("Invalid parameter: " + this.getId() + ", connection must be a database");
        }
        DBMTLogger.info(Channel.DEV, "Databse Type = " + parsedConnectString.getDbtype().getShortName());
        data.getPageData(this.m_dbTypePage).setValue(this.m_dbTypeField, parsedConnectString.getDbtype().getShortName());
        TDatabaseType type = this.getDatabaseType(parsedConnectString.getDbtype());
        DBPageInfo pageInfo = this.m_connectionInfo.get((Object)type);
        data.getPageData(pageInfo.getPageId(ConnectionFieldSpec.USER)).setValue(pageInfo.getFieldName(ConnectionFieldSpec.USER), parsedConnectString.getUsername());
        data.getPageData(pageInfo.getPageId(ConnectionFieldSpec.PASS)).setValue(pageInfo.getFieldName(ConnectionFieldSpec.PASS), parsedConnectString.getPassword());
        data.getPageData(pageInfo.getPageId(ConnectionFieldSpec.HOST)).setValue(pageInfo.getFieldName(ConnectionFieldSpec.HOST), parsedConnectString.getServer());
        data.getPageData(pageInfo.getPageId(ConnectionFieldSpec.PORT)).setValue(pageInfo.getFieldName(ConnectionFieldSpec.PORT), parsedConnectString.getPort());
        if (type == TDatabaseType.ORACLE || type == TDatabaseType.MSSQL) {
            data.getPageData(pageInfo.getPageId(ConnectionFieldSpec.NAME)).setValue(pageInfo.getFieldName(ConnectionFieldSpec.NAME), parsedConnectString.getDatabase());
        }
        return 0;
    }

    private TDatabaseType getDatabaseType(ServerType dbtype) {
        if (dbtype == ServerType.ORACLE) {
            return TDatabaseType.ORACLE;
        }
        if (dbtype == ServerType.SQLSERVER) {
            return TDatabaseType.MSSQL;
        }
        if (dbtype == ServerType.SYBASE) {
            return TDatabaseType.SYBASE;
        }
        if (dbtype == ServerType.ORACLEATP) {
            return TDatabaseType.ORACLEATP;
        }
        return null;
    }

    public String getDbTypeField() {
        return this.m_dbTypeField;
    }

    public String getDbTypePage() {
        return this.m_dbTypePage;
    }

    private class ExtraDataInfo {
        private final String m_pageId;
        private final int m_seq;
        private final String m_fieldId;
        private final FieldProcessor m_proc;

        public ExtraDataInfo(String pageId, String fieldId, FieldProcessor proc, int seq) {
            this.m_pageId = pageId;
            this.m_fieldId = fieldId;
            this.m_proc = proc;
            this.m_seq = seq;
        }

        public String getFieldId() {
            return this.m_fieldId;
        }

        public String getPageId() {
            return this.m_pageId;
        }

        public FieldProcessor getProc() {
            return this.m_proc;
        }

        public int getSeq() {
            return this.m_seq;
        }
    }

    private class DBPageInfo {
        private final Map<ConnectionFieldSpec, String> m_fieldNames = new HashMap<ConnectionFieldSpec, String>();
        private final Map<ConnectionFieldSpec, String> m_pageNames = new HashMap<ConnectionFieldSpec, String>();
        private final Set<ExtraDataInfo> m_extra = new HashSet<ExtraDataInfo>();
        private final String m_pageId;

        public DBPageInfo(String pageId) {
            this.m_pageId = pageId;
        }

        public Iterable<ExtraDataInfo> getExtras() {
            return this.m_extra;
        }

        public void addExtra(ExtraDataInfo info) {
            this.m_extra.add(info);
        }

        public void setFieldName(ConnectionFieldSpec spec, String fieldName) {
            this.m_fieldNames.put(spec, fieldName);
        }

        public void setPageName(ConnectionFieldSpec spec, String pageName) {
            this.m_pageNames.put(spec, pageName);
        }

        public String getFieldName(ConnectionFieldSpec fieldId) {
            String overrideFieldName = this.m_fieldNames.get((Object)fieldId);
            if (overrideFieldName == null) {
                return fieldId.m_defaultFieldName;
            }
            return overrideFieldName;
        }

        public String getPageId(ConnectionFieldSpec fieldId) {
            String overridePageId = this.m_pageNames.get((Object)fieldId);
            if (overridePageId == null) {
                return this.m_pageId;
            }
            return overridePageId;
        }
    }
}

