/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobFailedEvent;
import com.primavera.database.common.job.JobFinishedEvent;
import com.primavera.database.common.job.JobListenerAdaptor;
import com.primavera.database.common.job.JobStartingEvent;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.CommitPageDataDef;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.InvalidWizardPageData;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.JobTreeTypeDef;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransitionMap {
    private final Map<String, Map<String, List<TransitionOperation>>> m_operationMap = new HashMap<String, Map<String, List<TransitionOperation>>>();
    private final Map<String, Map<String, List<TransitionValidator>>> m_validatorMap = new HashMap<String, Map<String, List<TransitionValidator>>>();
    private final Map<String, List<PageInitializer>> m_pageInitializers = new HashMap<String, List<PageInitializer>>();
    private final Set<String> m_commitPages = new HashSet<String>();
    private final Map<String, List<TransitionOperation>> m_processors = new HashMap<String, List<TransitionOperation>>();

    public void addCommitPage(String pageId) {
        this.m_commitPages.add(pageId);
    }

    public boolean isCommitPage(String pageId) {
        boolean isTrue = this.m_commitPages.contains(pageId);
        return isTrue;
    }

    public void addPostProcessor(String pageId, TransitionOperation proc) {
        List<TransitionOperation> processors = this.m_processors.get(pageId);
        if (processors == null) {
            processors = new ArrayList<TransitionOperation>();
            this.m_processors.put(pageId, processors);
        }
        processors.add(proc);
    }

    public void addValidator(String from, String to, TransitionValidator validator) {
        List<TransitionValidator> validators;
        Map<String, List<TransitionValidator>> validatorMap = this.m_validatorMap.get(from);
        if (validatorMap == null) {
            validatorMap = new HashMap<String, List<TransitionValidator>>();
            this.m_validatorMap.put(from, validatorMap);
        }
        if ((validators = validatorMap.get(to)) == null) {
            validators = new ArrayList<TransitionValidator>();
            validatorMap.put(to, validators);
        }
        validators.add(validator);
    }

    public Collection<TransitionOperation> getPagePostProcessors(String pageId) {
        Collection procs = this.m_processors.get(pageId);
        if (procs == null) {
            return new HashSet<TransitionOperation>();
        }
        return procs;
    }

    public void addOperation(String from, String to, TransitionOperation operation) {
        List<TransitionOperation> operations;
        Map<String, List<TransitionOperation>> operationMap = this.m_operationMap.get(from);
        if (operationMap == null) {
            operationMap = new HashMap<String, List<TransitionOperation>>();
            this.m_operationMap.put(from, operationMap);
        }
        if ((operations = operationMap.get(to)) == null) {
            operations = new ArrayList<TransitionOperation>();
            operationMap.put(to, operations);
        }
        operations.add(operation);
    }

    public void addInitializer(String pageId, PageInitializer initializer) {
        List<PageInitializer> initializers = this.m_pageInitializers.get(pageId);
        if (initializers == null) {
            initializers = new ArrayList<PageInitializer>();
            this.m_pageInitializers.put(pageId, initializers);
        }
        initializers.add(initializer);
    }

    public void initialize(String pageId, JobProperties jobProps, WizardRunner runner, WizardInteractorData data, Set<String> results) throws Exception {
        if (this.isCommitPage(pageId)) {
            this.initializeCommitPage(pageId, runner, data);
            return;
        }
        if (!runner.inializePages()) {
            return;
        }
        List<PageInitializer> initializers = this.getInitializers(pageId);
        for (PageInitializer initializer : initializers) {
            DBMTLogger.info(Channel.DEV, "Calling initializer " + initializer.getClass().getSimpleName());
            String result = initializer.initializePage(jobProps, data, pageId);
            if (result == null) continue;
            results.add(result);
        }
    }

    private List<PageInitializer> getInitializers(String pageId) {
        List<PageInitializer> initializers = this.m_pageInitializers.get(pageId);
        if (initializers == null) {
            return new ArrayList<PageInitializer>();
        }
        return initializers;
    }

    public boolean validate(String from, String to, WizardInteractorData data, JobProperties jobProps, Set<String> results) {
        List<TransitionValidator> validators = this.getValidators(from, to);
        for (TransitionValidator validator : validators) {
            DBMTLogger.info(Channel.DEV, "Calling validator " + validator.getClass().getSimpleName());
            String result = null;
            try {
                result = validator.validate(data, jobProps, from);
            }
            catch (ConnectionNotFoundException e) {
                DBMTLogger.info(Channel.DEV, "Validator " + validator.getClass().getSimpleName() + " threw exception", e);
                results.add(e.getLocalizedMessage());
            }
            catch (InteractorDataError e) {
                DBMTLogger.info(Channel.DEV, "Validator " + validator.getClass().getSimpleName() + " threw exception", e);
                results.add(e.getLocalizedMessage());
            }
            if (result == null) continue;
            results.add(result);
        }
        return results.isEmpty();
    }

    private String cleanUpCommitPage(String page, WizardRunner runner, WizardInteractorData data) {
        runner.clearAllJobs();
        runner.stack().clear();
        try {
            JobTreeTypeDef typeDef = (JobTreeTypeDef)data.getPageData(page).getDef().getTypeDef("job-tree");
            typeDef.reset();
        }
        catch (Throwable e) {
            return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
        }
        return null;
    }

    public boolean perform(String from, String to, WizardRunner runner, WizardInteractorData data, JobProperties jobProps, Set<String> results) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        String result;
        if (this.isCommitPage(from) && (result = this.cleanUpCommitPage(from, runner, data)) != null) {
            results.add(result);
            return false;
        }
        List<TransitionOperation> operations = this.getOperations(from, to);
        for (TransitionOperation operation : operations) {
            DBMTLogger.info(Channel.DEV, "Calling operator " + operation.getClass().getSimpleName());
            String result2 = operation.process(runner, data, from, jobProps);
            if (result2 == null) continue;
            results.add(result2);
            return false;
        }
        return true;
    }

    private List<TransitionValidator> getValidators(String from, String to) {
        Map<String, List<TransitionValidator>> validatorMap = this.m_validatorMap.get(from);
        if (validatorMap == null) {
            return new ArrayList<TransitionValidator>();
        }
        List<TransitionValidator> validators = validatorMap.get(to);
        if (validators == null) {
            return new ArrayList<TransitionValidator>();
        }
        return validators;
    }

    private List<TransitionOperation> getOperations(String from, String to) {
        Map<String, List<TransitionOperation>> operationMap = this.m_operationMap.get(from);
        if (operationMap == null) {
            return new ArrayList<TransitionOperation>();
        }
        List<TransitionOperation> operations = operationMap.get(to);
        if (operations == null) {
            return new ArrayList<TransitionOperation>();
        }
        return operations;
    }

    public void undo(WizardRunner runner, String fromPageId, String toPage, JobProperties properties) {
        List<TransitionOperation> operations = this.getOperations(fromPageId, toPage);
        for (TransitionOperation operation : operations) {
            try {
                operation.unProcess(runner, properties);
            }
            catch (InteractorDataError e) {
                DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.warn.unprocessing.action", new String[]{e.getClass().getSimpleName(), e.getLocalizedMessage()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCommitPage(String pageId, WizardRunner runner, WizardInteractorData data) throws InvalidWizardPageData {
        JobTreeTypeDef typeDef = (JobTreeTypeDef)data.getPageData(pageId).getDef().getTypeDef("job-tree");
        data.getPageData(pageId).setValue("commit-status", "NOTSTART");
        JobTreeTypeDef jobTreeTypeDef = typeDef;
        synchronized (jobTreeTypeDef) {
            typeDef.reset();
            ArrayList<JobTreeTypeDef.JobNode> currentJobs = new ArrayList<JobTreeTypeDef.JobNode>();
            for (Job job : runner.currentJobs(runner.stack())) {
                currentJobs.add(new JobTreeTypeDef.JobNode(job));
            }
            typeDef.getTopLevel().addAll(currentJobs);
            typeDef.addListener(new CommitJobListener(data, pageId));
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (Job job : runner.currentJobs(runner.stack())) {
                jobs.add(job);
            }
            typeDef.getJobRunner().runJobs(runner, jobs);
            new CommitFinishInformer(typeDef.getJobRunner(), data.getPageData(pageId));
        }
    }

    private class CommitJobListener
    extends JobListenerAdaptor {
        private boolean alreadyFailed = false;
        private final WizardInteractorData m_data;
        private final String m_pageId;

        private CommitJobListener(WizardInteractorData data, String pageId) {
            this.m_data = data;
            this.m_pageId = pageId;
        }

        @Override
        public void jobStarting(JobStartingEvent evt, boolean isIndeterminate) {
            try {
                if (isIndeterminate) {
                    this.m_data.getPageData(this.m_pageId).setValue("job-pct", Double.toString(Double.NaN));
                } else {
                    this.m_data.getPageData(this.m_pageId).setValue("job-pct", Double.toString(0.0));
                }
            }
            catch (InvalidWizardPageData e) {
                DBMTLogger.error(Channel.USER, e.getLocalizedMessage());
            }
        }

        @Override
        public void jobFinished(JobFinishedEvent evt) {
            try {
                this.m_data.getPageData(this.m_pageId).setValue("job-pct", Double.toString(1.0));
            }
            catch (InvalidWizardPageData e) {
                DBMTLogger.error(Channel.USER, e.getLocalizedMessage());
            }
        }

        @Override
        public void jobFailed(JobFailedEvent evt) {
            try {
                if (!this.alreadyFailed) {
                    this.m_data.getPageData(this.m_pageId).setValue("status-msg", evt.toString());
                    this.m_data.getPageData(this.m_pageId).setValue("commit-status", CommitPageDataDef.CommitStatus.FAILED.toString());
                }
                this.alreadyFailed = true;
                if (this.m_data.getPageData(this.m_pageId).getValue("job-pct").equals(Double.toString(Double.NaN))) {
                    this.m_data.getPageData(this.m_pageId).setValue("job-pct", Double.toString(0.5));
                }
            }
            catch (InteractorDataError e) {
                DBMTLogger.error(Channel.USER, e.getLocalizedMessage());
            }
        }

        @Override
        public void jobProgressed(int processedStatements, int totalStatements) {
            try {
                if (totalStatements == 0) {
                    return;
                }
                this.m_data.getPageData(this.m_pageId).setValue("job-pct", Double.toString((double)processedStatements / (double)totalStatements));
            }
            catch (InteractorDataError e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private class CommitFinishInformer {
        public CommitFinishInformer(final JobTreeTypeDef.JobRunnerInterface runner, final InteractorData pageData) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean finishedOk = runner.waitForFinish();
                    if (finishedOk) {
                        pageData.setValue("commit-status", CommitPageDataDef.CommitStatus.FINISHED.toString());
                    } else {
                        pageData.setValue("commit-status", CommitPageDataDef.CommitStatus.FAILED.toString());
                    }
                }
            });
            runner.doThread(thread);
        }
    }

    public static interface TransitionValidator {
        public String validate(WizardInteractorData var1, JobProperties var2, String var3) throws ConnectionNotFoundException, InteractorDataError;
    }

    public static interface TransitionOperation {
        public String process(WizardRunner var1, WizardInteractorData var2, String var3, JobProperties var4) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException;

        public void unProcess(WizardRunner var1, JobProperties var2) throws InteractorDataError;
    }

    public static interface PageInitializer {
        public String initializePage(JobProperties var1, WizardInteractorData var2, String var3) throws Exception;
    }
}

