/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.util.TablespaceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TempTableSpaceInitialize
implements TransitionMap.PageInitializer {
    private final ConnectionClass m_connectStringName;

    public TempTableSpaceInitialize(ConnectionClass connectStringName) {
        this.m_connectStringName = connectStringName;
    }

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws Exception {
        HashSet<String> temporaryTableSpaces = new HashSet<String>();
        String connectionString = null;
        try {
            connectionString = jobProps.getConnection(this.m_connectStringName);
        }
        catch (ConnectionNotFoundException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        temporaryTableSpaces.addAll(TablespaceUtil.getTemporaryTablespaces(connectionString));
        SelectTypeDef typeDef = (SelectTypeDef)data.getPageData(page).getDef().getTypeDef("temptblsp");
        typeDef.reset();
        for (String tablespaceName : temporaryTableSpaces) {
            typeDef.addValue(new EnumDataEntry(tablespaceName, tablespaceName, tablespaceName, ""));
        }
        if (typeDef.getValues().size() > 0) {
            data.getPageData(page).setValue("temptblsp", typeDef.getValues().get(0).getId());
        }
        return null;
    }

    private List<String> sortKeys(Set<String> name) {
        Object[] keys = new String[name.size()];
        int i = 0;
        for (String next : name) {
            keys[i++] = next;
        }
        Arrays.sort(keys);
        ArrayList<String> sortedKeys = new ArrayList<String>();
        for (Object key : keys) {
            sortedKeys.add((String)key);
        }
        return sortedKeys;
    }
}

