/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.AbstractSetUpgradeSchemaType;
import com.primavera.database.tools.dbmt.dbservers.SchemaTypeNotFoundError;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import java.sql.SQLException;

public class SetSSUpgradeSchemaType
extends AbstractSetUpgradeSchemaType {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SchemaType getSchemaType(String connectionString, ProductSuiteType suiteType) throws SQLException, SchemaTypeNotFoundError {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectionString);
            SchemaType schemaType = SqlServerLogic.getSchemaType(connection, suiteType);
            return schemaType;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }
}

