/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.sql.SQLException;

public class SetPartitioningParameter
implements TransitionMap.TransitionOperation {
    private final String m_partitioningFieldName;
    private static final ConnectionClass CONNECTION_CLASS = ConnectionClass.SYSADMIN;

    public SetPartitioningParameter() {
        this("partitioning");
    }

    public SetPartitioningParameter(String fieldName) {
        this.m_partitioningFieldName = fieldName;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
        String connectionString = jobProps.getConnection(CONNECTION_CLASS);
        jobProps.setJobProperty("partitioned", this.getPartitionOption(page, data, connectionString));
        return null;
    }

    private Object getPartitionOption(String page, WizardInteractorData data, String connectionString) throws InteractorDataError {
        if (data.getValue(page, this.m_partitioningFieldName).toUpperCase().equals(Boolean.TRUE.toString().toUpperCase()) && SetPartitioningParameter.getPartitioningOption(connectionString).toUpperCase().equals(Boolean.TRUE.toString().toUpperCase())) {
            return "_partitioned";
        }
        return "";
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty("partitioned");
    }

    public static String getPartitioningOption(String connectionString) {
        DatabaseConnection conn = null;
        try {
            conn = new DatabaseConnection(connectionString);
            String string = OracleLogic.getPartitioningOption(conn);
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }
}

