/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import java.sql.SQLException;
import java.util.HashSet;

public class SSDatabasePrivPubUsersValid
implements TransitionMap.TransitionValidator {
    private final ConnectionClass m_connectionClassMaster;

    public SSDatabasePrivPubUsersValid(ConnectionClass connectionClassMaster) {
        this.m_connectionClassMaster = connectionClassMaster;
    }

    @Override
    public String validate(WizardInteractorData data, JobProperties jobProps, String page) throws ConnectionNotFoundException, InteractorDataError {
        HashSet<String> usersSet;
        DatabaseConnection conn;
        DatabaseConnection tempconn;
        String testConnection;
        String connectStringMaster = jobProps.getConnection(this.m_connectionClassMaster);
        String existingPrivUser = data.getValue(page, "useexistingpriv");
        String existingPubUser = data.getValue(page, "useexistingpub");
        if ("true".equalsIgnoreCase(existingPrivUser)) {
            String privuser = data.getValue(page, "existingPriv");
            String privpass = data.getValue(page, "privpasslist");
            DBMTLogger.info(Channel.DEV, "Privuser " + privuser + " already exists.");
            testConnection = privuser + "/" + privpass + connectStringMaster.substring(connectStringMaster.toLowerCase().indexOf("@sql"));
            try {
                tempconn = new DatabaseConnection(testConnection);
                tempconn.close();
            }
            catch (SQLException e) {
                return StringLocalizer.get("dbmt.error.install.useexistinguser", new String[]{privuser});
            }
        }
        try {
            conn = new DatabaseConnection(connectStringMaster);
            usersSet = new HashSet<String>(SqlServerLogic.getDatabaseUsers(conn));
            String privuser = data.getValue(page, "privuser");
            if (usersSet.contains(privuser)) {
                return StringLocalizer.get("dbmt.error.install.alreadyexists", new String[]{privuser});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (data.getValue(page, "privpass").isEmpty()) {
            return StringLocalizer.get("dbmt.error.install.passwordnotentered", new String[]{data.getValue(page, "privuser")});
        }
        if (!data.getValue(page, "privpass").equalsIgnoreCase(data.getValue(page, "privpassconfirm"))) {
            return StringLocalizer.get("dbmt.error.install.passwordnotmatchconfirm", new String[]{data.getValue(page, "privuser")});
        }
        if ("true".equalsIgnoreCase(existingPubUser)) {
            String pubuser = data.getValue(page, "existingPub");
            String pubpass = data.getValue(page, "pubpasslist");
            DBMTLogger.info(Channel.DEV, "Pubvuser " + pubuser + " already exists.");
            testConnection = pubuser + "/" + pubpass + connectStringMaster.substring(connectStringMaster.toLowerCase().indexOf("@sql"));
            try {
                DBMTLogger.info(Channel.DEV, "Database test Connetion " + testConnection);
                tempconn = new DatabaseConnection(testConnection);
                tempconn.close();
            }
            catch (SQLException e) {
                return StringLocalizer.get("dbmt.error.install.useexistinguser", new String[]{pubpass});
            }
        }
        try {
            conn = new DatabaseConnection(connectStringMaster);
            usersSet = new HashSet<String>(SqlServerLogic.getDatabaseUsers(conn));
            String pubuser = data.getValue(page, "pubuser");
            if (usersSet.contains(pubuser)) {
                return StringLocalizer.get("dbmt.error.install.alreadyexists", new String[]{pubuser});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (data.getValue(page, "pubpass").isEmpty()) {
            return StringLocalizer.get("dbmt.error.install.passwordnotentered", new String[]{data.getValue(page, "pubuser")});
        }
        if (!data.getValue(page, "pubpass").equalsIgnoreCase(data.getValue(page, "pubpassconfirm"))) {
            return StringLocalizer.get("dbmt.error.install.passwordnotmatchconfirm", new String[]{data.getValue(page, "pubuser")});
        }
        if ("true".equalsIgnoreCase(existingPubUser) && "true".equalsIgnoreCase(existingPrivUser) && data.getValue(page, "existingPriv").equalsIgnoreCase(data.getValue(page, "existingPub"))) {
            return StringLocalizer.get("dbmt.error.install.userduplicates", new String[]{data.getValue(page, "existingPriv")});
        }
        if (!"true".equalsIgnoreCase(existingPubUser) && !"true".equalsIgnoreCase(existingPrivUser) && data.getValue(page, "privuser").equalsIgnoreCase(data.getValue(page, "pubuser"))) {
            return StringLocalizer.get("dbmt.error.install.userduplicates", new String[]{"privileged user ", "public user"});
        }
        return null;
    }
}

