/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.common.StrUtil;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import java.sql.SQLException;
import java.util.HashSet;

public class SSDatabasePXUsersValid
implements TransitionMap.TransitionValidator {
    private final ConnectionClass m_connectionClassMaster;

    public SSDatabasePXUsersValid(ConnectionClass connectionClassMaster) {
        this.m_connectionClassMaster = connectionClassMaster;
    }

    private String validatePxTableSpaceSettings(WizardInteractorData data, JobProperties jobProps, String page) throws ConnectionNotFoundException, InteractorDataError {
        String existingPxTableSpace = data.getValue(page, "useexistingtablespace");
        String tbsp = null;
        String size = null;
        String loc = "";
        if ("true".equalsIgnoreCase(existingPxTableSpace)) {
            tbsp = data.getValue(page, "existingPxTbsp");
            if (StrUtil.isEmpty((String)tbsp)) {
                return StringLocalizer.get("dbmt.error.install.requiredfieldsempty");
            }
        } else {
            tbsp = data.getValue(page, "pxfile");
            size = data.getValue(page, "pxsize");
            loc = data.getValue(page, "pxloc");
            if (StrUtil.isEmpty((String)tbsp) || StrUtil.isEmpty((String)size) || StrUtil.isEmpty((String)loc)) {
                return StringLocalizer.get("dbmt.error.install.requiredfieldsempty");
            }
        }
        return null;
    }

    @Override
    public String validate(WizardInteractorData data, JobProperties jobProps, String page) throws ConnectionNotFoundException, InteractorDataError {
        String tableSpErrors;
        String connectStringMaster = jobProps.getConnection(this.m_connectionClassMaster);
        if (new ConnectStringParse(connectStringMaster).getDbtype() == ServerType.ORACLE && !StrUtil.isEmpty((String)(tableSpErrors = this.validatePxTableSpaceSettings(data, jobProps, page)))) {
            return tableSpErrors;
        }
        String existingPxrptUser = data.getValue(page, "useexistingpxrptuser");
        try {
            String pxrptuser;
            DatabaseConnection conn;
            HashSet<String> usersSet;
            if (!"true".equalsIgnoreCase(existingPxrptUser) && (usersSet = new HashSet<String>(SqlServerLogic.getDatabaseUsers(conn = new DatabaseConnection(connectStringMaster)))).contains(pxrptuser = data.getValue(page, "pxrptuser"))) {
                return StringLocalizer.get("dbmt.error.install.alreadyexists", new String[]{pxrptuser});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

