/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.PropSet;
import com.primavera.database.common.PropertiesFileManager;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import java.io.IOException;
import java.util.Map;

public enum DBMTPropertySets {
    APPLICATION("com/primavera/database/tools/dbmt/Application.properties", PropertiesFileManager.Retriever.DEFAULT_RETRIEVER),
    UI("com/primavera/database/tools/dbmt/gui/UI.properties", PropertiesFileManager.Retriever.DEFAULT_RETRIEVER);

    private final PropSet m_props;

    private DBMTPropertySets(String resourceLocation, PropertiesFileManager.PropRetriever retriever) {
        this.m_props = new PropSet(resourceLocation, retriever);
        try {
            for (Map.Entry<Object, Object> entry : retriever.loadProperties(resourceLocation).entrySet()) {
                this.m_props.getProps().put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException e) {
            DBMTLogger.info(Channel.DEV, "Unable to load properties file: " + resourceLocation);
        }
    }

    public PropSet getProps() {
        return this.m_props;
    }

    public String get(String propName) {
        return this.m_props.getProps().getProperty(propName);
    }

    public void set(String propName, String propValue) {
        this.m_props.getProps().setProperty(propName, propValue);
    }

    public String get(String propName, String defaultValue) {
        return this.m_props.getProps().getProperty(propName, defaultValue);
    }
}

