/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationImpl;
import com.primavera.database.tools.dbmt.ServerInfo;
import com.primavera.database.tools.dbmt.gui.util.FileDialogUtil;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.NodeLink;
import com.primavera.database.tools.dbmt.xml.util.SimpleHandler;
import com.primavera.database.tools.dbmt.xml.util.application.nodes.ApplicationNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ApplicationHelper {
    private static final Application s_app = ApplicationImpl.createApplication();
    private static final String APPLICATION_STATE_FILE_NAME = "DBMTApplicationState.xml";

    public static Application app() {
        return s_app;
    }

    private static PrintStream getApplicationStateOutputStream() {
        File userHome = new File(System.getProperty("user.home"));
        File file = new File(userHome.getAbsolutePath() + File.separatorChar + APPLICATION_STATE_FILE_NAME);
        try {
            return new PrintStream(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static InputStream getApplicationStateInputStream() {
        File userHome = new File(System.getProperty("user.home"));
        File file = new File(userHome.getAbsolutePath() + File.separatorChar + APPLICATION_STATE_FILE_NAME);
        if (!file.exists()) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void writeApplicationState() {
        PrintStream out = ApplicationHelper.getApplicationStateOutputStream();
        if (out != null) {
            ApplicationHelper.writeApplicationToStream(ApplicationHelper.app(), out);
        }
    }

    public static void readApplicationState() {
        InputStream in = ApplicationHelper.getApplicationStateInputStream();
        if (in != null) {
            ApplicationHelper.readApplicationFromStream(ApplicationHelper.app(), in);
        }
    }

    public static void writeApplicationToStream(Application app, PrintStream out) {
        out.println("<?xml version=\"1.0\"?>");
        out.println();
        out.print("<application>");
        for (ServerInfo server : app.getConnections()) {
            out.print(ApplicationHelper.getServerElement(server));
        }
        out.println("<user-directories>");
        ApplicationHelper.writeUserDirectories(out);
        out.println("</user-directories>");
        out.println("</application>");
    }

    private static void writeUserDirectories(PrintStream out) {
        for (Map.Entry<String, String> entry : FileDialogUtil.getEntrySet()) {
            out.println("<userdir key=\"" + entry.getKey() + "\" location=\"" + entry.getValue() + "\"/>");
        }
    }

    private static String getServerElement(ServerInfo server) {
        StringBuffer sb = new StringBuffer();
        String elemName = null;
        if (server.getType() == ServerType.ORACLE) {
            elemName = "oracle";
        } else if (server.getType() == ServerType.SQLSERVER) {
            elemName = "mssql";
        } else if (server.getType() == ServerType.SYBASE) {
            elemName = "sybase";
        }
        sb.append("<" + elemName);
        for (Map.Entry<Object, Object> propEntry : server.serverProperties().entrySet()) {
            sb.append(" " + propEntry.getKey() + "=" + ApplicationHelper.quote(propEntry.getValue()));
        }
        sb.append("/>");
        return sb.toString();
    }

    private static String quote(Object value) {
        if (value == null) {
            return "\"\"";
        }
        return "\"" + value.toString() + "\"";
    }

    public static void readApplicationFromStream(Application app, InputStream input) {
        try {
            if (input == null) {
                return;
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(input, (DefaultHandler)new SimpleHandler(ApplicationHelper.getRootNode(app)));
            return;
        }
        catch (Throwable e) {
            DBMTLogger.error(Channel.USER, "Problem reading application state: " + e);
            return;
        }
    }

    private static NodeLink getRootNode(final Application app) {
        return new NodeLink(){

            @Override
            public NodeHandler nextNode(String elemName, Attributes attr) {
                if ("application".equals(elemName)) {
                    return new ApplicationNode(app, attr);
                }
                return null;
            }

            @Override
            public String path() {
                return "";
            }
        };
    }
}

