/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader.output;

import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.common.DataDictionary;
import com.primavera.database.common.container.RowScrubber;
import com.primavera.database.common.container.SQLRowContainer;
import com.primavera.database.tools.Dataloader.SampleDataScrubber;
import com.primavera.database.tools.Dataloader.output.XMLOutputter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipTableOutputter {
    private final String XML_EXT = ".xml";
    private String m_sql = "";
    private String m_table = "";
    private final RowScrubber m_scrubber = new SampleDataScrubber();

    public String getSQL() {
        return this.m_sql;
    }

    public void output(Connection conn, String table, ZipOutputStream z) throws PrimaveraDatabaseException {
        try {
            DataDictionary dd = new DataDictionary(conn);
            if (!dd.tableExists(table)) {
                throw new PrimaveraDatabaseException("Table " + table + " does not exist");
            }
            if (this.m_sql.length() == 0 || !this.m_table.equalsIgnoreCase(table)) {
                this.m_sql = "";
                ArrayList<String> columns = dd.getColumns(table);
                Iterator i = columns.iterator();
                while (i.hasNext()) {
                    if (this.m_sql.length() == 0) {
                        this.m_sql = "SELECT /*zipoutputter:" + table + "*/ " + (String)i.next();
                        continue;
                    }
                    this.m_sql = this.m_sql + "," + (String)i.next();
                }
                this.m_sql = this.m_sql + " FROM " + table;
                this.m_table = table;
            }
            if (!this.m_scrubber.isExcluded(table)) {
                System.out.println(this.m_sql);
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(this.m_sql);
                SQLRowContainer src = new SQLRowContainer(conn, rs, table, this.m_scrubber);
                XMLOutputter xout = new XMLOutputter();
                ZipEntry entry = new ZipEntry(table.toLowerCase() + ".xml");
                z.putNextEntry(entry);
                xout.output(src, z);
                z.closeEntry();
                rs.close();
                stmt.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new PrimaveraDatabaseException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new PrimaveraDatabaseException(ex.getMessage());
        }
    }
}

