/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.Dataloader.output;

import com.primavera.database.PrimaveraDatabaseException;
import com.primavera.database.common.DataDictionary;
import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.tools.Dataloader.TableScrubber;
import com.primavera.database.tools.Dataloader.ZipOutputStreamProvider;
import com.primavera.database.tools.Dataloader.output.ZipTableOutputter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipOutputter {
    private String m_tablepattern = "%";
    private List<String> m_tables;
    private final List<String> m_excludedTables;
    private Connection m_conn;
    private TableScrubber m_scrubber = new TableScrubber();
    private final ZipOutputStreamProvider m_outputProvider;

    public ZipOutputter(ZipOutputStreamProvider provider) {
        this.m_tables = new ArrayList<String>();
        this.m_excludedTables = new ArrayList<String>();
        this.m_outputProvider = provider;
    }

    public void setScrubber(TableScrubber scrubber) {
        this.m_scrubber = scrubber;
    }

    public void setTablePattern(String pattern) {
        this.m_tablepattern = pattern;
    }

    public void setTables(ArrayList<String> tables) {
        this.m_tables = tables;
    }

    public String getTablePattern() {
        return this.m_tablepattern;
    }

    public void excludeTable(String table) {
        this.m_excludedTables.add(table);
    }

    private void createZip() throws IOException, PrimaveraDatabaseException {
        ZipOutputStream zipOutputStream = this.m_outputProvider.getOutputStream();
        ZipTableOutputter zipTableOutputter = new ZipTableOutputter();
        for (String tablename : this.m_tables) {
            if (this.m_scrubber.isExcluded(tablename)) continue;
            zipTableOutputter.output(this.m_conn, tablename, zipOutputStream);
        }
        ZipEntry entry = new ZipEntry("prm_info.txt");
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(DatabaseHelper.getSchemaVersionString(this.m_conn).getBytes());
        zipOutputStream.closeEntry();
        zipOutputStream.close();
    }

    public void output(Connection conn) throws PrimaveraDatabaseException {
        this.m_conn = conn;
        if (this.m_tables.size() == 0) {
            try {
                DataDictionary dd = new DataDictionary(conn);
                if (this.m_tables == null || this.m_tables.isEmpty()) {
                    this.m_tables = dd.getTables(this.m_tablepattern);
                }
                if (this.m_tables.size() == 0) {
                    throw new PrimaveraDatabaseException("No tables for pattern " + this.m_tablepattern);
                }
            }
            catch (SQLException ex) {
                throw new PrimaveraDatabaseException(ex.getMessage());
            }
        }
        try {
            this.createZip();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PrimaveraDatabaseException(ex.getMessage());
        }
    }
}

