/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.container;

import com.primavera.database.common.Base64;
import com.primavera.database.common.GenericDataTypes;
import com.primavera.database.common.TableManipulatorInterface;
import com.primavera.database.common.container.RowContainer;
import com.primavera.database.common.container.RowElement;
import com.primavera.database.common.container.XMLRowGenerator;
import com.primavera.database.common.container.XMLRowHandler;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class RowDataHandler
extends DefaultHandler {
    private boolean loadingMetaData = true;
    private int row = 0;
    XMLRowHandler rowhandler = null;
    RowContainer rc = new RowContainer();
    private final TableManipulatorInterface m_tableManipulator;

    public RowDataHandler(TableManipulatorInterface manipulator, String tableName) {
        this.m_tableManipulator = manipulator;
        this.rc.setName(tableName);
    }

    public void setRowhandler(XMLRowHandler rowhandler) {
        this.rowhandler = rowhandler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("FIELD".equalsIgnoreCase(qName)) {
            this.loadingMetaData = true;
            RowElement re = new RowElement();
            re.setName(atts.getValue("attrname"));
            GenericDataTypes gType = XMLRowGenerator.GenericDataTypeFromFieldType(atts.getValue("fieldtype"), atts.getValue("SUBTYPE"));
            re.setType(gType);
            if (atts.getValue("WIDTH") != null) {
                int width = Integer.parseInt(atts.getValue("WIDTH"));
                re.setSize(width);
            }
            this.rc.addElement(re);
        } else if ("ROW".equalsIgnoreCase(qName)) {
            if (this.loadingMetaData) {
                this.loadingMetaData = false;
                this.rowhandler.processMetaData(this.rc);
            }
            Iterator<RowElement> i = this.rc.iterator();
            String value = null;
            while (i.hasNext()) {
                RowElement ire = i.next();
                ire.setEmpty();
                try {
                    if (atts.getValue(ire.getName()) == null) continue;
                    String prelimValue = atts.getValue(ire.getName());
                    if (this.m_tableManipulator.toDecodeField(this.rc.getName().toUpperCase(), ire.getName().toUpperCase())) {
                        byte[] testBytes = Base64.decode(prelimValue);
                        value = new String(testBytes);
                    } else {
                        value = XMLRowGenerator.isLobType(ire.getType()) && prelimValue.startsWith("b64") ? new String(Base64.decode(prelimValue.substring("b64".length()))) : prelimValue;
                    }
                    ire.setValue(value);
                }
                catch (Exception e) {
                    throw new SAXException(e.getMessage());
                }
            }
            ++this.row;
            this.rowhandler.processRow(this.rc, this.row);
        } else if ("VALUE".equalsIgnoreCase(qName)) {
            // empty if block
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"ROW".equalsIgnoreCase(name) && "ROWDATA".equalsIgnoreCase(name)) {
            this.rowhandler.finishedProcessingRows();
        }
    }
}

