/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.common.container;

import com.primavera.common.StrUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class EncodingUtil {
    public static final Map<String, String> s_htmlEncodeChars = new HashMap<String, String>();
    public static final Map<String, String> s_htmlDecodeChars = new HashMap<String, String>();
    public static final Map<String, String> s_removeInvalidFileChars = new HashMap<String, String>();
    public static final String UTF_STR = "UTF-8";

    public static String encodeString(String s, Map<String, String> encodingChars) {
        return EncodingUtil.encodeString(s, encodingChars, false);
    }

    public static String encodeString(String s, Map<String, String> encodingChars, boolean supportXML) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        StringBuilder str = new StringBuilder(len + 16);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            String encodedStr = encodingChars.get(String.valueOf(ch));
            if (encodedStr == null) {
                if (supportXML && ch < ' ') {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                    continue;
                }
                str.append(ch);
                continue;
            }
            str.append(encodedStr);
        }
        return str.toString();
    }

    public static String decodeString(String s, Map<String, String> decodingChars) {
        if (s == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        try {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '&') {
                    int pos = s.indexOf(59, i);
                    if (pos != -1) {
                        String temp = s.substring(i, pos + 1);
                        if (temp.charAt(1) == '#') {
                            int strLen = temp.length();
                            if (strLen > 3) {
                                char thisChar;
                                try {
                                    thisChar = (char)Integer.parseInt(temp.substring(2, strLen - 1));
                                }
                                catch (NumberFormatException e) {
                                    str.append(ch);
                                    continue;
                                }
                                thisChar = (char)Integer.parseInt(temp.substring(2, strLen - 1));
                                str.append(thisChar);
                            }
                        } else {
                            String result = decodingChars.get(temp);
                            if (result == null) {
                                str.append(temp);
                            } else {
                                str.append(result);
                            }
                        }
                        i = pos;
                        continue;
                    }
                    str.append(ch);
                    continue;
                }
                str.append(ch);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str.toString();
    }

    public static String encodeHTML(String s) {
        return EncodingUtil.encodeString(s, s_htmlEncodeChars, false);
    }

    public static String encodeXML(String s) {
        return EncodingUtil.encodeString(s, s_htmlEncodeChars, true);
    }

    public static String decodeHTML(String s) {
        return EncodingUtil.decodeString(s, s_htmlDecodeChars);
    }

    public static String jsFormat(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block7;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String removeInvalidFileCharacters(String fileName) {
        return EncodingUtil.encodeString(fileName, s_removeInvalidFileChars);
    }

    public static String removeBOMCharactersFromString(String rawText) {
        int UTF8_BOM_LENGTH = 3;
        byte[] bytes = rawText.getBytes();
        if (EncodingUtil.isUTF8String(rawText)) {
            try {
                int length = bytes.length - 3;
                byte[] barray = new byte[length];
                System.arraycopy(bytes, 3, barray, 0, barray.length);
                rawText = new String(barray, UTF_STR);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (rawText.startsWith(UTF_STR)) {
            rawText = rawText.replace(UTF_STR, "");
        } else if (rawText.startsWith("\ufeff")) {
            rawText = rawText.replace("\ufeff", "");
        }
        return rawText;
    }

    public static boolean isUTF8String(String str) {
        return (str.charAt(0) & 0xFF) == 239 && (str.charAt(1) & 0xFF) == 187 && (str.charAt(2) & 0xFF) == 191;
    }

    public static String addUTF8Prefix(String blobStr) {
        if (!StrUtil.isEmpty((String)blobStr) && !blobStr.startsWith(UTF_STR)) {
            blobStr = UTF_STR + blobStr;
        }
        return blobStr;
    }

    static {
        s_htmlEncodeChars.put("<", "&lt;");
        s_htmlEncodeChars.put(">", "&gt;");
        s_htmlEncodeChars.put("&", "&amp;");
        s_htmlEncodeChars.put("\"", "&quot;");
        s_htmlEncodeChars.put("'", "&apos;");
        s_htmlEncodeChars.put("'", "&#39;");
        s_htmlEncodeChars.put("\n", "&#10;");
        s_htmlEncodeChars.put("\r", "&#13;");
        s_htmlEncodeChars.put("*", "&#42;");
        s_htmlDecodeChars.put("&lt;", "<");
        s_htmlDecodeChars.put("&gt;", ">");
        s_htmlDecodeChars.put("&amp;", "&");
        s_htmlDecodeChars.put("&quot;", "\"");
        s_htmlDecodeChars.put("&apos;", "'");
        s_htmlDecodeChars.put("&#39;", "'");
        s_htmlDecodeChars.put("&#42;", "*");
        s_htmlDecodeChars.put("&nbsp;", " ");
        s_removeInvalidFileChars.put(":", "");
        s_removeInvalidFileChars.put("*", "");
        s_removeInvalidFileChars.put("\\", "");
        s_removeInvalidFileChars.put("/", "");
        s_removeInvalidFileChars.put("!", "");
        s_removeInvalidFileChars.put("?", "");
        s_removeInvalidFileChars.put("\"", "");
        s_removeInvalidFileChars.put("<", "");
        s_removeInvalidFileChars.put(">", "");
        s_removeInvalidFileChars.put("|", "");
        s_removeInvalidFileChars.put(" ", "");
    }
}

