/*
 * Decompiled with CFR 0.152.
 */
package fixtures.util;

import fixtures.util.DBSqlParser;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DBResultSet {
    List<DbField> m_fieldList = new ArrayList<DbField>();
    BlockingQueue<DbRow> m_rowList = new ArrayBlockingQueue<DbRow>(5000);
    String m_sql;
    long m_sqlExecStartTime;
    long m_sqlExecEndTime;
    DBSqlParser m_sqlParser;
    volatile long m_rowsAffected;
    private volatile boolean m_populateComplete = false;
    private volatile boolean m_populateBegin = true;

    public String getBlobValueAsString(ResultSet rs, int columnIndex) {
        try {
            Blob blob = rs.getBlob(columnIndex);
            if (rs.wasNull()) {
                return "";
            }
            byte[] blobBytes = blob.getBytes(1L, (int)blob.length());
            return new String(blobBytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getClobValueAsString(ResultSet rs, int columnIndex) {
        try {
            Clob clob = rs.getClob(columnIndex);
            if (rs.wasNull()) {
                return "";
            }
            return clob.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void populate(ResultSet rs) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                this.m_fieldList.add(new DbField(metaData.getColumnName(i + 1), metaData.getColumnType(i + 1), metaData.getPrecision(i + 1), metaData.getScale(i + 1)));
            }
            ExecutorService populateService = Executors.newSingleThreadExecutor();
            populateService.submit(new PopulateResultSet(metaData, rs));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setPopulateComplete(boolean populateComplete) {
        this.m_populateComplete = populateComplete;
    }

    protected void setPopulateBegin(boolean populateBegin) {
        this.m_populateBegin = populateBegin;
    }

    protected boolean isPopulateComplete() {
        return this.m_populateComplete;
    }

    protected boolean isPopulateBegin() {
        return this.m_populateBegin;
    }

    public void run() {
        try {
            DbRow row = new DbRow();
            this.m_rowList.put(row);
            ++this.m_rowsAffected;
            this.setPopulateComplete(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class PopulateResultSet
    implements Runnable {
        ResultSetMetaData m_metaData;
        ResultSet m_rs;

        public PopulateResultSet(ResultSetMetaData metaData, ResultSet rs) {
            this.m_metaData = metaData;
            this.m_rs = rs;
        }

        @Override
        public void run() {
            try {
                while (this.m_rs.next()) {
                    DbRow row = new DbRow();
                    int columnCount = this.m_metaData.getColumnCount();
                    block8: for (int i = 0; i < columnCount; ++i) {
                        int columnType = this.m_metaData.getColumnType(i + 1);
                        switch (columnType) {
                            case 2004: {
                                row.m_values.add(DBResultSet.this.getBlobValueAsString(this.m_rs, i + 1));
                                continue block8;
                            }
                            case 2005: {
                                row.m_values.add(DBResultSet.this.getClobValueAsString(this.m_rs, i + 1));
                                continue block8;
                            }
                            case -1: {
                                String strValue = this.m_rs.getString(i + 1);
                                if (this.m_rs.wasNull()) {
                                    row.m_values.add("");
                                    continue block8;
                                }
                                row.m_values.add(strValue);
                                continue block8;
                            }
                            default: {
                                Object value = this.m_rs.getObject(i + 1);
                                if (this.m_rs.wasNull()) {
                                    row.m_values.add("");
                                    continue block8;
                                }
                                row.m_values.add(value);
                            }
                        }
                    }
                    DBResultSet.this.m_rowList.put(row);
                    ++DBResultSet.this.m_rowsAffected;
                }
                DBResultSet.this.setPopulateComplete(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class DbRow {
        List<Object> m_values = new ArrayList<Object>();
    }

    public static class DbField {
        String m_name;
        int m_type;
        int m_precision;
        int m_scale;

        public DbField(String name, int type, int precision, int scale) {
            this.m_name = name;
            this.m_type = type;
            this.m_precision = precision;
            this.m_scale = scale == -127 ? 10 : scale;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

