/*
 * Decompiled with CFR 0.152.
 */
package fixtures.util;

import fit.ActionFixture;
import fixtures.util.DBResultSet;
import fixtures.util.DBSqlParser;
import fixtures.util.DatabaseCompareConnFixture;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CompareFixture
extends ActionFixture {
    private static int s_compareCount;
    public static Map<Integer, String> s_javaSqlTypes;
    public static String NEW_LINE;
    private String m_testCaseName;
    private final boolean m_logFailuresOnly = true;
    private int m_keyCount = 1;
    private Connection m_SourceConn;
    private Connection m_TargetConn;
    private String m_sourceSQL;
    private String m_targetSQL;
    private DBResultSet dbSourceResultSet;
    private DBResultSet dbTargetResultSet;
    private boolean m_sHasResultSet = false;
    private boolean m_tHasResultSet = false;
    private String m_sourceTable;
    long m_comparisonStartTime;
    long m_comparisonEndTime;
    private final Set<String> m_missingSourceRows;
    private final Set<String> m_missingTargetRows;
    CompareValuesAs m_compareValuesAsNumber = new CompareValuesAsNumber();
    CompareValuesAs m_compareValuesAsString = new CompareValuesAsString();
    CompareValuesAs m_compareValuesAsLargeString = new CompareValuesAsLargeString();
    CompareValuesAs m_compareValuesAsDate = new CompareValuesAsDate();

    public CompareFixture() {
        ++s_compareCount;
        this.m_missingSourceRows = new LinkedHashSet<String>();
        this.m_missingTargetRows = new LinkedHashSet<String>();
    }

    public static String getJavaSqlTypeAsString(int type) {
        return s_javaSqlTypes.get(type);
    }

    private void logExecution(String prefix, DBResultSet resultSet) {
        System.out.println(prefix + " SQL: " + resultSet.m_sql);
        System.out.println(prefix + " Field Count: " + resultSet.m_fieldList.size());
        System.out.println("Rows found/affected: " + resultSet.m_rowsAffected);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(resultSet.m_sqlExecStartTime);
        System.out.println(prefix + " Execution Start Time: " + cal.getTime());
        cal.setTimeInMillis(resultSet.m_sqlExecEndTime);
        System.out.println(prefix + " Execution End Time: " + cal.getTime());
        System.out.println(prefix + " Elapsed Execution Time (in milliseconds): " + (resultSet.m_sqlExecEndTime - resultSet.m_sqlExecStartTime));
    }

    public void setSourceSQL(String sourcesql) {
        this.m_sourceSQL = sourcesql;
    }

    public void setTargetSQL(String targetsql) {
        this.m_targetSQL = targetsql;
    }

    public void setKeyCount(int keycount) {
        this.m_keyCount = keycount;
    }

    private String getKeyValueString(DBResultSet.DbField[] keyFields, Object[] keyValues) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyFields.length; ++i) {
            sb.append("[");
            sb.append(keyFields[i].m_name);
            sb.append("=");
            sb.append(keyValues[i] == null ? "NULL" : keyValues[i].toString());
            sb.append("]");
        }
        return sb.toString();
    }

    private void logExecution() {
        System.out.print(NEW_LINE);
        System.out.println("[ EXECUTION ]" + (this.m_testCaseName != null ? " [ " + this.m_testCaseName + " ]" : "") + " [ " + s_compareCount + " ] [ Source: " + this.m_sourceTable + "]:");
        this.logExecution("Source", this.dbSourceResultSet);
        this.logExecution("Target", this.dbTargetResultSet);
        System.out.print(NEW_LINE);
    }

    public boolean execute() {
        this.dbSourceResultSet = new DBResultSet();
        this.dbTargetResultSet = new DBResultSet();
        this.dbSourceResultSet.m_sql = this.m_sourceSQL;
        this.dbSourceResultSet.m_sqlParser = new DBSqlParser(this.m_sourceSQL);
        this.dbTargetResultSet.m_sql = this.m_targetSQL;
        this.dbTargetResultSet.m_sqlParser = new DBSqlParser(this.m_targetSQL);
        this.m_SourceConn = DatabaseCompareConnFixture.getInstance().getSource();
        this.m_TargetConn = DatabaseCompareConnFixture.getInstance().getTarget();
        PreparedStatement ps = null;
        PreparedStatement pt = null;
        try {
            ps = this.m_SourceConn.prepareStatement(this.m_sourceSQL);
            pt = this.m_TargetConn.prepareStatement(this.m_targetSQL);
            this.m_sHasResultSet = ps.execute();
            this.m_tHasResultSet = pt.execute();
            if (this.m_sHasResultSet && this.m_tHasResultSet) {
                ResultSet rsSource = null;
                ResultSet rsTarget = null;
                rsSource = ps.getResultSet();
                rsTarget = pt.getResultSet();
                this.dbSourceResultSet.populate(rsSource);
                this.dbTargetResultSet.populate(rsTarget);
                this.m_sourceTable = this.dbSourceResultSet.m_sqlParser.getTable();
            } else {
                try {
                    this.dbSourceResultSet.m_rowsAffected = ps.getUpdateCount();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.logExecution();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean executeAndCompare() {
        if (this.execute()) {
            return this.compare();
        }
        return false;
    }

    private void logMissingRows(Set<String> set) {
        for (String str : set) {
            System.out.println("   " + str);
        }
    }

    private DBResultSet.DbRow takeNextRow(DBResultSet dbResultSet) {
        DBResultSet.DbRow result = null;
        boolean rowTaken = false;
        while (!rowTaken) {
            try {
                if (!dbResultSet.m_rowList.isEmpty()) {
                    result = dbResultSet.m_rowList.take();
                    rowTaken = true;
                    continue;
                }
                if (!dbResultSet.isPopulateComplete()) {
                    Thread.sleep(1L);
                    continue;
                }
                result = null;
                rowTaken = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private int compareValues(DBResultSet.DbField sourceField, DBResultSet.DbField targetField, Object sourceValue, Object targetValue) {
        if (sourceValue == null && targetValue == null) {
            return 0;
        }
        if (sourceValue == null && targetValue != null) {
            return -1;
        }
        if (sourceValue != null && targetValue == null) {
            return 1;
        }
        CompareValuesAs compareValuesAs = null;
        if (sourceField.m_type == 4 || targetField.m_type == 4) {
            compareValuesAs = this.m_compareValuesAsNumber;
        } else if (sourceField.m_type == 2 || targetField.m_type == 2) {
            compareValuesAs = this.m_compareValuesAsNumber;
        } else if (sourceField.m_type == 93 || targetField.m_type == 93) {
            compareValuesAs = this.m_compareValuesAsDate;
        } else if (sourceField.m_type == 12 || targetField.m_type == 12) {
            compareValuesAs = this.m_compareValuesAsString;
        } else if (sourceField.m_type == -1 || targetField.m_type == -1) {
            compareValuesAs = this.m_compareValuesAsString;
        } else if (sourceField.m_type == 2004 || targetField.m_type == 2004) {
            compareValuesAs = this.m_compareValuesAsString;
        } else if (sourceField.m_type == 2005 || targetField.m_type == 2005) {
            compareValuesAs = this.m_compareValuesAsString;
        }
        if (compareValuesAs == null) {
            System.out.println("[ERROR]: Unhandled field type comparison.  [Source field: " + sourceField.m_name + "; Type: " + CompareFixture.getJavaSqlTypeAsString(sourceField.m_type) + "] [Target field: " + targetField.m_name + "; Type: " + CompareFixture.getJavaSqlTypeAsString(targetField.m_type) + "]");
            throw new RuntimeException("[ERROR]: Unhandled field type comparison.  [Source field: " + sourceField.m_name + "; Type: " + CompareFixture.getJavaSqlTypeAsString(sourceField.m_type) + "] [Target field: " + targetField.m_name + "; Type: " + CompareFixture.getJavaSqlTypeAsString(targetField.m_type) + "]");
        }
        return compareValuesAs.compare(sourceField, targetField, sourceValue, targetValue);
    }

    private int keysMatch(DBResultSet.DbField[] sourceKeyFields, DBResultSet.DbField[] targetKeyFields, Object[] sourceKeyFieldValues, Object[] targetKeyFieldValues) {
        for (int i = 0; i < sourceKeyFields.length; ++i) {
            int valueCompare = this.compareValues(sourceKeyFields[i], targetKeyFields[i], sourceKeyFieldValues[i], targetKeyFieldValues[i]);
            if (valueCompare == 0) continue;
            return valueCompare;
        }
        return 0;
    }

    private void logComparisonErrorDetail(String prefix, DBResultSet.DbField[] keyFields, Object[] keyFieldValues, DBResultSet.DbField field, Object value) {
        System.out.println("   " + prefix + " key: " + this.getKeyValueString(keyFields, keyFieldValues));
        System.out.println("   " + prefix + " field name: " + field.m_name);
        System.out.println("   " + prefix + " field data type: " + CompareFixture.getJavaSqlTypeAsString(field.m_type));
        System.out.println("   " + prefix + " field value: " + (value == null ? "NULL" : value.toString()));
    }

    private void logComparisonError(String errorMsg, DBResultSet.DbField[] sourceKeyFields, DBResultSet.DbField[] targetKeyFields, Object[] sourceKeyFieldValues, Object[] targetKeyFieldValues, DBResultSet.DbField sourceField, DBResultSet.DbField targetField, Object sourceValue, Object targetValue) {
        System.out.print(NEW_LINE);
        System.out.println(errorMsg);
        this.logComparisonErrorDetail("Source", sourceKeyFields, sourceKeyFieldValues, sourceField, sourceValue);
        System.out.println(NEW_LINE);
        this.logComparisonErrorDetail("Target", targetKeyFields, targetKeyFieldValues, targetField, targetValue);
        System.out.print(NEW_LINE);
    }

    private boolean logComparisonHeader() {
        this.logExecution();
        System.out.print(NEW_LINE);
        System.out.println("[ COMPARISON ]" + (this.m_testCaseName != null ? " [ " + this.m_testCaseName + " ]" : "") + " [ " + s_compareCount + " ] [ Source: " + this.m_sourceTable + "  ]");
        return true;
    }

    private boolean compare() {
        boolean result = true;
        long totalComparisonErrors = 0L;
        long rowsWithComparisonErrors = 0L;
        boolean headerLogged = false;
        this.m_comparisonStartTime = System.currentTimeMillis();
        if (this.dbSourceResultSet.m_fieldList.size() != this.dbTargetResultSet.m_fieldList.size()) {
            headerLogged = this.logComparisonHeader();
            System.out.println("[ERROR]: Source and Target field list count does not match: Source (" + this.dbSourceResultSet.m_fieldList.size() + ") Target(" + this.dbTargetResultSet.m_fieldList.size() + ")");
            return false;
        }
        DBResultSet.DbRow sourceRow = null;
        DBResultSet.DbRow targetRow = null;
        DBResultSet.DbField[] sourceKeyFields = new DBResultSet.DbField[this.m_keyCount];
        DBResultSet.DbField[] targetKeyFields = new DBResultSet.DbField[this.m_keyCount];
        for (int i = 0; i < this.m_keyCount; ++i) {
            sourceKeyFields[i] = this.dbSourceResultSet.m_fieldList.get(i);
            targetKeyFields[i] = this.dbTargetResultSet.m_fieldList.get(i);
        }
        boolean takeSourceRow = true;
        boolean takeTargetRow = true;
        while (!(this.dbSourceResultSet.isPopulateComplete() && this.dbSourceResultSet.m_rowList.isEmpty() && this.dbTargetResultSet.isPopulateComplete() && this.dbTargetResultSet.m_rowList.isEmpty())) {
            if (takeSourceRow) {
                sourceRow = this.takeNextRow(this.dbSourceResultSet);
            }
            if (takeTargetRow) {
                targetRow = this.takeNextRow(this.dbTargetResultSet);
            }
            if (sourceRow == null && targetRow == null) break;
            Object[] sourceKeyFieldValues = new Object[this.m_keyCount];
            Object[] targetKeyFieldValues = new Object[this.m_keyCount];
            for (int i = 0; i < this.m_keyCount; ++i) {
                if (sourceRow != null) {
                    sourceKeyFieldValues[i] = sourceRow.m_values.get(i);
                }
                if (targetRow == null) continue;
                targetKeyFieldValues[i] = targetRow.m_values.get(i);
            }
            if (targetRow == null) {
                result = false;
                this.m_missingSourceRows.add("Source key: " + this.getKeyValueString(sourceKeyFields, sourceKeyFieldValues));
                takeSourceRow = true;
                takeTargetRow = false;
                continue;
            }
            if (sourceRow == null) {
                result = false;
                this.m_missingTargetRows.add("Target key: " + this.getKeyValueString(targetKeyFields, targetKeyFieldValues));
                takeTargetRow = true;
                takeSourceRow = false;
                continue;
            }
            int keyMatch = this.keysMatch(sourceKeyFields, targetKeyFields, sourceKeyFieldValues, targetKeyFieldValues);
            if (keyMatch == -1) {
                result = false;
                this.m_missingSourceRows.add("Source key: " + this.getKeyValueString(sourceKeyFields, sourceKeyFieldValues));
                takeSourceRow = true;
                takeTargetRow = false;
                continue;
            }
            if (keyMatch == 1) {
                result = false;
                this.m_missingTargetRows.add("Target key: " + this.getKeyValueString(targetKeyFields, targetKeyFieldValues));
                takeTargetRow = true;
                takeSourceRow = false;
                continue;
            }
            boolean rowHasComparisonError = false;
            for (int i = this.m_keyCount; i < this.dbSourceResultSet.m_fieldList.size(); ++i) {
                Object targetValue;
                Object sourceValue;
                DBResultSet.DbField targetField;
                DBResultSet.DbField sourceField = this.dbSourceResultSet.m_fieldList.get(i);
                int compareResult = this.compareValues(sourceField, targetField = this.dbTargetResultSet.m_fieldList.get(i), sourceValue = sourceRow.m_values.get(i), targetValue = targetRow.m_values.get(i));
                if (compareResult == 0) continue;
                rowHasComparisonError = true;
                if (!headerLogged) {
                    headerLogged = this.logComparisonHeader();
                }
                this.logComparisonError("[ERROR]: Value mismatch.", sourceKeyFields, targetKeyFields, sourceKeyFieldValues, targetKeyFieldValues, sourceField, targetField, sourceValue, targetValue);
                ++totalComparisonErrors;
                result = false;
            }
            if (rowHasComparisonError) {
                ++rowsWithComparisonErrors;
            }
            takeSourceRow = true;
            takeTargetRow = true;
        }
        this.m_comparisonEndTime = System.currentTimeMillis();
        if (!result) {
            if (!headerLogged) {
                headerLogged = this.logComparisonHeader();
            }
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(this.m_comparisonStartTime);
            System.out.print(NEW_LINE);
            System.out.println("Comparison Start Time: " + cal.getTime());
            cal.setTimeInMillis(this.m_comparisonEndTime);
            System.out.println("Comparison End Time: " + cal.getTime());
            System.out.println("Elapsed Comparison Time (in milliseconds): " + (this.m_comparisonEndTime - this.m_comparisonStartTime));
            System.out.print(NEW_LINE);
            System.out.println("Source rows found/affected: " + this.dbSourceResultSet.m_rowsAffected);
            System.out.println("Target rows found/affected: " + this.dbTargetResultSet.m_rowsAffected);
            if (this.dbSourceResultSet.m_rowsAffected != this.dbTargetResultSet.m_rowsAffected) {
                result = false;
                System.out.println("[ERROR]: Source and Target row list count does not match: Source (" + this.dbSourceResultSet.m_rowsAffected + ") Target(" + this.dbTargetResultSet.m_rowsAffected + ")");
            }
            if (result) {
                System.out.print(NEW_LINE);
                System.out.println("***** NO DIFFERENCES FOUND. *****");
            }
            System.out.print(NEW_LINE);
            System.out.println("[ COMPARISON SUMMARY ]" + (this.m_testCaseName != null ? " [ " + this.m_testCaseName + " ]" : "") + " [ " + s_compareCount);
            System.out.println("Result: " + (result ? "PASSED" : "FAILED"));
            System.out.println("Comparison errors: " + totalComparisonErrors);
            System.out.println("Rows with comparison errors: " + rowsWithComparisonErrors);
            System.out.println("Source rows not found in Target (" + this.m_missingSourceRows.size() + ")");
            this.logMissingRows(this.m_missingSourceRows);
            System.out.println("Target rows not found in Source (" + this.m_missingTargetRows.size() + ")");
            this.logMissingRows(this.m_missingTargetRows);
            System.out.print(NEW_LINE);
        }
        return result;
    }

    static {
        Field[] fields;
        s_javaSqlTypes = new HashMap<Integer, String>();
        NEW_LINE = System.getProperty("line.separator");
        for (Field field : fields = Types.class.getFields()) {
            try {
                String name = field.getName();
                Integer value = (Integer)field.get(null);
                s_javaSqlTypes.put(value, name);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static class CompareValuesAsLargeString
    implements CompareValuesAs {
        private CompareValuesAsLargeString() {
        }

        @Override
        public int compare(DBResultSet.DbField sourceField, DBResultSet.DbField targetField, Object sourceValue, Object targetValue) {
            String normalizedSourceString = this.normalizeString(sourceValue);
            String normalizedTargetString = this.normalizeString(targetValue);
            return normalizedSourceString.compareTo(normalizedTargetString);
        }

        private String normalizeString(Object obj) {
            if (obj == null) {
                return "";
            }
            String[] strings = obj.toString().split("[ \n\r\t]");
            StringBuffer sbuf = new StringBuffer();
            String prefix = "";
            for (String s : strings) {
                String stringPart = s.trim();
                if (stringPart.isEmpty()) continue;
                sbuf.append(prefix + stringPart);
                prefix = " ";
            }
            return sbuf.toString().trim();
        }
    }

    private static class CompareValuesAsString
    implements CompareValuesAs {
        private CompareValuesAsString() {
        }

        @Override
        public int compare(DBResultSet.DbField sourceField, DBResultSet.DbField targetField, Object sourceValue, Object targetValue) {
            int result = 0;
            String sourceValueString = null;
            String targetValueString = null;
            int compareValue = 0;
            sourceValueString = (String)sourceValue;
            targetValueString = (String)targetValue;
            compareValue = sourceValueString.trim().compareTo(targetValueString.trim());
            if (compareValue < 0) {
                result = -1;
            }
            if (compareValue > 0) {
                result = 1;
            }
            return result;
        }
    }

    private static class CompareValuesAsNumber
    implements CompareValuesAs {
        private CompareValuesAsNumber() {
        }

        private double getDblValue(DBResultSet.DbField field, Object value) {
            double result = 0.0;
            if ("".equals(value)) {
                return 0.0;
            }
            if (value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)value;
                result = bd.doubleValue();
            } else if (value instanceof Double) {
                Double d = (Double)value;
                result = d;
            } else if (value instanceof Integer) {
                Integer i = (Integer)value;
                result = i.intValue();
            } else if (value instanceof String) {
                result = Double.parseDouble((String)value);
            } else {
                throw new RuntimeException("[ERROR]: Unrecognized value for comparison: Number.  [Field: " + field.m_name + "] [Type: " + CompareFixture.getJavaSqlTypeAsString(field.m_type) + "] [Value: " + value.toString() + "]");
            }
            return result;
        }

        @Override
        public int compare(DBResultSet.DbField sourceField, DBResultSet.DbField targetField, Object sourceValue, Object targetValue) {
            double sourceDblValue = this.getDblValue(sourceField, sourceValue);
            double targeDblValue = this.getDblValue(targetField, targetValue);
            int result = 0;
            double diff = sourceDblValue - targeDblValue;
            result = diff > 1000000.0 ? 1 : (diff < -1000000.0 ? -1 : 0);
            return result;
        }
    }

    private static class CompareValuesAsDate
    implements CompareValuesAs {
        private CompareValuesAsDate() {
        }

        private Date getDateValue(DBResultSet.DbField field, Object value) {
            Date result = null;
            if ("".equals(value)) {
                return new Date(0L);
            }
            if (value instanceof Date) {
                result = (Date)value;
            } else if (value instanceof Timestamp) {
                Timestamp t = (Timestamp)value;
                result = t;
            } else {
                throw new RuntimeException("[ERROR]: Unrecognized value for comparison: Date.  [Field: " + field.m_name + "] [Type: " + CompareFixture.getJavaSqlTypeAsString(field.m_type) + "] [Value: " + value.toString() + "]");
            }
            return result;
        }

        public int compareInt(int sourceInt, int targetInt) {
            int result = 0;
            if (sourceInt < targetInt) {
                result = -1;
            } else if (sourceInt > targetInt) {
                result = 1;
            }
            return result;
        }

        @Override
        public int compare(DBResultSet.DbField sourceField, DBResultSet.DbField targetField, Object sourceValue, Object targetValue) {
            Date sourceValueDate = this.getDateValue(sourceField, sourceValue);
            Date targetValueDate = this.getDateValue(targetField, targetValue);
            Calendar sourceCal = Calendar.getInstance();
            sourceCal.setTime(sourceValueDate);
            Calendar targetCal = Calendar.getInstance();
            targetCal.setTime(targetValueDate);
            int compareResult = this.compareInt(sourceCal.get(1), targetCal.get(1));
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = this.compareInt(sourceCal.get(2), targetCal.get(2));
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = this.compareInt(sourceCal.get(5), targetCal.get(5));
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = this.compareInt(sourceCal.get(11), targetCal.get(11));
            if (compareResult != 0) {
                return compareResult;
            }
            compareResult = this.compareInt(sourceCal.get(12), targetCal.get(12));
            if (compareResult != 0) {
                return compareResult;
            }
            return 0;
        }
    }

    private static interface CompareValuesAs {
        public int compare(DBResultSet.DbField var1, DBResultSet.DbField var2, Object var3, Object var4);
    }
}

